* Program......: CEE
* Version......: 1.10
* Author.......: Ryan Katri & Randy Wallin
* Date.........: October 24, 1993     Last Modified: 03/26/94 @ 07:31 pm
* Notice.......: Copyright (c) 1993 COB System Designs, Inc., All Rights Reserved.
* QFRestore....: 128,28
* Compiler.....: FoxPro 2.5
* Abstract.....: Initialize the COB Editor Extensions
* Changes......:
*

#define VERSION         "1.10"
#define DEBUG_ON        .F.    && Turn off for release version (?)

* You may modify the following key assignments.
* Use Fox's On Key Help to see what are valid keys.
#define KEY_HELP        "ALT+1"       && Expansion Macro help
#define KEY_FUNCTION    "ALT+2"       && Function/Procedure List
#define KEY_STRUCTURE   "ALT+3"       && Get/Build Field Structures
#define KEY_COMMENT     "ALT+4"       && Comment/Uncomment Block
#define KEY_SETUP       "ALT+5"       && Macro Key Setup
#define KEY_INTRO       "ALT+0"       && Startup Screen/Shows Key Bindings
#define KEY_INDENT      "ALT+7"       && Indent a block of text
#define KEY_OUTDENT     "ALT+8"       && Outdent a block of text

* DON'T MODIFY THIS KEY ASSIGNMENT
#define KEY_EXPAND      "ALT+BACKSPACE"

* Set to .T. to use tabs in an INDENT function, .F. for spaces
#define USE_TABS        .F.

#define NEWLINE         CHR(13)
#define LINEFEED        CHR(10)

* These are the offsets for the array returned by the _XEGetEnv() function
#define ED_NAME        1
#define ED_LEN         2
#define ED_LIMIT       3
#define ED_WRAP        4
#define ED_SELSTART    5
#define ED_SELEND      6
#define ED_SELANCHOR   7
#define ED_JUSTMODE    8
#define ED_TABWIDTH    9
#define ED_FONTSIZE    10
#define ED_FONTSTYLE   11
#define ED_KIND        12
#define ED_DIRTY       13
#define ED_AUTOINDENT  14
#define ED_BACKUP      15
#define ED_ADDLF       16
#define ED_AUTOCOMP    17
#define ED_ADDCTRLZ    18
#define ED_SAVEPREFS   19
#define ED_DRAGDROP    20
#define ED_READONLY    21
#define ED_STATUS      22
#define ED_LOCKPREFS   23
#define ED_INSERT      24


PRIVATE m.cTalk, m.cError, m.lByRef, m.sSaveScr
PUBLIC _CEEApp

* Make sure our environment is set up properly
IF SET("TALK")="ON"
   SET TALK OFF
   m.cTalk="ON"
ELSE
   m.cTalk="OFF"
ENDIF &&* SET("TALK")="ON"

m.cError = ON("ERROR")
IF _DOS
   SAVE SCREEN TO m.sSaveScr
ENDIF &&* _DOS

* Check for version #
IF "2.5"$Version()=0
   WAIT WINDOW [This program requires FoxPro 2.5 to run.]
   SET TALK &cTalk
   RETURN
ENDIF &&* "2.5"$Version()=0


* Set pass by reference (required by library routines) and turn on our
* error handler--these are reset again in ResetEnv()
m.lByRef = (SET("UDFParms") == "REFERENCE")
SET UDFPARMS TO VALUE
ON ERROR DO CEEError WITH ERROR(), PROGRAM(), LINENO(), "ResetEnv"

* We close the library first in order to release any
* event handlers we may have defined.  Then we load the
* library again.
IF "CEE"$SET("LIBRARY")
   =FreeLibr("CEE")
ENDIF &&* "CEE"$SET("LIBRARY")

cDirExpand=LOOKFOR("CEE.APP")
* SYS(16,1) returns the full path & name of the currently executing program
* We want to store EXPAND database in that dir. if it's not found elsewhere
* cDirExpand=LEFT(SYS(16,1),RAT("\",SYS(16,1)))


m.cCeeLib="CEE." + IIF(_DOS, "PLB", "FLL")
lCeeLib = FILE(m.cCeeLib)
IF ! lCeeLib
   m.cCeeLib = LookFor(m.cCeeLib)
   IF EMPTY(m.cCeeLib)
      ON ERROR m.cCeeLib=""
      m.cCeeLib=LOCFILE("CEE",IIF(_DOS,"PLB","FLL"),"Where is CEE Library?")
      ON ERROR DO CEEError WITH ERROR(), PROGRAM(), LINENO(), "ResetEnv"
   ENDIF &&* EMPTY(m.cCeeLib)
   lCeeLib=! EMPTY(m.cCeeLib)
ENDIF &&* ! lCeeLib

IF .NOT. OpenExpand()
   WAIT WINDOW [This program cannot continue without EXPAND.DBF.]
   DO ResetEnv
   =FreeLibr("CEE")
   RETURN
ENDIF &&* OpenExpand()

IF lCeeLib
   * This variable is set up so that the library routine (CEE.FLL/CEE.PLB)
   * can find CEE.APP again if CEE.APP is not in the path or current directory.
   * The variable is automatically released by the library routine.
   _CEEApp = cDirExpand  && + "CEE.APP"

   SET LIBRARY TO (m.cCeeLib) ADDITIVE

ELSE
   WAIT WINDOW [This program requires CEE Library to continue!]
   DO ResetEnv
   RETURN
ENDIF &&* lCeeLib

ON ERROR DO CEEError WITH ERROR(), PROGRAM(), LINENO(), "ResetEnv"

m.lShowStartup = !(UPPER(GetProfileString("CEE.INI", "CEE", "StartupScreen")) == "OFF")

WAIT CLEAR
IF .NOT. _XEQuiet()
   IF m.lShowStartup
      DO CEEIntro
   ELSE
      WAIT WINDOW "COB Editor Extensions v" + VERSION + " loaded." + CHR(13) + ;
        "Copyright" + IIF(_WINDOWS, CHR(169), " (c)") + " 1994 COB System Designs, Inc." NOWAIT
   ENDIF &&* m.lShowStartup
ENDIF &&* .NOT. _XEQuiet()

DO ResetEnv
IF _DOS
   RESTORE SCREEN FROM m.sSaveScr
ENDIF &&* _DOS

RETURN


**
* Function....: OpenExpand
* Called by...:
*
* Abstract....:
*   Opens the expand database, if it can find it
*
* Returns.....: TRUE if opened, FALSE otherwise
*
* Parameters..: None
*
* Notes.......:
**
FUNCTION OpenExpand
PRIVATE m.cDirExpand, m.cExpandDBF

m.cDirExpand = LEFT(SYS(16,1),RAT("\",SYS(16,1)))
* Open expansion database, if not already open
IF .NOT. USED("EXPAND")
   IF .NOT. FILE("EXPAND.DBF")
      m.cExpandDBF=LookFor("EXPAND.DBF")

      * If database is not found, let the user locate it or create new one
      IF EMPTY(m.cExpandDBF)
         DO CEEEXPLK.SPR WITH m.cDirExpand
      ENDIF &&* EMPTY(m.cExpandDBF)

      IF .NOT. EMPTY(m.cExpandDBF)
         USE (m.cExpandDBF) IN SELECT(1) SHARED ALIAS EXPAND
      ELSE
         RETURN .F.
      ENDIF &&* .NOT. EMPTY(m.cExpandDBF)

   ELSE
      USE EXPAND IN SELECT(1) SHARED
   ENDIF &&* .NOT. FILE("EXPAND.DBF")

ENDIF &&* .NOT. USED("EXPAND")
SET ORDER TO TAG KEY IN EXPAND

RETURN .T.
*EOF OpenExpand


**
* Procedure...: ExecModule
* Called by...: ON KEY LABEL
*
* Abstract....:
*   Executes specified module (app).  Exits gracefully if the
*   module cannot be found.
*
* Parameters..:
*   cModule = application to execute
*
* Notes.......:
**
PROCEDURE ExecModule
PARAMETERS cModule
PRIVATE m.cTalk

* Make sure our environment is set up properly
IF SET("TALK")="ON"
   SET TALK OFF
   m.cTalk="ON"
ELSE
   m.cTalk="OFF"
ENDIF &&* SET("TALK")="ON"

IF FILE(m.cModule)
   DO (m.cModule)
ELSE
   WAIT WINDOW UPPER(m.cModule) + " not found." NOWAIT
ENDIF &&* FILE(m.cModule)

SET TALK &cTalk

RETURN
*EOP ExecModule


**
* Procedure...: GetOnKey
* Called by...: Global
*
* Returns.....:
*   The ON KEY LABEL using the key from the .INI file,
*   or the default is none is set
*
* Parameters..:
*   cFunction = Function to look for in CEE.INI
*   cDefKey   = Default key if no definition found
*
* Notes.......:
**
PROCEDURE GetOnKey
PARAMETERS cFunction, cDefKey
PRIVATE m.cKey

cKey = UPPER(ALLTRIM(GetProfileString("CEE.INI", "KEYS", m.cFunction)))
DO CASE
CASE m.cKey == ""
   m.cKey = cDefKey
CASE m.cKey = "NONE"
   * Don't set up this key if NONE is returned
   m.cKey = ""
OTHERWISE

ENDCASE

RETURN m.cKey
*EOP GetOnKey


**
* Procedure...: SetOnKey
* Called by...: CEEKeySet
*
* Abstract....:
*   Sets the ON KEY LABEL using the key from the .INI file.
*
* Parameters..:
*   cFunction = Function to look for in CEE.INI
*   cExec     = What to execute when key is pressed
*   cDefKey   = Default key if no definition found
*
* Notes.......:
**
PROCEDURE SetOnKey
PARAMETERS cFunction, cExec, cDefKey
PRIVATE m.cKey, m.cError


m.cKey = GetOnKey(m.cFunction, m.cDefKey)
IF .NOT. EMPTY(m.cKey)
   m.cError = ON("ERROR")
   ON ERROR WAIT WINDOW m.cKey + " is an invalid key." + CHR(13) + "Press any key. . ."
   ON KEY LABEL (m.cKey) DO &cExec
   ON ERROR &cError
ENDIF &&* .NOT. EMPTY(m.cKey)

RETURN
*EOP SetOnKey



**
* Procedure...: CEEKeySet
* Called by...: EdInit in CEE
*
* Abstract....:
*   Sets up hotkeys when CEE library is loaded
*
* Parameters..: None
*
* Notes.......:
**
PROCEDURE CEEKeySet
PRIVATE m.lUseTabs, m.cCommentStr, m.cCeeApp
PUBLIC _CEEQuiet, _CEENoCmd, _CEENoSpc


* Check for Quiet mode
_CEEQuiet = UPPER(GetProfileString("CEE.INI", "CEE", "ShowStatus")) == "OFF"

IF .NOT. _CEEQuiet
   WAIT WINDOW "Setting up CEE..." NOWAIT
ENDIF &&* .NOT. _CEEQuiet

* Check to see if expansion should be turned off in command window
_CEENoCmd = UPPER(GetProfileString("CEE.INI", "CEE", "CommandWindow")) == "OFF"

* Check for No Spacebar expansion
_CEENoSpc = UPPER(GetProfileString("CEE.INI", "CEE", "Spacebar")) == "OFF"



m.lUseTabs = UPPER(GetProfileString("CEE.INI", "CEE", "TabIndent")) == "ON"
m.cCommentStr = GetProfileString("CEE.INI", "CEE", "Comment")
IF EMPTY(m.cCommentStr)
   m.cCommentStr = "*-* "
ENDIF &&* EMPTY(m.cCommentStr)

m.cCeeApp=LookFor("CEE.APP")
m.cDirExpand=LEFT(m.cCeeApp,RAT("\",m.cCeeApp))

ON KEY LABEL KEY_EXPAND DO CEEExpand IN &cCeeApp
DO SetOnKey WITH "HELP", "CEEList IN "+m.cCeeApp, KEY_HELP
DO SetOnKey WITH "FUNCTION", "CEEFuncList IN "+m.cCeeApp, KEY_FUNCTION
DO SetOnKey WITH "COMMENT", "CEEComment IN "+m.cCeeApp+" WITH [" + m.cCommentStr + "]", KEY_COMMENT
DO SetOnKey WITH "STRUCTURE", "ExecModule IN "+m.cCeeApp+" WITH ["+m.cDirExpand+"CEEStruc.APP]", KEY_STRUCTURE
DO SetOnKey WITH "INTRO", "CEEIntro IN "+m.cCeeApp, KEY_INTRO
DO SetOnKey WITH "INDENT", "CEEIndent IN "+m.cCeeApp+" WITH 1," + IIF(m.lUseTabs, [.T.], [.F.]), KEY_INDENT
DO SetOnKey WITH "OUTDENT", "CEEIndent IN "+m.cCeeApp+" WITH -1," + IIF(m.lUseTabs, [.T.], [.F.]), KEY_OUTDENT
DO SetOnKey WITH "SETUP", "ExecModule IN "+m.cCeeApp+" WITH ["+m.cDirExpand+"CEEMacro.APP]", KEY_SETUP


IF .NOT. _CEEQuiet
   WAIT CLEAR
ENDIF &&* .NOT. _CEEQuiet

RETURN
*EOP CEEKeySet

**
* Procedure...: CEEKeyFree
* Called by...: EdInit in CEE, CEEUnload
*
* Abstract....:
*   Releases hotkeys when CEE library is unloaded
*
* Parameters..: None
*
* Notes.......:
**
PROCEDURE CEEKeyFree

=ClearKey("EXPAND", KEY_EXPAND)
=ClearKey("HELP", KEY_HELP)
=ClearKey("FUNCTION", KEY_FUNCTION)
=ClearKey("STRUCTURE", KEY_STRUCTURE)
=ClearKey("COMMENT", KEY_COMMENT)
=ClearKey("SETUP", KEY_SETUP)
=ClearKey("INTRO", KEY_INTRO)
=ClearKey("INDENT", KEY_INDENT)
=ClearKey("OUTDENT", KEY_OUTDENT)

RETURN
*EOP CEEKeyFree

**
* Function....: ClearKey
* Called by...: CEEKeyFree
*
* Abstract....:
*   Clears ON KEY LABEL <cKey> if "CEE" appears in the
*   do stuff
*
* Returns.....: TRUE if key released, FALSE otherwise
*
* Parameters..:
*   cKey = text of ON KEY LABEL
*
* Notes.......:
**
FUNCTION ClearKey
PARAMETERS cFunction, cDefKey
PRIVATE m.cKey

m.cKey = GetOnKey(m.cFunction, m.cDefKey)
IF .NOT. EMPTY(m.cKey)
   IF "CEE"$UPPER(ON("KEY", m.cKey))
      ON KEY LABEL (m.cKey)
      RETURN .T.
   ENDIF &&* "CEE"$UPPER(ON("KEY", m.cKey))
ENDIF &&* .NOT. EMPTY(m.cKey)

RETURN .F.
*EOF ClearKey




**
* Procedure...: CEEFuncList
* Called by...: ON KEY LABEL hotkey
*
* Abstract....:
*   If we're in an edit window, display a list of all
*   functions & procedures--the user may choose one &
*   jump directly to it.
*
* Parameters..:
*
* Notes.......:
**
PROCEDURE CEEFuncList

PRIVATE aFuncList, m.nFuncCnt, m.nSavePos, m.nGotoFunc, m.wHandle
PRIVATE m.cError, m.cTalk, m.lByRef, m.sCEEScreen

DIMENSION aFuncList[300, 2]

* Make sure our environment is set up properly
IF SET("TALK")="ON"
   SET TALK OFF
   m.cTalk="ON"
ELSE
   m.cTalk="OFF"
ENDIF &&* SET("TALK")="ON"
IF _DOS
   m.cSetSysmenu=SET("SYSMENU")
   SET SYSMENU OFF
   SAVE SCREEN TO m.sCEEScreen
ENDIF &&* _DOS


m.lByRef = (SET("UDFParms") == "REFERENCE")
SET UDFPARMS TO VALUE

m.cError = ON("ERROR")
ON ERROR DO CEEError WITH ERROR(), PROGRAM(), LINENO(), "ResetEnv"



IF .NOT. "CEE"$SET("LIBRARY")
   SET LIBRARY TO CEE ADDITIVE
ENDIF &&* .NOT. "CEE"$SET("LIBRARY")


m.wHandle = _XEHandle()
IF m.wHandle > 0
   m.nGotoFunc = 0
   m.nSavePos = _XEGetPos(m.wHandle)

   WAIT WINDOW "Building Procedure/Function List. . ." NOWAIT
   m.nFuncCnt = _XEFunList(m.wHandle, @aFuncList)
   WAIT CLEAR

   IF m.nFuncCnt > 0
      DIMENSION aFuncList[m.nFuncCnt, 2]

      m.nGotoFunc = 1
      DO WHILE aFuncList[m.nGotoFunc, 2] <= m.nSavePos .AND. m.nGotoFunc < m.nFuncCnt
         m.nGotoFunc = m.nGotoFunc + 1
      ENDDO &&* aFuncList[m.nGotoFunc, 2] <= m.nSavePos .AND. m.nGotoFunc < m.nFuncCnt
      IF m.nSavePos >= aFuncList[m.nFuncCnt, 2]
         m.nGotoFunc = m.nFuncCnt
      ELSE
         m.nGotoFunc = MAX(m.nGotoFunc - 1, 1)
      ENDIF &&* m.nSavePos >= aFuncList[m.nFuncCnt, 2]

      IF CEEFunc()
         m.nSavePos = aFuncList[m.nGotoFunc, 2]
      ENDIF &&* CEEFunc()
   ELSE
      WAIT WINDOW "No procedures/functions found." NOWAIT
   ENDIF &&* m.nFuncCnt > 0

   =_XESetPos(m.wHandle, m.nSavePos)
   =_XEScrlToP(m.wHandle, m.nSavePos, .F.)
ELSE
   WAIT WINDOW [Procedure/Function List: available only in an editing environment.] NOWAIT
ENDIF &&* m.wHandle > 0

DO ResetEnv
IF _DOS
   SET SYSMENU &cSetSysMenu
   RESTORE SCREEN FROM m.sCEEScreen
ENDIF &&* _DOS

RETURN
*EOP CEEFuncList




**
* Procedure...: CEEComment
* Called by...: ON KEY LABEL hotkey
*
* Abstract....:
*   If we're in an editing window, then comment out the
*   selected text region.
*
* Parameters..: None
*
* Notes.......:
**
PROCEDURE CEEComment
PARAMETERS cCommentStr

PRIVATE m.wHandle, m.cError, m.cTalk, m.lByRef

* Make sure our environment is set up properly
IF SET("TALK")="ON"
   SET TALK OFF
   m.cTalk="ON"
ELSE
   m.cTalk="OFF"
ENDIF &&* SET("TALK")="ON"

m.lByRef = (SET("UDFParms") == "REFERENCE")
SET UDFPARMS TO VALUE

m.cError = ON("ERROR")
ON ERROR DO CEEError WITH ERROR(), PROGRAM(), LINENO(), "ResetEnv"


IF .NOT. "CEE"$SET("LIBRARY")
   SET LIBRARY TO CEE ADDITIVE
ENDIF &&* .NOT. "CEE"$SET("LIBRARY")


m.wHandle = _XEHandle()
IF m.wHandle > 0
   IF _XEComment(m.wHandle, m.cCommentStr)
      * Make sure our insertion point is in view
      =_XEScrlToP(m.wHandle, _XEGetPos(m.wHandle), .F.)
   ELSE
      WAIT WINDOW [Comment/Uncomment: must select text to operate on.] NOWAIT
   ENDIF &&* _XEComment(wHandle, m.cCommentStr)

ELSE
   WAIT WINDOW [Comment/Uncomment: available only in an editing environment.] NOWAIT
ENDIF &&* m.wHandle > 0

DO ResetEnv

RETURN
*EOP CEEComment


**
* Procedure...: CEEIndent
* Called by...: ON KEY LABEL hotkey
*
* Abstract....:
*   If we're in an editing window, then indent/outdent
*   the selected text.
*
* Parameters..:
*   nIndent = # of characters to indent, negative value to outdent
*   lTabs   = TRUE to use tabs, FALSE for spaces
*
* Notes.......:
**
PROCEDURE CEEIndent
PARAMETERS nIndent, lTabs
PRIVATE m.wHandle, m.cError, m.cTalk, m.lByRef

PUSH KEY CLEAR
* Make sure our environment is set up properly
IF SET("TALK")="ON"
   SET TALK OFF
   m.cTalk="ON"
ELSE
   m.cTalk="OFF"
ENDIF &&* SET("TALK")="ON"


m.lByRef = (SET("UDFParms") == "REFERENCE")
SET UDFPARMS TO VALUE

m.cError = ON("ERROR")
ON ERROR DO CEEError WITH ERROR(), PROGRAM(), LINENO(), "ResetEnv"


IF .NOT. "CEE"$SET("LIBRARY")
   SET LIBRARY TO CEE ADDITIVE
ENDIF &&* .NOT. "CEE"$SET("LIBRARY")

IF TYPE("m.nIndent") <> "N"
   m.nIndent = 1
ENDIF &&* TYPE("m.nIndent") <> "N"
IF TYPE("m.lTabs") <> "L"
   m.lTabs = .F.
ENDIF &&* TYPE("m.lTabs") <> "L"


m.wHandle = _XEHandle()
IF m.wHandle > 0
   IF .NOT. _XEIndent(m.wHandle, m.nIndent, m.lTabs)
      WAIT WINDOW [Indent/Outdent: must select text to operate on.] NOWAIT
   ENDIF &&* .NOT. _XEIndent(m.wHandle, m.nIndent, m.lTabs)

ELSE
   WAIT WINDOW [Indent/Outdent: available only in an editing environment.] NOWAIT
ENDIF &&* m.wHandle > 0

DO ResetEnv
POP KEY

RETURN
*EOP CEEIndent



**
* Procedure...: CEEList
* Called by...: ON KEY LABEL ALT+key
*
* Abstract....:
*   Displays a popup of available expansion macros and what
*   they expand to.  Selecting one inserts the abbreviation
*   at current text position.
*
* Parameters..: None
*
* Notes.......:
**
PROCEDURE CEEList
PRIVATE m.cTalk, m.cError, m.lByRef
PRIVATE m.cPrompt, m.nSelect, m.nRecNo, m.popExpand, m.cSetConfirm
PRIVATE m.cSetSysMenu, m.sCEEScreen
PRIVATE m.cFont, m.nSize, m.cStyle

* Make sure our environment is set up properly
IF SET("TALK")="ON"
   SET TALK OFF
   m.cTalk="ON"
ELSE
   m.cTalk="OFF"
ENDIF &&* SET("TALK")="ON"

IF _DOS
   m.cSetSysMenu=SET("SYSMENU")
   SET SYSMENU OFF
   SAVE SCREEN TO m.sCEEScreen
ENDIF &&* _DOS

m.lByRef = (SET("UDFParms") == "REFERENCE")
SET UDFPARMS TO VALUE

m.cError = ON("ERROR")
ON ERROR DO CEEError WITH ERROR(), PROGRAM(), LINENO(), "ResetEnv"


IF .NOT. "CEE"$SET("LIBRARY")
   SET LIBRARY TO CEE ADDITIVE
ENDIF &&* .NOT. "CEE"$SET("LIBRARY")

PUSH KEY CLEAR
m.wHandle = _XEHandle()
IF m.wHandle > 0
   m.cPrompt=""
   m.nSelect=SELECT()
   m.nRecNo=RECNO()

   IF .NOT. USED("EXPAND")
      USE EXPAND IN SELECT(1) SHARED
   ENDIF &&* .NOT. USED("EXPAND")
   SELECT EXPAND
   SET ORDER TO KEY IN EXPAND

   IF _WINDOWS
      m.cFont = WFONT(1)
      m.nSize = WFONT(2)
      m.cStyle = WFONT(3)
      MODIFY WINDOW SCREEN FONT "FoxFont", 10 STYLE "N"
      DEFINE POPUP popExpand FROM 1,1 TO 10,60 IN SCREEN PROMPT ;
        FIELD STRTRAN(Key, " ",".") + " " + ;
        ALLTRIM(IIF(EMPTY(Descript), MLINE(Code,1), Descript)) ;
        SHADOW SCROLL ;
        COLOR ,RGB(,,,192,192,192) ;
        TITLE "CEE Expansions"
   ELSE
      DEFINE POPUP popExpand FROM 1,1 TO 10,60 IN SCREEN PROMPT ;
        FIELD STRTRAN(Key, " ",".") + " " + ;
        ALLTRIM(IIF(EMPTY(Descript), MLINE(Code,1), Descript)) ;
        SHADOW SCROLL TITLE "CEE Expansions"
   ENDIF &&* _WINDOWS
   m.cSetConfirm=SET("CONFIRM")
   SET CONFIRM ON
   ON SELECTION POPUP popExpand DO CEEPick WITH PROMPT()
   ACTIVATE POPUP popExpand
   RELEASE POPUP popExpand
   SET CONFIRM &cSetConfirm
   SELECT (m.nSelect)

   IF m.nRecNo > 0
      GOTO (m.nRecNo)
   ENDIF &&* nRecNo > 0

   IF ""<>m.cPrompt
      KEYBOARD m.cPrompt PLAIN
   ENDIF &&* ""<>m.cPrompt
   IF _WINDOWS
      MODIFY WINDOW SCREEN FONT (m.cFont), (m.nSize) STYLE (m.cStyle)
   ENDIF &&* _WINDOWS

ELSE
   WAIT WINDOW [Expansion Listing: available only in an editing environment.] NOWAIT
ENDIF &&* m.wHandle > 0
POP KEY
DO ResetEnv
IF _DOS
   SET SYSMENU &cSetSysMenu
   RESTORE SCREEN FROM m.sCEEScreen
ENDIF &&* _DOS

RETURN
*EOP CEEList

**
* Procedure...: CEEPick
* Called by...: CEEList
*
* Abstract....:
*   Parses the Prompt() and keyboards the Abbreviation.
*
* Parameters..:
*   cText = the prompt() from the PopUp
*
* Notes.......:
**
PROCEDURE CEEPick
PARAMETERS cText

m.cPrompt=ALLTRIM(LEFT(m.cText,AT(".", m.cText)-1))
DEACTIVATE POPUP popExpand

RETURN
*EOP CEEPick


**
* Procedure...: CEEExpand
* Called by...: ON KEY LABEL SPACEBAR
*
* Abstract....:
*   If in an edit window and at a valid position where
*   a key is possible to be expanded, then expand the word
*   at the cursor.
*
* Parameters..: None
*
* Notes.......:
*   Relies upon EXPAND.DBF to be available
**
PROCEDURE CEEExpand
#define ZCURSOR         "~"
#define ZSEND_CR        "^^"

PRIVATE m.cError, m.cTalk, m.lByRef
PRIVATE m.wHandle, m.cTitle, m.nMemoWidth, m.cExact
PRIVATE m.nPos, m.ch, m.nBeginPos, m.nSavePos, m.cKey, m.cInsText
PRIVATE m.cLine, m.cIndent, m.i, aMacros, m.cHotKey
PRIVATE m.lAbort, m.lSpaceHit, m.cOnKey, m.lSendCR

DIMENSION aMacros[1, 2]

* Set up environment & variables
IF SET("TALK")="ON"
   SET TALK OFF
   m.cTalk="ON"
ELSE
   m.cTalk="OFF"
ENDIF &&* SET("TALK")="ON"


m.lByRef = (SET("UDFParms") == "REFERENCE")
SET UDFPARMS TO VALUE

m.cError = ON("ERROR")


ON ERROR DO CEEError WITH ERROR(), PROGRAM(), LINENO(), "ResetEnv"
IF "EXPAND.CODE"==WONTOP()
   * do not let the expansion work inside the EXPAND Browse
   KEYBOARD "{SPACEBAR}" PLAIN
   DO ResetEnv
   RETURN
ENDIF &&* "EXPAND.CODE"==WONTOP()

* cHotKey = CHR(LASTKEY())
aMacros = ""

IF .NOT. "CEE"$SET("LIBRARY")
   ON ERROR m.cCeeLib=""
   m.cCeeLib=LOCFILE("CEE",IIF(_DOS,"PLB","FLL"),"Where is CEE Library?")
   m.lCeeLib=! EMPTY(m.cCeeLib)
   ON ERROR DO CEEError WITH ERROR(), PROGRAM(), LINENO(), "ResetEnv"
   IF m.lCeeLib
      SET LIBRARY TO (m.cCeeLib) ADDITIVE
   ELSE
      WAIT WINDOW [This program requires CEE Library to continue!]
      DO ResetEnv
      RETURN
   ENDIF &&* m.lCeeLib
ENDIF &&* .NOT. "CEE"$SET("LIBRARY")


m.lSpaceHit = (LASTKEY() == 32)
m.lAbort = .F.
m.cOnKey = ON("KEY", "SPACEBAR")

m.wHandle = _XEHandle()

IF m.wHandle > 0 .AND. (EMPTY(m.cOnKey) .OR. .NOT. m.lSpaceHit)
   PUSH KEY CLEAR

   * Start undo group
   =_XEUndoOn(m.wHandle, .T.)

   m.nSavePos = _XEGetPos(m.wHandle) -1
   IF m.lSpaceHit
      m.nSavePos = m.nSavePos - 1
   ENDIF &&* m.lSpaceHit

   m.nPos = m.nSavePos
   DO WHILE m.nPos >= 0
      m.ch = _XEGetChar(m.wHandle, m.nPos)
      IF m.ch == NEWLINE .OR. m.ch == LINEFEED .OR. m.ch == " " .OR. m.ch == CHR(9)
         EXIT
      ENDIF &&* m.ch == NEWLINE .OR. m.ch == LINEFEED .OR. m.ch == " " .OR. m.ch == CH
      m.nPos = m.nPos - 1
   ENDDO &&* nPos >= 0
   *  Changed on 01/28/94 by RMK
   IF m.nPos <> m.nSavePos
      m.nPos = m.nPos + 1
   ENDIF &&* m.nPos <> m.nSavePos

   * Find how far it is to the beginning of the line
   m.nBeginPos = _XEGetLnPo(m.wHandle, _XEGetLnNu(m.wHandle, _XEGetPos(m.wHandle)))


   * Grab the key now that we know where it is on the line
   m.cKey = UPPER(_XEGetStr(m.wHandle, m.nPos, m.nSavePos))

   * Make sure our expansion database is available
   IF .NOT. OpenExpand()
      WAIT WINDOW [EXPAND.DBF is not available] NOWAIT
      POP KEY
      DO ResetEnv
      RETURN
   ENDIF &&* .NOT. OpenExpand()

   ** Commented out 03/11/94 at 11:00 am
   **   IF .NOT. USED("EXPAND")
   **      ON ERROR cExpDBF=""
   **      cExpDBF=LOCFILE("EXPAND.DBF","DBF","Where is EXPAND.DBF?")
   **      ON ERROR DO CEEError WITH ERROR(), PROGRAM(), LINENO(), "ResetEnv"
   **      IF ""<> cExpDBF
   **         USE (cExpDBF) IN SELECT(1) SHARED
   **      ELSE
   **         WAIT WINDOW [EXPAND.DBF is not available] NOWAIT
   **         POP KEY
   **         DO ResetEnv
   **         RETURN
   **      ENDIF &&* ""<> cExpDBF
   **   ENDIF &&* .NOT. USED("EXPAND")

   SET ORDER TO KEY IN EXPAND

   m.cExact = SET("EXACT")
   SET EXACT ON
   m.nMemoWidth = SET("MEMOWIDTH")
   SET MEMOWIDTH TO 256


   * Lookup key in the database
   m.cInsText = ""
   IF SEEK(m.cKey, "EXPAND")
      m.cInsText = Expand.Code
   ENDIF &&* SEEK(m.cKey, "EXPAND")



   IF !EMPTY(m.cInsText)

      * Delete the space char which was inserted by our event handler.
      * A space is inserted there so that in case we lose the ON KEY
      * LABEL ALT+BACKSPACE for this thing, we can still generate a space
      * in the editing window!
      IF m.lSpaceHit
         m.nSavePos = m.nSavePos + 1
      ENDIF &&* m.lSpaceHit

      * Delete the key
      =_XESelect(m.wHandle, m.nPos, m.nSavePos + 1)
      =_XEDelete(m.wHandle)

      * Determine what our indent string should be.  This is determined
      * by the white space preceding the keyword, or blank if the keyword
      * is the first text on the line.
      IF (m.nPos-1) >= m.nBeginPos
         m.cIndent = _XEGetStr(m.wHandle, m.nBeginPos, m.nPos-1)
      ELSE
         m.cIndent = ""
      ENDIF &&* (m.nPos-1) >= m.nBeginPos

      * ZSEND_CR indicates that ENTER should be keyboarded when finished
      * inserting text
      m.lSendCR = AT(ZSEND_CR, m.cInsText) > 0
      IF m.lSendCR
         m.cInsText = STRTRAN(m.cInsText, ZSEND_CR, "")
      ENDIF &&* m.lSendCR

      * Expand the first line
      m.cLine = TransCode(TransMacro(MLINE(m.cInsText, 1)))
      m.lAbort = (LASTKEY() == 27 .OR. LASTKEY() == 17)

      IF .NOT. m.lAbort


         * Write out the first line
         =_XEInsert(m.wHandle, m.cLine, LEN(m.cLine))

         * Write out the additional lines, if there are any
         i = 2
         FOR i = 2 TO MEMLINES(m.cInsText)
            m.cLine = CHR(13) + CHR(10) + m.cIndent + TransCode(TransMacro(MLINE(m.cInsText, m.i)))
            m.lAbort = (LASTKEY() == 27 .OR. LASTKEY() == 17)
            IF m.lAbort
               EXIT
            ELSE
               =_XEInsert(m.wHandle, m.cLine, LEN(m.cLine))
            ENDIF &&* m.lAbort
         ENDFOR &&* i = 2 TO MEMLINES(m.cInsText)

         IF .NOT. lAbort
            * Position cursor at tilde character & delete tilde
            IF AT(ZCURSOR, m.cInsText) > 0
               m.nPos = _XEGetPos(m.wHandle)
               m.ch = _XEGetChar(m.wHandle, m.nPos)
               DO WHILE m.ch <> ZCURSOR .AND. m.nPos > 0
                  m.nPos = m.nPos - 1
                  m.ch = _XEGetChar(m.wHandle, m.nPos)
               ENDDO &&* m.ch <> ZCURSOR .AND. m.nPos > 0
               =_XESetPos(m.wHandle, m.nPos)
               =_XESelect(m.wHandle, m.nPos, m.nPos+1)
               =_XEDelete(m.wHandle)
            ENDIF &&* AT(ZCURSOR, m.cInsText) > 0

            IF m.lSendCR
               KEYBOARD "{ENTER}" PLAIN
            ENDIF &&* m.lSendCR

            * Make sure our insertion point is in view
            =_XEScrlToP(m.wHandle, _XEGetPos(m.wHandle), .F.)

         ENDIF &&* .NOT. lAbort
      ENDIF &&* .NOT. m.lAbort

   ELSE
      IF .NOT. m.lSpaceHit
         KEYBOARD ("{" + KEY_EXPAND + "}") PLAIN
      ENDIF &&* .NOT. m.lSpaceHit
   ENDIF &&* !EMPTY(m.cInsText)

   SET EXACT &cExact
   SET MEMOWIDTH TO (m.nMemoWidth)

   * End undo group
   =_XEUndoOn(m.wHandle, .F.)

   IF lAbort
      =_XEUndo(m.wHandle)

      * If we got here through the spacebar, then delete the extra
      * space character that was inserted into the text
      IF lSpaceHit
         =_XESelect(m.wHandle, m.nSavePos, m.nSavePos+1)
         =_XEDelete(m.wHandle)
      ENDIF &&* lSpaceHit
   ENDIF &&* lAbort

   POP KEY
ELSE
   * If we get to this point, it's probably because we had a hotkey
   * defined to call the expansion function, but the library was not
   * loaded.  In that case, just send the hotkey out plain.
   IF m.lSpaceHit
      IF m.wHandle > 0
         * Delete the extra space character
         m.nSavePos = _XEGetPos(m.wHandle) - 1
         =_XESelect(m.wHandle, m.nSavePos, m.nSavePos+1)
         =_XEDelete(m.wHandle)
         ON ERROR WAIT WINDOW MESSAGE()
         &cOnKey
      ENDIF &&* m.wHandle > 0
   ELSE
      KEYBOARD ("{" + KEY_EXPAND + "}") PLAIN
   ENDIF &&* m.lSpaceHit

ENDIF &&* m.wHandle > 0 .AND. (EMPTY(m.cOnKey) .OR. .NOT. m.lSpaceHit)
DO ResetEnv

RETURN
*EOP CEEExpand



**
* Function....: TransMacro
* Called by...: Expand()
*
* Abstract....:
*   Translate macros strings into their full-text
*   equivalents.
*
* Returns.....:
*   Translated line, with macro expansions done.
*
* Parameters..:
*   cLine = Line to translate
*
* Notes.......:
*   Assumes that aMacros array is defined in Expand()
**
FUNCTION TransMacro
PARAMETERS cLine

PRIVATE m.nPos, m.nPos2, m.cMacro, m.cExpand, m.nMacSize, m.cToFind


m.nPos = AT("##", m.cLine, 1)
DO WHILE m.nPos > 0 .AND. LASTKEY() <> 27 .AND. LASTKEY() <> 17
   m.nPos2 = AT("##", m.cLine, 2)
   IF m.nPos2 > 0
      m.cMacro = SUBSTR(m.cLine, m.nPos + 2, m.nPos2 - m.nPos - 2)
      m.cToFind = UPPER(m.cMacro)

      IF SEEK(m.cToFind, "EXPAND")
         m.cLine = STRTRAN(m.cLine, "##" + m.cMacro + "##", Expand.Code)
      ELSE
         * Get a custom macro here
         * First, see if the macro has been defined already
         nFound = ASCAN(aMacros, m.cToFind)
         IF nFound > 0
            * Yes it has, so don't ask for it again--do immediate replace
            nFound = ASUBSCRIPT(aMacros, nFound, 1)
            m.cExpand = aMacros[nFound, 2]
         ELSE
            * Not defined, so we need to request macro expansion from user
            m.cExpand = CEEEntry(m.cMacro + "?")

            * Add the new macro to our macro array
            m.nMacSize = ALEN(aMacros, 1) + 1
            DIMENSION aMacros[m.nMacSize, 2]
            aMacros[m.nMacSize, 1] = m.cToFind
            aMacros[m.nMacSize, 2] = m.cExpand
         ENDIF &&* nFound > 0
         m.cLine = STRTRAN(m.cLine, "##" + m.cMacro + "##", m.cExpand)

      ENDIF &&* SEEK(m.cToFind, "EXPAND")

      m.nPos = AT("##", m.cLine, 1)
   ELSE
      m.nPos = 0
   ENDIF &&* m.nPos2 > 0
ENDDO &&* m.nPos > 0 .AND. LASTKEY() <> 27 .AND. LASTKEY() <> 17


RETURN m.cLine
*EOF TransMacro

**
* Function....: TransCode
* Called by...: Expand()
*
* Abstract....:
*   Translates any embedded code by evaluating expressions
*   contained in << >> delimiters
*
* Returns.....:
*   Expanded line
*
* Parameters..:
*   cLine = line to expand
*
* Notes.......:
**
FUNCTION TransCode
PARAMETERS cLine

PRIVATE m.nPos, m.nPos2, m.cMacro, m.cExpand, m.cOldError

m.nPos = AT("<<", m.cLine, 1)
DO WHILE m.nPos > 0
   m.nPos2 = AT(">>", m.cLine, 1)
   IF m.nPos2 > 0
      m.cMacro = SUBSTR(m.cLine, m.nPos + 2, m.nPos2 - m.nPos - 2)

      m.cExpand = ""
      m.cOldError = ON("ERROR")
      ON ERROR DO ShowError WITH "Invalid Expression: " + m.cMacro
      m.cExpand = EVAL(m.cMacro)
      ON ERROR &cOldError

      * All expressions must evaluate to numeric.  If this one did
      * not, then display exclamations around it!
      IF TYPE("m.cExpand") <> "C"
         m.cExpand = "!!" + m.cMacro + "!!"
      ENDIF &&* TYPE("m.cExpand") <> "C"

      m.cLine = STRTRAN(m.cLine, "<<" + m.cMacro + ">>", m.cExpand)

      m.nPos = AT("<<", m.cLine, 1)
   ELSE
      m.nPos = 0
   ENDIF &&* m.nPos2 > 0
ENDDO &&* m.nPos > 0

RETURN m.cLine
*EOF TransCode

**
* Procedure...: ShowError
* Called by...: Global
*
* Abstract....:
*   Displays error message & a beep
*
* Parameters..:
*   cMsg = error message to display
*
* Notes.......:
**
PROCEDURE ShowError
PARAMETERS cMsg

WAIT WINDOW m.cMsg NOWAIT
?? CHR(7)

RETURN
*EOP ShowError

**
* Procedure...: CEEError
* Called by...: ON ERROR routine
*
* Abstract....:
*   Handles common errors which may occur in CEE
*   or MacroUpd.SPR
*
* Parameters..:
*   nErrNum = Error number
*
* Notes.......:
*   This error routine is very simple & specific to
*   handling problems with the EXPAND database.
**
PROCEDURE CEEError
PARAMETERS nErrNum, cProgram, nLineNo, cExitProc

PRIVATE m.lErrFlag

m.lErrFlag = .F.
ON ERROR

* Errors we'll handle:
*    1 = File doesn't exist
*    5 = Record out of range
*   12 = Variable not found opening file or index
*   13 = Alias not found opening file or index
*   15 = Not a DBF
*   19 = Index doesn't match DBF
*   20 = Record not in index
*   23 = Index expression too big to fit
*   26 = Database isn't ordered
*   41 = Memo missing or invalid
*  108 = File is in use by another
*  112 = Invalid key length
*  114 = Index file doesn't match database
*  202 = Invalid path
* 1124 = Key too big
* 1160 = Insufficient disk space
* 1683 = Tag not found
* 1705 = File access denied
* 1707 = Structural CDX not found
* 1721 = All work areas in use

DO CASE
   CASE INLIST(m.nErrNum, 5, 19, 20, 23, 26, 112, 114, 1124, 1683, 1707)

      IF CEEYesNo("EXPAND needs to be reindex.  Reindex now?", ;
           "Reindex", .T.)
         IF USED("EXPAND")
            SELECT EXPAND
         ELSE
            USE EXPAND IN SELECT(1)
         ENDIF &&* USED("EXPAND")
         m.cOnError=ON("ERROR")
         ON ERROR m.lErrFlag=.T.
         USE EXPAND EXCLUSIVE
         IF ! m.lErrFlag
            INDEX ON KEY TAG KEY
            RETURN
         ENDIF &&* ! m.lErrFlag
      ELSE
         m.lErrFlag = .T.
      ENDIF &&* CEEYesNo("EXPAND needs to be reindex.  Reindex now?",


   CASE INLIST(m.nErrNum, 12, 13) .AND. (UPPER(MESSAGE(1)) = 'SET INDEX' .OR. ;
        (UPPER(MESSAGE(1)) = 'USE' .AND. UPPER(MESSAGE(1)) <> 'USE IN'))
      WAIT WINDOW "Expand index does not appear to be associated with EXPAND.DBF"
      m.lErrFlag = .T.

   CASE INLIST(m.nErrNum, 15, 41, 1160)
      WAIT WINDOW "The error '" + MESSAGE() + "'" + CHR(13) + ;
        " occurred while trying to use EXPAND.DBF."
      m.lErrFlag = .T.

   CASE INLIST(m.nErrNum, 1, 202)
      WAIT WINDOW "EXPAND.DBF or CEE library could not be found." NOWAIT
      m.lErrFlag = .T.

   CASE m.nErrNum = 108 or m.nErrNum = 1705
      WAIT WINDOW "EXPAND database being used by someone else." + CHR(13) + ;
        "Please try again later."
      m.lErrFlag = .T.

   CASE m.nErrNum = 1721
      WAIT WINDOW "There are no free work areas to open EXPAND.DBF"
      m.lErrFlag = .T.

      * Some other error occurred, so display a message and quit.
   OTHERWISE
      WAIT WINDOW "Error #" + LTRIM(STR(m.nErrNum)) + ":" + message() + CHR(13) + ;
        "Executing: " + LEFT(MESSAGE(1), 60) + IIF(LEN(MESSAGE(1)) > 60, ". . .", "")
      m.lErrFlag = .T.
ENDCASE

IF m.lErrFlag
   #IF DEBUG_ON
   PRIVATE e_cnt, e_EndLvl, e_trace
   * Generate the trace log
   * Find the last nesting, not including the ON ERROR and CEEError calls
   e_cnt = 32
   DO WHILE LEN(SYS(16, e_cnt)) == 0
      e_cnt = e_cnt - 1
   ENDDO &&* LEN(SYS(16, e_cnt)) == 0
   e_EndLvl = e_cnt - 1
   e_cnt = 1
   e_trace = ""
   DO WHILE e_cnt <> e_EndLvl
      IF e_cnt > 1
         FOR e_temp = 2 TO e_cnt-1
            e_trace = e_trace + "   "
         ENDFOR &&* e_temp = 2 TO e_cnt-1
         e_trace = e_trace + ""
      ENDIF &&* e_cnt > 1
      e_trace = e_trace + SYS(16, e_cnt) + CHR(13)

      e_cnt = e_cnt + 1
   ENDDO &&* e_cnt <> e_EndLvl

   DO CEEERRSC.SPR WITH MESSAGE(), m.nErrNum, e_trace, m.nLineNo, MESSAGE(1)
   #ENDIF

   =CEEUnload()
   DO ResetEnv
   IF .NOT. EMPTY(m.cExitProc)
      DO (m.cExitProc)
   ENDIF &&* .NOT. EMPTY(m.cExitProc)
   CANCEL
ENDIF &&* m.lErrFlag

ON ERROR DO CEEError WITH ERROR(), "ResetEnv"

RETURN
*EOP CEEError

**
* Procedure...: CEEIntro
*
* Called by...: Global
*
* Abstract....: Brings up Cheat Sheet
*
* Parameters..: None
*
* Notes.......:
**
PROCEDURE CEEIntro
PRIVATE m.cSetSysMenu, m.sCEEScreen
PUSH KEY CLEAR
* Make sure our environment is set up properly
IF SET("TALK")="ON"
   SET TALK OFF
   m.cTalk="ON"
ELSE
   m.cTalk="OFF"
ENDIF &&* SET("TALK")="ON"

IF _DOS
   m.cSetSysMenu=SET("SYSMENU")
   SET SYSMENU OFF
   SAVE SCREEN TO m.sCEEScreen
ENDIF &&* _DOS


DO CEEIntro.SPR WITH VERSION, ;
   GetOnKey("Help", KEY_HELP), ;
   GetOnKey("Function", KEY_FUNCTION), ;
   GetOnKey("Comment", KEY_COMMENT), ;
   GetOnKey("Structure", KEY_STRUCTURE), ;
   GetOnKey("Indent", KEY_INDENT), ;
   GetOnKey("Outdent", KEY_OUTDENT), ;
   GetOnKey("Setup", KEY_SETUP), ;
   GetOnKey("Intro", KEY_INTRO), ""
IF _DOS
   SET SYSMENU &cSetSysMenu
   RESTORE SCREEN FROM sCEEScreen
ENDIF &&* _DOS

POP KEY
RETURN
*EOP CEEIntro

**
* Function....: CEEUnload
* Called by...: Global
*
* Abstract....:
*   Unloads the CEE Editor Extensions:
*      Releases the library
*      Redefines ON KEY LABELS as necessary
*      Closes EXPAND database
*
* Returns.....: TRUE
*
* Parameters..:
*   lKeepLibr = TRUE to not release the CEE library
*
* Notes.......:
**
PROCEDURE CEEUnload
PARAMETERS lKeepLibr
PRIVATE m.cTalk, m.lByRef, m.cError

* Set up environment & variables
IF SET("TALK")="ON"
   SET TALK OFF
   m.cTalk="ON"
ELSE
   m.cTalk="OFF"
ENDIF &&* SET("TALK")="ON"

m.lByRef = (SET("UDFParms") == "REFERENCE")
SET UDFPARMS TO VALUE

m.cError = ON("ERROR")

IF USED("EXPAND")
   USE IN EXPAND
ENDIF &&* USED("EXPAND")

IF .NOT. m.lKeepLibr .AND. "CEE"$SET("LIBRARY")
   * RELEASE LIBRARY CEE
   =FreeLibr("CEE")
ENDIF &&* .NOT. m.lKeepLibr .AND. "CEE"$SET("LIBRARY")
DO CEEKeyFree


DO ResetEnv

RETURN
*EOF CEEUnload



**
* Function....: FreeLibr
* Called by...: Global
*
* Abstract....:
*   Releases specified library.  This function is necessary
*   because FoxPro sometimes requires a full path name
*   to a library file.  We determine the full path here
*   in order to release the library.
*
* Returns.....:
*   TRUE if the file is opened & was released.
*   FALSE if the file was not found in list of open libraries.
*
* Parameters..:
*   cLibrary = Library name to release
*
* Notes.......:
**
FUNCTION FreeLibr
PARAMETERS cLibrary
PRIVATE m.cAllLibr, m.cOneLibr, m.lReleased

m.lReleased = .F.
m.cAllLibr = SET("LIBRARY")
FOR i = 1 TO OCCURS(",", SET("LIBRARY")) + 1
   m.nPos = ATC(",", m.cAllLibr)
   IF m.nPos > 0
      m.cOneLibr = LEFT(m.cAllLibr, m.nPos - 1)
      m.cAllLibr = SUBSTR(m.cAllLibr, m.nPos + 2)
   ELSE
      m.cOneLibr = m.cAllLibr
   ENDIF &&* m.nPos > 0

   IF ATC(m.cLibrary, m.cOneLibr) > 0
      RELEASE LIBRARY (m.cOneLibr)
      m.lReleased = .T.
   ENDIF &&* ATC(m.cLibrary, m.cOneLibr) > 0
ENDFOR &&* i = 1 TO OCCURS(",", SET("LIBRARY")) + 1


RETURN m.lReleased
*EOF FreeLibr

**
* Function....: LookFor
*
* Called by...: Programs looking for a file
*
* Abstract....: Used in place of LOCFILE - so that we take control.
*
* Returns.....: Character - file name - or "" if not found.
*
* Parameters..:
*
* Notes.......:
**
FUNCTION LookFor
PARAMETERS cLookinFor
PRIVATE m.cSetPath, m.nStart, m.nBreak, m.nEndBreak, m.cCompat, m.cAppPath
PRIVATE m.cFile, m.cChkPath, m.nCallLevel, m.cTemp

m.cCompat = SET("COMPATIBLE")
SET COMPATIBLE ON

m.cFile=""
m.cChkPath=""
m.nCallLevel=1
DO WHILE LEN(SYS(16, m.nCallLevel)) <> 0
   m.nCallLevel = m.nCallLevel + 1
ENDDO &&* LEN(SYS(16, m.nCallLevel)) <> 0
m.nCallLevel=m.nCallLevel-1
IF " "$SYS(16,m.nCallLevel)
   m.cTemp=SUBSTR(SYS(16,m.nCallLevel),RAT(" ",SYS(16,m.nCallLevel))+1)
   m.cAppPATH=LEFT(m.cTemp,RAT("\",m.cTemp)) + m.cLookinFor
ELSE
   m.cAppPath=LEFT(SYS(16,m.nCallLevel),RAT("\",SYS(16,m.nCallLevel))) + m.cLookinFor
ENDIF &&* " "$SYS(16,m.nCallLevel)

IF FILE(m.cAppPath)
   * found in APP directory
   m.cFile = m.cAppPath
ELSE
   m.cChkPath = SYS(2004) + m.cLookinFor
   IF FILE(m.cChkPath)
      * found startup directory
      m.cFile = m.cChkPath
   ELSE
      m.cChkPath = SYS(5)+SYS(2003)
      IF RIGHT(m.cChkPath, 1) <> "\"
         m.cChkPath = m.cChkPath + "\" + m.cLookinFor
      ELSE
         m.cChkPath = m.cChkPath + m.cLookinFor
      ENDIF &&* RIGHT(m.cChkPath, 1) <> "\"
      
      IF FILE(m.cChkPath)
         * found in default directory
         m.cFile = SYS(5)+SYS(2003) + "\" + m.cLookinFor
      ELSE
         m.cSetPath=SET("PATH")
         IF RIGHT(m.cSetPath,1)<>";"
            m.cSetPath = m.cSetPath + ";"
         ENDIF &&* RIGHT(m.cSetPath,1)<>"
         m.cSetPath = ";" + m.cSetPath
         m.lSuccess=.F.
         * Path will now = something like ";C:\FPW;H:\FP2;D:\FPDOS;"
         m.nStart = 1
         DO WHILE ATC(";", m.cSetPath, m.nStart+1)<>0
            m.nBreak = ATC(";", m.cSetPath, m.nStart)
            m.nEndBreak = ATC(";", m.cSetPath, m.nStart+1)
            m.nLen = (m.nEndBreak - m.nBreak) - 1
            m.cChkPath = SUBSTR(m.cSetPath, m.nBreak+1, m.nLen)+"\"
            IF FILE(m.cChkPath + m.cLookinFor)
               m.lSuccess=.T.
               EXIT
            ENDIF &&* FILE(m.cChkPath + m.cLookinFor)
            m.nStart = m.nStart+1
         ENDDO &&* ATC("
         
         IF m.lSuccess
            m.cFile = m.cChkPath + m.cLookinFor
         ENDIF &&* m.lSuccess
      ENDIF &&* FILE(m.cChkPath)
      
   ENDIF &&* FILE(m.cChkPath)
ENDIF &&* FILE(m.cAppPath)
SET COMPATIBLE &cCompat
RETURN m.cFile
*EOF LookFor


**
* Function....: GetProfileString
* Called by...: Global
*
* Abstract....:
*
* Returns.....:
*  Option value of a particular section, if found.
*  Null if not found.
*
* Parameters..:
*  cFile    = .INI file name
*  cSection = Section name to search under (not including [])
*  cOption  = Option name to search for
*
* Notes.......:
**
#define ZBUF_SIZE 20000     && Maximum .INI file size
FUNCTION GetProfileString
PARAMETERS cFile, cSection, cOption, cRetVal

PRIVATE m.nMLINE, m.fHandle, m.nMemoWidth
PRIVATE m.cBuffer, m.cLine, m.nPos, m.nLen

m.cSection = "[" + ALLTRIM(m.cSection) + "]"
m.nMLINE = _MLINE
nMemoWidth = SET("MEMOWIDTH")
SET MEMOWIDTH TO 256
m.cRetVal = ""
m.cFile = LookFor(m.cFile)
m.fHandle = FOPEN(m.cFile, 0)
IF m.fHandle > -1
   =FSEEK(m.fHandle, 0, 0)
   cBuffer = FREAD(m.fHandle, ZBUF_SIZE)
   =FCLOSE(m.fHandle)
   _MLINE = ATC(m.cSection, m.cBuffer)
   IF _MLINE > 0
      m.cLine = ""
      m.nLen = LEN(m.cBuffer)
      _MLINE = _MLINE - 1
      DO WHILE _MLINE < m.nLen .AND. LEFT(m.cLine, 1) <> ']'
         m.cLine = LTRIM(MLINE(m.cBuffer, 1, _MLINE))
         IF ATC(m.cOption, m.cLine) > 0
            m.nPos = AT("=", m.cLine)
            IF UPPER(RTRIM(LEFT(m.cLine, m.nPos - 1))) == UPPER(m.cOption)
               cRetVal = LTRIM(SUBSTR(m.cLine, m.nPos + 1))
               EXIT
            ENDIF &&* UPPER(RTRIM(LEFT(m.cLine, m.nPos - 1))) == UPPER(m.cOption)

         ENDIF &&* ATC(m.cOption, m.cLine) > 0
      ENDDO &&* _MLINE < m.nLen .AND. LEFT(m.cLine, 1) <> ']'
   ENDIF &&* _MLINE > 0
ENDIF &&* m.fHandle > -1

_MLINE = m.nMLINE
SET MEMOWIDTH TO (nMemoWidth)

RETURN m.cRetVal
*EOF GetProfileString



************************************************************************************************
*
*  Routine for setting a string in a user configuration file
*
*  Written by:  Gregory A. Green   (Thanks, Greg)
*               3832 Forest Creek Way
*               Martinez, GA  30907
*               (Minor modifications by COB System Designs)
*
*  Program:     PROFILE.PRG 1994 Gregory A. Green. All rights reserved.

*  Return Value:      number of bytes written to file, or 0 if cannot write to file (Note: the
*                     value returned will be the number of bytes last successfully written and
*                     not necessarily the number of bytes for the string passed to write;
*                     therefore, success is determined if number returned is greater than zero.)
*
*  Parameters:        cFileName    the name of the configuration file; full path optional,
*                                  will use the search path as specified by SET PATH command
*                                  if not located first in the current directory
*                     cStrSection  the section in the configuration file to write the
*                                  string under
*                     cStrName     the name of the string text to write
*                     cStrValue    the value of the string text to write (Note: the value
*                                  does not have to be a string -- can be passed as a string,
*                                  numeric, or logical.)
*
*
FUNCTION SetProfileString
PARAMETER m.cFileName, m.cStrSection, m.cStrName, m.cStrValue
PRIVATE m.fHandle, m.cStrBuffer, m.fTHandle, m.cTempName, m.nNumBytes, m.lWriteSection
PRIVATE m.lWriteValue, m.cBakName

m.cFileName = LookFor(m.cFileName)
IF .NOT. EMPTY(m.cFileName)
   m.cStrSection = '[' + ALLTRIM(m.cStrSection) + ']'
   m.cFileName = FULLPATH(m.cFileName)
   m.lWriteSection = .F.                                   && Set not written flag (section)
   m.lWriteValue = .F.                                     && Set not written flag (value)
   m.fHandle = FOPEN(m.cFileName,12)                         && Open conf file for read/write
   m.cTempName = LEFT(m.cFileName, RAT("\", m.cFileName)) + "temp.ini"
   m.fTHandle = FCREATE(m.cTempName)                          && Create temporary conf file
   DO WHILE NOT FEOF(m.fHandle)                            && Loop to find string header section
      m.cStrBuffer = FGETS(m.fHandle)                        && Get line of text from conf file
      m.nNumBytes = FPUTS(m.fTHandle,m.cStrBuffer)              && Write out text name and value
      IF ATC(m.cStrSection,LTRIM(m.cStrBuffer)) = 1          && Test if section header found
         m.lWriteSection = .T.                             && Indicate section header written
         DO WHILE NOT FEOF(m.fHandle)                      && Loop to find string text
            m.cStrBuffer = FGETS(m.fHandle)                  && Get string of text from file
            IF ATC(m.cStrName,LTRIM(m.cStrBuffer)) = 1       && Test if string text found
               m.nNumBytes = PutStrValue(m.fTHandle,m.cStrName,m.cStrValue)
               m.lWriteValue = .T.                         && Indicate conf value written
               EXIT
            ELSE
               IF ATC("[",m.cStrBuffer) = 1                && Check for next section
                  m.nNumBytes = PutStrValue(m.fTHandle,m.cStrName,m.cStrValue)
                  m.lWriteValue = .T.                      && Indicate conf value written
                  m.nNumBytes=FPUTS(m.fTHandle,m.cStrBuffer)    && Write out text name and value
                  EXIT
               ELSE
                  m.nNumBytes=FPUTS(m.fTHandle,m.cStrBuffer)    && Write out text name and value
               ENDIF &&* ATC("[",m.cStrBuffer) = 1                && Check for next section
            ENDIF &&* ATC(m.cStrName,LTRIM(m.cStrBuffer)) = 1       && Test if string text f
         ENDDO &&* NOT FEOF(m.fHandle)                      && Loop to find string text
         IF !m.lWriteValue                                 && Check if conf value written
            m.nNumBytes = PutStrValue(m.fTHandle,m.cStrName,m.cStrValue)
            m.lWriteValue = .T.                            && Indicate conf value written
         ENDIF &&* !m.lWriteValue                                 && Check if conf value 
         IF m.nNumBytes > 0                                && Check if user text written
            DO WHILE NOT FEOF(m.fHandle)                   && Loop to write remaining file
               m.cStrBuffer = FGETS(m.fHandle)               && Get text from conf file
               m.nNumBytes = FPUTS(m.fTHandle,m.cStrBuffer)     && Write text to temp file
            ENDDO &&* NOT FEOF(m.fHandle)                   && Loop to write remaining file
         ENDIF &&* m.nNumBytes > 0                                && Check if user text w
         EXIT                                            && Exit loop
      ENDIF &&* ATC(m.cStrSection,LTRIM(m.cStrBuffer)) = 1          && Test if section
   ENDDO &&* NOT FEOF(m.fHandle)                            && Loop to find string 
   IF !m.lWriteSection                                     && Check if sect/conf value written
      m.cStrBuffer = "[" + m.cStrSection + "]"
      m.nNumBytes=FPUTS(m.fTHandle,m.cStrBuffer)                && Write out section header text
      IF m.nNumBytes > 0
         m.nNumBytes = PutStrValue(m.fTHandle,m.cStrName,m.cStrValue)
      ENDIF &&* m.nNumBytes > 0
   ENDIF &&* !m.lWriteSection                                     && Check if sect/
   =FCLOSE(m.fHandle)                                      && Close file
   =FCLOSE(m.fTHandle)                                      && Close file
   IF m.nNumBytes > 0                                      && Check if user text written
      ndx = ATC(".",m.cFileName)                           && Get file name w/o extension
      m.cBakName = LEFT(m.cFileName,ndx) + "BAK"             && Add extension to bak name
      IF FILE(m.cBakName)                                  && Check if backup exists
         DELETE FILE (m.cBakName)                          && Delete if exists
      ENDIF &&* FILE(m.cBakName)                                  && Check if backup e
      RENAME (m.cFileName) TO (m.cBakName)
      RENAME (m.cTempName) TO (m.cFileName)
   ELSE
      DELETE FILE m.cTempName                              && Not written, del tmp & return
   ENDIF &&* m.nNumBytes > 0                                      && Check if user 
ELSE
   m.fHandle = FCREATE(m.cFileName)                          && File does not exist, create
   IF m.fHandle > -1                                       && Check for file creation error
      m.cStrBuffer = "[" + m.cStrSection + "]"
      m.nNumBytes=FPUTS(m.fHandle,m.cStrBuffer)                && Write out section header text
      IF m.nNumBytes > 0
         m.nNumBytes = PutStrValue(m.fHandle,m.cStrName,m.cStrValue)
         =FCLOSE(m.fHandle)                                && Close file
      ENDIF &&* m.nNumBytes > 0
   ELSE
      m.nNumBytes = 0
   ENDIF &&* m.fHandle > -1                                       && Check for file
ENDIF &&* .NOT. EMPTY(m.cFileName)
RETURN m.nNumBytes


************************************************************************************************
*
*  Routine for writing the user string value to the configuration file based on data type
*
FUNCTION PutStrValue
PARAMETER handle, m.cStrName, m.cStrValue
PRIVATE m.cStrBuffer

DO CASE                                                 && Determine data type to write
   CASE TYPE('m.cStrValue') = "C"                         && User string is of char type
      m.cStrBuffer = m.cStrName + "=" + m.cStrValue
      m.nNumBytes=FPUTS(handle,m.cStrBuffer)                && Write out text name and value
   CASE TYPE('m.cStrValue') = "N"                         && User string is numeric
      m.cStrBuffer = m.cStrName + "=" + STR(m.cStrValue)
      m.nNumBytes=FPUTS(handle,m.cStrBuffer)                && Write out text name and value
   CASE TYPE('m.cStrValue') = "D"                         && User string is date
      m.cStrBuffer = m.cStrName + "=" + DTOC(m.cStrValue)
      m.nNumBytes=FPUTS(handle,m.cStrBuffer)                && Write out text name and value
   CASE TYPE('m.cStrValue') = "L"                         && User string is logical
      IF m.cStrValue
         m.cStrBuffer = m.cStrName + "=TRUE"
      ELSE
         m.cStrBuffer = m.cStrName + "=FALSE"
      ENDIF &&* m.cStrValue
      m.nNumBytes=FPUTS(handle,m.cStrBuffer)                && Write out text name and value
   OTHERWISE                                            && Data type unknown
      m.nNumBytes = 0
ENDCASE
RETURN m.nNumBytes

**
* Procedure...: ResetEnv
*
* Called by...: Multiple Programs
*
* Abstract....:
*   Resets the FoxPro environment to what it was before
*   entering this program.  Assumes that the following variables
*   are defined: lByRef, cError, m.cTalk
*
* Parameters..:
*
* Notes.......:
**
PROCEDURE ResetEnv
*
IF m.lByRef
   SET UDFPARMS TO REFERENCE
ENDIF &&* m.lByRef
ON ERROR &cError
SET TALK &cTalk

RETURN
*EOP ResetEnv


