//////////////////////////////////////////////////
//
// File:     CBASE.H
// Author:   Patrick T. Hurley
// Created:  02-06-92 08:18:42pm
// Modified: 10-22-93 05:17:46pm
// Copyright (c) 1993 Foresight Consulting
//
// Notes:   A set of wrapper classes for the
//          CodeBase 5.0 Library
//

#ifndef __CBASE_H
#define __CBASE_H

#if !defined(S4FOX)
#include <d4all.h>
#endif

#include <iostream.h>

#ifndef __COMMON_H
enum Boolean { False = 0, True };

typedef unsigned short word;
typedef unsigned char  uchar;
typedef unsigned char  byte;
typedef unsigned long  ulong;
#endif

#if !defined(NDEBUG) && !defined(ZIL_MSWINDOWS)

#define LOCK_CLICK

#endif


#define CBE_NOSUCHFIELD    700
#define CBE_NOSUCHALIAS    CBE_NOSUCHFIELD + 1
#define CBE_NOSUCHTAG      CBE_NOSUCHALIAS + 1
#define CBE_IDXCREATE      CBE_NOSUCHTAG   + 1


class CodeBaseRoot {
public:
   CodeBaseRoot();
   ~CodeBaseRoot();
   static CODE4* cb;
   static void undo();

   static Boolean auto_open ()
		{ return Boolean (root.auto_open); }
   static Boolean auto_open (Boolean val)
		{ return Boolean (root.auto_open = val); }
   static Boolean create_error ()
		{ return Boolean (root.create_error); }
   static Boolean create_error (Boolean val)
		{ return Boolean (root.create_error = val); }
	static Boolean exclusive ()
		{ return Boolean (root.exclusive); }
	static Boolean exclusive (Boolean val)
		{ return Boolean (root.exclusive = val); }
	static Boolean expr_error ()
		{ return Boolean (root.expr_error); }
	static Boolean expr_error (Boolean val)
		{ return Boolean (root.expr_error = val); }
   static Boolean field_name_error ()
		{ return Boolean (root.field_name_error); }
   static Boolean field_name_error (Boolean val)
		{ return Boolean (root.field_name_error = val); }
   static Boolean go_error ()
		{ return Boolean ( root.go_error); }
   static Boolean go_error (Boolean val)
		{ return Boolean (root.go_error = val); }
	static int lock_attempts ()
		{ return root.lock_attempts; }
	static int lock_attempts (int val)
		{ return root.lock_attempts = val; }
   static Boolean open_error ()
		{ return Boolean (root.open_error); }
   static Boolean open_error (Boolean val)
		{ return Boolean (root.open_error = val); }
   static Boolean read_lock ()
		{ return Boolean (root.read_lock); }
   static Boolean read_lock (Boolean val)
		{ return Boolean (root.read_lock = val); }
	static Boolean read_only ()
		{ return Boolean (root.read_only); }
	static Boolean read_only (Boolean val)
		{ return Boolean (root.read_only = val); }
	static Boolean relate_error ()
		{ return Boolean (root.relate_error); }
	static Boolean relate_error (Boolean val)
		{ return Boolean (root.relate_error = val); }
   static Boolean safety ()
		{ return Boolean (root.safety); }
   static Boolean safety (Boolean val)
		{ return Boolean (root.safety = val); }
   static Boolean skip_error ()
		{ return Boolean (root.skip_error); }
   static Boolean skip_error (Boolean val)
		{ return Boolean (root.skip_error = val); }
   static Boolean tag_name_error ()
		{ return Boolean (root.skip_error); }
   static Boolean tag_name_error (Boolean val)
		{ return Boolean (root.skip_error = val); }

protected:
private:
   static CODE4  root;
   static int ref_count;
};


class cfield {
friend class cbase;
public:
   cfield (FIELD4 *fld=0) : f(fld) {}
   cfield (cbase& cb, char* fld) { init (cb, fld); }
	cfield (char* alias, char* fldName);

   void init (FIELD4* fld) { f = fld; }
   void init (cbase& cb, char* fld);

   void   operator= (const cfield& fld) { f4memo_assign (f, f4memo_str(fld.f)); }
   char*  operator= (char* ptr) { f4memo_assign (f, ptr); return ptr; }
   char   operator= (char chr) { f4assign_char (f, chr); return chr; }
   double operator= (double val) { f4assign_double (f, val); return val; }
   int    operator= (int val) { f4assign_int (f, val); return val; }
   long   operator= (long val) { f4assign_long (f, val); return val; }

   operator char()    const { return f4char (f); }
   operator double()  const { return f4double (f); }
   operator int()     const { return f4int (f); }
   operator long()    const { return f4long (f); }
   virtual operator char*()         { return f4memo_str (f); }
   virtual char*    operator () ()  { return f4ptr (f); }

   void assign (char* ptr)          { f4memo_assign   (f, ptr); }
   void assign (char* ptr, int len) { f4memo_assign_n (f, ptr, len); }
   void blank () { f4blank (f); }
	Boolean empty ();
   virtual int  copy (char* buf, unsigned len=0xFFFF) const
      { return f4ncpy (f, buf, len); }

   // special funcs...
   void today () { date4today (f4assign_ptr (f)); }

   virtual int   decimals () const { return f4decimals (f); }
   virtual int   len ()      const { return f4len (f); }
   virtual char* name ()     const { return f4name (f); }
   virtual int   type ()     const { return f4type (f); }

	int refresh() { return d4refresh_record(f->data); }
	int flush() { int rv = d4flush (f->data); d4unlock(f->data); return rv; }
   void mflush () { f4memo_flush (f); }
   void mfree () { f4memo_free (f); }

   friend ostream& operator<<(ostream&, const cfield&);
private:
   FIELD4* f;
};


int mnthsbtwn (char S4PTR* bdate, char S4PTR* tdate=0);
int yrsbtwn (char S4PTR* bdate, char S4PTR* tbdate=0);


class cbase : protected CodeBaseRoot {
friend class cfield;
public:
   cbase();
   cbase(char* fname);        // open this file...
   cbase(char* fname, FIELD4INFO* finfo, TAG4INFO* tinfo=0);
   virtual ~cbase();

	// status func
	enum cbaseStatus {
		Opening,
		Closing,
		Creating,
		Indexing,
		Reindexing,
		InvalidDBF,
		InvalidCDX
	};
	virtual void status (cbaseStatus) {}

   // info funcs...
	Boolean     chkStruct (FIELD4INFO* st1);
	Boolean     chkIndex (TAG4INFO* st1);
	FIELD4INFO* dbStruct () { return d4field_info (dbf); }
	TAG4INFO*   tagInfo ()  { return i4tag_info (idx); }
   int         undo ()     { return d4read (dbf, recno(), record()); }
   Boolean     isOpen ()   { return opened; }
   long        reccount () { return d4reccount (dbf); }
   long        recno ()    { return d4recno (dbf); }

   // Error response function
   virtual Boolean bad () { return Boolean (cb->error_code != 0); }
   virtual Boolean good () { return Boolean (cb->error_code == 0); }

	// open close alias etc...
	virtual void 	open () { /* stub */ }
	virtual void 	open (char* fname);
   virtual void   open (char* fname, FIELD4INFO* _dbf, TAG4INFO* _cdx=0);
	virtual void   iopen (char* iname=0) { idx = i4open (dbf, iname); }
   virtual Boolean create (char* fname, FIELD4INFO* finfo, TAG4INFO* tinfo=0);
   virtual Boolean link (char* alias);
   virtual Boolean close ();
   virtual Boolean iclose ();
   virtual char*   fname ()                 { return name; }
   virtual char*   alias ()                 { return d4alias(dbf); }
   virtual void    alias (char* alias)      { d4alias_set(dbf, alias); }
           cfield  field (char* fld);

   // NOTE: this is undoc'd
   Boolean chkDirty () { return Boolean (dbf->record_changed); }
   void    dirty () { dbf->record_changed = True; }
   void    clean () { dbf->record_changed = False; }

   // record based funcs
   long  record_width () { return d4record_width (dbf); }
   char* record () { return d4record (dbf); }

	// append record stuff
	enum append_type {
		Memos   = True,
		NoMemos = False
	};
	int append_start(int memo_stat = NoMemos)
		{ return d4append_start(dbf, memo_stat); }
	int  append()						{ return d4append(dbf); }
   virtual int  append_blank()           { return d4append_blank(dbf); }
   virtual int  append_data()            { return d4append_data(dbf); }
   virtual void blank()                  { d4blank(dbf); }

	// record deletion
	virtual void recall ()					  { d4recall (dbf); }
   virtual void del()                    { d4delete (dbf); }
   virtual int  deleted()                { return d4deleted (dbf); }

	// database status functions
	int bof()							{ return d4bof(dbf); }
   int eof()							{ return d4eof(dbf); }

   // where were we?
   double position () { return d4position (dbf); }
   int    position (double per) { return d4position_set (dbf, per); }

	// database current record movement functions
   int seek (char* key)          { return d4seek (dbf, key); }
	int bottom()						{ return d4bottom(dbf); }
   int top()							{ return d4top(dbf); }
   int operator++ ()             { return d4skip (dbf, 1); }
#pragma argsused
   int operator++ (int dummy)    { return d4skip (dbf, 1); }
   int operator-- ()             { return d4skip (dbf, -1); }
#pragma argsused
   int operator-- (int dummy)    { return d4skip (dbf, -1); }
   int skip (long num_records=1) { return d4skip (dbf, num_records); }
   int recno (long rec)          { return d4go (dbf, rec); }

	// index functions
   Boolean isTag (char* tag_name);
	Boolean tag ()  { d4tag_select (dbf, 0); return True; }
   Boolean tag (char* tag_name);
   Boolean tag (int tag_num);
   int tagPos (char* tag);
   char*   curTag ()
      {
         TAG4* t = d4tag_selected (dbf);
         return (t) ? t->alias : 0;
      }
   int   tagCount ();
   char* firstTag ()
      {
         TAG4* t = d4tag_next (dbf, 0);
         d4tag_select (dbf, t);
         return (t) ? t->alias : 0;
      }
   char* nextTag ()
      {
         TAG4* t = d4tag_next (dbf, d4tag_selected (dbf));
         d4tag_select (dbf, t);
         return (t) ? t->alias : 0;
      }
   char* prevTag ()
      {
         TAG4* t = d4tag_prev (dbf, d4tag_selected (dbf));
         d4tag_select (dbf, t);
         return (t) ? t->alias : 0;
      }

   Boolean index (char* name, TAG4INFO* t);
   Boolean index (char* name, char* expr, char* filter="", int unique=0, int desc=0);
   char*   key (char* buf=0, int bufsize=-1);

	// field level functions
   char* operator[] (char* fldname);

	// Integrity Checking and Maintenance
   virtual int pack()                    { return d4pack(dbf); }

	int check()							{ return d4check(dbf); }
	int flush_all()					{ return d4flush(dbf); }
   int commit()                  { return flush(); }
	int flush()							{ return d4flush(dbf); }
	int refresh()                 { return d4refresh_record(dbf); }
   int zap (long start=1, long stop=LONG_MAX)
      { return d4zap (dbf, start, stop); }

   DATA4*  dbf;
   INDEX4* idx;
protected:
   Boolean  opened;
   int      app_error;
   char*    name;

protected:
   virtual void init ();
};



#endif   // CBASE_HPP

//  End of CBASE.HPP
