*----------------------------------------------------------------------------
*-- Name.......:  CASEFIXR.PRG
*-- Date.......:  4-1-92
*-- Author.....:  Robert Riley
*-- Version....:  v1.0
*----------------------------------------------------------------------------
*-- Usage......:  Corrects data entry errors in mailing list address lines;
*--               puts first letter of each word in caps and puts correct
*--               spacing in street address abbreviations.
*-- Examples...:  Data in: "2600 nw 88th st"
*--               Data converted: "2600 NW 88th ST"
*--               Data in: "123 s.w. 10th way, apt. 706"
*--               Data converted: "123 S. W. 10th Way, Apt. 706"
*--
*-- Program examples:
*--
*--    Example 1  ? CORR_CASE("123 s.w. 10th way, apt. 706")
*--    Example 2  REPLACE ADDRESS1 with CORR_CASE(ADDRESS1)
*-- Calls......:  None
*-- Parameters.:  OLD_STRING = Uncorrected data (from data file or variable)
*-- Returns....:  Corrected data line
*----------------------------------------------------------------------------

CLOSE ALL
lz_talk = SET("TALK")
lz_status = SET("STATUS")
set status off
set talk off
clear
USE TESTDEMO   && just a sample file with the field name "ADDR"
@ 3,34 say "Data Samples" color gr+
set border to single
@ 2,0 to 4,79
?? "Data entry before"
?? "Data entry after function" at 40
?
?? "-----------------"
?? "-------------------------" at 40
?
do while .not. eof()

?? ADDR  && this would be your current database field
?? CORR_CASE(addr) at 40   && this would be your data corrected
?
*-- You can also do a "REPLACE ADDR with CORR_CASE(ADDR)"
*
skip
enddo
?
wait
close databases
set talk &lz_talk
set status &lz_status
RETURN

*--------------------------------------*
*  Here's what you add to your program
*--------------------------------------*

FUNCTION CORR_CASE
parameters OLD_STRING
private zc_CONVERT, zc_OLDDATA, zc_COUNT

store " " to zc_CONVERT
store OLD_STRING to zc_OLDDATA

DO while .not. eof()
store len(rtrim(zc_OLDDATA)) to addr2z
IF addr2z<1
store " " to zc_CONVERT
exit
ENDIF
store 1 to zc_count
store " " to zc_CONVERT
do while .not. eof()
if zc_count>addr2z
exit
endif
store .t. to yes

DO CASE
case substr(zc_OLDDATA,zc_count,1)="+" .and. yes=.t.
store zc_CONVERT + " + " to zc_CONVERT
if substr(zc_OLDDATA,zc_count+2,1)<>" "
   store zc_CONVERT + upper(substr(zc_OLDDATA,zc_count,1)) to zc_CONVERT
else
   store zc_count - 1 to zc_count
endif
store zc_count+2 to zc_count

case substr(zc_OLDDATA,zc_count,2)=".,"
if substr(zc_OLDDATA,zc_count+3)<>" "
   store zc_CONVERT+"., " + upper(substr(zc_OLDDATA,zc_count+3,1)) to zc_CONVERT
   store zc_count+3 to zc_count
else
   store zc_CONVERT+"., " + upper(substr(zc_OLDDATA,zc_count+4,1)) to zc_CONVERT
   store zc_count+3 to zc_count
endif 

case substr(zc_OLDDATA,zc_count,1)="." .and. yes=.t.
store zc_CONVERT + "." to zc_CONVERT
if substr(zc_OLDDATA,zc_count+1,1)=" " 
   store zc_CONVERT + upper(substr(zc_OLDDATA,zc_count+1,2)) to zc_CONVERT
   store zc_count+1 to zc_count
else
   store zc_CONVERT+" " + upper(substr(zc_OLDDATA,zc_count+1,1)) to zc_CONVERT
endif
store zc_count+1 to zc_count

case substr(zc_OLDDATA,zc_count+1,1)="(" .and. yes=.t.
store zc_CONVERT +substr(zc_OLDDATA,zc_count,1)+ " (" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+2,1)<>" "
   store zc_CONVERT + upper(substr(zc_OLDDATA,zc_count+2,1)) to zc_CONVERT
else
   store zc_count - 1 to zc_count
endif
store zc_count+2 to zc_count

case substr(zc_OLDDATA,zc_count,1)="(" .and. yes=.t.
store zc_CONVERT +substr(zc_OLDDATA,zc_count,1) to zc_CONVERT
if substr(zc_OLDDATA,zc_count+1,1)<>" "
   store zc_CONVERT + upper(substr(zc_OLDDATA,zc_count+1,1)) to zc_CONVERT
else
   store zc_count - 1 to zc_count
endif
store zc_count+1 to zc_count

case upper(substr(zc_OLDDATA,zc_count+1,2))="II" .and. yes=.t.
store zc_CONVERT + " II" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+3,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+2,1)) to zc_CONVERT
else
   store zc_count-1 to zc_count
endif
store zc_count+3 to zc_count

case upper(substr(zc_OLDDATA,zc_count+1,3))="III" .and. yes=.t.
store zc_CONVERT + " III" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+4,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+3,1)) to zc_CONVERT
else
store zc_count-1 to zc_count
endif
store zc_count+4 to zc_count

case upper(substr(zc_OLDDATA,zc_count,4))=" NE " .and. yes=.t.
store zc_CONVERT + " NE " to zc_CONVERT
if substr(zc_OLDDATA,zc_count+5,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+4,1)) to zc_CONVERT
else
   store zc_count-1 to zc_count
endif
store zc_count+4 to zc_count

case upper(substr(zc_OLDDATA,zc_count,4))=" NW " .and. yes=.t.
store zc_CONVERT + " NW " to zc_CONVERT
if substr(zc_OLDDATA,zc_count+5,1)<>" "
store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+4,1)) to zc_CONVERT
else
store zc_count-1 to zc_count
endif
store zc_count+4 to zc_count

case upper(substr(zc_OLDDATA,zc_count,4))=" SE " .and. yes=.t.
store zc_CONVERT + " SE " to zc_CONVERT
if substr(zc_OLDDATA,zc_count+5,1)<>" "
store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+4,1)) to zc_CONVERT
else
store zc_count-1 to zc_count
endif
store zc_count+4 to zc_count

case upper(substr(zc_OLDDATA,zc_count,4))=" SW " .and. yes=.t.
store zc_CONVERT + " SW " to zc_CONVERT
if substr(zc_OLDDATA,zc_count+5,1)<>" "
store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+4,1)) to zc_CONVERT
else
store zc_count-1 to zc_count
endif
store zc_count+4 to zc_count

case upper(substr(zc_OLDDATA,zc_count,3))=" SW" .and. yes=.t.
store zc_CONVERT + " SW" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+5,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+3,1)) to zc_CONVERT
else
   store zc_count-1 to zc_count
endif
store zc_count+3 to zc_count

case upper(substr(zc_OLDDATA,zc_count,3))=" SE" .and. yes=.t.
store zc_CONVERT + " SE" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+5,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+3,1)) to zc_CONVERT
else
   store zc_count-1 to zc_count
endif
store zc_count+3 to zc_count

case upper(substr(zc_OLDDATA,zc_count,3))=" NE" .and. yes=.t.
store zc_CONVERT + " NE" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+5,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+3,1)) to zc_CONVERT
else
   store zc_count-1 to zc_count
endif
store zc_count+3 to zc_count

case upper(substr(zc_OLDDATA,zc_count,3))=" NW" .and. yes=.t.
store zc_CONVERT + " NW" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+5,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+3,1)) to zc_CONVERT
else
  store zc_count-1 to zc_count
endif
store zc_count+3 to zc_count

case upper(substr(zc_OLDDATA,zc_count,3))=" DR" .and. yes=.t. .and. ;
     upper(substr(zc_OLDDATA,zc_count+3,3))<>"IVE"
store zc_CONVERT + " DR" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+4,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+3,1)) to zc_CONVERT
else
   store zc_count-1 to zc_count
endif
store zc_count+3 to zc_count

case upper(substr(zc_OLDDATA,zc_count,3))=" AV" .and. yes=.t. .and. ;
     upper(substr(zc_OLDDATA,zc_count+3,4))<>"ENUE"
store zc_CONVERT + " AV" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+4,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+3,1)) to zc_CONVERT
else
   store zc_count-1 to zc_count
endif
store zc_count+3 to zc_count

case upper(substr(zc_OLDDATA,zc_count,3))=" PL" .and. yes=.t. .and. ;
upper(substr(zc_OLDDATA,zc_count+2,3))<>"ACE"
store zc_CONVERT + " PL" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+3,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+3,1)) to zc_CONVERT
else
   store zc_count-1 to zc_count
endif
store zc_count+3 to zc_count

case upper(substr(zc_OLDDATA,zc_count,3))=" WY" .and. yes=.t.
store zc_CONVERT + " WY" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+4,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+3,1)) to zc_CONVERT
else
   store zc_count-1 to zc_count
endif
store zc_count+2 to zc_count
       
case upper(substr(zc_OLDDATA,zc_count,3))=" LN" .and. yes=.t.
store zc_CONVERT + " LN" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+4,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+3,1)) to zc_CONVERT
else
   store zc_count-1 to zc_count
endif
store zc_count+3 to zc_count

case upper(substr(zc_OLDDATA,zc_count,5))=" TERR" .and. yes=.t. .and. ;
     upper(substr(zc_OLDDATA,zc_count+5,3))<>"ACE"
store zc_CONVERT + " TERR" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+5,1)<>" "
   store zc_CONVERT+upper(substr(zc_OLDDATA,zc_count+5,1)) to zc_CONVERT
else
   store zc_count-1 to zc_count
endif
store zc_count+6 to zc_count

case substr(zc_OLDDATA,zc_count,1)=" " .and. substr(zc_OLDDATA,zc_count+1,1) ;
    = " " .and. zc_count>1
store zc_CONVERT + " " + upper(substr(zc_OLDDATA,zc_count+2,1)) to zc_CONVERT
store zc_count+2 to zc_count
store .f. to yes
store zc_count+2 to zc_count
store .f. to yes

case substr(zc_OLDDATA,zc_count,1)="-" .and. yes=.t.
store zc_CONVERT + "-" to zc_CONVERT
if substr(zc_OLDDATA,zc_count+1,1)<>" "
   store zc_CONVERT + upper(substr(zc_OLDDATA,zc_count+1,1)) to zc_CONVERT
else
   store zc_count - 1 to zc_count
endif
   store zc_count+1 to zc_count

case substr(zc_OLDDATA,zc_count,1)="," .and. yes=.t.
store zc_CONVERT + "," to zc_CONVERT
if substr(zc_OLDDATA,zc_count+1,1)=" "
   store zc_CONVERT + upper(substr(zc_OLDDATA,zc_count+1,2)) to zc_CONVERT
   store zc_count+1 to zc_count
else
   store zc_CONVERT+" " + upper(substr(zc_OLDDATA,zc_count+1,1)) to zc_CONVERT
endif
store zc_count+1 to zc_count

case substr(zc_OLDDATA,zc_count,1)=" " .and. zc_count>1 .and. yes=.t.
store zc_CONVERT + " " + upper(substr(zc_OLDDATA,zc_count+1,1)) to zc_CONVERT
store zc_count+1 to zc_count
store .f. to yes

case substr(zc_OLDDATA,zc_count,1)<>" " .and. zc_count>1 .and. yes=.t.
store zc_CONVERT + lower(substr(zc_OLDDATA,zc_count,1)) to zc_CONVERT
store .f. to yes

case zc_count=1 .and. yes=.t.
store upper(substr(zc_OLDDATA,zc_count,1)) to zc_CONVERT

ENDCASE

store zc_count+1 to zc_count
ENDDO  && Go back and check the next set of character(s)
exit

ENDDO  && Completed with entire line of text.

store rtrim(zc_CONVERT) to zc_CONVERT
RETURN zc_CONVERT

*- End of program
