; Program ...: Caps.ASM
; Author ....: Ralph Davis
; Date ......: September 1, 1985
; Note ......: Turns the Capslock key on or off.  Note that this
;              listing includes the set of instructions for
;              turning the Capslock key both on and off.
;
;
	.LFCOND			; List false conditionals.
	PAGE 60,132		; Page length 60, width 132

COM	EQU 	0		; Assemble as .BIN file
D3	EQU 	1		; for Developer's Release.
		
CODESEG SEGMENT BYTE PUBLIC 'CODE'
CAPSLOCK PROC	FAR
	ASSUME CS:CODESEG
	IF	COM
	   ORG	100H		; ORG at 100H for .COM file.
	ENDIF
START:	PUSH	AX		; Save registers.
	PUSH 	DS
	PUSH 	SI
 	PUSH 	CX
	MOV     AX,40H          ; Point DS to system data segment
	MOV 	DS,AX
	MOV	SI,17H		; and SI to KB_FLAG.
	MOV 	CX,2		; Set counter to perform
				; loop twice.
LOOPER:	MOV	BL,[SI]		; Load flag contents 
	AND 	BL,0BFH		; and turn off Capslock bit.
				; Note that the instruction 
				; to turn the Capslock key on
				; is  OR BL,40H.
				; Every other instruction is
				; identical.
	MOV	[SI],BL		; Replace flag.
	INC	SI		; Point to KB_FLAG_1
	LOOP	LOOPER		; and do the same thing.
	POP	CX		; Restore registers.
	POP	SI
	POP	DS
	POP	AX
	IF	COM
	   INT	20H		; INT 20H if .COM file.
	ELSE
	   RET			; Far return to dBASE III.
	ENDIF
;
CAPSLOCK ENDP
CODESEG ENDS
	END	START
