* Calc.PRG
* As published in FoxTalk

* Author: Ilja V. Galakhov
* Modified by Bob Grommes   Replace macro expansions with EVALUATE();
*                           use PADR() instead of adding 80 spaces
*                           and chopping; change PRIVATE to LOCAL
*                           in NewCalculator; change .Y. and .N. to
*                           .T. and .F.  (8/7/95)
* Modified by Ilja Galakhov Declare Self property as PROTECTED;
*                           move initialization of Height and Width
*                           button properties into CalculatorButton
*                           class definition; change PRIVATE to LOCAL
*                           in CalculatorButton::Click method;
*                           change IF-ELSE-ENDIF
*                           to DO CASE-CASE-OTHERWISE-ENDCASE
*                           in CalculatorButton::Click method (8/11/95)
* Modified by Bob Grommes   Minor formatting changes and final test (8/17/95)

DEFINE       PAD Calculator OF _MSYSMENU PROMPT "\<Calculator" KEY ALT+C
ON SELECTION PAD Calculator OF _MSYSMENU DO NewCalculator IN Calc.prg

PROCEDURE NewCalculator
   LOCAL Calculator
   Calculator = CreateObject("Calculator")
   Calculator.Show
ENDPROC

DEFINE CLASS Calculator AS Form
   BackColor = 12632256 && Gray
   BorderStyle = 1 && Single line
   Caption = "Calculator"
   FontName = "MS Sans Serif"
   FontSize = 8
   MaxButton = .F. && No maximizable
   ScaleMode = 3 && Pixels
   Height = 179
   Left = 153
   Top = 68
   Width = 160
   Value = SPACE(80)
   PROTECTED Self

   PROCEDURE Init
      THIS.Self = THIS
   ENDPROC

   ADD OBJECT ExpressionBox AS TextBox ;
      WITH BackColor = 12632256, ;
           FontName = "MS Sans Serif", ;
           FontSize = 8, ;
           Height = 21, ;
           Left = 14, ;
           Top = 25, ;
           Width = 131
   ADD OBJECT Button1  AS CalculatorButton ;
      WITH Caption = "{", ;
           Left = 7, ;
           Top = 65
   ADD OBJECT Button2  AS CalculatorButton ;
      WITH Caption = "7", ;
           Left = 31, ;
           Top = 65
   ADD OBJECT Button3  AS CalculatorButton ;
      WITH Caption = "8", ;
           Left = 55, ;
           Top = 65
   ADD OBJECT Button4  AS CalculatorButton ;
      WITH Caption = "9", ;
           Left = 79, ;
           Top = 65
   ADD OBJECT Button5  AS CalculatorButton ;
      WITH Caption = "/", ;
           Left = 103, ;
           Top = 65
   ADD OBJECT Button6  AS CalculatorButton ;
      WITH Caption = '"', ;
           Left = 127, ;
           Top = 65
   ADD OBJECT Button7  AS CalculatorButton ;
      WITH Caption = "}", ;
           Left = 7, ;
           Top = 91
   ADD OBJECT Button8  AS CalculatorButton ;
      WITH Caption = "4", ;
           Left = 31, ;
           Top = 91
   ADD OBJECT Button9  AS CalculatorButton ;
      WITH Caption = "5", ;
           Left = 55, ;
           Top = 91
   ADD OBJECT Button10 AS CalculatorButton ;
      WITH Caption = "6", ;
           Left = 79, ;
           Top = 91
   ADD OBJECT Button11 AS CalculatorButton ;
      WITH Caption = "*", ;
           Left = 103, ;
           Top = 91
   ADD OBJECT Button12 AS CalculatorButton ;
      WITH Caption = "%", ;
           Left = 127, ;
           Top = 91
   ADD OBJECT Button13 AS CalculatorButton ;
      WITH Caption = "(", ;
           Left = 7, ;
           Top = 117
   ADD OBJECT Button14 AS CalculatorButton ;
      WITH Caption = "1", ;
           Left = 31, ;
           Top = 117
   ADD OBJECT Button15 AS CalculatorButton ;
      WITH Caption = "2", ;
           Left = 55, ;
           Top = 117
   ADD OBJECT Button16 AS CalculatorButton ;
      WITH Caption = "3", ;
           Left = 79, ;
           Top = 117
   ADD OBJECT Button17 AS CalculatorButton ;
      WITH Caption = "-", ;
           Left = 103, ;
           Top = 117
   ADD OBJECT Button18 AS CalculatorButton ;
      WITH Caption = "C", ;
           Left = 127, ;
           Top = 117, ;
           Cancel = .T.
   ADD OBJECT Button19 AS CalculatorButton ;
      WITH Caption = ")", ;
           Left = 7, ;
           Top = 143
   ADD OBJECT Button20 AS CalculatorButton ;
      WITH Caption = "0", ;
           Left = 31, ;
           Top = 143
   ADD OBJECT Button21 AS CalculatorButton ;
      WITH Caption = ".", ;
           Left = 55, ;
           Top = 143
   ADD OBJECT Button22 AS CalculatorButton ;
      WITH Caption = "^", ;
           Left = 79, ;
           Top = 143
   ADD OBJECT Button23 AS CalculatorButton ;
      WITH Caption = "+", ;
           Left = 103, ;
           Top = 143
   ADD OBJECT Button24 AS CalculatorButton ;
      WITH Caption = "=", ;
           Left = 127, ;
           Top = 143, ;
           Default = .T.
ENDDEFINE

DEFINE CLASS CalculatorButton AS CommandButton
   Height = 23
   Width = 24

   PROCEDURE Click
      LOCAL e, t
      e = THIS.Parent.ExpressionBox.Value
      t = TYPE(e)

      DO CASE
         CASE THIS.Caption = "="

            DO CASE
               CASE t = "C"
                  e = PADR(["] + EVALUATE(e) + ["],80)
               CASE t = "N"
                  e = PADR(LTRIM(STR(EVALUATE(e), 20, 7)),80)
               CASE t = "D"
                  e = PADR('{' + DTOC(EVALUATE(e)) + '}',80)
               CASE t = "L"
                  e = PADR(IIF(EVALUATE(e),".T.",".F."),80)
            ENDCASE

         CASE THIS.Caption = "C"

            e = SPACE(80)

         OTHERWISE

            e = PADR(RTRIM(e) + THIS.Caption,80)

      ENDCASE

      THIS.Parent.ExpressionBox.Value = e
      THIS.Parent.ExpressionBox.Refresh
   ENDPROC

ENDDEFINE
