* Automates adding various clauses to screen fields
* by directly modifying .SCX files. Just generate the screen(s)
* and you're done.
* Inspired by George Goley IV in "Creating FoxPro Applications"
* Get this superior book if you can!
* Assumptions:
* 1) Memory variables are used for all GET fields
* 2) You want to control access to each GET field via a logical field
*	in its WHEN clause. If you use a data dictionary that contains each
*	field name, use this code to turn every GET field "on":
*	SELECT DATADICT
*	SCAN
*		TEMP='L' + ALLTRIM(FieldName)
*		PUBLIC &TEMP  && Declare PUBLIC!
*		STORE .T. TO &TEMP
*	ENDSCAN
*   This way the same screens can be used in a READ-ONLY situation. Also
*	access to each GET field can be controlled.
* 3) The 2nd character of each field name is used for validation.
* If no validation is to be done, use a '_'. Otherwise, see below for
* an easy way to incorporate some simple edits.
* 4) You want some default values for those same fields that will be
* validated. 
* 5) For alphanumeric fields: Select on entry, force to UPPER case
*    For numeric fields     : Select on entry, suppress if 0
*    For memo fields        : Select on entry, use a scroll bar

* This program will do:
* 1) Adds logical variable name (based on memory variable) to WHEN clause
* 2) Plugs in PICTURE clause based on FILLTYPE (basically vartype)
* 3) Fills in VALID clause and default value (i.e. State or country)
*    based on 2nd character of fieldname.
*     D - date (needs VALDATE.prg)
*     S - state (needs VALTABLE.prg and STATES.dbf)
*     C - country (needs VALTABLE.prg and COUNTRY.dbf)
* 3a) Kluge - We use 'M' for MEMO fields 
*     Make MEMO fields: 1) EDIT rather than GET, 2) Set SCROLL BAR on
*     3)Allow TABs.


m.l_scx=GETFILE("SCX","Choose a screen to be modified")
IF EMPTY(m.l_scx)
	RETURN
ENDIF
IF USED('allwv')
	USE IN allwv
ENDIF
USE (l_scx) IN SELECT(1)  ALIAS allwv AGAIN
SELECT allwv

SCAN FOR OBJTYPE=15  && GET fields only
	*---- Picture clause	
	DO CASE
		*** If you're an alpha type, we'll give you an '@!K' picture
		*** Select on entry, force to UPPER case
		CASE fillchar='C' AND objtype=15
			REPLACE picture WITH '"@!K"'

		*** If you're a numeric type, we'll give you an '@KZ' picture
		*** Select on entry, Blank if 0
		CASE fillchar='N' AND objtype=15	
			REPLACE picture WITH '"@KZ"'

		*** Otherwise, we'll give you a '@K' picture
		*** Select on entry
		OTHERWISE
			REPLACE picture WITH '"@K"'
	ENDCASE
ENDSCAN

*---- Logical Name
*** Plug in logical variable name into WHEN clause of READ
*** and change 'Procedure' TO 'Expression'
REPLACE ALL ;
    when WITH "L"+SUBSTR(name,3,LEN(name)-2),;
	whentype WITH 0 ;
	FOR !EMPTY(name) AND objtype=15


*---- Validation & Initial values
*We'll replace SetupCode in 1st record after this SCAN
*This will default State(SC) or Country(US) to proper value
AutoInitVal=""
SCAN FOR !EMPTY(name) and ObjType = 15
	DO CASE
		CASE UPPER(SUBSTR(name,4,1)) = 'D'  && Date
			REPLACE Valid WITH "IF NOT valdate(" + name + ")" + CHR(13) +;
									"_CUROBJ=_CUROBJ" + CHR(13) +;
							   "ENDIF" 
		CASE UPPER(SUBSTR(name,4,1)) = 'S'  && State
			REPLACE Valid WITH "IF !valtable('STATES','STABBREV','state',"+ name + ")" +CHR(13) +;	
									"_CUROBJ=_CUROBJ" + CHR(13) +;
							   "ENDIF" 
			AutoInitVal=AutoInitVal + Name + ' = "SC"' + CHR(13)
		CASE UPPER(SUBSTR(name,4,1)) = 'C'  && Country
			REPLACE Valid WITH "IF !valtable('COUNTRY','CNABBREV','country',"+ name + ")" +CHR(13) +;	
									"_CUROBJ=_CUROBJ" + CHR(13) +;
							   "ENDIF"
			AutoInitVal=AutoInitVal + Name + ' = "US"' + CHR(13)
		CASE UPPER(SUBSTR(name,4,1)) = 'M'  && MEMO (See 3a) above)
			REPLACE ObjCode WITH 2  && Edit
			REPLACE ScrollBar WITH .T.
			REPLACE Tab WITH .T.
		ENDCASE
ENDSCAN

GO TOP

IF !EMPTY(AutoInitVal)
	AutoInitVal = "#SECTION 1" + CHR(13) + AutoInitVal
ENDIF
REPLACE SetupCode WITH AutoInitVal

USE IN allwv
CLOSE DATABASES

RETURN