***********************************************************************
*                            Abacus Networks                         **
*             11818 Bluecrest Ln., Whittier, CA 90606-2010           **
*                       Telephone (310) 907-2640                     **
***********************************************************************
*
*
*         Calls	: CurrQueue()               	(function in AbaLib)
*               : EndCap()              		(function in AbaLib)
*               : GetCParms()                  	(function in AbaLib)
*         	    : N_UserId()                   	(function in AbaLib)
*               : NWGetCapSt()                 	(function in AbaLib)
*               : NWGetQList()                 	(function in AbaLib)
*               : SetCParms()               	(function in AbaLib)
*               : StartCap()                   	(function in AbaLib)
*
*
********************************************************************************

********************************************************************************
******                              IMPORTANT                             ******
******                                                                    ******
******                            WINDOWS USERS                           ******
******                                                                    ******
******  Due to a  bug in MS FoxPro for Windows, it is essential to have   ******
******  the printer port (LPT1) captured before you start MS FoxPro for   ******
******  Windows, otherwise you will encounter problems using this library ******
******  also use only the default printer port being captured.            ******
******                                                                    ******
********************************************************************************

*
*  PROGRAM DESCRIPTION:
*
*  This program will assign the specified queue name to a specified
*  lpt device, using the AbaLib API library.
*
*  Parameters passed:
*
*  mQueue               This is the name queue to be use.
*
*
*  mLpt                 This is the LPT device number to be use.
*
*
*  Syntax               DO setprint WITH (Queue Name, Port Number)
*
*  Example              DO setprint WITH "HP4", 1
*


PARAMETERS mQueue, mLpt

IF PARAMETERS() < 2
   WAIT 'Two parameters are required for SETPRINT' WINDOW
   RETURN
ELSE
   IF TYPE('mQueue') <> 'C'
      WAIT 'Parameter 1 must be of type CHARACTER' WINDOW
      RETURN
   ENDIF ( TYPE('mQueue') <> 'C' )
   IF TYPE('mLpt') <> 'N'
      WAIT 'Parameter 2 must be of type NUMERIC' WINDOW
      RETURN
   ENDIF ( TYPE('mLpt') <> 'C' )
ENDIF ( PARAMETERS() < 2 )

mqueue=UPPER(ALLTRIM((mqueue)))

lpt=mlpt

SET LIBRARY TO AbaLib ADDITIVE

IF EMPTY(n_userid())
   WAIT 'You are not logged in to the server' WINDOW
   RETURN
ENDIF

RELEASE oldpparms, qlist, usepparms

=nwgetqlist('QLIST')

IF ASCAN(qlist, mqueue) = 0
   WAIT WINDOW 'Queue '+(mqueue)+' not found' NOWAIT
   RETURN
ENDIF

DO CASE
CASE nwgetcapst((mlpt)) = 2
   *% LPT device can not be capture
   WAIT WINDOW 'Specified LPT device not available' NOWAIT
   RETURN
CASE nwgetcapst((mlpt)) = 0
   *% LPT device is not being capture
   IF NOT startcap((mqueue),(mlpt))
      WAIT WINDOW 'Capture command failed' NOWAIT
      RETURN
   ENDIF
   IF NOT getcparms('USEPPARMS',(mlpt))
      WAIT WINDOW 'Get capture parameters failed' NOWAIT
      RETURN
   ENDIF
   STORE .T. TO mendcap
CASE nwgetcapst((mlpt)) = 1
   *% LPT device is being capture
   IF NOT getcparms('OLDPPARMS',(mlpt))
      WAIT WINDOW 'Get capture parameters failed' NOWAIT
      RETURN
   ENDIF
   IF mqueue <> currqueue((mlpt))
      oldqueue = currqueue((mlpt))
      IF NOT  startcap((mqueue),(mlpt))
	 WAIT WINDOW 'Capture command failed' NOWAIT
	 RETURN
      ENDIF
      moldqueue = .T.
   ENDIF
   IF NOT getcparms('USEPPARMS',(mlpt))
      WAIT WINDOW 'Get capture parameters failed' NOWAIT
      RETURN
   ENDIF
   moldparms = .T.
ENDCASE

*% SET NEW PARAMETERS

=setparms()

IF NOT setcparms('USEPPARMS',(mlpt))
   WAIT WINDOW 'Set capture parameters failed' NOWAIT
   RETURN
ENDIF
RETURN
*: EOF: SETPRINT.PRG
