'$FORM frmDemo
' Demonstration of how to use VGA palette in text mode
' start Visual Basic with /L VBDOS.QLB

OPTION EXPLICIT

' Define INTERRUPT type
TYPE RegType
	 ax    AS INTEGER
	 bx    AS INTEGER
	 cX    AS INTEGER
	 dx    AS INTEGER
	 bp    AS INTEGER
	 si    AS INTEGER
	 di    AS INTEGER
	 flags AS INTEGER
END TYPE

DECLARE SUB INTERRUPT (intnum AS INTEGER, inreg AS RegType, outreg AS RegType)
DECLARE SUB Blink (Switch%)
DECLARE SUB Demo ()
DECLARE SUB GetVga (Pal%, Red%, Green%, Blue%)
DECLARE SUB Prnt (BYVAL Row%, BYVAL Col%, Strng$, BYVAL ForeGround%, BYVAL BackGround%)
DECLARE SUB SetVga (Pal%, Red%, Green%, Blue%)

 Demo

SUB Blink (Switch%)
	'Sets blinking attribute
	'0 = off:high intensity on
	'1 = on

	DIM reg AS RegType

	reg.ax = &H1003     'Interrupt 10h, service 03h
	reg.bx = Switch% AND &HFF  'Enable/disable blinking
	INTERRUPT &H10, reg, reg

END SUB

SUB Demo ()

	DIM i AS INTEGER, k AS INTEGER
	DIM Pal(0 TO 15, 1 TO 3) AS INTEGER

	'Save existing Palette
	FOR i = 0 TO 15
		GetVga i, Pal(i, 1), Pal(i, 2), Pal(i, 3)
	NEXT i

	'make sure we are in text mode
	SCREEN 0
	CLS

	'Turn on high intensity background
	Blink 0

	'Show existing colors
	GOSUB showcols
	Prnt 20, 5, "press a key for vga colors", 15, 0
	WHILE INKEY$ = "": WEND

	CLS

	'Set new colors
	FOR i = 1 TO 15
		SetVga i, i * 4, i * 4, i * 4
	NEXT i

	'Show new colors
	GOSUB showcols
	Prnt 20, 5, "press a key for form", 15, 0
	WHILE INKEY$ = "": WEND
	
	'Show that it works when form is displayed
	frmDemo.SHOW 1
	CLS

	'Restore old Palette
	FOR i = 0 TO 15
		SetVga i, Pal(i, 1), Pal(i, 2), Pal(i, 3)
	NEXT i
			 
	'Show old colors
	GOSUB showcols
	Prnt 20, 5, "Old colors restored", 15, 0
	WHILE INKEY$ = "": WEND

EXIT SUB

showcols:
	FOR k = 0 TO 15
		Prnt k + 1, 5, STRING$(70, 254), k, 15 - k
	NEXT k
RETURN

END SUB

SUB GetVga (Pal%, Red%, Green%, Blue%)

	DIM reg AS RegType
	DIM Dacindex%

	'translate VB palette registers to DAC registers
	reg.bx = Pal% AND &HFF  'Palette No.
	reg.ax = &H1007         'Interrupt 10h, service 07h
	INTERRUPT &H10, reg, reg
	'Register is in BL
	Dacindex% = (reg.bx AND &HFF00) \ 256


	reg.bx = Dacindex%   'DAC Register to get
	reg.ax = &H1015      'Interrupt 10h, service 10h
	INTERRUPT &H10, reg, reg  'Get VGA DAC register

	'Blue goes in CL, Green in CH, Red in DH
	Green% = (reg.cX AND &HFF00) \ 256
	Blue% = (reg.cX AND &HFF)
	Red% = (reg.dx AND &HFF00) \ 256
	
END SUB

SUB Prnt (BYVAL Row%, BYVAL Col%, Strng$, BYVAL ForeGround%, BYVAL BackGround%)
	'Easy way to print in one statement
	'Foreground & background can be from 0-15

	IF BackGround% > 7 THEN
		ForeGround% = ForeGround% + 16
	END IF
	COLOR ForeGround%, BackGround%
	LOCATE Row%, Col%
	PRINT Strng$

END SUB

SUB SetVga (Pal%, Red%, Green%, Blue%)
	'Red, Green & Blue can be from 0-63

	DIM reg AS RegType
	DIM Dacindex%
	DIM BigCX&
	DIM BigDX&

	'have to use this bios call to translate VB palette
	'registers to DAC registers

	reg.bx = Pal% AND &HFF  'Palette No.
	reg.ax = &H1007         'Interrupt 10h, service 07h
	INTERRUPT &H10, reg, reg  '
	'Register is in BL
	Dacindex% = (reg.bx AND &HFF00) \ 256


	reg.bx = Dacindex%      'DAC Register to set

	'Blue goes in CL, Green in CH
	BigCX& = Blue% OR (Green% * 256&)
	'Check if no. exceeds VB integer max
	IF BigCX& > 32767 THEN
		'If so, negate
		reg.cX = BigCX& - 65536
	ELSE
		reg.cX = BigCX&
	END IF

	'Red goes in DH
	BigDX& = (Red% * 256&)
	IF BigDX& > 32767 THEN
		reg.dx = BigDX& - 65536
	ELSE
		reg.dx = BigDX&
	END IF

	reg.ax = &H1010      'Interrupt 10h, service 10h
	INTERRUPT &H10, reg, reg  'Set VGA DAC register

END SUB

