' FONTEST.BAS
'
'   Author:     Christy Gemmell
'   For:        Roy Olsen
'   Date:       4/5/1992
'
'   $DYNAMIC
'
'   $INCLUDE: 'QBX.BI'
'
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    DIM Block AS STRING * 16            ' To hold the new definition table

    LSET Block = STRING$(16, 255)       ' Light up 8 * 16 pixels

    InRegs.ax = &H1100                  ' Load user font
    InRegs.bx = &H1000                  ' AH = bytes per character
    InRegs.cx = 1                       ' Number of characters to change
    InRegs.dx = 156                     ' ASCII code of char to start at
    InRegs.es = VARSEG(Block)           ' Segment of definition table
    InRegs.bp = VARPTR(Block)           ' Offset of definition table.
    INTERRUPTX &H10, InRegs, OutRegs    ' Call Video BIOS

    CLS : LOCATE 10, 1
    FOR I% = 128 TO 255
        PRINT CHR$(I%);
    NEXT I%
END

'You must be careful to specify the correct number of bytes per
'character for the video adaptor being used. For VGA the number
'is 16 as used above, but EGA cards only use 14 bytes to define
'an individual character. Fortunately you don't have to worry
'about resetting the original character set, since QuickBASIC
'does this for you automatically when a program ends. It also
'does this if you switch screen modes, so be warned.

'I'll leave it to you to design your own characters. If you need
'to see how the existing character set is organised then you can
'find the address of it's definition table by reading the contents
'of interrupt vector 1Fh in low RAM. These four bytes at address
'0000:007C contain a pointer to the character definition table
'for the high ASCII characters 128-255. These are in your video
'card's ROM, however, so you can't alter them directly.
