DECLARE FUNCTION Zeller% (Day%, Month%, Year%)
'
FUNCTION Zeller% (Day%, Month%, Year%) STATIC
  ' Zeller Algorithm : Returns Day of the Week

  ' Returns weekday
  ' 0 = sunday ... 6 = saturday
  '
  TmpDay% = Day%
  TmpMonth% = Month%
  TmpYear% = Year%
  '
  IF TmpMonth% > 2 THEN
    TmpMonth% = TmpMonth% - 2
  ELSE
    TmpMonth% = TmpMonth% + 10
    TmpYear% = TmpYear% - 1
  END IF
  Century% = TmpYear% \ 100
  TmpYear% = TmpYear% MOD 100
  Zeller% = (TmpDay% - 1 + ((13 * TmpMonth% - 1) \ 5) + (5 * TmpYear% \ 4) + Century% \ 4 - 2 * Century% + 1) MOD 7
  '
END FUNCTION
