DEFINT A-Z
DECLARE FUNCTION DialogBox% (Height%, Wide%, ForeColor%, BackColor%, border%, Title$, Rh1$, Rh2$, Text$)
'==========================================================================
'                        DIALOG BOX FOR BASIC PDS 7.1 TOOLBOX
'This is a basic dialog box for the PDS 7.1 ToolBox. Try it out and see if
'it works for you.  Make any modification you want.  Use at your own risk.
'Let me know of any improvements. I sure many could be made.
'The following is an explanation of the function.
'  x% = DialogBox(Height%, Wide%, ForeColor%, BackColor%, border%, Title$, Rh1$, Rh2$, Text$)
'        x% = Integer returned. 1 = First Command Button, 2 = Second Command Button, 0 = ESC Pressed
'        Height% = Height% of Box in number of rows. The box is self centering
'                Note: Minimum should be 4 and rows should be in increments
'                      of 2s, i.e 4,6,8,10.  Max is 20
'        Wide% = Width or Lenght of box in number of columns. Max is 74
'        ForeColor% = 0 - 15
'        BackColor = 0 - 15
'        border% = 1 (Single Line), 2 (Double Line), 0 (No Border)
'        Title$ = String title of box (Max 15 characters)
'        Rh1$ = 1st button caption "Ok", "Save", etc.
'        Rh2$ = 2nd button caption "No", "ESC", etc.
'               Note:  Both Rh1$ and Rh2$ have to have a value.
'        Text$ = Text to show in the box at the start. Also Text$ return the string
'                entered into the edit field of the box
'
'
' Should you have any questions or suggestions, contact me on CompuServe:
'               Leo Kuneman, 73367,2553
' Finally, I have expanded on the EditField, Mouse, Alert, and Window functions
' and sub in the Basic 7.12 ToolBox. Also I have added PopWin and RemoveWin subs to
' make adding windows easier.  I will and these files to the forum soon.

DEFSNG A-Z
FUNCTION DialogBox% (Height%, Wide%, ForeColor%, BackColor%, border%, Title$, Rh1$, Rh2$, Text$)
DEFINT A-Z

'=========================================================================
'  Set up the Window
'=========================================================================
        IF Height% > 20 THEN EXIT FUNCTION
        IF Wide% > 74 THEN EXIT FUNCTION
        row1% = ((13 - (Height%) \ 2) - 1)
        row2% = ((13 + (Height%) \ 2) - 1)
        col1% = ((40 - (Wide%) \ 2) - 1)
        col2% = ((40 + (Wide%) \ 2) - 1)
        textfore% = ForeColor%
        textback% = BackColor%
        fore% = ForeColor%
        back% = BackColor%

        handle% = WindowNext
        WindowOpen handle%, row1%, col1%, row2%, col2%, textfore%, textback%, fore%, back%, 15, FALSE, FALSE, FALSE, TRUE, border%, Title$

'====================================================
' Put the text, editfield and buttons in the window.
'====================================================

        WindowLocate 1, 1
        WindowPrint 3, Text$
        WindowLocate (Height% - 2), 2
        WindowPrint 1, "Text:"
        WindowBox (Height% - 3), 8, (Height% - 1), (Wide% - 2)
        t$ = "text"
        EditFieldOpen 1, t$, (Height% - 1) - 1, 9, 15, 0, (Wide% - 11), (Wide% - 12), 5
        WindowLine Height%

        IF Rh2$ = "" THEN
                ButtonOpen 1, 1, Rh1$, (Height% + 1), (Wide% \ 2), 0, 0, 1
        ELSE
                ButtonOpen 1, 1, Rh1$, (Height% + 1), (Wide% \ 3), 0, 0, 1
                ButtonOpen 2, 1, Rh2$, (Height% + 1), ((Wide% \ 3) * 2), 0, 0, 1
        END IF
'==============================================================
'  Enter the Loop
'==============================================================
    currButton = 0
    currEditField = 1
    ExitFlag = FALSE
    WHILE NOT ExitFlag
        WindowDo currButton, currEditField
          SELECT CASE Dialog(0)
            CASE 1       'Button, or Enter, exit loop
                 currButton = Dialog(1)
                    IF currButton = 1 THEN
                        DialogBox% = 1
                        ExitFlag = TRUE
                        ButtonToggle 1
                    END IF
                    IF currButton = 2 THEN
                        DialogBox% = 2
                        ExitFlag = TRUE
                        ButtonToggle 2
                    END IF
            CASE 2
                currEditField = Dialog(2)
            CASE 6
                    IF currButton = 1 THEN
                        DialogBox% = 1
                        ExitFlag = TRUE
                        ButtonToggle 1
                    END IF
                    IF currButton = 2 THEN
                        DialogBox% = 2
                        ExitFlag = TRUE
                        ButtonToggle 2
                    END IF

            CASE 7                       'tab
                IF Rh2$ = "" THEN
                        IF currEditField = 1 THEN
                                currEditField = 0
                                currButton = 1
                        ELSE currButton = 1
                                currButton = 0
                                currEditField = 1
                        END IF
                ELSE
                        IF currEditField = 1 THEN
                                currEditField = 0
                                currButton = 1
                        ELSEIF currButton = 1 THEN
                                currButton = 2
                                currEditField = 0
                        ELSEIF currButton = 2 THEN
                                currEditField = 1
                        END IF
                END IF
            CASE 9                          'escape
                DialogBox% = 0
                WindowClose WindowCurrent
                EXIT FUNCTION
            CASE ELSE
        END SELECT

    WEND

    ' =======================================================================
    ' Assign the variable before closing the window, and close the window
    ' =======================================================================

    Text$ = EditFieldInquire$(1)
    WindowClose WindowCurrent
END FUNCTION

