'=================================
'DEMO01.bas     03/02/93   kso
' Shows how to open database file, index file
' and memo file
'=================================

'$INCLUDE: 'dbhdr.bi'

'=================================
'Initialize program
'
'=================================

'Set debug flag to TRUE for debugging
   debug = FALSE
'    debug = TRUE

Ddisp:
   CLS

'Open dBase file system
   dbfName$ = "test"                              'dBase filename

   dbChan = dbOpnDbf(dbfName$)                    'Open the dBase file
   IF dbChan <= 0 THEN
      PRINT "%ERROR opening DBF file"
   ELSE
      DbfHdrStat = dbGetDbfHdr(dbChan, Header1)
   END IF

   'Determine if there is a memo file and open if present
   IF Header1.Version = CHR$(&H83) THEN           'Memo file present
      dmChan = dbOpnMem(dbfName$)
      IF dmChan <= 0 THEN
         PRINT "%ERROR opening Memo file"
      ELSE
         MemHdrStat = dbGetMemHdr(dmChan, MemHeader)
      END IF
   END IF

   'Open the index file
   dnChan = dbOpnNdx("test1")
   IF dnChan <= 0 THEN
      PRINT "%ERROR opening Index file"
   ELSE
      NdxHdrStat = dbGetNdxHdr(dnChan, NdxHeader)
   END IF

'File system open, now get field info
   DIM Fld1(1 TO Header1.NumFields) AS FldDsc
   FldStat = dbGetDsc(dbChan, Flds, Fld1(), Header1.NumFields)

'=================================
'Main program
'
'=================================
   CLS
   PRINT "Status of all file operations:"
   PRINT STRING$(36, "-")
   PRINT
   PRINT "DBF Channel: "; dbChan; "    DbfHdrStat: "; DbfHdrStat
   PRINT "MEM Channel: "; dmChan; "    MemHdrStat: "; MemHdrStat
   PRINT "NDX Channel: "; dnChan; "    NdxHdrStat: "; NdxHdrStat
   PRINT
   INPUT "DBG-continue>", dbg$

'Close it up, end, goodbye
Done:
    CLOSE
    CLS
    END
