'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Writes to a file using DOS calls: replaces QuickBASIC WRITE, PUT and
'PRINT routines.
'
'NOTE: BASIC COMPILER 7.X users -- change VARSEG to SSEG.
'      QuickBASIC 4.X users     -- no modifications needed.
'

DEFINT A-Z

TYPE RegTypeX
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
  DS AS INTEGER
  ES AS INTEGER
END TYPE

DECLARE SUB InterruptX (IntNum, InRegsX AS RegTypeX, OutRegsX AS RegTypeX)
DECLARE SUB SetMAXError (ErrNum)

SUB WriteFile (FileHandle, Data$)
  
   '
   'Writes data$ to a file opened using MAXBASIC routines. WON'T write
   'to BASIC opened files. Writes starting at current cursor position.
   'Use SeekFile to set position.
   '
   'Sets MAXError to error if error occurs.
   '
  
   '---DOS type
   DIM Regs  AS RegTypeX
   Status = 100                                 'assume invalid file handle

   '---if opened then write to it
   IF FileHandle > 0 THEN                       'valid file handler
    
     Status = 0                                 'assume success
    
     Regs.AX = &H4000                           'memory -> disk
     Regs.BX = FileHandle                       'file
     Regs.CX = LEN(Data$)                       'no. bytes to write
     Regs.DX = SADD(Data$)                      'offset of memory
     Regs.DS = VARSEG(Data$)                    'segment of memory
     InterruptX &H21, Regs, Regs                'write to disk
    
     IF Regs.Flags AND 1 THEN Status = Regs.AX  'error handler
  
   END IF
  
   '--- error handler
   SetMAXError Status

END SUB

