'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Opens a file using DOS calls: replaces QuickBASIC OPEN routine.
'
'NOTE: BASIC COMPILER 7.X users -- change VARSEG to SSEG.
'      QuickBASIC 4.X users -- no modifications needed.
'
DEFINT A-Z

TYPE RegTypeX
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
  DS AS INTEGER
  ES AS INTEGER
END TYPE

DECLARE SUB InterruptX (IntNum, InRegsX AS RegTypeX, OutRegsX AS RegTypeX)
DECLARE SUB SetMAXError (ErrNum)
DECLARE FUNCTION CheckDrive (Drive$)

SUB OpenFile (filename$, filehandle)

        '
        'Opens a file for read/write operations. Returns the DOS allocated
        'file handle in 'filehandle'. Use 'filehandle' for all subsequent
        'file operations. Be sure to use the MAXBASIC CloseFile routine
        'when done - BASIC CAN'T CLOSE A FILE OPENED BY THIS ROUTINE.
        '
        'NOTE : Open fails is file does not exist.
        '
        'NOTE : Files opened using OpenFile are the equivalent of BASIC
        '       BINARY files.
        '
  
        '--- make sure drive is ready so DOS dosen't hang
        IF NOT CheckDrive(filename$) THEN SetMAXError &H15: EXIT SUB
       
        '--- DOS type
        DIM Regs  AS RegTypeX
       
        '--- ASCIIZ file name
        f$ = filename$ + CHR$(0)     'ASCIIZ file name
       
        '--- use DOS
        Regs.AX = &H3D02             'open file
        Regs.DX = SADD(f$)           'offset of file name
        Regs.DS = VARSEG(f$)         'offset of file name
        InterruptX &H21, Regs, Regs  'do it
       
        '--- assign handle
        IF Regs.Flags AND 1 THEN     'errors?
           filehandle = 0            'no handle
           Status = Regs.AX          'assign error
        ELSE
           filehandle = Regs.AX      'assign handle
        END IF

        '---- error handler
        SetMAXError Status                'set error level
  
END SUB

