'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'

DEFINT A-Z

'--- DBF type & declarations
'$INCLUDE: 'DBFUNC.BI'

DECLARE SUB GetRec (File, Record&, Record$)
DECLARE SUB GetNumrecs (File, HeadRecs&)

DECLARE FUNCTION MAXError (Msg$)

SUB SearchDBF (File, SearchData$, SRecord&, SRecord$) STATIC
 
  'Searches a DBF file for the pattern held in SearchData$.
  'Used because DBASFUNC LIB does not process dBASE index files.
  '
  'On entry:
  '     SearchData$ is the data to find
  '     File is the file to seach
  '     SRecord& controls the seach mode where:
  '             0=get NEXT matching record
  '            -1=start search from top (record 1)
  '  
  'On exit:
  '     SRecord& holds the record number of the record containing SearchData$
  '     SRecord$ is the record containing SearchData$
  '
 
  '---get last record
  GetNumrecs File, LastRec&
 
  '---reset to first record if so desired
  IF SRecord& = -1 THEN
    '---get 1st record
    Rec& = 1
    GetRec File, Rec&, Record$
  END IF
 
  SearchData$ = UCASE$(SearchData$)

  '---step through DBF
  DO

    '---look through record
    IF INSTR(UCASE$(Record$), SearchData$) THEN
      SRecord& = Rec&
      SRecord$ = Record$
      EXIT DO
    END IF
   
    '---reset record
    Rec& = 0
   
    '---get a record
    GetRec File, Rec&, Record$
  
    '---check for error
    IF Rec& > LastRec& THEN EXIT DO
   
  LOOP
  
END SUB

