'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Closes a file using DOS calls: replaces QuickBASIC CLOSE routine.
'
'NOTE: BASIC COMPILER 7.X users -- change VARSEG to SSEG.
'      QuickBASIC 4.X users     -- no modifications needed.
'

DEFINT A-Z

TYPE RegTypeX
  AX    AS INTEGER
  BX    AS INTEGER
  CX    AS INTEGER
  DX    AS INTEGER
  BP    AS INTEGER
  SI    AS INTEGER
  DI    AS INTEGER
  Flags AS INTEGER
  DS    AS INTEGER
  ES    AS INTEGER
END TYPE

DECLARE SUB InterruptX (IntNum, InRegsX AS RegTypeX, OutRegsX AS RegTypeX)
DECLARE SUB SetMAXError (ErrNum)

SUB CloseFile (FileHandle)

        '
        'Closes a file opened using OpenFile routine. More specifically,
        'allows you to close ANY file (this program or not) that used
        'FileHandle. Sets MAXError to error if error occurs.
        '
        'NOTE : Careful here, you can close QB with this!
        '
        '
 
        '--- DOS type
        DIM Regs  AS RegTypeX                           'DOS type
        Status = 0                                      'assume success
 
        '--- using 0 closes the keyboard!
        IF FileHandle < 1 THEN                          'exit if 0
           Status = 100                                 'invalid handle
        ELSE
           '---ask DOS to close this file
           Regs.AX = &H3E00                             'DOS close file
           Regs.BX = FileHandle                         'file
           InterruptX &H21, Regs, Regs                  'close filehandle
           IF Regs.Flags AND 1 THEN Status = Regs.AX    'set error status
        END IF

        '--- set error handler
        SetMAXError Status

END SUB

