'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Returns a database (DBF) records data.
'

 DEFINT A-Z

 '--- DBF type & declarations
 '$INCLUDE: 'DBFUNC.BI'

 DECLARE SUB GetRecSize (File, RecSize)
 DECLARE SUB GetHeadSize (File, HeadSize)
 DECLARE SUB SetMAXError (ErrNum)
 DECLARE SUB GetNumrecs (File, HeadRecs&)
 DECLARE SUB SeekRead (FileHandle, OffSet&, Data$)
 DECLARE SUB CheckFields (File)

SUB GetRec (File, Record&, Record$) STATIC

   '
   'Reads & returns a record from a dBASE III+ or IV database file (DBF).
   '
   'On entry Record& is:
   '
   '  Record& =  0 > Get next record -- returns record no. in Record&.
   '  Record& >  0 > get record Record&
   '  Record& = -1 > get last record
   '  Record& =  1 > get first record
   '
   'On exit Record& = Record number retrieved
   '
   'NOTE: GetRec() maintains a record pointer; to re-set it, call GetRec()
   '      with a record number.
   '
  
   '--- get DBF definition, if needed
   IF OldFile <> File THEN CheckFields File     'get definition if new file
   OldFile = File                               'save file number for next
  
   '--- figure record number to get
   IF Record& = 0 THEN                          'get next
     Rec& = Rec& + 1                            'pop record
   ELSEIF Record& = -1 THEN                     'get last
     Rec& = Rec& - 1                            'decr record
     IF Rec& <= 0 THEN Rec& = 1                 'fixup for first
   ELSE                                         'get THIS record
     Rec& = Record&                             'assign Rec&
   END IF

   '--- Get total records
   GetNumrecs File, HeadRecs&                   'get total recs
   IF Record& = 0 THEN Record& = Rec&           'assign it
  
   IF Rec& > HeadRecs& THEN                     'invalid record?
      SetMAXError 3000                          'end of DBF
      EXIT SUB                                  'exit early
   END IF
  
   '--- setup for read
   RecSize = Fld(0).RecSize                     'assign record size
   HeadSize = Fld(0).HeadSize                   'assign header size
  
   '--- prefill a string to get the record
   Record$ = SPACE$(RecSize)                    'make blank record
  
   '--- determine offset into dbf - recsize to move to start of record.
   OffSet& = (HeadSize + (RecSize * Rec&)) - RecSize
 
   '--- read record
   SeekRead File, OffSet&, Record$              'get the record!
  
END SUB

