'****************************************************************************
'  CONFIG.BAS
'  *********
'  This module allows the hadling of a global configuration file and
'  also updates the program on startup,  of the original executable
'  file location,  so the same config file is accessed everytime,
'  regardless of the path.
'
'                           JORDAN/DENSKE SOFTWARE PUBLISHING-VERSION 1.00
'                                    Serial Number UI_UICFG3.47-920911-001
'****************************************************************************
' Define all integers as alpha.
   DEFINT A-Z
   REM $DYNAMIC
' Define all inclusion files.
   '$INCLUDE: 'ui.bi'
' Constants for alert response's.
   CONST OK = 1: CONST CANCEL = 2
' Set up the Program Configuration Format.
   TYPE Config
      ColorScheme       AS STRING * 1
      Batch             AS STRING * 45
      PollTime          AS STRING * 8
      DayNiteProfile    AS INTEGER
      ActiveProfile     AS INTEGER
      QtrDay            AS INTEGER
      ActiveStyle       AS INTEGER
      ActiveRun         AS INTEGER
      ContinousRun      AS INTEGER
      ResetType         AS STRING * 3
      BaudRate          AS INTEGER
      CommPort          AS INTEGER
      PARITY            AS INTEGER
      StopBits          AS INTEGER
      WordLength        AS INTEGER
   END TYPE
' Global active variables.
   COMMON SHARED /jdprojs/ SaveDir           AS STRING
   COMMON SHARED /jdprojs/ DisplayType       AS INTEGER
   COMMON SHARED /uitools/ GloMenu           AS MenuMiscType
   COMMON SHARED /uitools/ GloTitle()        AS MenuTitleType
   COMMON SHARED /uitools/ GloItem()         AS MenuItemType
   COMMON SHARED /uitools/ GloWindow()       AS windowType
   COMMON SHARED /uitools/ GloButton()       AS buttonType
   COMMON SHARED /uitools/ GloEdit()         AS EditFieldType
   COMMON SHARED /uitools/ GloStorage        AS WindowStorageType
   COMMON SHARED /uitools/ GloWindowStack()  AS INTEGER
   COMMON SHARED /uitools/ GloBuffer$()
' Declare sub and functions.
   DECLARE FUNCTION OrgPrgLoc$ ()
   DECLARE FUNCTION OpenConfigFile% (ProgName$, FileNum, Config AS ANY)
   DECLARE FUNCTION GetConfig% (FileNum, Config AS ANY)
   DECLARE SUB WriteConfig (FileNum, Config AS ANY)
   DECLARE SUB RestoreDefaults (Config AS ANY)

REM $STATIC
FUNCTION GetConfig (FileNum, Config AS Config) STATIC
' Open the Configuration file.
      GET FileNum, 1, Config
      GetConfig = TRUE
      CLOSE FileNum
END FUNCTION

FUNCTION OpenConfigFile (ProgName$, FileNum, Config AS Config)
ON LOCAL ERROR RESUME NEXT
OPEN.CFG.START:
' Get the first free file #
   FileNum = FREEFILE
' Now open the file as an input to test for failure.
   OPEN ProgName$ + ".CFG" FOR INPUT AS FileNum
' Now test and pass back a fail/success
   IF ERR THEN
      ' Draw a backdrop.
         COLOR 15, 1
         CLS
      ' Now test the error message.
         SELECT CASE ERR
            CASE 53                    ' File Not Found Error..
            ' Prompt user that record is non-existent.
               a$ = "The " + ProgName$ + ".CFG" + "|"
               a$ = a$ + "file cannot be found!|"
               a$ = a$ + "You will need to reconfigure|"
               a$ = a$ + "the default parameters!|"
               r = Alert(4, a$, 9, 20, 14, 60, "OK", "", "")
            CASE ELSE
            ' Propmt user file is unaccessable.
               a$ = "Cannot access the Configuration|"
               a$ = a$ + "file for this program.  Check|"
               a$ = a$ + "file for corruption and re-install.|"
               r = Alert(4, a$, 9, 20, 13, 60, "OK", "Cancel", "")
               IF r = CANCEL THEN COLOR 7, 0: CLS : END 1
         END SELECT
      ' Close orginal file handle.
         CLOSE FileNum
      ' Reset the Global Err Value.
         ERR = 0
      ' Now let user know a series of defaults will be written to
      ' disk.
         a$ = "I am going to create a Configuration|"
         a$ = a$ + "files with default values.|"
         r = Alert(4, a$, 9, 20, 12, 60, "OK", "Cancel", "")
         IF r = CANCEL THEN COLOR 7, 0: CLS : END 1
      ' Get the first free file #
         FileNum = FREEFILE
      'Open the random-access file:
         OPEN ProgName$ + ".CFG" FOR RANDOM AS FileNum LEN = LEN(Config)
      ' Restore original parameters and update file.
         CALL RestoreDefaults(Config)
         CALL WriteConfig(FileNum, Config)
         OpenConfigFile = FALSE
         EXIT FUNCTION
   ELSE
      ' Close orginal file handle.
         CLOSE FileNum
      ' Reset the Global Err Value.
         ERR = 0
   END IF
' Open for Random Access
   OPEN ProgName$ + ".CFG" FOR RANDOM AS FileNum LEN = LEN(Config)
   IF LOF(FileNum) <> LEN(Config) THEN
   ' Draw a backdrop.
      COLOR 15, 1
      CLS
   ' Propmt user file is corrupt or improper format.
      a$ = "The configuration file on disk|"
      a$ = a$ + "is incompatible with this version|"
      a$ = a$ + "of software or is corrupted.|"
      r = Alert(4, a$, 9, 20, 13, 60, "OK", "Cancel", "")
      IF r = CANCEL THEN COLOR 7, 0: CLS : END 1
      ' Close orginal file handle.
         CLOSE FileNum
      ' Delete the incompatible version.
         KILL ProgName$ + ".CFG"
      ' Get the first free file #
         FileNum = FREEFILE
      'Open the random-access file:
         OPEN ProgName$ + ".CFG" FOR RANDOM AS FileNum LEN = LEN(Config)
      ' Restore original parameters and update file.
         CALL RestoreDefaults(Config)
         CALL WriteConfig(FileNum, Config)
         OpenConfigFile = FALSE
         EXIT FUNCTION
   END IF
   OpenConfigFile = TRUE
END FUNCTION

FUNCTION OrgPrgLoc$
DIM Regs AS RegType
'Get PSP address
  Regs.ax = &H6200
  CALL Interrupt(&H21, Regs, Regs)
  PSPSegment = Regs.bx
' Find environment address from PSP
  DEF SEG = PSPSegment
  EnvSegment = PEEK(&H2D) * 256 + PEEK(&H2C)
' Find the filename
  DEF SEG = EnvSegment
  EOT = FALSE                 'Set end of environment table flag
  Offset = 0
  WHILE NOT EOT
       Byte = PEEK(Offset)       'Get table character
       IF Byte = 0 THEN          'End of environment string?
'        PRINT                   'Uncomment to print environment
         Offset = Offset + 1
         Byte = PEEK(Offset)
         IF Byte = 0 THEN        'End of environment?
           Offset = Offset + 3   'Yes - Skip over nulls & tbl info
           C% = PEEK(Offset)
           WHILE C% <> 0                   'Assemble filename string
                FileN$ = FileN$ + CHR$(C%)    '  from individual
                Offset = Offset + 1           '  characters
                C% = PEEK(Offset)
           WEND
           EOT = TRUE              'Set flag to exit while/wend loop
         END IF
       ELSE                        'No-Read more environment string
'        PRINT CHR$(Byte);         'Uncomment to print environment
         Offset = Offset + 1
       END IF
  WEND
  OrgPrgLoc$ = FileN$
  DEF SEG
END FUNCTION

SUB RestoreDefaults (Config AS Config)
' This routine will reassign default vaules to passed array.
      Config.ColorScheme = "C"
      Config.Batch = "RESET.BAT"
      Config.PollTime = "08:00 PM"
END SUB

SUB WriteConfig (FileNum, Config AS Config) STATIC
' Place the configuration file onto the disk.
    PUT FileNum, 1, Config
    CLOSE FileNum
END SUB

