'**************************************************************************
'|    TESTCFG.BAS
'|
'|    A short demo of how to set up a bullet proof configuration file.
'|
'|                           JORDAN/DENSKE SOFTWARE PUBLISHING-VERSION 1.00
'|                                     Serial Number UI_UITC3.47-920911-001
'**************************************************************************
   DEFINT A-Z
   REM $DYNAMIC
' Define all inclusion files.
   '$INCLUDE: 'ui.bi'
' Constants for button types.
   CONST OK = 1
   CONST CANCEL = 2
   CONST SELECTED = 2
   CONST NOT.SELECTED = 1
   CONST COMMAND.BUTTON = 1
   CONST CHECK.BUTTON = 2
   CONST RADIO.BUTTON = 3
   CONST AREA.BUTTON = 4
   CONST VSCROLL.BUTTON = 6
   CONST HSCROLL.BUTTON = 7
   CONST BACK.COLOR = 3
' Set up the Program Configuration Format.
   TYPE Config
      ColorScheme       AS STRING * 1
      Batch             AS STRING * 45
      PollTime          AS STRING * 8
      DayNiteProfile    AS INTEGER
      ActiveProfile     AS INTEGER
      QtrDay            AS INTEGER
      ActiveStyle       AS INTEGER
      ActiveRun         AS INTEGER
      ContinousRun      AS INTEGER
      ResetType         AS STRING * 3
      BaudRate          AS INTEGER
      CommPort          AS INTEGER
      PARITY            AS INTEGER
      StopBits          AS INTEGER
      WordLength        AS INTEGER
   END TYPE
' Global active variables.
   COMMON SHARED /jdprojs/ SaveDir           AS STRING
   COMMON SHARED /jdprojs/ DisplayType       AS INTEGER
   COMMON SHARED /uitools/ GloMenu           AS MenuMiscType
   COMMON SHARED /uitools/ GloTitle()        AS MenuTitleType
   COMMON SHARED /uitools/ GloItem()         AS MenuItemType
   COMMON SHARED /uitools/ GloWindow()       AS windowType
   COMMON SHARED /uitools/ GloButton()       AS buttonType
   COMMON SHARED /uitools/ GloEdit()         AS EditFieldType
   COMMON SHARED /uitools/ GloStorage        AS WindowStorageType
   COMMON SHARED /uitools/ GloWindowStack()  AS INTEGER
   COMMON SHARED /uitools/ GloBuffer$()
' Declare all Sub & Function calls.
   DECLARE FUNCTION OrgPrgLoc$ ()
   DECLARE FUNCTION OpenConfigFile% (ProgName$, FileNum, Config AS ANY)
   DECLARE FUNCTION GetConfig% (FileNum, Config AS ANY)
   DECLARE FUNCTION ErrorProcessor% (a$)
   DECLARE FUNCTION CommConfig% ()
   DECLARE FUNCTION EditConfig% ()
   DECLARE SUB About ()
   DECLARE SUB MenuDisplay ()
   DECLARE SUB SetupDesktop ()
   DECLARE SUB SetupMenu ()
   DECLARE SUB MonoDisplay ()
   DECLARE SUB ColorDisplay ()
   DECLARE SUB WriteConfig (FileNum, Config AS ANY)
' Dimension all arrays.
   DIM GloTitle(MAXMENU)            AS MenuTitleType
   DIM GloItem(MAXMENU, MAXITEM)    AS MenuItemType
   DIM GloWindow(MAXWINDOW)         AS windowType
   DIM GloButton(MAXBUTTON)         AS buttonType
   DIM GloEdit(MAXEDITFIELD)        AS EditFieldType
   DIM GloWindowStack(MAXWINDOW)    AS INTEGER
   DIM GloBuffer$(MAXWINDOW + 1, 2)
   DIM SHARED Config                AS Config
' Set the on error functions.
   ON ERROR GOTO ERRORHANDLER
' Initialize the program.
   MenuInit
   WindowInit
   MouseShow
' Save current directory or startup directory.
' NOTE: While you are in the QBX enviroment the name of the program is
' going to be QBX.EXE.  So set the progname manually until right before
' you compile the program.
   ProgName$ = OrgPrgLoc$
   ProgName$ = LEFT$(ProgName$, (INSTR(ProgName$, ".") - 1))
' Discard the file name and ending chr$(92) if not a drive spec.
   a$ = RIGHT$(ProgName$, INSTR(ProgName$, CHR$(92)) + 1)
   SaveDir = MID$(ProgName$, 1, INSTR(ProgName$, a$) - 1)
' Remark out this statement when you compile the program, or you can force
' the CFG name by leaving this statement in...
   REM ProgName$ = SaveDir + CHR$(92) + "TESTCFG"
' Open the configuration  file.
    r = OpenConfigFile(ProgName$, FileNum, Config)
   IF r = TRUE THEN r = GetConfig(FileNum, Config)
   IF Config.ColorScheme = "M" THEN
      DisplayType = FALSE: CALL MonoDisplay
    ELSE
      DisplayType = TRUE: CALL ColorDisplay
    END IF
   DO: SOUND 440, 3: SOUND 560, 2: z = z + 1: LOOP UNTIL z = 2
' Return on error.
START:
      CALL MenuDisplay
      ProgramDone = FALSE
      WHILE NOT ProgramDone
        kbd$ = MenuInkey$
        IF kbd$ = CHR$(27) THEN
         a$ = "Exit Program?|"
         r = Alert(4, a$, 10, 35, 12, 65, "Yes", "No", "")
         IF r = 1 THEN
            ProgramDone = TRUE
         END IF
        END IF
        WHILE MenuCheck(2)
            GOSUB MenuTrap
        WEND
    WEND
' End Program
   MouseHide
   COLOR 15, 0
   CLS
   END
' If a menu event occured, call the proper demo, or if Exit, set ProgramDone
MenuTrap:
    menu = MenuCheck(0)
    item = MenuCheck(1)
    SELECT CASE menu
        CASE 1                         ' The Main File Menu
            SELECT CASE item
                CASE 1                             ' Parms Config.
                     WindowClose 1
                     r = EditConfig
                     IF r THEN
                        r = OpenConfigFile(ProgName$, FileNum, Config)
                        IF r THEN CALL WriteConfig(FileNum, Config)
                     END IF
                     CALL MenuDisplay
                CASE 2                             ' Comm Parms.
                     WindowClose 1
                     r = CommConfig
                     IF r THEN
                        r = OpenConfigFile(ProgName$, FileNum, Config)
                        IF r THEN CALL WriteConfig(FileNum, Config)
                     END IF
                     CALL MenuDisplay
                CASE 3                             ' Color...
                     WindowClose 1
                     CALL ColorDisplay
                     r = OpenConfigFile(ProgName$, FileNum, Config)
                     IF r THEN CALL WriteConfig(FileNum, Config)
                     CALL MenuDisplay
                CASE 4                             ' Monochrome...
                     WindowClose 1
                     CALL MonoDisplay
                     r = OpenConfigFile(ProgName$, FileNum, Config)
                     IF r THEN CALL WriteConfig(FileNum, Config)
                     CALL MenuDisplay
                CASE 6                             ' About..
                  CALL About
                CASE 8                             ' Exit Program.
                     ProgramDone = TRUE
            END SELECT
        END SELECT
RETURN
ERRORHANDLER:
' Now call the error handling function.
   result = ErrorProcessor(a$)
   ERR = 0
   SELECT CASE result
      CASE 1
         ' Ok button and message displayed.
            z = 0: DO: SOUND 987, 5: SOUND 329, 5: z = z + 1: LOOP UNTIL z = 3
            action = Alert(4, a$, 8, 25, 13, 55, "OK", "", "")
            CLOSE : ERR = 0: RESUME START
      CASE 2
         ' Ok & Retry button and applicable message displayed.
            z = 0: DO: SOUND 987, 5: SOUND 329, 5: z = z + 1: LOOP UNTIL z = 3
            action = Alert(4, a$, 8, 25, 13, 55, "Abort", "Retry", "")
            IF action = 2 THEN CLOSE : RESUME NEXT
            CLOSE : ERR = 0: RESUME START
      CASE 3
        ' Terminate message displayed and the program killed.
            z = 0: DO: SOUND 987, 5: SOUND 329, 5: z = z + 1: LOOP UNTIL z = 3
            action = Alert(4, a$, 8, 25, 13, 55, "OK", "", "")
            CLOSE : COLOR 7, 0: CLS
         ' inform user of software problem.
            PRINT "There is an internal software error occuring. Please"
            PRINT "Contact  - Jordan/Denske Software for a solution."
            PRINT "Error is number " + STR$(ERR)
         ' End with a error to DOS.
            END 1
      CASE 4
         ' Ok button and applicable message displayed.
            z = 0: DO: SOUND 987, 5: SOUND 329, 5: z = z + 1: LOOP UNTIL z = 3
            action = Alert(4, a$, 8, 25, 13, 55, "Abort", "Retry", "")
            IF action = 2 THEN RESUME NEXT
            KillErr% = TRUE: CLOSE : RESUME
      CASE ELSE
        ' Terminate message displayed and the program killed.
            z = 0: DO: SOUND 987, 5: SOUND 329, 5: z = z + 1: LOOP UNTIL z = 3
            action = Alert(4, a$, 8, 25, 13, 55, "OK", "", "")
            CLOSE : COLOR 7, 0: CLS
         ' inform user of software problem.
            PRINT "There is an internal software error occuring. Please"
            PRINT "Contact  - Jordan/Denske Software for a solution."
            PRINT "Error is number " + STR$(ERR)
         ' End with a error to DOS.
            END 1
   END SELECT

REM $STATIC
SUB About
         a$ = "Configuration Demo for PDS 7.x|"
    a$ = a$ + "|"
    a$ = a$ + "Copyright Jordan/Denske Software v1.00|"
    junk = Alert(4, a$, 9, 35, 13, 75, "", "", "")
END SUB

SUB ColorDisplay
    DisplayType = TRUE
    Config.ColorScheme = "C"
    MouseHide
    SetupMenu
    MenuSetState 1, 3, 2
    MenuSetState 1, 4, 1
    SetupDesktop
    MenuShow
    MouseShow
END SUB

FUNCTION CommConfig
' Set up info screen.
   ' (t)op, (b)ottom, (l)eft and (r)ight
     t = 4: b = 18: l = 21: r = 59
       IF NOT DisplayType THEN
         WindowOpen 2, t, l, b, r, 0, 7, 0, 7, 15, FALSE, FALSE, FALSE, TRUE, 2, "Comm Config"
       ELSE
         WindowOpen 2, t, l, b, r, 0, 3, 0, 3, 15, FALSE, FALSE, FALSE, TRUE, 2, "Comm Config"
       END IF
   WindowLine 14
' Draw the Baud Rate Frame.
     WindowBox 1, 2, 6, 17
     WindowLocate 1, 4
     WindowPrint 2, " Baud Rate "
' Draw the Comm Port Frame.
     WindowBox 8, 2, 13, 17
     WindowLocate 8, 4
     WindowPrint 2, " Comm Port "
' Draw the Parity Frame.
     WindowBox 1, 21, 5, 38
     WindowLocate 1, 23
     WindowPrint 2, " Parity "
' Draw the Bits Frame.
     WindowBox 6, 21, 9, 38
     WindowLocate 6, 23
     WindowPrint 2, " Stop Bits "
' Draw the Word Length Frame.
     WindowBox 10, 21, 13, 38
     WindowLocate 10, 23
     WindowPrint 2, " Word Length "
EDITCOMMSTART:
' Set up the local Constants
       CONST B1200.BUTTON = 1
       CONST B2400.BUTTON = 2
       CONST B4800.BUTTON = 3
       CONST B9600.BUTTON = 4
       CONST COM1.BUTTON = 5
       CONST COM2.BUTTON = 6
       CONST COM3.BUTTON = 7
       CONST COM4.BUTTON = 8
       CONST NONE.BUTTON = 9
       CONST EVEN.BUTTON = 10
       CONST ODD.BUTTON = 11
       CONST BIT1.BUTTON = 12
       CONST BIT2.BUTTON = 13
       CONST WORD7.BUTTON = 14
       CONST WORD8.BUTTON = 15
       CONST SAVE.BUTTON = 16
       CONST CANCEL.BUTTON = 17
' Open all buttons
      ButtonOpen B1200.BUTTON, NOT.SELECTED, " 1200", 2, 3, 0, 0, RADIO.BUTTON
      ButtonOpen B2400.BUTTON, NOT.SELECTED, " 2400", 3, 3, 0, 0, RADIO.BUTTON
      ButtonOpen B4800.BUTTON, NOT.SELECTED, " 4800", 4, 3, 0, 0, RADIO.BUTTON
      ButtonOpen B9600.BUTTON, NOT.SELECTED, " 9600", 5, 3, 0, 0, RADIO.BUTTON
      ButtonOpen COM1.BUTTON, NOT.SELECTED, " COM1", 9, 3, 0, 0, RADIO.BUTTON
      ButtonOpen COM2.BUTTON, NOT.SELECTED, " COM2", 10, 3, 0, 0, RADIO.BUTTON
      ButtonOpen COM3.BUTTON, NOT.SELECTED, " COM3", 11, 3, 0, 0, RADIO.BUTTON
      ButtonOpen COM4.BUTTON, NOT.SELECTED, " COM4", 12, 3, 0, 0, RADIO.BUTTON
      ButtonOpen NONE.BUTTON, NOT.SELECTED, " None", 2, 23, 0, 0, RADIO.BUTTON
      ButtonOpen EVEN.BUTTON, NOT.SELECTED, " Even", 3, 23, 0, 0, RADIO.BUTTON
      ButtonOpen ODD.BUTTON, NOT.SELECTED, " Odd", 4, 23, 0, 0, RADIO.BUTTON
      ButtonOpen BIT1.BUTTON, NOT.SELECTED, " 1 Bit", 7, 23, 0, 0, RADIO.BUTTON
      ButtonOpen BIT2.BUTTON, NOT.SELECTED, " 2 Bit", 8, 23, 0, 0, RADIO.BUTTON
      ButtonOpen WORD7.BUTTON, NOT.SELECTED, " Word 7", 11, 23, 0, 0, RADIO.BUTTON
      ButtonOpen WORD8.BUTTON, NOT.SELECTED, " Word 8", 12, 23, 0, 0, RADIO.BUTTON
      ButtonOpen SAVE.BUTTON, SELECTED, "Save", 15, 9, 0, 0, 1
      ButtonOpen CANCEL.BUTTON, NOT.SELECTED, "Cancel", 15, 23, 0, 0, 1
' Toggle all buttons based upon the current value of the config parms.
      IF Config.BaudRate THEN
         ButtonSetState Config.BaudRate, 2
      ELSE
         ButtonSetState B1200.BUTTON, 2
      END IF
      IF Config.CommPort THEN
         ButtonSetState Config.CommPort, 2
      ELSE
         ButtonSetState COM1.BUTTON, 2
      END IF
      IF Config.PARITY THEN
         ButtonSetState Config.PARITY, 2
      ELSE
         ButtonSetState NONE.BUTTON, 2
      END IF
      IF Config.StopBits THEN
         ButtonSetState Config.StopBits, 2
      ELSE
         ButtonSetState BIT1.BUTTON, 2
      END IF
      IF Config.WordLength THEN
         ButtonSetState Config.WordLength, 2
      ELSE
         ButtonSetState WORD8.BUTTON, 2
      END IF
' Set initial states to match initial button settings
      FOR x = B1200.BUTTON TO B9600.BUTTON
         r = ButtonInquire(x)
         IF r = SELECTED THEN Btn = x: EXIT FOR
      NEXT
' Do until exitFlag is set
     ExitFlag = FALSE
     WHILE NOT ExitFlag
      WindowDo Btn, CurEF
     SELECT CASE Dialog(0)
      CASE 1                                   ' (Mouse)
          Btn = Dialog(1)
            SELECT CASE Btn
               CASE SAVE.BUTTON
                  ButtonSetState SAVE.BUTTON, 2
                  ButtonSetState CANCEL.BUTTON, 1
                  ExitFlag = TRUE
              CASE CANCEL.BUTTON
                  ButtonSetState SAVE.BUTTON, 1
                  ButtonSetState CANCEL.BUTTON, 2
                  ExitFlag = TRUE
              CASE B1200.BUTTON TO B9600.BUTTON
                  FOR x = B1200.BUTTON TO B9600.BUTTON
                     r = ButtonInquire(x)
                     IF r = SELECTED THEN ButtonSetState x, 1: EXIT FOR
                  NEXT
                  ButtonSetState Btn, 2
              CASE COM1.BUTTON TO COM4.BUTTON
                  FOR x = COM1.BUTTON TO COM4.BUTTON
                     r = ButtonInquire(x)
                     IF r = SELECTED THEN ButtonSetState x, 1: EXIT FOR
                  NEXT
                  ButtonSetState Btn, 2
              CASE NONE.BUTTON TO ODD.BUTTON
                  FOR x = NONE.BUTTON TO ODD.BUTTON
                     r = ButtonInquire(x)
                     IF r = SELECTED THEN ButtonSetState x, 1: EXIT FOR
                  NEXT
                  ButtonSetState Btn, 2
              CASE BIT1.BUTTON TO BIT2.BUTTON
                  IF Btn = BIT1.BUTTON THEN
                     ButtonSetState BIT2.BUTTON, 1
                  ELSE
                     ButtonSetState BIT1.BUTTON, 1
                  END IF
                  ButtonSetState Btn, 2
              CASE WORD7.BUTTON TO WORD8.BUTTON
                  IF Btn = WORD7.BUTTON THEN
                     ButtonSetState WORD8.BUTTON, 1
                  ELSE
                     ButtonSetState WORD7.BUTTON, 1
                  END IF
                  ButtonSetState Btn, 2
            END SELECT
         CASE 9                              ' (Escape)
            ButtonSetState SAVE.BUTTON, 1
            ButtonSetState CANCEL.BUTTON, 2
            ExitFlag = TRUE
         CASE 6                              ' (Return)
            ExitFlag = TRUE
         CASE 7                              ' (Tab)
            SELECT CASE Btn
               CASE B1200.BUTTON TO B9600.BUTTON
                  FOR x = COM1.BUTTON TO COM4.BUTTON
                     r = ButtonInquire(x)
                     IF r = SELECTED THEN Btn = x: EXIT FOR
                  NEXT
               CASE COM1.BUTTON TO COM4.BUTTON
                  FOR x = NONE.BUTTON TO ODD.BUTTON
                     r = ButtonInquire(x)
                     IF r = SELECTED THEN Btn = x: EXIT FOR
                  NEXT
               CASE NONE.BUTTON TO ODD.BUTTON
                     r = ButtonInquire(BIT1.BUTTON)
                     IF r = SELECTED THEN
                        Btn = BIT1.BUTTON
                     ELSE
                        Btn = BIT2.BUTTON
                     END IF
               CASE BIT1.BUTTON TO BIT2.BUTTON
                     r = ButtonInquire(WORD7.BUTTON)
                     IF r = SELECTED THEN
                        Btn = WORD7.BUTTON
                     ELSE
                        Btn = WORD8.BUTTON
                     END IF
               CASE WORD7.BUTTON TO WORD8.BUTTON
                     Btn = SAVE.BUTTON
               CASE SAVE.BUTTON
                     ButtonSetState SAVE.BUTTON, 1
                     ButtonSetState CANCEL.BUTTON, 2
                     Btn = CANCEL.BUTTON
               CASE CANCEL.BUTTON
                  ' Toggle the set options flag.
                     ButtonSetState SAVE.BUTTON, 2
                     ButtonSetState CANCEL.BUTTON, 1
                     FOR x = B1200.BUTTON TO B9600.BUTTON
                        r = ButtonInquire(x)
                        IF r = SELECTED THEN Btn = x: EXIT FOR
                     NEXT
            END SELECT
         CASE 8                              ' (Shift+Tab)
            SELECT CASE Btn
               CASE B1200.BUTTON TO B9600.BUTTON
                     ButtonSetState SAVE.BUTTON, 1
                     ButtonSetState CANCEL.BUTTON, 2
                     Btn = CANCEL.BUTTON
               CASE COM1.BUTTON TO COM4.BUTTON
                     FOR x = B1200.BUTTON TO B9600.BUTTON
                        r = ButtonInquire(x)
                        IF r = SELECTED THEN Btn = x: EXIT FOR
                     NEXT
               CASE NONE.BUTTON TO ODD.BUTTON
                  FOR x = COM1.BUTTON TO COM4.BUTTON
                     r = ButtonInquire(x)
                     IF r = SELECTED THEN Btn = x: EXIT FOR
                  NEXT
               CASE BIT1.BUTTON TO BIT2.BUTTON
                  FOR x = NONE.BUTTON TO ODD.BUTTON
                     r = ButtonInquire(x)
                     IF r = SELECTED THEN Btn = x: EXIT FOR
                  NEXT
               CASE WORD7.BUTTON TO WORD8.BUTTON
                  r = ButtonInquire(BIT1.BUTTON)
                  IF r = SELECTED THEN
                     Btn = BIT1.BUTTON
                  ELSE
                     Btn = BIT2.BUTTON
                  END IF
               CASE SAVE.BUTTON
                  r = ButtonInquire(WORD7.BUTTON)
                  IF r = SELECTED THEN
                     Btn = WORD7.BUTTON
                  ELSE
                     Btn = WORD8.BUTTON
                  END IF
                  ButtonSetState SAVE.BUTTON, 2
                  ButtonSetState CANCEL.BUTTON, 1
               CASE CANCEL.BUTTON
                  ButtonSetState SAVE.BUTTON, 2
                  ButtonSetState CANCEL.BUTTON, 1
                  Btn = SAVE.BUTTON
            END SELECT
         CASE 10                                ' (Up Arrow)
            CHANGES = TRUE
            SELECT CASE Btn
               CASE B1200.BUTTON TO B9600.BUTTON
                  ButtonSetState Btn, 1
                  Btn = Btn - 1
                  IF Btn < B1200.BUTTON THEN
                     Btn = B9600.BUTTON
                     ButtonSetState Btn, 2
                  ELSE
                     ButtonSetState Btn, 2
                  END IF
               CASE COM1.BUTTON TO COM4.BUTTON
                  ButtonSetState Btn, 1
                  Btn = Btn - 1
                  IF Btn < COM1.BUTTON THEN
                     Btn = COM4.BUTTON
                     ButtonSetState Btn, 2
                  ELSE
                     ButtonSetState Btn, 2
                  END IF
               CASE NONE.BUTTON TO ODD.BUTTON
                  ButtonSetState Btn, 1
                  Btn = Btn - 1
                  IF Btn < NONE.BUTTON THEN
                     Btn = ODD.BUTTON
                     ButtonSetState Btn, 2
                  ELSE
                     ButtonSetState Btn, 2
                  END IF
               CASE BIT1.BUTTON TO BIT2.BUTTON
                  ButtonSetState Btn, 1
                  r = ButtonInquire(BIT1.BUTTON)
                  IF r = SELECTED THEN
                     Btn = BIT2.BUTTON
                     ButtonSetState Btn, 2
                  ELSE
                     Btn = BIT1.BUTTON
                     ButtonSetState Btn, 2
                  END IF
               CASE 14 TO 15
                  ButtonSetState Btn, 1
                  r = ButtonInquire(WORD7.BUTTON)
                  IF r = SELECTED THEN
                     Btn = WORD8.BUTTON
                     ButtonSetState Btn, 2
                  ELSE
                     Btn = WORD7.BUTTON
                     ButtonSetState Btn, 2
                  END IF
               END SELECT
      CASE 11                                    ' (Down Arrow)
            CHANGES = TRUE
            SELECT CASE Btn
               CASE B1200.BUTTON TO B9600.BUTTON
                  ButtonSetState Btn, 1
                  Btn = Btn + 1
                  IF Btn > B9600.BUTTON THEN
                     Btn = B1200.BUTTON
                     ButtonSetState Btn, 2
                  ELSE
                     ButtonSetState Btn, 2
                  END IF
               CASE COM1.BUTTON TO COM4.BUTTON
                  ButtonSetState Btn, 1
                  Btn = Btn + 1
                  IF Btn > COM4.BUTTON THEN
                     Btn = COM1.BUTTON
                     ButtonSetState Btn, 2
                  ELSE
                     ButtonSetState Btn, 2
                  END IF
               CASE NONE.BUTTON TO ODD.BUTTON
                  ButtonSetState Btn, 1
                  Btn = Btn + 1
                  IF Btn > ODD.BUTTON THEN
                     Btn = NONE.BUTTON
                     ButtonSetState Btn, 2
                  ELSE
                     ButtonSetState Btn, 2
                  END IF
               CASE BIT1.BUTTON TO BIT2.BUTTON
                  ButtonSetState Btn, 1
                  r = ButtonInquire(BIT1.BUTTON)
                  IF r = SELECTED THEN
                     Btn = BIT1.BUTTON
                     ButtonSetState Btn, 2
                  ELSE
                     Btn = BIT2.BUTTON
                     ButtonSetState Btn, 2
                  END IF
               CASE 14 TO 15
                  ButtonSetState Btn, 1
                  r = ButtonInquire(WORD7.BUTTON)
                  IF r = SELECTED THEN
                     Btn = WORD7.BUTTON
                     ButtonSetState Btn, 2
                  ELSE
                     Btn = WORD8.BUTTON
                     ButtonSetState Btn, 2
                  END IF
            END SELECT
         END SELECT
   WEND
   IF ButtonInquire(SAVE.BUTTON) = SELECTED THEN
      FOR x = B1200.BUTTON TO B9600.BUTTON
         r = ButtonInquire(x)
         IF r = SELECTED THEN Config.BaudRate = x: EXIT FOR
      NEXT
      FOR x = COM1.BUTTON TO COM4.BUTTON
         r = ButtonInquire(x)
         IF r = SELECTED THEN Config.CommPort = x: EXIT FOR
      NEXT
      FOR x = NONE.BUTTON TO ODD.BUTTON
         r = ButtonInquire(x)
         IF r = SELECTED THEN Config.PARITY = x: EXIT FOR
      NEXT
      r = ButtonInquire(BIT1.BUTTON)
      IF r = SELECTED THEN
         Config.StopBits = BIT1.BUTTON
      ELSE
         Config.StopBits = BIT2.BUTTON
      END IF
      r = ButtonInquire(WORD7.BUTTON)
      IF r = SELECTED THEN
         Config.WordLength = WORD7.BUTTON
      ELSE
         Config.WordLength = WORD8.BUTTON
      END IF
      CommConfig = TRUE
   END IF
   ' Close window when done.
     WindowClose 2
     EXIT FUNCTION
END FUNCTION

'----------------------------------------------------------------------------
' This sub routine allows the installer to configure the auto polling
' software, to a specific set of optional paramters.  These parameters
' dictate how the program will behave upon a polling opertion taking place.
'----------------------------------------------------------------------------
FUNCTION EditConfig
' Set up info screen.
' (t)op, (b)ottom, (l)eft and (r)ight
     t = 5: b = 17: l = 15: r = 65
       IF NOT DisplayType THEN
         WindowOpen 2, t, l, b, r, 0, 7, 0, 7, 15, FALSE, FALSE, FALSE, TRUE, 2, "Configuration"
       ELSE
         WindowOpen 2, t, l, b, r, 0, 3, 0, 3, 15, FALSE, FALSE, FALSE, TRUE, 2, "Configuration"
       END IF
     WindowLine 12
' Write the Shell Command window.
   WindowBox 1, 2, 3, 19
   WindowLocate 1, 4
   WindowPrint 2, " Batch File "
' Write the Polling Time window.
   WindowBox 1, 22, 3, 31
   WindowLocate 1, 23
   WindowPrint 2, " Time "
' Draw the Shell Style Frame.
   WindowBox 4, 2, 8, 26
   WindowLocate 4, 4
   WindowPrint 2, " DOS Action"
' Draw the Profiles Frame.
     WindowBox 4, 28, 11, 48
     WindowLocate 4, 29
     WindowPrint 2, " Profile "
EDITSTART:
' Set up the local Constants
    CONST SAVE.BUTTON = 1
    CONST CANCEL.BUTTON = 2
    CONST HELP.BUTTON = 3
    CONST DAILY.BUTTON = 4
    CONST MONTHLY.BUTTON = 5
    CONST QUARTER.BUTTON = 6
    CONST SCHEDULE.BUTTON = 7
    CONST RTFWD.BUTTON = 8
    CONST RTBKWD.BUTTON = 9
    CONST SHELLDOS.BUTTON = 10
    CONST PUSHBUF.BUTTON = 11
    CONST TINYCOMM.BUTTON = 12
    CONST AUTORUN.BUTTON = 13
    CONST CONT.BUTTON = 14
    CONST AM.BUTTON = 15
    CONST PM.BUTTON = 16
' Establish the edit fields.
    Batch$ = LTRIM$(RTRIM$(Config.Batch))
    PollTime$ = LTRIM$(RTRIM$(Config.PollTime))
' Open all buttons
   ButtonOpen SAVE.BUTTON, SELECTED, "Save", 13, 8, 0, 0, 1
   ButtonOpen CANCEL.BUTTON, NOT.SELECTED, "Cancel", 13, 20, 0, 0, 1
   ButtonOpen HELP.BUTTON, NOT.SELECTED, "Help", 13, 34, 0, 0, 1
   ButtonOpen DAILY.BUTTON, NOT.SELECTED, "1. Daily", 5, 30, 0, 0, RADIO.BUTTON
   ButtonOpen MONTHLY.BUTTON, NOT.SELECTED, "2. Monthly", 6, 30, 0, 0, RADIO.BUTTON
   ButtonOpen QUARTER.BUTTON, NOT.SELECTED, "3. Quarter", 7, 30, 0, 0, RADIO.BUTTON
   ButtonOpen SCHEDULE.BUTTON, NOT.SELECTED, "4. Schedule", 8, 30, 0, 0, RADIO.BUTTON
   ButtonOpen RTFWD.BUTTON, NOT.SELECTED, "5. R/T +", 9, 30, 0, 0, RADIO.BUTTON
   ButtonOpen RTBKWD.BUTTON, NOT.SELECTED, "6. R/T -", 10, 30, 0, 0, RADIO.BUTTON
   ButtonOpen SHELLDOS.BUTTON, NOT.SELECTED, "1. LARGE Model", 5, 4, 0, 0, RADIO.BUTTON
   ButtonOpen PUSHBUF.BUTTON, NOT.SELECTED, "2. SMALL Model", 6, 4, 0, 0, RADIO.BUTTON
   ButtonOpen TINYCOMM.BUTTON, NOT.SELECTED, "3. TinyComm", 7, 4, 0, 0, RADIO.BUTTON
   ButtonOpen AUTORUN.BUTTON, NOT.SELECTED, "Auto Run on Entry", 9, 2, 0, 0, CHECK.BUTTON
   ButtonOpen CONT.BUTTON, NOT.SELECTED, "Continous Execution", 10, 2, 0, 0, CHECK.BUTTON
   ButtonOpen AM.BUTTON, NOT.SELECTED, "AM", 2, 35, 0, 0, RADIO.BUTTON
   ButtonOpen PM.BUTTON, NOT.SELECTED, "PM", 2, 42, 0, 0, RADIO.BUTTON
' Establish the Edit Fields.
   EditFieldOpen 1, Batch$, 2, 5, 0, 0, 13, 12
   EditFieldOpen 2, PollTime$, 2, 24, 0, 0, 6, 5
' Set initial states to match initial button settings
   SELECT CASE Config.ActiveProfile
      CASE DAILY.BUTTON: ButtonToggle DAILY.BUTTON
      CASE MONTHLY.BUTTON: ButtonToggle MONTHLY.BUTTON
      CASE QUARTER.BUTTON: ButtonToggle QUARTER.BUTTON
      CASE SCHEDULE.BUTTON: ButtonToggle SCHEDULE.BUTTON
      CASE RTFWD.BUTTON: ButtonToggle RTFWD.BUTTON
      CASE RTBKWD.BUTTON: ButtonToggle RTBKWD.BUTTON
      CASE ELSE: ButtonToggle SCHEDULE.BUTTON
   END SELECT
   SELECT CASE Config.ActiveStyle
      CASE SHELLDOS.BUTTON: ButtonToggle SHELLDOS.BUTTON
      CASE PUSHBUF.BUTTON: ButtonToggle PUSHBUF.BUTTON
      CASE TINYCOMM.BUTTON: ButtonToggle TINYCOMM.BUTTON
      CASE ELSE: ButtonToggle PUSHBUF.BUTTON
   END SELECT
' Set the status of continous run feature.
   IF Config.ContinousRun = TRUE THEN ButtonToggle CONT.BUTTON
' Check status of autorun features.
   IF Config.ActiveRun = TRUE THEN ButtonToggle AUTORUN.BUTTON
' Set Am/Pm values.
   IF Config.DayNiteProfile THEN
      ButtonToggle AM.BUTTON
   ELSE
      ButtonToggle PM.BUTTON
   END IF
' Set current edit field to 1
   CurEF = 1
DOEDIT:
   ' Do until exitFlag is set
     ExitFlag = FALSE
WHILE NOT ExitFlag
   WindowDo Btn, CurEF
   SELECT CASE Dialog(0)
      CASE 2                                    ' (Mouse) on Edit Field.
          Btn = 0
          CurEF = Dialog(2)
       CASE 1                                   ' (Mouse)
          Btn = Dialog(1)
          SELECT CASE Btn
            CASE DAILY.BUTTON TO RTBKWD.BUTTON
               FOR x = DAILY.BUTTON TO RTBKWD.BUTTON
                  r = ButtonInquire(x)
                  IF r = SELECTED THEN EXIT FOR
               NEXT
               ButtonToggle x
               ButtonToggle Btn
           CASE SHELLDOS.BUTTON TO TINYCOMM.BUTTON
               FOR x = SHELLDOS.BUTTON TO TINYCOMM.BUTTON
                  r = ButtonInquire(x)
                  IF r = SELECTED THEN EXIT FOR
               NEXT
               ButtonToggle x
               ButtonToggle Btn
           CASE AUTORUN.BUTTON, CONT.BUTTON
               ButtonToggle Btn
           CASE AM.BUTTON, PM.BUTTON
               ButtonToggle AM.BUTTON
               ButtonToggle PM.BUTTON
            CASE SAVE.BUTTON
               ExitFlag = TRUE
            CASE CANCEL.BUTTON
               ExitFlag = TRUE
               ButtonToggle Btn
               ButtonToggle SAVE.BUTTON
            CASE HELP.BUTTON
                  a$ = "Configuration Help||"
               a$ = a$ + "Changes made on the configuration screen,  dictate how|"
               a$ = a$ + "the AutoPoll program will perform Daily/Monthly resets|"
               a$ = a$ + "when you run in immediate or sleep mode|"
               x = Alert(4, a$, 8, 10, 14, 70, "OK", "", "")
               Btn = 0
               CurEF = 1
          END SELECT
      CASE 9                                    ' (Escape)
         ExitFlag = TRUE
      CASE 6                                    ' (Return)
         SELECT CASE Btn
            CASE HELP.BUTTON
                  a$ = "Configuration Help||"
               a$ = a$ + "Changes made on the configuration screen,  dictate how|"
               a$ = a$ + "the AutoPoll program will perform Daily/Monthly resets|"
               a$ = a$ + "when you run in immediate or sleep mode|"
               x = Alert(4, a$, 8, 10, 14, 70, "OK", "", "")
               ButtonToggle Btn
               ButtonToggle SAVE.BUTTON
               Btn = 0
               CurEF = 1
            CASE ELSE
               ExitFlag = TRUE
         END SELECT
      CASE 7                                    ' (Tab)
         SELECT CASE Btn
            CASE 0
               IF CurEF = 1 THEN
                  CurEF = 2
               ELSE
                  r = ButtonInquire(AM.BUTTON)
                  IF r = SELECTED THEN
                     Btn = AM.BUTTON
                  ELSE
                     Btn = PM.BUTTON
                  END IF
                  CurEF = 0
               END IF
            CASE AM.BUTTON TO PM.BUTTON
                  FOR x = DAILY.BUTTON TO RTBKWD.BUTTON
                     r = ButtonInquire(x)
                     IF r = SELECTED THEN EXIT FOR
                  NEXT
                  Btn = x
            CASE DAILY.BUTTON TO RTBKWD.BUTTON
               FOR x = SHELLDOS.BUTTON TO TINYCOMM.BUTTON
                  r = ButtonInquire(x)
                  IF r = SELECTED THEN EXIT FOR
               NEXT
               Btn = x
            CASE SHELLDOS.BUTTON TO TINYCOMM.BUTTON
               Btn = AUTORUN.BUTTON
            CASE AUTORUN.BUTTON
               Btn = CONT.BUTTON
            CASE CONT.BUTTON
               Btn = SAVE.BUTTON
            CASE SAVE.BUTTON
               ButtonToggle Btn
               Btn = CANCEL.BUTTON
               ButtonToggle Btn
            CASE CANCEL.BUTTON
               ButtonToggle Btn
               Btn = HELP.BUTTON
               ButtonToggle Btn
            CASE HELP.BUTTON
               ButtonToggle Btn
               ButtonToggle SAVE.BUTTON
               Btn = 0
               CurEF = 1
         END SELECT
      CASE 8                                    ' (Shift+Tab)
         SELECT CASE Btn
            CASE 0
               IF CurEF = 1 THEN
                  CurEF = 0
                  ButtonToggle SAVE.BUTTON
                  Btn = HELP.BUTTON
                  ButtonToggle Btn
               ELSE
                  CurEF = 1
               END IF
            CASE AM.BUTTON TO PM.BUTTON
               CurEF = 2
               Btn = 0
            CASE DAILY.BUTTON TO RTBKWD.BUTTON
               r = ButtonInquire(AM.BUTTON)
               IF r = SELECTED THEN
                  Btn = AM.BUTTON
               ELSE
                  Btn = PM.BUTTON
               END IF
            CASE SHELLDOS.BUTTON TO TINYCOMM.BUTTON
               FOR x = DAILY.BUTTON TO RTBKWD.BUTTON
                  r = ButtonInquire(x)
                  IF r = SELECTED THEN EXIT FOR
               NEXT
               Btn = x
            CASE AUTORUN.BUTTON
               FOR x = SHELLDOS.BUTTON TO TINYCOMM.BUTTON
                  r = ButtonInquire(x)
                  IF r = SELECTED THEN EXIT FOR
               NEXT
               Btn = x
            CASE CONT.BUTTON
               Btn = AUTORUN.BUTTON
            CASE SAVE.BUTTON
               Btn = CONT.BUTTON
            CASE CANCEL.BUTTON
               ButtonToggle Btn
               Btn = SAVE.BUTTON
               ButtonToggle Btn
            CASE HELP.BUTTON
               ButtonToggle Btn
               Btn = CANCEL.BUTTON
               ButtonToggle Btn
         END SELECT
      CASE 10                                   ' (Up Arrow)
         SELECT CASE Btn
            CASE DAILY.BUTTON TO RTBKWD.BUTTON
               ButtonToggle Btn
               Btn = Btn - 1
               IF Btn < DAILY.BUTTON THEN Btn = DAILY.BUTTON
               ButtonToggle Btn
            CASE SHELLDOS.BUTTON TO TINYCOMM.BUTTON
               ButtonToggle Btn
               Btn = Btn - 1
               IF Btn < SHELLDOS.BUTTON THEN Btn = SHELLDOS.BUTTON
               ButtonToggle Btn
            END SELECT
      CASE 11                                   ' (Down Arrow)
         SELECT CASE Btn
            CASE DAILY.BUTTON TO RTBKWD.BUTTON
               ButtonToggle Btn
               Btn = Btn + 1
               IF Btn > RTBKWD.BUTTON THEN Btn = RTBKWD.BUTTON
               ButtonToggle Btn
            CASE SHELLDOS.BUTTON TO TINYCOMM.BUTTON
               ButtonToggle Btn
               Btn = Btn + 1
               IF Btn > TINYCOMM.BUTTON THEN Btn = TINYCOMM.BUTTON
               ButtonToggle Btn
            END SELECT
      CASE 13                                   ' (Left arrow)
         IF Btn = AM.BUTTON THEN
               ButtonToggle Btn
               Btn = Btn + 1
               ButtonToggle Btn
         END IF
      CASE 12                                   ' (Right arrow)
         IF Btn = PM.BUTTON THEN
               ButtonToggle Btn
               Btn = Btn - 1
               ButtonToggle Btn
         END IF
      CASE 14                                   ' (Space Bar)
         IF Btn = AUTORUN.BUTTON OR Btn = CONT.BUTTON THEN
                  ButtonToggle Btn
         END IF
   END SELECT
WEND
' Check for any changes that may have taken place.
   tmp$ = EditFieldInquire(1)
   tmp$ = EditFieldInquire(2)
   r = ButtonInquire(SAVE.BUTTON)
   IF r = SELECTED THEN
      ' Get the file name.
        IF INSTR(EditFieldInquire(1), ".") THEN
            Config.Batch = EditFieldInquire(1)
         ELSE
           Config.Batch = EditFieldInquire(1) + ".BAT"
         END IF
         ' Get the time that the reset should occur.
             tmp$ = EditFieldInquire(2)
             IF INSTR(tmp$, ":") THEN
               tl% = LEN(tmp$)
               IF tl% = 5 THEN
                  major$ = MID$(tmp$, 1, 2)
                  minor$ = MID$(tmp$, 4, 5)
                  IF VAL(major$) >= 0 AND VAL(major$) <= 12 THEN
                     IF VAL(minor$) >= 0 AND VAL(minor$) <= 60 THEN
                         IF ButtonInquire(AM.BUTTON) = SELECTED THEN
                           Config.DayNiteProfile = TRUE
                           Config.PollTime = EditFieldInquire(2) + " AM"
                         ELSE
                           Config.DayNiteProfile = FALSE
                           Config.PollTime = EditFieldInquire(2) + " PM"
                         END IF
                     ELSE
                        GOSUB INVALIDTIME
                        GOTO DOEDIT
                     END IF
                  ELSE
                     GOSUB INVALIDTIME
                     GOTO DOEDIT
                  END IF
               ELSEIF tl% = 4 AND INSTR(tmp$, ":") = 2 THEN
                  major$ = MID$(tmp$, 1, 1)
                  minor$ = MID$(tmp$, 3, 4)
                  IF VAL(major$) >= 0 AND VAL(major$) <= 12 THEN
                     IF VAL(minor$) >= 0 AND VAL(minor$) <= 60 THEN
                         IF ButtonInquire(AM.BUTTON) = SELECTED THEN
                           Config.DayNiteProfile = TRUE
                           Config.PollTime = "0" + EditFieldInquire(2) + " AM"
                         ELSE
                           Config.DayNiteProfile = FALSE
                           Config.PollTime = "0" + EditFieldInquire(2) + " PM"
                         END IF
                     ELSE
                        GOSUB INVALIDTIME
                        GOTO DOEDIT
                     END IF
                  ELSE
                    GOSUB INVALIDTIME
                    GOTO DOEDIT
                  END IF
               ELSEIF tl% = 4 AND INSTR(tmp$, ":") = 3 THEN
                 GOSUB INVALIDTIME
                 GOTO DOEDIT
               END IF
            END IF
         ' Get the active profile style.
            FOR x = DAILY.BUTTON TO RTBKWD.BUTTON
               r = ButtonInquire(x)
               IF r = SELECTED THEN EXIT FOR
            NEXT
            Config.ActiveProfile = x
         ' Get the active poll style.
            FOR x = SHELLDOS.BUTTON TO TINYCOMM.BUTTON
               r = ButtonInquire(x)
               IF r = SELECTED THEN EXIT FOR
            NEXT
            Config.ActiveStyle = x
         ' Set the Autorun on startup variable.
            r = ButtonInquire(AUTORUN.BUTTON)
            IF r = SELECTED THEN
               Config.ActiveRun = TRUE
            ELSE
               Config.ActiveRun = FALSE
            END IF
         ' Set the Continous run on return variable.
            r = ButtonInquire(CONT.BUTTON)
            IF r = SELECTED THEN
               Config.ContinousRun = TRUE
            ELSE
               Config.ContinousRun = FALSE
            END IF
         ' Update file Configuration.
               EditConfig = TRUE
       END IF
   ' Close window when done.
      WindowClose 2
      EXIT FUNCTION
INVALIDTIME:
' Show a warning screen.
       a$ = "YOUR TIME ENTRY IS INVALID!|"
  a$ = a$ + "1...Use [1 thru 12] for valid HOURS|"
  a$ = a$ + "2...Use [01 thru 60] for the MINUTES|"
  a$ = a$ + "3...Use a colon [:] to separate the|"
  a$ = a$ + "    Hours from the Minutes [HH:MM]|"
  a$ = a$ + "4...Add a [0] prefix to the Minutes [1-9]|"
  x = Alert(3, a$, 12, 5, 19, 45, "", "", "")
  EditFieldClose 2
  PollTime$ = LTRIM$(RTRIM$(Config.PollTime))
  EditFieldOpen 2, PollTime$, 2, 24, 0, 0, 6, 5
  Btn = 0
  CurEF = 2
  RETURN
END FUNCTION

SUB MenuDisplay
   DIM text$(1 TO 6)
' This sub routine simply display the menu when needed.
    IF NOT DisplayType THEN
      WindowOpen 1, 8, 3, 15, 25, 0, 7, 15, 7, 15, FALSE, FALSE, FALSE, TRUE, 2, "Speed Menu"
    ELSE
      WindowOpen 1, 8, 3, 15, 25, 0, 3, 0, 3, 15, FALSE, FALSE, FALSE, TRUE, 2, "Speed Menu"
    END IF
' Assign all of the menu choices.
      text$(1) = "F1 - About"
      text$(2) = "F2 - Program Config"
      text$(3) = "F3 - Communications"
      text$(4) = "F4 - Color"
      text$(5) = "F5 - MonoChrome"
      text$(6) = "Escape  - Exit"
' Print Choices to the screen.
   FOR x = 1 TO UBOUND(text$)
      WindowLocate x + 1, 2
      WindowPrint 1, text$(x)
   NEXT
END SUB

SUB MonoDisplay
    DisplayType = FALSE
    Config.ColorScheme = "M"
    MouseHide
    SetupMenu
    MenuSetState 1, 3, 1
    MenuSetState 1, 4, 2
    SetupDesktop
    MenuShow
    MouseShow
END SUB

SUB SetupDesktop STATIC
   MouseHide
   WIDTH , 25
   COLOR 15, 1
   CLS
   LOCATE 22, 17
   PRINT "Configuration File Demonstration Version 1.00"
   LOCATE 23, 18
   PRINT "(c) Jordan/Denske Software Publishing 1992"
   MouseShow
END SUB

SUB SetupMenu
' Report Header menu options
   MenuSet 1, 0, 1, "Config", 1
   MenuSet 1, 1, 1, "Program Parms...   F2", 1
   MenuSet 1, 2, 1, "Communications     F3", 1
   MenuSet 1, 3, 1, "Color              F4", 1
   MenuSet 1, 4, 1, "Monochrome         F5", 1
   MenuSet 1, 5, 1, "-", 1
   MenuSet 1, 6, 1, "About...           F1", 1
   MenuSet 1, 7, 1, "-", 1
   MenuSet 1, 8, 1, "Exit            [Esc]", 2
' Instant access keys.
   ShortCutKeySet 1, 6, CHR$(0) + CHR$(59) ' F1
   ShortCutKeySet 1, 1, CHR$(0) + CHR$(60) ' F2
   ShortCutKeySet 1, 2, CHR$(0) + CHR$(61) ' F3
   ShortCutKeySet 1, 3, CHR$(0) + CHR$(62) ' F4
   ShortCutKeySet 1, 4, CHR$(0) + CHR$(63) ' F5
' Set the menu colors
   MenuColor 0, 7, 15, 8, 7, 0, 15   'Best for monochrome and colors
' Run internal menu processing sub routine.
   MenuPreProcess
END SUB

