' ¿
'  Name     : PRINTDOC                                                  
'  Type     : Utility                                                   
'  Module   : PRINTDOC.BAS                                              
'  Language : MicroSoft QuickBASIC Version 4.5                          
'  Source   : LAMCO Software                                            
' 
'  DESCRIPTION ¿
'  This simple program will print the file COMMENTS.DOC in 12 cpi       
'  pitch with a left margin of 1 1/2 inch.                              
' 
'  REQUIREMENTS ¿
'  (none)                                                               
' 
'  .MAK FILE ¿
'  (not required)                                                       
' 
'  COMMAND LINE PARAMETERS ¿
'  (none)                                                               
' 
'  VARIABLES ¿
'  IsFileThere#    Flag telling if the file is in the current directory 
'  LineRead$       A line read from the file                            
' 

' Clear the screen
  CLS

' Verify that COMMENTS.DOC is in the current directory
  OPEN "comments.doc" FOR RANDOM AS #1
  IsFileThere# = LOF(1)
  CLOSE #1

' If the file is not there, display the proper message and exit
  IF IsFileThere# = 0 THEN
    KILL "comments.doc"                 ' Erase the 0 byte file
    LOCATE 4, 10
    PRINT "The file COMMENTS.DOC must be in the current directory."
    LOCATE 6, 10
    PRINT "Please copy the file and load this program again."
    LOCATE 8, 10
    SYSTEM
  END IF

' Ask user to turn the printer on and align the paper
  LOCATE 4, 10
  PRINT "Please turn printer on and align top of page."
  LOCATE 7, 10
  PRINT "Press any key when ready ..."
  BEEP
  DO: LOOP UNTIL INKEY$ <> ""              ' Wait for a key to be pressed
 
  WIDTH "LPT1:", 255                       ' Set printer width to 255
  LPRINT CHR$(27) + "!" + CHR$(1)          ' Set printer pitch to 12 cpi
  LPRINT CHR$(27) + "m" + CHR$(3)          ' Set printer to graphic mode
 
  OPEN "comments.doc" FOR INPUT AS #1      ' Open the file for reading

  LINE INPUT #1, LineRead$                 ' Read first two lines to
  LINE INPUT #1, LineRead$                 ' compensate for the two linefeeds
                                           ' we got when setting the printer

  DO UNTIL EOF(1)                          ' Read the whole file
    LINE INPUT #1, LineRead$               ' Read one line
    LPRINT STRING$(13, 32); LineRead$      ' Add the left margin and print it
  LOOP
  CLOSE #1                                 ' Close the file

' Tell the user the printing is completed and exit
  LOCATE 12, 10
  PRINT "Printing of the COMMENTS' user's manual completed."
  PRINT
  PRINT
 
' Reset the printer to the default settings
  WIDTH "LPT1:", 80                        ' Set printer width to 80
  LPRINT CHR$(27) + "!" + CHR$(0)          ' Set printer pitch to 10 cpi
  LPRINT CHR$(27) + "m" + CHR$(0)          ' Set printer to text mode
 
  SYSTEM                                   ' Exit the program

  END                                      ' End of the module level

