; POKESUB - subroutine to write memory for Pascal programs
; POKESUB(DATASEG,LOCATION,POKEVAL)
; DATASEG is the value of the data segment
; LOCATION is the memory location relative to the DS (0-66535)
; POKEVAL is the integer value (0-255) to be written
cseg segment para public 'code'
public pokesub
pokesub proc far
    assume cs:cseg,ds:nothing,ss:nothing,es:nothing
    push bp
    mov bp,sp
    push es	     ; save original es
    mov si,[bp+10]   ; point to dataseg
    mov ax,[si]      ; dataseg in ax
    mov es,ax	     ; fix extra segment
    mov di,[bp+8]    ; point to memory location
    mov di,[di]      ; location in di
    mov si,[bp+6]    ; point to return value
    mov ax,[si]      ; value in al
    mov es:[di],al   ; poke
    pop es	     ; restore es
    pop bp
    ret 6
pokesub endp
cseg ends
    end
