;********************************;
; PARADOX Script: ValCheck       ;
;                                ;
; ValCheck, Version 1.1          ;
; 15 Jan 92                      ;
; Informant Communications Group ;
;                                ;
; Required Scripts:              ;
;   GetValCk                     ;
;   ValCheck                     ;
;   PicLkUp                      ;
;   TabLkUp                      ;
;                                ;
; Required Tables:               ;
;   PicTab                       ;
;********************************;

CREATELIB "ValCheck"

;***************************************************;
; GetVal() initializes global variable set, copies  ;
; active Table to the canvas with ECHO, and manages ;
; movement between fields and the selection of a    ;
; field for which ValChecks are desired.            ;
;***************************************************;
PROC GetVal()
  PRIVATE ModeColor,FormView,MsgLn1,MsgLn2,LkUpMu,
          LkUpLn1,LkUpLn2,FldName,CurrFld,MaxCol,
          Mode,Errorproc,WorkTab,c
  ;
  ; exit if a Table is not the current image
  ;
  IF IMAGETYPE()<>"Display"
    THEN BEEP
         MESSAGE "No table present..."
         SLEEP 1200
         RETURN
  ENDIF
  ;
  ; initialize variables
  ;
  ModeColor=SYSCOLOR(5)
  WorkTab=TABLE()

  IF ISFORMVIEW()
    THEN FormView=True
    ELSE FormView=False
  ENDIF

  ARRAY MsgLn1[7]
  ARRAY MsgLn2[7]
  MsgLn1[1]="Enter the lowest acceptable value for  "
  MsgLn2[1]="this field.                            "
  MsgLn1[2]="Enter the highest acceptable value for "
  MsgLn2[2]="this field.                            "
  MsgLn1[3]="Enter the value to insert if field is  "
  MsgLn2[3]="left blank.                            "
  MsgLn1[4]="Enter Picture format, [F1] to see list "
  MsgLn2[4]="or [ESC] to cancel changes.            "
  MsgLn1[5]="Enter the name of the table to use for "
  MsgLn2[5]="Look Up or press [F1] for list.        "
  MsgLn1[6]="Indicate with 'Yes' or 'No' whether or "
  MsgLn2[6]="not field requires an entry.           "
  MsgLn1[7]="Clear all validity checks from present "
  MsgLn2[7]="'Field' or from 'All' fields.          "

  ARRAY LkUpMu[6]
  LkUpMu[1]="Just Current Field      "
  LkUpMu[2]="All Corresponding Fields"
  LkUpMu[3]="Private Lookup          "
  LkUpMu[4]="Help and Fill           "
  LkUpMu[5]="Fill No Help            "
  LkUpMu[6]="Help and Fill           "

  ARRAY LkUpLn1[6]
  ARRAY LkUpLn2[6]
  LkUpLn1[1]="Check current field against "
  LkUpLn2[1]="lookup table.               "
  LkUpLn1[2]="Check current field; fill   "
  LkUpLn2[2]="in all like fields.         "
  LkUpLn1[3]="Check current field; prevent"
  LkUpLn2[3]="access to lookup table.     "
  LkUpLn1[4]="Allow browsing of lookup    "
  LkUpLn2[4]="table and choice of value.  "
  LkUpLn1[5]="Prevent access to lookup    "
  LkUpLn2[5]="table; fill in like fields. "
  LkUpLn1[6]="Allow browsing and choice of"
  LkUpLn2[6]="value; fill in like fields. "
  ;
  ; get current field number (column) and
  ; total number of fields
  ;
  CANVAS OFF
  SYNCCURSOR
  FldName=FIELD()
  CurrFld=COLNO()
  CTRLEND
  MaxCol=COLNO()
  MOVETO FIELD FldName
  ;
  ; define procedure to intercept Paradox error
  ; conditions - these will occur with attempts
  ; to select incompatible validity values
  ;
  Errorproc="ValErr"
  ;
  ; get current mode for reset upon
  ; completion of program
  ;
  Mode=SYSMODE()
  IF Mode="CoEdit"
    THEN LOCKRECORD
  ENDIF
  DO_IT!

  WHILE True
    CANVAS OFF
    PROMPT " [Enter]  Define ValChecks",
           " [ESC]    Quit"
    ;
    ; copy active Table to canvas
    ;
    ECHO NORMAL
    ECHO OFF
    STYLE ATTRIBUTE ModeColor
    @0,67 ??"ValCheck"
    STYLE
    CANVAS ON
    SYNCCURSOR
    ;
    ; get field type of current field for
    ; use in validating a Lookup table
    ;
    FldType=FIELDTYPE()
    ;
    ; wait for user input; Left and Right
    ; cursor available in TableView, Up
    ; and Down in FormView
    ;
    c=GETCHAR()
    SWITCH
      CASE c=27:
        QUITLOOP
      CASE NOT FormView AND c=-75 AND CurrFld>1:
        CurrFld=CurrFld-1
        LEFT
      CASE NOT FormView AND c=-77 AND CurrFld<MaxCol:
        CurrFld=CurrFld+1
        RIGHT
      CASE FormView AND c=-72 AND CurrFld>2:
        CurrFld=CurrFld-1
        UP
      CASE FormView AND c=-80 AND CurrFld<MaxCol:
        CurrFld=CurrFld+1
        DOWN
      CASE c=13:
        ;
        ; get data entry screen for ValChecks
        ;
        AddValCheck()
      OTHERWISE:
        BEEP
    ENDSWITCH
  ENDWHILE
  STYLE
  ;
  ; reset original mode prior to exit
  ;
  GetMode()
ENDPROC


;*************************************************;
; AddValCheck() is called by GetVal() and manages ;
; modification of validity checks for the given   ;
; field.  It calls ValCheckScr() to open the data ;
; entry window and GetCurrValCk() to get current  ;
; validity settings.                              ;
;*************************************************;
PROC AddValCheck()
  PRIVATE Val,FieldName,i,c,Pos,Item,Next
  ;
  ; check that the current field is a table
  ; field and return if untrue;
  ;
  IF COLNO()=1
    THEN BEEP
         MESSAGE "Only table fields can have "+
                 "validity checks..."
         SLEEP 1500
         RETURN
    ELSE EDITKEY
  ENDIF
  ;
  ; initialize variables; Val[] stores validity
  ; settings and FieldName name of the field
  ; for which ValChecks are being established
  ;
  ARRAY Val[7]
  FOR i FROM 1 TO 7
    Val[i]=""
  ENDFOR
  FieldName=FIELD()
  c=0
  Item=1
  Pos=1
  ;
  ; open window and get validity settings for
  ; the current field
  ;
  ValCheckScr()
  GetCurrValCk()

  WHILE Item>0
    ;
    ; display data entry message for current
    ; line (i.e. current ValCheck option)
    ;
    STYLE ATTRIBUTE 31
    @17,20 ??MsgLn1[Item]
    @18,20 ??MsgLn2[Item]
    ;
    ; highlight data entry area
    ;
    STYLE ATTRIBUTE 113
    PAINTCANVAS
      ATTRIBUTE 113
      Item+8,33,Item+8,58
    ;
    ; if editing Picture string, call GetPicStr()
    ;
    IF Item=4
      THEN Item=GetPicStr()
           Next=Item
           LOOP
;           IF Item=0
;             THEN CANCELEDIT
;                  RETURN
;             ELSE Next=Item
;                  LOOP
;           ENDIF
    ENDIF
    ;
    ; place cursor at end of data string
    ;
    Pos=LEN(Val[Item])+1
    @Item+8,Pos+32
    CANVAS ON
    CURSOR NORMAL
    ;
    ; hold value of current validity check
    ; in temporary variable for use by
    ; the procedure that checks for valid
    ; entry (i.e. ValidEntry())
    ;
    TempVal=Val[Item]
    WHILE True
      ;
      ; wait for user input
      ;
      c=GETCHAR()
      SWITCH
        CASE c>31 AND c<127 AND Pos<26: ;printable char
          Pos=Pos+1
          ?? CHR(c)
          Val[Item]=Val[Item]+CHR(c)
          LOOP
        CASE c=8 AND Pos>1:             ;Backspace
          Pos=Pos-1
          @Item+8,Pos+32 ??" "
          @Item+8,Pos+32
          IF Pos=1
            THEN Val[Item]=""
            ELSE Val[Item]=
                 SUBSTR(Val[Item],1,Pos-1)
          ENDIF
          LOOP
        CASE c=127:                     ;Ctrl Backspace
          Pos=1
          @Item+8,Pos+32 ??SPACES(24)
          @Item+8,Pos+32
          Val[Item]=""
          LOOP
        CASE c=-72:                     ;Up
          IF NOT ValidEntry()
            THEN LOOP
          ENDIF
          IF Item=5
            THEN IF NOT GetLkUpSpec()
                   THEN QUITLOOP
                 ENDIF
          ENDIF
          IF Item=1
            THEN Next=7
            ELSE Next=Item-1
          ENDIF
          QUITLOOP
        CASE c=13 or c=-80:             ;Enter or Down
          IF NOT ValidEntry()
            THEN LOOP
          ENDIF
          IF Item=5
            THEN IF NOT GetLkUpSpec()
                   THEN QUITLOOP
                 ENDIF
          ENDIF
          IF Item=7
            THEN Next=1
            ELSE Next=Item+1
          ENDIF
          QUITLOOP
        CASE c=-59 AND Item=5:          ;F1
          ;
          ; display Table lookup list
          ; and get user choice
          ;
          LookUpTab()
          ;
          ; redraw ValCheck window and
          ; redisplay current values
          ;
          ValCheckScr()
          DisplayValCk()
          QUITLOOP
        CASE c=-60:                     ;F2
          IF NOT ValidEntry()
            THEN LOOP
          ENDIF
          IF Item=5
            THEN IF NOT GetLkUpSpec()
                   THEN QUITLOOP
                 ENDIF
          ENDIF
          DO_IT!
          RETURN
        CASE c=27:                      ;Esc
          CANCELEDIT
          RETURN
        OTHERWISE:
          c=0
          BEEP
      ENDSWITCH
    ENDWHILE
    CURSOR OFF
    CANVAS OFF
    ;
    ; remove highlight
    ;
    PAINTCANVAS
      ATTRIBUTE 31
      Item+8,33,Item+8,58
    Item=Next
  ENDWHILE
ENDPROC


;*********************************************;
; ValidEntry(), called by AddValCheck() prior ;
; to a field departure, checks for validity   ;
; of entered value and returns True or False. ;
;*********************************************;
PROC ValidEntry()
  PRIVATE GoodValCk
  ;
  ; if no change in current value, return; if
  ; field is left blank, reset to original value
  ; and return - existing ValChecks can only
  ; be removed with the Clear option
  ;
  IF TempVal=Val[Item]
    THEN RETURN True
    ELSE IF ISBLANK(Val[Item])
           THEN Val[Item]=TempVal
                @Item+8,33 ??Val[Item]
                RETURN True
         ENDIF
  ENDIF
  ;
  ; the validity of entered values is checked
  ; by assigning the value and trapping any
  ; resulting error through Errorproc="ValErr";
  ; ValErr() resets GoodValCk to False and
  ; displays the current Paradox error message
  ;
  GoodValCk=True
  SWITCH
    CASE Item=1:
      IF NOT ISBLANK(Val[1])
        THEN MENU {ValCheck} {Define}
             MOVETO FIELD FieldName ENTER
             {LowValue}
             SELECT Val[1]
      ENDIF
    CASE Item=2:
      IF NOT ISBLANK(Val[2])
        THEN MENU {ValCheck} {Define}
             MOVETO FIELD FieldName ENTER
             {HighValue}
             SELECT Val[2]
      ENDIF
    CASE Item=3:
      IF NOT ISBLANK(Val[3])
        THEN MENU {ValCheck} {Define}
             MOVETO FIELD FieldName ENTER
             {Default}
             SELECT Val[3]
      ENDIF
    CASE Item=4:
      IF NOT ISBLANK(Val[4])
        THEN MENU {ValCheck} {Define}
             MOVETO FIELD FieldName ENTER
             {Picture}
             SELECT Val[4]
      ENDIF
    CASE Item=5:
      IF NOT ISBLANK(Val[5])
        THEN MENU {ValCheck} {Define}
             MOVETO FIELD FieldName ENTER
             {TableLookup}
             SELECT Val[5]
      ENDIF
    CASE Item=6:
      IF NOT ISBLANK(Val[6])
        THEN MENU {ValCheck} {Define}
             MOVETO FIELD FieldName ENTER
             {Required}
             SELECT Val[6]
        ELSE Val[6]=TempVal
      ENDIF
    CASE Item=7:
      IF NOT ISBLANK(Val[7])
        THEN MENU {ValCheck} {Clear}
             SELECT Val[7]
             IF UPPER(Val[7])="FIELD"
               THEN MOVETO FIELD FieldName ENTER
             ENDIF
             IF GoodValCk
               THEN GetCurrValCk()
             ENDIF
      ENDIF
  ENDSWITCH
  ;
  ; exit Paradox menu so that the
  ; defined PROMPT will display
  ;
  MENU ESC
  RETURN GoodValCk
ENDPROC


;**********************************************;
; ValCheckScr() is called by AddValCheck() and ;
; opens a window on the canvas for validity    ;
; setting data entry/edit.                     ;
;**********************************************;
PROC ValCheckScr()
  CANVAS OFF
  PROMPT " [F2]  Save validity checks"+SPACES(20)+
         " Defining validity checks for",
         " [ESC] Quit/cancel changes "+SPACES(20)+
         " ["+FieldName+"]"
  ;
  ; display current PROMPT definition
  ;
  ECHO NORMAL
  ECHO OFF
  ;
  ; paint shadow
  ;
  PAINTCANVAS
    ATTRIBUTE 8
    7,19,20,61

  STYLE ATTRIBUTE 31
  @6,18
  SETMARGIN 18

TEXT
Ŀ
            V A L   C H E C K            
Ĵ
    LowValue:                            
   HighValue:                            
     Default:                            
     Picture:                            
 TableLookUp:                            
    Required:                            
       Clear:                            
Ĵ
                                         
                                         

ENDTEXT

  SETMARGIN 0
ENDPROC


;********************************************;
; GetCurrValCk() uses MENU options to obtain ;
; the current validity settings.  These are  ;
; stored in the array Val[].  ESC is used to ;
; "back up" one menu level after querying    ;
; each option for its current value.         ;
;********************************************;
PROC GetCurrValCk()

  MENU {ValCheck} {Define}
  MOVETO FIELD FieldName ENTER

  {LowValue}
  Val[1]=MENUCHOICE()
  ESC

  {HighValue}
  Val[2]=MENUCHOICE()
  ESC

  {Default}
  Val[3]=MENUCHOICE()
  ESC

  {Picture}
  Val[4]=MENUCHOICE()
  ESC

  {TableLookup}
  Val[5]=MENUCHOICE()
  ESC

  {Required}
  Val[6]=MENUCHOICE()
  ;
  ; exit the Paradox menu so that the
  ; defined PROMPT will display
  ;
  MENU ESC
  Val[7]=""
  ;
  ; display current ValCheck definitions
  ;
  DisplayValCk()
ENDPROC


;*********************************************;
; DisplayValCk() is used to write the current ;
; validity settings to the ValCheck screen.   ;
;*********************************************;
PROC DisplayValCk()
  PRIVATE i

  CANVAS OFF
  STYLE ATTRIBUTE 31
  ;
  ; necessary to redisplay the data entry
  ; message when closing "Lookup Specs"
  ; window (LookUpTab() and GetLkUpSpec())
  ;
  @17,20 ??MsgLn1[Item]
  @18,20 ??MsgLn2[Item]

  FOR i FROM 1 TO 7
    ;
    ; clear line before writing value
    ;
    @i+8,33 ??SPACES(25)
    @i+8,33 ??Val[i]
  ENDFOR
  ;
  ; highlight current line for same reason
  ; as redisplaying field message
  ;
  PAINTCANVAS
    ATTRIBUTE 113
    Item+8,33,Item+8,58
ENDPROC


;*************************************************;
; ValErr() is the procedure defined to be called  ;
; whenever Paradox encounters an error.  This     ;
; will normally occur with an attempt to enter    ;
; out-of-range or invalid validity checks.  Using ;
; a defined procedure allows the program to       ;
; continue and wait for a corrected entry rather  ;
; than exiting with a Cancel/Debug.               ;
;*************************************************;
PROC ValErr()
  PRIVATE Errorproc

  BEEP
  MESSAGE ERRORMESSAGE()+"..."
  GoodValCk=False
  ;
  ; returning 1 causes the error producing
  ; statement to be skipped
  ;
  RETURN 1
ENDPROC


;**************************************************;
; GetMode() is called by GetVal() prior to exiting ;
; the program and restores Paradox to its original ;
; mode (i.e. View, Edit, or CoEdit).               ;
;**************************************************;
PROC GetMode()
  PRIVATE c
  ;
  ; empty keyboard buffer
  ;
  WHILE CHARWAITING()
    c=GETCHAR()
  ENDWHILE
  ;
  ; reset to original mode
  ;
  SWITCH
    CASE Mode="Edit":
      EDITKEY
    CASE Mode="CoEdit":
      COEDITKEY
  ENDSWITCH
ENDPROC


;**********************************************;
; GetLkUpSpec() is called by AddValCheck() to  ;
; complete the process of defining a Table as  ;
; a "LookUp."  If a new Table name is entered, ;
; LookUpSpec() is called to open a window for  ;
; choice of lookup specifications (e.g. Help   ;
; and Fill).                                   ;
;**********************************************;
PROC GetLkUpSpec()
  PRIVATE Result

  IF TempVal=Val[Item]
    THEN RETURN True
    ELSE IF ISBLANK(Val[Item])
           THEN Val[Item]=TempVal
                @Item+8,33 ??Val[Item]
                RETURN True
         ENDIF
  ENDIF

  IF NOT LookUpSpec(WorkTab)
    THEN Result=False
    ELSE Result=True
  ENDIF

  ValCheckScr()
  DisplayValCk()
  EDITKEY
  RETURN Result
ENDPROC


;***************************************************;
; GetPicStr() manages the viewing and editing of a  ;
; picture definition string longer than the display ;
; area by allowing the string to be scrolled        ;
; horizontally.  The predefined list of Picture     ;
; formats, located in Table PicTab, can be accessed ;
; by using [F1].                                    ;
;***************************************************;
PROC GetPicStr()
  PRIVATE c,Pos,First,Last,MaxLen,NextItem,
          TempStr,TempFirst,TempLast,
          TempPos,TempStrLen
  ;
  ; set maximum string length
  ;
  MaxLen   = 100
  ;
  ; NextItem is returned to the calling
  ; procedure for field depart direction
  ;
  NextItem = 0

  Last   = LEN(Val[4])
  StrLen = Last
  Pos    = Last+1
  First  = 1
  IF Last>25
    THEN First = Last-24
         Pos   = 26
  ENDIF
  ;
  ; temporary variables used to undo changes
  ;
  TempStr    = Val[4]
  TempFirst  = First
  TempLast   = Last
  TempPos    = Pos
  TempStrLen = StrLen

  WHILE NextItem=0
    ;
    ; display field length indicators; left
    ; and right arrow heads indicating text
    ; beyond that currently in view
    ;
    STYLE ATTRIBUTE 31
    @ 12,32
    IF First>1
      THEN ?? CHR(17)
      ELSE ?? " "
    ENDIF
    @ 12,59
    IF Last<StrLen
      THEN ?? CHR(16)
      ELSE ?? " "
    ENDIF
    ;
    ; highlight current field, display
    ; last 25 characters of string and
    ; leave cursor at end
    ;
    STYLE ATTRIBUTE 113
    @12,33 ?? SUBSTR(Val[4],First,25)
    CANVAS ON
    CURSOR NORMAL

    WHILE True
      @12,32+Pos
      ;
      ; get user input
      ;
      c=GETCHAR()
      SWITCH
        CASE c>31 AND c<127:                ;printable chr
          IF StrLen=MaxLen
            THEN BEEP
                 LOOP
          ENDIF
          Len1=First+Pos-2
          Len2=StrLen-Len1-1
          Val[4]=SUBSTR(Val[4],1,Len1)+
                 CHR(c)+
                 SUBSTR(Val[4],Len1+2,Len2)
          IF Pos>(StrLen-First+1)
            THEN StrLen=StrLen+1
                 Last=Last+1
          ENDIF
          IF Pos=26
            THEN First=First+1
                 CANVAS OFF
                 QUITLOOP
            ELSE ?? CHR(c)
                 Pos=Pos+1
          ENDIF
          LOOP
        CASE c=8 AND Pos>(Last-First+1):    ;Backspace
          IF Pos>1
            THEN Pos=Pos-1
            ELSE IF First>1
                   THEN First=First-1
                   ELSE BEEP
                        LOOP
                 ENDIF
          ENDIF
          Last=Last-1
          StrLen=StrLen-1
          Val[4]=SUBSTR(Val[4],1,StrLen)
          @12,32+Pos ??" "
          LOOP
        CASE c=-83 AND Pos<=(Last-First+1): ;Del
          StrLen=StrLen-1
          Len1=First+Pos-2
          Len2=StrLen-Len1
          Val[4]=SUBSTR(Val[4],1,Len1)+
                 SUBSTR(Val[4],Len1+2,Len2)
          IF StrLen<Last
            THEN Last=StrLen
          ENDIF
          CANVAS OFF
          @12,33 ?? SPACES(25)
          QUITLOOP
        CASE c=-75:                         ;Left
          IF Pos>1
            THEN Pos=Pos-1
            ELSE IF First>1
                   THEN First=First-1
                        IF (Last-First)>24
                          THEN Last=Last-1
                        ENDIF
                        CANVAS OFF
                        QUITLOOP
                   ELSE BEEP
                 ENDIF
          ENDIF
          LOOP
        CASE c=-77:                         ;Right
          IF Pos<=(Last-First+1)
            THEN Pos=Pos+1
            ELSE IF Last<StrLen
                   THEN First=First+1
                        Last=Last+1
                        CANVAS OFF
                        @12,33 ?? SPACES(25)
                        QUITLOOP
                   ELSE BEEP
                 ENDIF
          ENDIF
          LOOP
        CASE c=-72:                         ;Up
          NextItem=3
          QUITLOOP
        CASE c=13 OR c=-80:                 ;Enter or Down
          NextItem=5
          QUITLOOP
        CASE c=-59:                         ;F1
          ;
          ; display Picture lookup list and
          ; get user choice; if choice made,
          ; reset Picture parameters
          ;
          IF LookUpPic()
            THEN Last  =LEN(Val[4])
                 StrLen=Last
                 Pos   =Last+1
                 First =1
                 IF Last>25
                   THEN First=Last-24
                        Pos  =26
                 ENDIF
          ENDIF
          ;
          ; redraw ValCheck window and redisplay
          ; current values
          ;
          ValCheckScr()
          DisplayValCk()
          ;
          ; check validity of Picture element
          ;
          ValidEntry()
          QUITLOOP
        CASE c=-60:                         ;F2
          ;
          ; if Picture format is valid, save
          ; ValCheck changes to field and exit
          ;
          IF NOT ValidEntry()
            THEN LOOP
          ENDIF
          DO_IT!
          RETURN 0
        CASE c=27:                          ;Esc
          ;
          ; exit if no change; otherwise,
          ; undo changes and loop
          ;
          IF Val[4]=TempStr
            THEN CANCELEDIT
                 RETURN 0
            ELSE Val[4] = TempStr
                 First  = TempFirst
                 Last   = TempLast
                 StrLen = TempStrLen
                 Pos    = TempPos
                 CANVAS OFF
                 @12,33 ?? SPACES(25)
                 QUITLOOP
          ENDIF
        OTHERWISE:
          BEEP
      ENDSWITCH
    ENDWHILE
  ENDWHILE
  CANVAS OFF
  STYLE ATTRIBUTE 31
  ;
  ; display from beginning of string and
  ; return field departure direction
  ;
  @12,32 ?? " "+FORMAT("w25",Val[4])+" "
  RETURN NextItem
ENDPROC


WRITELIB "ValCheck" GetVal,AddValCheck,ValCheckScr,GetCurrValCk,
                    DisplayValCk,ValidEntry,ValErr,GetMode,
                    GetLkUpSpec,GetPicStr
RELEASE PROCS GetVal,AddValCheck,ValCheckScr,GetCurrValCk,
              DisplayValCk,ValidEntry,ValErr,GetMode,
              GetLkUpSpec,GetPicStr
