; ---------------------------------------------------------------------------
;                         SHADOW BOX TEXT POPUP
;
; shadowed box, auto-sized, auto-located, displays text from array that must
; be named SBText and should be private to the proc calling ShadowBox()
; ---------------------------------------------------------------------------
proc ShadowBox(Color,R,C,Title)
  private n, AShadow, AText, NumLines, MaxLen, BoxWidth, R1, R2, R3, R4,
          NetLine, T, Tlen, Lfill, Rfill, BorderString

  switch
    case upper(Color) = "BLACK"  :  AShadow = 16    AText = 11
    case upper(Color) = "BLUE"   :  AShadow = 9     AText = 31
    case upper(Color) = "GREEN"  :  AShadow = 10    AText = 47
    case upper(Color) = "CYAN"   :  AShadow = 3     AText = 63
    case upper(Color) = "RED"    :  AShadow = 4     AText = 79
    case upper(Color) = "PURPLE" :  AShadow = 13    AText = 95
    case upper(Color) = "BROWN"  :  AShadow = 6     AText = 111
    case upper(Color) = "GRAY"   :  AShadow = 7     AText = 112
    case upper(Color) = "MONO"   :  AShadow = 112   AText = 15
  endswitch

  NumLines = min(arraysize(SBText),18)  ;how many lines? we allow 18 max

  MaxLen = 0                            ;find the longest line in text array
  for n from 1 to NumLines              ;step through it a line at a time
    MaxLen = max(MaxLen,len(SBText[n]))   ;set to largest of the two
  endfor

  MaxLen = max(MaxLen,len(Title))       ;if title is longer ...
  MaxLen = min(MaxLen,74)               ;74 = 80-2 col shadow-4 cols
                                          ;for borders and spaces
  BoxWidth = MaxLen+4

  ;************************** auto box location **************************
  switch
    ;*** if both R=99 and C=99, center box in screen
    case R = 99 and C = 99:
      R1 = int((24-NumLines-3)/2)       ;center the box vertically
      R2 = R1 + NumLines +3
      C1 = int((80-BoxWidth)/2)         ;center the box horizontally
      C2 = C1 + BoxWidth-1
    ;*** if only R=99, center box top to bottom w/left edge at C value
    case R = 99:
      R1 = int((24-NumLines-3)/2)       ;center the box vertically
      R2 = R1 + NumLines +3
      C1 = min(C,80-BoxWidth)           ;move left if C too low for size
      C2 = C1+BoxWidth-1                ;(allow offset of 2 for shadow)
    ;*** if only C=99, centered box left to right with top at R value
    case C = 99:
      R1 = min(R,24-NumLines-3)         ;move up if R too low for size
      R2 = R1+NumLines+3
      C1 = int((80-BoxWidth)/2)         ;center the box horizontally
      C2 = C1+BoxWidth-1                ;(allow offset of 2 for shadow)
    ;*** all other cases, try to locate at parameters passed, and if
    ;    impossible then adjust as required
    otherwise:
      R1 = min(R,24-NumLines-3)         ; move up if R too low for size
      R2 = R1 + NumLines +3
      C1 = min(C,80-BoxWidth)           ; move left if C too low for size
      C2 = C1+BoxWidth-1
  endswitch

  ;*** make sure there's room for shadow
  R1 = min(R1,24-NumLines-4)
  R2 = R1+NumLines+3
  C1 = max(C1,2)
  C2 = C1+BoxWidth-1

  ;*** title line calculations
  T = substr(Title,1,70)
  Tlen = max(0,BoxWidth-2-len(T))
  Lfill = max(0,int(Tlen/2))
  Rfill = max(0,Tlen-Lfill)

  ;*** calculate border fill string
  BorderString = ""+fill("",Lfill)+T+fill("",Rfill)+""  +
                     fill("",(NumLines+2)*2)               +
                 ""+fill("",BoxWidth-2)+""
  ;*** paint transparent shadow
  paintcanvas  attribute AShadow   R1+1, C1-2, R2+1, C2-2
  ;*** paint solid color text box
  paintcanvas  fill " "  attribute Atext  R1, C1, R2, C2
  ;*** paint text box borders
  paintcanvas border fill BorderString  attribute Atext R1, C1, R2, C2

  ;*** write text from array into box
  style attribute Atext
  for n from 1 to NumLines
    @ R1+1+n, C1+2 ?? SBText[n]
  endfor
  style

endproc

;*** DEMO CODE - include at end and play:
array SBText[11]
      SBText[1]  = "This is a sample message box."
      SBText[2]  = "        "
      SBText[3]  = "Put whatever you want here to"
      SBText[4]  = "inform or enrage your users."
      SBText[5]  = "        "
      SBText[6]  = "This sort of thing can keep"
      SBText[7]  = "David Kelton entertained for"
      SBText[8]  = "entire weekends, but then he"
      SBText[9]  = "DOES live in the Philly area."
      SBText[10] = "        "
      SBText[11] = "     Press Esc to quit"

array SBColor[9]
      SBColor[1] = "BLACK"
      SBColor[2] = "BLUE"
      SBColor[3] = "GREEN"
      SBColor[4] = "CYAN"
      SBColor[5] = "RED"
      SBColor[6] = "PURPLE"
      SBColor[7] = "BROWN"
      SBColor[8] = "GRAY"
      SBColor[9] = "MONO"
MaxLen = 0
for n from 1 to arraysize(SBText)
  MaxLen = max(MaxLen,len(SBText[n]))
endfor
while charwaiting()                     ;if any keys in keyboard buffer
  retval = getchar()                      ;suck up keys in buffer
endwhile                                ;until all gone
paintcanvas  fill chr(177)   0,  0, 24, 79  ;nice background
while true
  R = int(rand()*25)                    ;random row selection
  C = int(rand()*(80-MaxLen))           ;balanced random column selection
  Color = SBColor[int(rand()*9)+1]      ;random color selection
  ShadowBox(Color,R,C,"SHADOW BOX")
  if charwaiting() then                 ;see if there's a key in the buffer
    retval = getchar()                    ;get the key
    if retval = 27 then quitloop endif    ;quit if it's Esc
  endif
endwhile
message "Press any key to clear the screen"
retval=getchar()
; It's a pleasure and a privilege to be of service to you  -  Steve

