;        COPYRIGHT 1-Jan-1988
;
;        Marx Leon Martin, Dallas, Texas (214) 239-8726.
;            Telex: 795514 HQB DAL   Facsimile: (214) 458-7618
;
;   ALL RIGHTS RESERVED. Selling this product without express written
;                        consent is not permitted.
;
;-----------------------------------------------------------------------------

; **************************
;
;  These programming aids have been made available as is, and without warranties
;    of any kind.  These are not for resale.  These may be altered to any extent
;    for the purposes, and ease of the user.  Please make as many copies as you need
;    and distribute to whomever desires them.
;                 Marx Martin
;
;  TO Install:
;
;      Set autolib to the library of your choice, and play "progaids."
;
;  TO Set Control Key Access: (NOTE: Procedures' call from control key will
;                              be the current autolib.)
;
;      From the pal menu alt + F10 select Miniscript and set the autolib
;      variable to the library where you installed the programmer's aids, and
;      enter "zzkeys()" to enable the following control keys.
;
;******Ctrl A : Type in one or more characters in script, or forms using
;               asc ii code entered, and the number of characters requested.
;        e.g. draw a :
;                       left corner double line: ctrl a 201 [enter] 1 [enter]
;                       double line of 40 char.: ctrl a 205 [enter] 40 [enter]
;                      right corner double line: ctrl a 188 [enter] 1 [enter]
;
;        Refer to the appendix in the PAL manual for asc numeric codes.
;        PERFORMANCE CONSIDERATION:  Use of the fill() proc may help performance
;                                    when applicable.
;
;******Alt C : Copy one or more lines in scripts, reports, or forms.
;              Will prompt for number of lines to copy from line at cursor/and down.
;
;******Alt P : Paste the above lines at the cursorline postion.
;
;            NOTE: Use of ins typeover modes will be recognized.
;
;
;
;*******Alt x : Calls the programmer aids menu for the following functions:
;    "AscType" : "Typein characters not available through keyboard.",
;    "Lcopy" : "Copy lines of script, report, or form.",
;    "Paste" : "Paste lines from Lcopy in script, report, or form.",
;    "Debug" : "Execute a string in debug mode.",
;    "Variable" : "Show a memory variable.",
;    "[array]" : "Show an array and its positions.",
;    "Echo" : "Select an Echo mode.",
;    "=Status" : "Show current library & size, memory, no. images, and drivespace.",
;    "CopyR" : "TypeIn copyright statement in script.",
;    ".EndProc" : "Place EndProc, WriteLib, Release Procs, and display message in script.",
;    "ZeroBlk" : "CAUTION: Clears a field of a table."
;    "KeySet" : "Set control keys for AscType, Lcopy, Paste, and Progamming Menu."
;
;





; display date and time of procedure creation/update
;
; zc = procedure name

proc zzproc(zc)

  private x,y,zc
  zc = lower(zc)

  if not isassigned(zzrw) then zzrw = 4 endif
  zzrw = zzrw + 1

  if zzrw > 20 or zzrw < 5 then zzrw = 5 endif
  style intense
  @ zzrw + 1,0 clear eol
  @ zzrw,0 ?? "   ",time()," ",sdir()," \179 Procedure",zc clear eol

endproc writelib autolib zzproc zzproc("zzproc")





; programming aids menu

proc zzmenu()

  private x,y,z

  while(true)
    showmenu
    "AscType" : "Typein characters not available through keyboard.",
    "Lcopy" : "Copy lines of script, report, or form.",
    "Paste" : "Paste lines from Lcopy in script, report, or form.",
    "Debug" : "Execute a string in debug mode.",
    "[array]" : "Show array's element numbers and values.",
    "Echo" : "Select an Echo mode.",
    "=Status" : "Show current library & size, memory, no. images, and drivespace.",
    "CopyR" : "TypeIn copyright statement in script.",
    ".EndProc" : "Place EndProc, WriteLib, Release Procs, and display message in script.",
    "ZeroBlk" : "CAUTION: Clears a field of a table.",
    "KeySet" : "Set control keys for AscType, Lcopy, Paste, and Progamming Menu."
    to x

    switch
      case x = "KeySet" : zzkeys() message "Setkey Commands Completed"
      case x = "AscType" : zzasctype() return
      case x = "Lcopy" : zzcopyline() return
      case x = "Paste" : zzpaste() return
      case x = "ZeroBlk" : zzzeroblk()
      case x = "Echo" : showmenu "Off" : "",
                                 "Slow" : "",
                                 "Fast" : "",
                                 "Normal" : ""
                        to x if x = "Esc" then loop endif
                        execute "echo " + x
      case x = "=Status"
      : clear @ 3,0 if isassigned(autolib) then ? autolib," is ",strval(filesize(autolib + ".lib")) endif
                   y = substr(directory(),1,1)
                 ? " Mem:",strval(memleft())
                 ? " Dir:",directory()
                 ? " Images:",strval(nimages())
                 ? " Disk:",strval(drivespace(y))
      case x = "CopyR" : zzcopyr() return
      case x = ".EndProc" : zzendproc() return
      case x = "[array]" : zzarray()
      case x = "Debug"
      : if isruntime() then message "Runtime" loop endif
        getclr() ?? " Enter the debug selection." style reverse @ 0,0 accept "a160" to x

        if retval <> false then execute "debug " + x endif
        getclr()
      otherwise : return
    endswitch
  endwhile

endproc writelib autolib zzmenu release procs zzmenu zzproc("zzmenu")




; programming aids setkey commands


proc zzkeys()

  setkey 1 zzasctype()       ; ctrl a = typein an ascii character

  setkey -25 zzpaste()       ; alt p = paste

  setkey -45 zzmenu()        ; alt x = programming aids menu

  setkey -46 zzcopyline()    ; alt c = for copy line

endproc writelib autolib zzkeys release procs zzkeys zzproc("zzkeys")




proc zzendproc()

  private x,y,z

  getclr() ?? " Please key procedure name"
  accept "a12" to x
  if retval = false then return true endif
  x = lower(x)
  enter
  typein "endproc writelib autolib " + x + " release procs " + x + " zzproc(\"" + x + "\")"
  enter enter enter enter

endproc writelib autolib zzendproc release procs zzendproc zzproc("zzendproc")






; array display

proc zzarray()

  private x,y,z,aryname

  while(true)
    getclr() ?? " Enter array name"
    accept "a12" to aryname
    if retval = false then quitloop endif

    execute " x = arraysize(" + aryname + ")"
    if x = 0 then message aryname,"Not Defined" loop endif

    while(true)
      getclr()
      ?? " Array ",aryname

      style @ 3,0
      y = 1
      for y to x
        execute "if isassigned(" + aryname + "[y]) then z = 1 else z = 0 endif"
        if z = 1 then
          execute "? format(\"w4,al\",y) + \" \" + strval(" + aryname + "[y])" clear eol

          else ? format("w4,al",y)," NOT ASSIGNED" clear eol
        endif

        if row() = 24 then message "PauseAny Key" z = getchar()
          @ 3,0
        endif
      endfor
      message "Pause DoneAny Key"
      z = getchar()
      quitloop
    endwhile
  endwhile

  message ""

endproc writelib autolib zzarray release procs zzarray zzproc("zzarray")






; to zero or blank a field of a table

proc zzzeroblk()

  private x,y,z

  if sysmode() <> "Main" then do_it! endif

  switch
    case nimages() = 0 : showfiles noext "*.db" "Select table to clear a field in." to x
                         if x = "Esc" then quitloop endif
                         view x

    otherwise : getclr() ?? " Enter Table Name"
                accept "a8" to x if retval = false or isblank(x) then return false endif
                moveto 1
                while imagetype() <> "Display" downimage endwhile
                y = imageno()
                for y to nimages()
                  if upper(table()) = upper(x) then return false endif
                endfor
                if upper(table()) <> upper(x) then return false endif
  endswitch
  coeditkey

  x = format("w80,ac","Place cursor on field to clear and press [F2], or [F8] cancels.")
  wait table prompt x
  until "f2","f8"
  if retval = "f8" then return false endif

  switch
    case fieldtype() = "$" or fieldtype() = "N" or fieldtype() = "S"
    : x = 0

    case fieldtype() = "D"
    : x = blankdate()

    otherwise : x = ""
  endswitch
  clear

  getclr() ?? " Clearing table",table()," and field",field(),"."
  cursor off

  scan
    while(true)
      lockrecord
      if retval = true then quitloop endif
      message erroruser()," Using Record ",recno()," Waiting; [Esc] Cancels."
      y = ""
      z = 1
      for z to 3000 if charwaiting() then y = getchar() quitloop endif endfor
      if y = 27 then return false endif
    endwhile
    [] = x
    message "Cleared ",recno()
  endscan
  do_it!
  clear
  return

endproc writelib autolib zzzeroblk release procs zzzeroblk zzproc("zzzeroblk")






; place copyright statement in source code when reqeusted.
;
proc zzcopyr()

  if not isinsertmode() then ins endif
  enter enter
  typein ";        COPYRIGHT "+format("d7",today()) enter
  typein ";" enter
  typein ";        (Your name, address, phone , etc.)" enter
  typein ";" enter
  typein ";   ALL RIGHTS RESERVED. Copying, duplicating, selling, or using this" enter
  typein ";   product without express written consent is not permitted." enter
  enter enter
  typein "; * * * * * * * * * * * " enter
  enter enter

endproc writelib autolib zzcopyr release procs zzcopyr zzproc("zzcopyr")








; copy number of line to memory


proc zzcopyline()

  private y,z

  style reverse
  ?? " No Lines" accept "n" to y

  if retval = false or isblank(y) then return true endif
  array x[y]

  z = 1
  for z to y
    x[z] = cursorline()
    down
  endfor

endproc writelib autolib zzcopyline release procs zzcopyline zzproc("zzcopyline")







proc zzasctype()

  private x,y

  style reverse
  ?? " ASC" accept "n" to x if retval = false or isblank(x) then return
    endif
  ? " No." accept "n" to y if retval = false or isblank(y) then return
    endif
  while(y>0) typein chr(x) y=y-1 endwhile


endproc writelib autolib zzasctype release procs zzasctype zzproc("zzasctype")


proc zzpaste()

  private z

  z = 1 for z to arraysize(x) typein x[z] enter endfor

endproc writelib autolib zzpaste release procs zzpaste zzproc("zzpaste")







; clear line of screen
;
proc getclr()

  private x

  cursor box
  style
  @ 3,0 ?? fill("",80)
  @ 2,0 clear eol
  while charwaiting() x = getchar() endwhile

endproc writelib autolib getclr release procs getclr zzproc("getclr")




proc dimkinit(a)

  private x,y,a

  switch case isblank(a) : array z[9]
    y = today()
    x = "" + dow(y) + "  " + format("d2",y) + ""
    y = int(len(x) / 2)
    x = fill("",int(80 / 2) - y) + x
    y = len(x)
    x = x + fill("",80 - y)
    z[1] = x

    z[2] = format("w78,ac","SALES & SERVICES SYSTEMMarx L. Martin")
    z[3] = format("w78,ac","5026 Forest Bend, Dallas, Texas 75244 Phone: (214) 239-8726")
    z[4] = format("w78,ac","Facsimile: (214) 458-7618   Telex: 795514 HQB DAL")

;    x = " Sales & Services System "
;    y = int(len(x) / 2)
;    x = fill("",int(71 / 2) - y) + x
;    y = len(x)
;    x = x + fill("",71 - y)
    z[5] = fill("",71)
    z[6] = "     "
    z[7] = "    "
    z[8] = fill("",71)
    z[9] = fill("",80)

    OTHERWISE : array z[10]
      ;22  219  220  221  222  223  254 
      z[1]  = " ͸͸Ŀ" ;10
      z[2]  = "       ;                    ;      " ;11
      z[3]  = " ۳Ĵ¿                       Ŀ" ;12
      z[4]  = "ٰ͵ͻ                           " ;13
      z[5]  = "          Լ            " ;14
      z[6]  = "          ͻ    Ŀ        " ;15
      z[7]  = "¿          ͵         " ;16
      z[8]  = " ۳Ĵ                        ٳ" ;17
      z[9]  = "       ͸                    ͸       " ;18
      z[10] = " ;;" ;19
  endswitch

endproc writelib autolib dimkinit release procs dimkinit zzproc("dimkinit")








proc diinit(a)

  private x,y,c,z,zl,rw

; display copyright and system name screen
  clear
  cursor off

  if monitor() = "Color" then c = sygrand(1,15) style attribute c
     else style
  endif
  dimkinit("")

  rw = 4
  @ rw,0 ?? z[1]
  x = rw + 1
  for x to 20
    @ x,0 ?? "",spaces(78),""
  endfor
  @ 21,0 ?? z[9]

  @ 5,1 ?? z[2]
  @ 6,1 ?? z[3]
  @ 7,1 ?? z[4]

  cl = 5
  rw = 9
  @ rw,cl     ?? z[5]
  @ rw + 1,cl ?? z[6] ; 1
  @ rw + 2,cl ?? z[7] ; 2
  @ rw + 3,cl ?? z[6] ; 3
  @ rw + 4,cl ?? z[7] ; 4
  @ rw + 5,cl ?? z[6] ; 5
  @ rw + 6,cl ?? z[7] ; 6
  @ rw + 7,cl ?? z[6] ; 7
  @ rw + 8,cl ?? z[7] ; 8
  @ rw + 9,cl ?? z[6] ; 9
  @ rw + 10,cl ?? z[7]; 10
  @ rw + 11,cl ?? z[8]

  dimkinit("1")

  rw = 9
  if isblank(a) then
    x = 75 zl = 2
    for zl to len(z[1]) step 2
      x = x - 2
      @ rw + 1,x ?? substr(z[1],1,zl)
      @ rw + 2,x ?? substr(z[2],1,zl)
      @ rw + 3,x ?? substr(z[3],1,zl)
      @ rw + 4,x ?? substr(z[4],1,zl)
      @ rw + 5,x ?? substr(z[5],1,zl)
      @ rw + 6,x ?? substr(z[6],1,zl)
      @ rw + 7,x ?? substr(z[7],1,zl)
      @ rw + 8,x ?? substr(z[8],1,zl)
      @ rw + 9,x ?? substr(z[9],1,zl)
      @ rw + 10,x ?? substr(z[10],1,zl)
    endfor

    else
    y = 1
    for y to arraysize(z)
     @ rw + y,17 ?? z[y]
    endfor
  endif

endproc writelib autolib diinit release procs diinit zzproc("diinit")



; random integer generation

proc sygrand(low,hi)

    return (int((hi - low + 1) * rand() + low))

endproc writelib autolib sygrand release procs sygrand zzproc("sygrand")



diinit("") getclr() cursor off
message "Thank you. Please notify me of errors. Keypress Continues."
x = getchar()



                                