;******************************************************************************
; SCRIPT NAME   : PASSCHG.SC
;
; PURPOSE       : This script prompts the user for the new password, then
;                 changes it for all tables specified in the Protect statement.
;                 When finished, it returns to DOS.
;
; CALLED BY     : PASS.SC
;
; WRITTEN BY    : T. Bonney / April 1988
;
; UPDATED BY    :
;
; NOTES         :
;******************************************************************************


RELEASE VARS ALL

MONTYPE = MONITOR()


;** Opportunity is given to abort the password change and return to DOS.
;** Otherwise, the procedure continues.

WHILE(TRUE)
    CLEAR
    SHOWMENU
        "NewPass": "Change password",
        "Quit": "Do NOT continue. Return to DOS without making any changes"
    DEFAULT "NewPass"
    TO CHOICE
        SWITCH
            CASE CHOICE = "Quit":
                MESSAGE "Leaving password change procedure and returning to DOS."
                SLEEP 4000
                RETURN FALSE

            CASE CHOICE = "NewPass":
                DO_IT!
        ENDSWITCH


;** First new password prompt.

IF MONTYPE = "Mono"
    THEN STYLE ATTRIBUTE 30
    ELSE STYLE ATTRIBUTE 112
ENDIF

PASS = ""
PW   = ""

@10,1 ? " Enter new password. Maximum length 15 characters."
    STYLE ATTRIBUTE 0                                  ;** Attribute 0 is black
@11,1 ? ": "                                           ;** (non-printing)
    ACCEPT "A15" TO PW
    PASS = PW
    STYLE

IF MONTYPE = "Mono"
    THEN STYLE ATTRIBUTE 30
    ELSE STYLE ATTRIBUTE 112
ENDIF


;** Second new password prompt.

PASS2 = ""
PW2   = ""

@12,1 ? "        Enter new password again for confirmation."
    STYLE ATTRIBUTE 0                                  ;** Attribute 0 is black
@13,1 ? ": "                                           ;** (non-printing)
    ACCEPT "A15" TO PW2
    PASS2 = PW2
    STYLE


;** The first new password entry is compared to the second.  If they are
;** identical, the procedure continues.  If they are different, a message is
;** displayed to that effect then the procedure terminates.

IF PASS<>PASS2 THEN
    MESSAGE "Second entry different than first. Try again."
    SLEEP 5000
    RETURN FALSE
ENDIF

CLEAR


;** Passwords are changed for all tables in the Protect statement.

IF MONTYPE = "Mono"
    THEN STYLE ATTRIBUTE 30
    ELSE STYLE ATTRIBUTE 112
ENDIF
@10,1 ? " Changing system password.  This will take a moment."

IF MONTYPE = "Mono"
    THEN STYLE ATTRIBUTE 138
    ELSE STYLE ATTRIBUTE 143
ENDIF
@12,1 ? "                   PLEASE STANDBY "
    STYLE

PROTECT "A" PASS                        ;** A, B, C = table names.  Substitute for
PROTECT "B" PASS                        ;**           your table names and add
PROTECT "C" PASS                        ;**           others as necessary.

CLEAR
MESSAGE "Password change completed."
SLEEP 4000
RETURN

RELEASE VARS ALL

