
vlib = "MEMOEDIT" CREATELIB vlib

;------------------------------------------------------------------------------
;Procname    : MEMO_VIEW_EDIT
;Description : This proc is a generic memo and/or text file view/editor.
;              It can be used for viewing or editing memo or ascii text and
;              works by loading the specified text file from disk or the
;              current (memo) field.
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. (404) 499-1368
;Returns     : TRUE OR FALSE
;------------------------------------------------------------------------------
PROC MEMO_VIEW_EDIT(FileToLoad,EditFlag,WinTitle)

   PRIVATE memowin,memoflag,memotext,memohndl,initmode,holdfile

   GUI_MSG4("Processing","Loading File/One Moment Please...")

   holdfile  = IIF(ISTABLE("HOLDFILE"),"HOLDFILE",PRIVDIR()+"HOLDFILE")
   initmode  = UPPER(SYSMODE())
   errorproc = "MEMOERRORHANDLER"

   IF NOT INIT_VIEW_EDIT() THEN RETURN FALSE ENDIF

   SHOWMEMOPULLDOWN()

   ECHO NORMAL PROMPT "DataMasters of Georgia, Inc."

   WAIT FIELD

      PROC "MEMO_WAIT_HNDLR" TRIGGER "OPEN"
                             KEY 27,-60,-59,-18,26,15,-18 ;,-63
                             ;Esc,F2,F1,Alt-E,Ctrl-Z,Alt-O,Ctrl-O,F5
                             MESSAGE "MENUSELECT"
   ENDWAIT

   ECHO OFF CLEARPULLDOWN CLEARSPEEDBAR
   IF UPPER(SYSMODE()) <> initmode THEN
      IF initmode = "COEDIT" THEN COEDITKEY ELSE DO_IT! ENDIF
   ENDIF
   RETURN TRUE

ENDPROC ;MEMO_VIEW_EDIT
;-----------------------------------------------------------------------------
WRITELIB vlib MEMO_VIEW_EDIT
RELEASE PROCS MEMO_VIEW_EDIT

;-----------------------------------------------------------------------------
;Procname    : INIT_VIEW_EDIT
;Description : Performs initial file & sysmode checking
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. August 1995
;Returns     : TRUE or FALSE
;-----------------------------------------------------------------------------
PROC INIT_VIEW_EDIT()

   IF NOT ISBLANK(FileToLoad) THEN
      IF NOT ISFILE(FileToLoad) THEN
         ERRBEEP() WINDOW SELECT msgwin WINCLOSE
         MESSAGE FileToLoad," Not Found! (press any key to continue)"
         RETVAL = GETCHAR() RETURN FALSE
      ENDIF
      memoflag = FALSE
   ELSE
      IF NOT SUBSTR(FIELDTYPE(),1,1) = "M" THEN
         ERRBEEP() WINDOW SELECT msgwin WINCLOSE
         MESSAGE FIELD()," field is NOT a Memo field!",
                 " (press any key to continue)"
         RETVAL = GETCHAR() RETURN FALSE
      ENDIF
      memoflag = TRUE
   ENDIF

   IF initmode <> "COEDIT" AND initmode <> "MAIN" THEN
      ERRBEEP() WINDOW SELECT msgwin WINCLOSE
      MESSAGE "Must be in Main or CoEdit mode! (press any key to continue)"
      RETVAL = GETCHAR() RETURN FALSE
   ENDIF

   IF NOT memoflag THEN
      FILEREAD FileToLoad TO memotext
      IF NOT ISTABLE(holdfile) THEN
         ERRBEEP() WINDOW SELECT msgwin WINCLOSE
         MESSAGE holdfile," Not Found! (press any key to continue)"
         RETVAL = GETCHAR() RETURN FALSE
      ENDIF
      IF initmode = "COEDIT" THEN
         MENU {TableAdd} SELECT holdfile
      ELSE
         COEDIT holdfile
      ENDIF
      WINDOW HANDLE IMAGE IMAGENO() TO holdmemo
      WINDOW MOVE holdmemo TO -50,-50
      MOVETO [TEXT]
      [] = memotext
   ELSE
      memotext = []
   ENDIF

   SWITCH

      CASE memoflag AND initmode = "MAIN" AND EditFlag:
         COEDITKEY
         IF NOT LOCKREC() THEN DO_IT! RETURN FALSE ENDIF RETURN TRUE

      CASE memoflag AND initmode = "COEDIT" AND NOT EditFlag:
         IMAGERIGHTS READONLY RETURN TRUE

      CASE NOT memoflag AND NOT EditFlag:
         IMAGERIGHTS READONLY RETURN TRUE

      OTHERWISE:
         RETURN TRUE

   ENDSWITCH


ENDPROC ;INIT_VIEW_EDIT
;-----------------------------------------------------------------------------
WRITELIB vlib INIT_VIEW_EDIT
RELEASE PROCS INIT_VIEW_EDIT

;-----------------------------------------------------------------------------
;Procname    : SHOWMEMOPULLDOWN
;Description : Creates a pulldown menu to replace the standard Pdox pulldown.
;              I've left the "File" & "Edit" code in (remmed out) so you can
;              implement those options easier (change Memo_Wait_Hndlr too).
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. August 1995
;Returns     : Nothing
;-----------------------------------------------------------------------------
PROC SHOWMEMOPULLDOWN()

   SHOWPULLDOWN
      CHR(240)         :" Set screen height, Help."             :""
      SUBMENU
         "Dis~p~lay"   :" Toggle Screen (24 TO 43 Line Mode)."  :"TOGGLESCR",
         "~H~elp   "   :" Read the Text Editor help screen."    :"HELPMEMOED"
      ENDSUBMENU,
;      "~F~ile"         :" Save, CopytoFile, or Print."          :""
;      SUBMENU
;         "~S~ave"      : " Save file and continue Editing."     :"MESAVE",
;         "~C~opytoFile": " Copy highlighted text to file."      :"MECTOF",
;         "~P~rint"     : " Send this file to the Printer."      :"MEPRINT"
;      ENDSUBMENU,
;      "~E~dit"         :" Cut, Copy, Paste, Etc."               :""
;      SUBMENU
;         "Cu~t~"       :" Cut highlighted text to Clipboard."   :"MEXCUT",
;         "~C~opy"      :" Copy highlighted text to Clipboard."  :"MECOPY",
;         "~P~aste"     :" Copy text from ClipBoard."            :"MEPASTE",
;         SEPARATOR,
;         "Showclip"    :" View the contents of the Clipboard."  :"MESHOWCLIP"
;      ENDSUBMENU,
      "~S~earch"       :" Search for a value or word."          :""
      SUBMENU
         "~F~ind"      :" Search for specified text."           :"MEFIND",
         "~N~ext"      :" Search for next specified text."      :"MENEXT"
      ENDSUBMENU,
      "~O~ptions"      :" Toggle AutoIndent, Wordwrap"          :""
      SUBMENU
         "~A~utoIndent":" Toggle Auto Indentation of lines."    :""
         SUBMENU
            "~S~et"    :" Set Auto Indentation of lines."       :"MEINDENTON",
            "~C~lear"  :" Clear Auto Indentation of lines."     :"MEINDENTOFF"
         ENDSUBMENU,
         "~W~ordWrap"  :" Toggle Auto WordWrap."                :""
         SUBMENU
            "~S~et"    :" Set Auto WordWrap at screen width."   :"MEWRAPON",
            "~C~lear"  :" Clear Auto WordWrap."                 :"MEWRAPOFF"
         ENDSUBMENU
      ENDSUBMENU,
      "~P~ost!"        :" Save File and return. "               :"MEDOIT",
      "~C~ancel"       :" Abort changes and return."            :"MECANCEL"
   ENDMENU

ENDPROC
;-----------------------------------------------------------------------------
WRITELIB vlib SHOWMEMOPULLDOWN
RELEASE PROCS SHOWMEMOPULLDOWN

;------------------------------------------------------------------------------
;Procname    : MEMO_WAIT_HNDLR
;Description : This proc handles the OPEN trigger and key & message events
;             from MEMO_VIEW_EDITs wait field.
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. August, 1995
;Returns     : 0, 1 or 2
;-----------------------------------------------------------------------------
PROC MEMO_WAIT_HNDLR(triggertype,eventinfo,cyclenum)

   SWITCH

      CASE triggertype = "OPEN"       : RETURN TRIGGERMEMO()

      CASE eventinfo["TYPE"]="KEY"    : RETURN KEYMEMO()

      CASE eventinfo["TYPE"]="MESSAGE": RETURN MESSAGEMEMO()

   ENDSWITCH

ENDPROC ;MEMO_WAIT_HNDLR
;-----------------------------------------------------------------------------
WRITELIB vlib MEMO_WAIT_HNDLR
RELEASE PROCS MEMO_WAIT_HNDLR

;------------------------------------------------------------------------------
;Procname    : TRIGGERMEMO
;Description : Handles the "OPEN" trigger (the only trigger trapped).
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. August, 1995
;Returns     : 0
;------------------------------------------------------------------------------
PROC TRIGGERMEMO()

   DYNARRAY memowin[]
   memowin["TITLE"]       = WinTitle
   memowin["MAXIMIZED"]   = TRUE
   memowin["CANCLOSE"]    = FALSE
   memowin["CANRESIZE"]   = FALSE
   memowin["CANMAXIMIZE"] = FALSE
   memowin["CANMOVE"]     = TRUE
   memowin["FLOATING"]    = TRUE
   memowin["HASFRAME"]    = TRUE
   memowin["CANVAS"]      = FALSE

   IF NOT EditFlag THEN
      MENUDISABLE "MEDOIT"
      SPEEDBAR "~Esc~ Cancel":27,"~F1~ Help":-59,
               "~Ctrl-Z~ Search":26 ;,"~F5~ Print":-63
   ELSE
      SPEEDBAR "~Esc~ Cancel":27,"~F1~ Help":-59,"~F2~ Post":-60,
               "~Ctrl-Z~ Search":26 ;,"~F5~ Print":-63
   ENDIF

   WINDOW SELECT msgwin WINCLOSE FIELDVIEW
   WINDOW HANDLE CURRENT TO memohndl
   WINDOW SETATTRIBUTES memohndl FROM memowin RETURN 0

ENDPROC ;TRIGGERMEMO
;-----------------------------------------------------------------------------
WRITELIB vlib TRIGGERMEMO
RELEASE PROCS TRIGGERMEMO

;------------------------------------------------------------------------------
;Procname    : KEYMEMO
;Description : Handles a KEY event.
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. August 1995
;Returns     : 1 or 2
;------------------------------------------------------------------------------
PROC KEYMEMO()

   SWITCH

      CASE eventinfo["KEYCODE"] =  27:
         RETURN ESCAPEMEMO()

      CASE eventinfo["KEYCODE"] = -60:
         RETURN POSTMEMO()

      CASE eventinfo["KEYCODE"] = -59:
         MEMO_HELP() RETURN 1

      CASE eventinfo["KEYCODE"] =  26:
         EZZOOM4() RETURN 1

      OTHERWISE:
         RETURN 1

   ENDSWITCH

ENDPROC ;KEYMEMO
;-----------------------------------------------------------------------------
WRITELIB vlib KEYMEMO
RELEASE PROCS KEYMEMO

;------------------------------------------------------------------------------
;Procname    : MESSAGEMEMO
;Description : Handles a MESSAGE event.
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. August 1995
;Returns     : 1 or 2
;------------------------------------------------------------------------------
PROC MESSAGEMEMO()

   SWITCH

      CASE eventinfo["MENUTAG"]="MEFIND":
         EZZOOM4() RETURN 1

      CASE eventinfo["MENUTAG"]="MENEXT":
         ZOOMNEXT RETURN 1

      CASE eventinfo["MENUTAG"]="MEINDENTON":
         Menu {Options} {AutoIndent} {Set}
         MESSAGE "Automatic Indention of new lines is on." RETURN 1

      CASE eventinfo["MENUTAG"]="MEINDENTOFF":
         Menu {Options} {AutoIndent} {Clear}
         MESSAGE "Automatic Indention of new lines is off." RETURN 1

      CASE eventinfo["MENUTAG"]="MEWRAPON":
         Menu {Options} {WordWrap} {Set}
         MESSAGE "Automatic WordWrap at screen width is on." RETURN 1

      CASE eventinfo["MENUTAG"]="MEWRAPOFF":
         Menu {Options} {WordWrap} {Clear}
         MESSAGE "Automatic WordWrap at screen width is off." RETURN 1

      CASE eventinfo["MENUTAG"]="MEDOIT":
         RETURN POSTMEMO()

      CASE eventinfo["MENUTAG"]="MECANCEL":
         RETURN ESCAPEMEMO()

      CASE eventinfo["MENUTAG"]="TOGGLESCR":
         TOGGLESCR() WINDOW SETATTRIBUTES memohndl FROM memowin RETURN 0

      CASE eventinfo["MENUTAG"]="HELPMEMOED":
         MEMO_HELP() RETURN 1

   ENDSWITCH

ENDPROC ;MESSAGEMEMO
;-----------------------------------------------------------------------------
WRITELIB vlib MESSAGEMEMO
RELEASE PROCS MESSAGEMEMO

;------------------------------------------------------------------------------
;Procname    : ESCAPEMEMO
;Description : Handles an ESC KEY event or Cancel message event.
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. August 1995
;Returns     : 1 or 2
;------------------------------------------------------------------------------
PROC ESCAPEMEMO()

   PRIVATE edinfo

   IF EditFlag THEN
      MESSAGE "One moment..." ECHO OFF
      EDITOR INFO TO edinfo
      CTRLPGUP SHIFTPRESS "CTRLPGDN"
      EDITOR EXTRACT TO newtext
      IF memotext<>newtext THEN
         ERRBEEP() MESSAGE ""
         IF YES_NO4(" Cancel Edit ","//Abort Changes?") THEN
            MENU {Cancel} {Yes}
         ELSE
            EDITOR GOTO POSITION edinfo["CHARPOS"] ECHO NORMAL RETURN 1
         ENDIF
      ENDIF
   ENDIF
   DO_IT! MESSAGE "" IF NOT memoflag THEN DO_IT! CLEARIMAGE ENDIF RETURN 2

ENDPROC ;ESCAPEMEMO
;-----------------------------------------------------------------------------
WRITELIB vlib ESCAPEMEMO
RELEASE PROCS ESCAPEMEMO

;------------------------------------------------------------------------------
;Procname    : POSTMEMO
;Description : Handles an F2 KEY event or Post message event.
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. August 1995
;Returns     : 1 or 2
;------------------------------------------------------------------------------
PROC POSTMEMO()

   DO_IT!
   IF NOT memoflag THEN
      memotext = [] FILEWRITE FileToLoad FROM memotext
      DO_IT! CLEARIMAGE
   ENDIF
   RETURN 2

ENDPROC ;POSTMEMO
;-----------------------------------------------------------------------------
WRITELIB vlib POSTMEMO
RELEASE PROCS POSTMEMO

;-----------------------------------------------------------------------------
;Procname    : MEMO_HELP
;Description : MEMO_VIEW_EDIT Help Screen
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. August 1995
;Returns     : Nothing
;-----------------------------------------------------------------------------
PROC MEMO_HELP()

   PRIVATE HelpWinAtts, HelpWin

   DYNARRAY HelpWinAtts[]
   HelpWinAtts["STYLE"] = SYSCOLOR(13)
   HelpWinAtts["CANCLOSE"] = False
   HelpWinAtts["MAXIMIZED"] = True
   HelpWinAtts["CANMAXIMIZE"] = false
   HelpWinAtts["CANRESIZE"] = false
   HelpWinAtts["TITLE"] = "Help Screen for Searching"

   WINDOW CREATE FLOATING @0,0 ATTRIBUTES HelpWinAtts TO HelpWin

   TEXT
                  ** Press Any Key (Or Click Mouse) To Return **

    This is the Memo View/Edit help screen - tailor it to your needs

   

   

   

   

   

   

   

   




   ENDTEXT
   PAINTCANVAS ATTRIBUTE SYSCOLOR(13)+128 00,10,01,77
   SLEEP 2000
   PAINTCANVAS ATTRIBUTE SYSCOLOR(13) 00,10,00,77
   WHILE TRUE
      GETEVENT KEY "ALL" MOUSE "DOWN" TO Retval
      IF retval["TYPE"]="MOUSE" THEN
         LOCALIZEEVENT retval
         IF retval["ONFRAME"] THEN EXECEVENT retval LOOP ENDIF
      ENDIF
      QUITLOOP
   ENDWHILE
   WINDOW SELECT HelpWin WINDOW CLOSE

ENDPROC  ;MEMO_HELP
;-----------------------------------------------------------------------------
WRITELIB vlib MEMO_HELP
RELEASE PROCS MEMO_HELP

;-----------------------------------------------------------------------------
;Procname    : YES_NO4
;Description : This proc creates a generic dialog box with customizable
;              title and message. The message string may be up to 255 chars &
;              can be split by including "//". Message text is centered within
;              the dlg box and the box itself is centered on-screen (25x80).
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. Dec 1992
;              (inspired by Mr. Tony Goodman - Ensemble Corporation)
;
;Returns     : TRUE or FALSE
;-----------------------------------------------------------------------------
PROC YES_NO4(v_title,v_message)

   PRIVATE v_row, v_col,v_width, v_height,v_y_button_col, v_n_button_col,
           v_button_row,v_msg_col,v_line_count,v_maxlen,v_msg,v_msg_save,
           v_choice,v_minlen

   DYNARRAY msg_array[]
   v_msg_save = v_message
   v_msg_col = 1
   v_line_count = 0
   v_maxlen = 0
   v_minlen = 16

   IF LEN(v_title) > 74 THEN ; ShowDialog will be 6 chars wider than title
      v_title = SUBSTR(v_title,1,74)
   ENDIF

   IF NOT ISBLANK(v_message) THEN
      WHILE MATCH(v_message,"..//..",v_msg,v_message)
            v_maxlen = MAX(v_maxlen,LEN(v_msg))
            v_line_count = v_line_count + 1
            msg_array[v_line_count] = v_msg
      ENDWHILE
      v_line_count = v_line_count + 1
      msg_array[v_line_count] = v_message
   ENDIF

   v_maxlen = MAX(v_maxlen,LEN(v_message))
   v_maxlen = MAX(v_maxlen,LEN(v_title)+6)
   v_maxlen = MAX(v_maxlen,v_minlen)
   v_minlen = MIN(v_maxlen,v_minlen)

   v_message = ""

   IF NOT ISBLANK(v_msg_save) THEN
      FOR v_index FROM 1 TO v_line_count
         IF LEN(msg_array[v_index]) < v_maxlen THEN
            IF MOD((v_maxlen - LEN(msg_array[v_index])),2) = 0 THEN
               v_message = v_message + SPACES( (v_maxlen-LEN(msg_array[v_index]))/2 )+
                           msg_array[v_index]+
                           SPACES( (v_maxlen-LEN(msg_array[v_index]))/2 )
            ELSE
               v_message = v_message + SPACES( INT((v_maxlen-LEN(msg_array[v_index]))/2) )+
                           msg_array[v_index]+
                           SPACES( INT((v_maxlen-LEN(msg_array[v_index]))/2) +1 )
            ENDIF
         ELSE
            IF LEN(msg_array[v_index]) < v_minlen THEN
               IF MOD(v_minlen-LEN(msg_array[v_index]),2) = 0 THEN
                  v_message = SPACES(INT(v_minlen-LEN(msg_array[v_index]))/2)+
                              msg_array[v_index]+
                              SPACES(INT(v_minlen-LEN(msg_array[v_index]))/2)
               ELSE
                  v_message = SPACES(INT((v_minlen-LEN(msg_array[v_index]))/2))+
                              msg_array[v_index]+
                              SPACES(INT((v_minlen-LEN(msg_array[v_index]))/2)+1)
               ENDIF
            ELSE
               v_message = v_message + msg_array[v_index]
            ENDIF
         ENDIF
      ENDFOR
   ENDIF

   IF v_maxlen >= v_minlen THEN
      v_width = MIN(v_maxlen + 4,80)
      v_height = 5 + v_line_count

      v_row = 11 - INT(v_height/2)
      v_col = MAX(0,40 - INT((v_maxlen + 4) /2))

      v_y_button_col = INT(v_width/2)-10
      v_n_button_col = INT(v_width/2)+2
      v_button_row = 1 + v_line_count
   ELSE
      IF ISBLANK(v_msg_save) THEN
         v_width = 20
         v_height = 4

         v_row = 9
         v_col = 30

         v_y_button_col = INT(v_width/2)-10
         v_n_button_col = INT(v_width/2)+1
         v_button_row = 0
      ELSE
         v_width = 20
         v_height = 5 + v_line_count

         v_row = 11 - INT(v_height/2)
         v_col = 30

         v_y_button_col = INT(v_width/2)-10
         v_n_button_col = INT(v_width/2)+1
         v_button_row = 1 + v_line_count
      ENDIF
   ENDIF

   IF v_line_count > 0 THEN
      v_line_count = v_line_count - 1
   ENDIF

   SHOWDIALOG v_title

      PROC "TWO_BTN_DLG" KEY "Down", "Left", "Right", "Up"

      @v_row,v_col HEIGHT v_height WIDTH v_width

      PAINTCANVAS FILL v_message
      ATTRIBUTE SYSCOLOR(1036) 0,v_msg_col,0+v_line_count,v_width-4

      PUSHBUTTON @v_button_row,v_y_button_col WIDTH 7
         "~Y~es"
         OK
         VALUE (TRUE)
         TAG "1"
      TO v_choice

      PUSHBUTTON @v_button_row,v_n_button_col WIDTH 6
         "~N~o "
         CANCEL
         VALUE (FALSE)
         TAG "0"
      TO v_choice

   ENDDIALOG

   RETURN RETVAL

ENDPROC ;YES_NO4
;-----------------------------------------------------------------------------
WRITELIB vlib YES_NO4
RELEASE PROCS YES_NO4

;-----------------------------------------------------------------------------
;Procname    : TWO_BTN_DLG
;Description : This Dialog Proc handles the interactions with ContinueCancel4,
;              YesNo4 and YesNo24. It simply changes the button focus.
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. Dec 1992
;
;Returns     : TRUE
;-----------------------------------------------------------------------------
PROC TWO_BTN_DLG(triggertype, tagvalue, eventvalue, elementvalue)

   SELECTCONTROL IIF(tagvalue="1","0","1") RETURN TRUE

ENDPROC  ;TWO_BTN_DLG
;-----------------------------------------------------------------------------
WRITELIB vlib TWO_BTN_DLG
RELEASE PROCS TWO_BTN_DLG

;-----------------------------------------------------------------------------
;Procname    : EZZOOM4
;Description : This proc creates a 3-button dialog box to replace the ZOOM box
;              (from interactive Pdox). It's main advantage is the built-in
;              help screen & precluding possible errors with the interactive
;              Zoom. Could use some re-work in situations where current field
;              is a Date field and to allow a "goto record #" feature.
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. Dec 1992
;              (inspired by Mr. Tony Goodman - Ensemble Corporation)
;
;Returns     : TRUE or FALSE
;-----------------------------------------------------------------------------
PROC EZZOOM4()

   PRIVATE vtype,vrec,vmemo,was_here,now_here,vdate,vpict,asysinfo.y,
           vrow,vcol

   vtype = FIELDTYPE()
   vrec  = RECNO()
   vmemo = FALSE
   vdate = FALSE
   vpict = "*@"

   SYSINFO TO asysinfo.y

   vrow=INT((asysinfo.y["SCREENHEIGHT"]-12)/2)
   vcol=INT((asysinfo.y["SCREENWIDTH"]-42)/2)

   IF ISFIELDVIEW() AND NOT MATCH(vtype,"M..") THEN
      DO_IT!
   ENDIF

   IF FIELD()="#" THEN
     BEEP
     OK4("Unable To Comply","//Sorry - You Cannot Search In//"+
         "The Record Number Field.//Please Move To A Differnt Field.")
     RETURN FALSE
   ENDIF

   IF SEARCH("*",vType) > 0 THEN
      vType = SUBSTR(vType,1,LEN(vType)-1)
   ENDIF

   IF MATCH(vtype,"M..") AND ISFIELDVIEW() THEN
      vmemo=TRUE
      EDITOR INFO TO was_here
      vtype="A50"
   ENDIF

   IF MATCH(vtype,"M..") AND NOT ISFIELDVIEW() THEN
      vtype="A50"
   ENDIF

   IF vtype="D" THEN
      vtype="A10"
      vdate=TRUE
      vpict="[[.][.]][*;@][#][#][/][#][#][/][#][#][[.][.]]"
   ENDIF

   IF vtype="$" OR vtype="N" THEN
      vtype="A20"
      vpict="[..][-][*;@]*#[.##][..]"
   ENDIF

   IF NOT ISASSIGNED(vwb) THEN
      vwb = (INT(SYSCOLOR(1036)/16)*16)+15 ;white on current background
      vbb = (INT(SYSCOLOR(1036)/16)*16)    ;black on current background
   ENDIF

   SHOWDIALOG "Search "+FIELD()+" Field"

      PROC "ZOOMHANDLER" KEY -59 TRIGGER "ACCEPT"

      @ vrow,vcol HEIGHT 12 WIDTH 42

      @ 01,03  ?? "Enter value to search for: "
      @ 02,03  ?? "Exact match or pattern (value + ..)"

      FRAME SINGLE FROM 03,02 TO 05,37
      PAINTCANVAS ATTRIBUTE vwb 03,02,05,02
      PAINTCANVAS ATTRIBUTE vwb 03,03,03,36
      PAINTCANVAS ATTRIBUTE vbb 05,04,05,37
      PAINTCANVAS ATTRIBUTE vbb 03,37,04,37

      ACCEPT @ 04,12 WIDTH 24
         vType
         PICTURE vpict
         TAG "SEEK"
      TO vSeek

      LABEL @ 04,03
         "Value :"
         FOR "SEEK"

      PUSHBUTTON @ 07,03 WIDTH 10
         "~O~k"
         OK
         DEFAULT
         VALUE "Ok"
         TAG "OK"
      TO vSelect

      PUSHBUTTON @ 07,15 WIDTH 10
         "~H~elp"
         OK
         VALUE "Help"
         TAG "HELP"
      TO vSelect

      PUSHBUTTON @ 07,27 WIDTH 10
         "~C~ancel"
         CANCEL
         VALUE "Cancel"
         TAG "CANCEL"
      TO vSelect

   ENDDIALOG

   IF NOT RETVAL THEN RETURN FALSE ENDIF

   IF vmemo AND vseek="" THEN vseek=" " ENDIF

   IF vdate AND vseek ="" THEN vseek=BLANKDATE() ENDIF

   ZOOM CTRLBACKSPACE TYPEIN vseek ENTER

   IF vmemo THEN
      EDITOR INFO TO now_here
      IF was_here["CHARPOS"]<>now_here["CHARPOS"] THEN
         RETURN TRUE
      ELSE
         RETURN FALSE
      ENDIF
   ENDIF

   IF RECNO()<>vrec OR MATCH([],vseek) THEN
      RETURN TRUE
   ELSE
      BEEP RETURN FALSE
   ENDIF

ENDPROC  ;EZZOOM4
;-----------------------------------------------------------------------------
WRITELIB vlib EZZOOM4
RELEASE PROCS EZZOOM4

;-----------------------------------------------------------------------------
;Procname    : ZOOMHANDLER
;Description : EZZOOM4 Dialog Proc.
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. Dec 1992
;
;Returns     : TRUE or FALSE
;-----------------------------------------------------------------------------
PROC ZOOMHANDLER(vtrigger,vtag,vevent,caca)

   SWITCH

      CASE vtrigger="ACCEPT":
         IF vtag="HELP" THEN
            EZZOOMHELP() SELECTCONTROL "SEEK" RETURN FALSE
         ENDIF
         RETURN TRUE

      CASE vevent["TYPE"]="KEY":
         EZZOOMHELP() SELECTCONTROL "SEEK" RETURN FALSE

   ENDSWITCH

ENDPROC  ;ZOOMHANDLER
;-----------------------------------------------------------------------------
WRITELIB vlib ZOOMHANDLER
RELEASE PROCS ZOOMHANDLER

;-----------------------------------------------------------------------------
;Procname    : EZZOOMHELP
;Description : EZZOOM4 Help Screen
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. Dec 1992
;
;Returns     : Nothing
;-----------------------------------------------------------------------------
PROC EZZOOMHELP()

   PRIVATE HelpWinAtts, HelpWin

   DYNARRAY HelpWinAtts[]
   HelpWinAtts["STYLE"] = SYSCOLOR(13)
   HelpWinAtts["CANCLOSE"] = False
   HelpWinAtts["MAXIMIZED"] = True
   HelpWinAtts["CANMAXIMIZE"] = false
   HelpWinAtts["CANRESIZE"] = false
   HelpWinAtts["TITLE"] = "Help Screen for Searching"

   WINDOW CREATE FLOATING @0,0 ATTRIBUTES HelpWinAtts TO HelpWin

   TEXT
                  ** Press Any Key (Or Click Mouse) To Return **

    This utility allows you to search for a value within the current field.

    You may search for an exact match by typing in the exact criteria you
     wish to search for and press the "Ok" button (Enter).  This type of a
     search IS case sensitive and will only find EXACT matches.

     For example: "SMITH" will find "SMITH" but NOT "Smith".

    You may search for a partial match by including the wildcard characters
     ".." anywhere in your search criteria.  You may enter ".." wildcards at
     the start, end or both start and end of the search criteria.  This type
     of search is NOT case sensitive.

     For example: "SMI.." will find values starting with "SMI" (even "Smith")
     and "..corp.." will find values that have "corp" anywhere within them.

    You may also use the "@" symbol as a placeholder for a single character.
     The "@" may be used alone or in combination with the ".." wildcards.

     For example: "@@@i.." will find values whose fourth character is an "i".

   ENDTEXT
   PAINTCANVAS ATTRIBUTE SYSCOLOR(13)+128 00,10,01,77
   SLEEP 2000
   PAINTCANVAS ATTRIBUTE SYSCOLOR(13) 00,10,00,77
   WHILE TRUE
      GETEVENT KEY "ALL" MOUSE "DOWN" TO Retval
      IF retval["TYPE"]="MOUSE" THEN
         LOCALIZEEVENT retval
         IF retval["ONFRAME"] THEN EXECEVENT retval LOOP ENDIF
      ENDIF
      QUITLOOP
   ENDWHILE
   WINDOW SELECT HelpWin WINDOW CLOSE

ENDPROC  ;EZZOOMHELP
;-----------------------------------------------------------------------------
WRITELIB vlib EZZOOMHELP
RELEASE PROCS EZZOOMHELP

;-----------------------------------------------------------------------------
;Procname    : OK4
;Description : This proc creates a 1-button dialog box and is meant to stop
;              program execution & display a message to the user. The message
;              will be centered in the dialog box and can be split by adding
;              "//"(s) in the message string.
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. Dec 1992
;              (inspired by Mr. Tony Goodman - Ensemble Corporation)
;
;Returns     : TRUE or FALSE
;----------------------------------------------------------------------------
PROC OK4(v_title,v_message)

   PRIVATE v_row, v_col,
           v_width, v_height,
           v_button_col,
           v_button_row,
           v_msg_col,
           v_line_count,
           v_maxlen,
           v_msg,
           v_msg_save,
           v_choice,
           v_minlen

   DYNARRAY msg_array[]
   v_msg_save = v_message
   v_msg_col = 1
   v_line_count = 0
   v_maxlen = 0
   v_minlen = 16

   IF LEN(v_title) > 74 THEN ; ShowDialog window will be 6 chars wider than title
      v_title = SUBSTR(v_title,1,74)
   ENDIF

   IF NOT ISBLANK(v_message) THEN
      WHILE MATCH(v_message,"..//..",v_msg,v_message)
            v_maxlen = MAX(v_maxlen,LEN(v_msg))
            v_line_count = v_line_count + 1
            msg_array[v_line_count] = v_msg
      ENDWHILE
      v_line_count = v_line_count + 1
      msg_array[v_line_count] = v_message
   ENDIF

   v_maxlen = MAX(v_maxlen,LEN(v_message))
   v_maxlen = MAX(v_maxlen,LEN(v_title)+6)
   v_maxlen = MAX(v_maxlen,v_minlen)
   v_minlen = MIN(v_maxlen,v_minlen)

   v_message = ""

   IF NOT ISBLANK(v_msg_save) THEN
      FOR v_index FROM 1 TO v_line_count
         IF LEN(msg_array[v_index]) < v_maxlen THEN
            IF MOD((v_maxlen - LEN(msg_array[v_index])),2) = 0 THEN
               v_message = v_message + SPACES( (v_maxlen-LEN(msg_array[v_index]))/2 )+
                           msg_array[v_index]+
                           SPACES( (v_maxlen-LEN(msg_array[v_index]))/2 )
            ELSE
               v_message = v_message + SPACES( INT((v_maxlen-LEN(msg_array[v_index]))/2) )+
                           msg_array[v_index]+
                           SPACES( INT((v_maxlen-LEN(msg_array[v_index]))/2) +1 )
            ENDIF
         ELSE
            IF LEN(msg_array[v_index]) < v_minlen THEN
               IF MOD(v_minlen-LEN(msg_array[v_index]),2) = 0 THEN
                  v_message = SPACES(INT(v_minlen-LEN(msg_array[v_index]))/2)+
                              msg_array[v_index]+
                              SPACES(INT(v_minlen-LEN(msg_array[v_index]))/2)
               ELSE
                  v_message = SPACES(INT((v_minlen-LEN(msg_array[v_index]))/2))+
                              msg_array[v_index]+
                              SPACES(INT((v_minlen-LEN(msg_array[v_index]))/2)+1)
               ENDIF
            ELSE
               v_message = v_message + msg_array[v_index]
            ENDIF
         ENDIF
      ENDFOR
   ENDIF

   IF v_maxlen >= v_minlen THEN
      v_width = MIN(v_maxlen + 4,80)
      v_height = 5 + v_line_count

      v_row = 11 - INT(v_height/2)
      v_col = MAX(0,40 - INT((v_maxlen + 4) /2))

      v_button_col = INT(v_width/2)-5
      v_button_row = 1 + v_line_count
   ELSE
      IF ISBLANK(v_msg_save) THEN
         v_row = 9
         v_col = 30

         v_width = 20
         v_height = 4

         v_button_col = INT(v_width/2)-5
         v_button_row = 0
      ELSE
         v_width = 20
         v_height = 5 + v_line_count

         v_row = 11 - INT(v_height/2)
         v_col = 30

         v_button_col = INT(v_width/2)-5
         v_button_row = 1 + v_line_count
      ENDIF
   ENDIF

   IF v_line_count > 0 THEN
      v_line_count = v_line_count - 1
   ENDIF

   SHOWDIALOG v_title
      @v_row,v_col HEIGHT v_height WIDTH v_width

      PAINTCANVAS FILL v_message ATTRIBUTE SYSCOLOR(1036) 0,v_msg_col,0+v_line_count,v_width-4

      PUSHBUTTON @v_button_row,v_button_col WIDTH 6
         "~O~k"
         OK
         VALUE (TRUE)
         TAG ""
      TO v_choice

   ENDDIALOG

   RETURN(v_choice)

ENDPROC
;-----------------------------------------------------------------------------
WRITELIB vlib OK4
RELEASE PROCS OK4

;-----------------------------------------------------------------------------
;Procname    : GUI_MSG4
;Description : This proc creates a generic canvas window with customizable
;              title and message. The message string may be up to 255 chars &
;              can be split by including "/". Message text is centered within
;              the window. If the message string has "..." at the end, the
;              dots will flash.
;
;Written By  : Scott W. Parker - DataMasters of Georgia, Inc. Dec 1992
;              (inspired by Mr. Tony Goodman - Ensemble Corporation)
;
;Returns     : Window Handle (msgwin)
;-----------------------------------------------------------------------------
PROC GUI_MSG4(v_title,v_message)

   private m, l, n, v_msg, y, x, w, dmy, s, winclrs

   m = v_message
   l = 0
   n = 1

   WHILE MATCH(m,"../..",v_msg,m)
      l=MAX(l,LEN(v_msg))
      n=n+1
   ENDWHILE
   l=MAX(l,LEN(m))
   l=MIN(l,72)

   y=12-INT(n/2)
   x=39-INT(l/2)
   w="W"+STRVAL(l)+",AC"

   DYNARRAY winatts[]
   winatts["HASFRAME"] = FALSE
   winatts["ECHO"] = TRUE
   winatts["ORIGINROW"] = y-2
   winatts["ORIGINCOL"] = x-2
   winatts["WIDTH"]     = l+4
   winatts["HEIGHT"]    = n+4

   WINDOW CREATE FLOATING ATTRIBUTES winatts TO msgwin

   FRAME DOUBLE FROM 0,0 TO n+3,l+3
   @ 0,MAX(1,(INT(l/2)+2) - (INT(LEN(v_title)/2))) ?? v_title
   PAINTCANVAS ATTRIBUTE SYSCOLOR(1008) 0,0,n+3,l+3

   y=1
   x=2

   m="/"+v_message
   WHILE MATCH(m,"../..",v_msg,m)
      @ y,x ?? FORMAT(w,v_msg)
      y=y+1
   ENDWHILE
   dmy=FORMAT(w,m)
   @ y,x ?? dmy
   s=SEARCH("...",dmy)
   IF s>0 THEN
      @ y,x+s-1 ?? "..."
      PAINTCANVAS ATTRIBUTE SYSCOLOR(8)+128 y,x+s-1,y,x+s+1
   ENDIF

   RETURN msgwin

ENDPROC
;-----------------------------------------------------------------------------
WRITELIB vlib GUI_MSG4
RELEASE PROCS GUI_MSG4

;------------------------- ERRBEEP() A bad thing happened --------------------
PROC ERRBEEP()
   SOUND 100 100 SOUND 50 70
ENDPROC
;-----------------------------------------------------------------------------
WRITELIB vlib ERRBEEP
RELEASE PROCS ERRBEEP

;-----------------------------------------------------------------------------
PROC LOCKREC()

   MESSAGE "Attempting to obtain record lock..."

   WHILE TRUE

      LOCKRECORD IF RETVAL THEN QUITLOOP ENDIF
      ERRBEEP() MESSAGE ERRORMESSAGE()
      IF NOT YES_NO4("Lock Failure","//Do you wish to try again?") THEN
         MESSAGE "" RETURN FALSE
      ENDIF

   ENDWHILE

   MESSAGE "" RETURN TRUE

ENDPROC
;-----------------------------------------------------------------------------
WRITELIB vlib LOCKREC
RELEASE PROCS LOCKREC

;-----------------------------------------------------------------------------
PROC REVERSECOLOR( ColorCode )
   private backcolor,
           forecolor

   forecolor = MOD( ColorCode, 16 )

   backcolor = INT(ColorCode/16)

   IF forecolor > 8 THEN
      forecolor = forecolor - 8
   ENDIF

   RETURN (forecolor * 16) + backcolor

ENDPROC
;-----------------------------------------------------------------------------
WRITELIB vlib REVERSECOLOR
RELEASE PROCS REVERSECOLOR

;-----------------------------------------------------------------------------
PROC TOGGLESCR()

   PRIVATE asysinfo

   SYSINFO TO asysinfo

   ECHO OFF SETCANVAS DEFAULT CANVAS OFF
   IF aSysInfo["ScreenHeight"]<30 THEN
      Menu {} {Video} {D: EGA/VGA: 80x43/50}
   ELSE
      Menu {} {Video} {C: EGA/VGA: 80x25}
   ENDIF
   CANVAS ON ECHO NORMAL

ENDPROC
;-----------------------------------------------------------------------------
WRITELIB vlib TOGGLESCR
RELEASE PROCS TOGGLESCR

;----------------------------------------------------------------------------
PROC CONTINUECANCEL4(v_message)

   PRIVATE v_row, v_col,
           v_width, v_height,
           v_y_button_col, v_n_button_col,
           v_button_row,
           v_msg_col,
           v_line_count,
           v_maxlen,
           v_msg,
           v_msg_save,
           v_choice,
           v_minlen

   DYNARRAY msg_array[]
   v_msg_save = v_message
   v_msg_col = 1
   v_line_count = 0
   v_maxlen = 0
   v_minlen = 28

   IF NOT ISBLANK(v_message) THEN
      WHILE MATCH(v_message,"..\\..",v_msg,v_message)
            v_maxlen = MAX(v_maxlen,LEN(v_msg))
            v_line_count = v_line_count + 1
            msg_array[v_line_count] = v_msg
      ENDWHILE
      v_line_count = v_line_count + 1
      msg_array[v_line_count] = v_message
   ENDIF

   v_maxlen = MAX(v_maxlen,LEN(v_message))
   v_maxlen = MAX(v_maxlen,v_minlen)
   v_minlen = MIN(v_maxlen,v_minlen)

   v_message = ""

   IF NOT ISBLANK(v_msg_save) THEN
      FOR v_index FROM 1 TO v_line_count
         IF LEN(msg_array[v_index]) < v_maxlen THEN
            IF MOD((v_maxlen - LEN(msg_array[v_index])),2) = 0 THEN
               v_message = v_message + SPACES( (v_maxlen-LEN(msg_array[v_index]))/2 )+
                           msg_array[v_index]+
                           SPACES( (v_maxlen-LEN(msg_array[v_index]))/2 )
            ELSE
               v_message = v_message + SPACES( INT((v_maxlen-LEN(msg_array[v_index]))/2) )+
                           msg_array[v_index]+
                           SPACES( INT((v_maxlen-LEN(msg_array[v_index]))/2) +1 )
            ENDIF
         ELSE
            IF LEN(msg_array[v_index]) < v_minlen THEN
               IF MOD(v_minlen-LEN(msg_array[v_index]),2) = 0 THEN
                  v_message = SPACES(INT(v_minlen-LEN(msg_array[v_index]))/2)+
                              msg_array[v_index]+
                              SPACES(INT(v_minlen-LEN(msg_array[v_index]))/2)
               ELSE
                  v_message = SPACES(INT((v_minlen-LEN(msg_array[v_index]))/2))+
                              msg_array[v_index]+
                              SPACES(INT((v_minlen-LEN(msg_array[v_index]))/2)+1)
               ENDIF
            ELSE
               v_message = v_message + msg_array[v_index]
            ENDIF
         ENDIF
      ENDFOR
   ENDIF

   IF v_maxlen >= v_minlen THEN
      v_width = MIN(v_maxlen + 4,80)
      v_height = 5 + v_line_count

      v_row = 11 - INT(v_height/2)
      v_col = MAX(0,40 - INT((v_maxlen + 4) /2))

      v_y_button_col = INT(v_width/2)-15
      v_n_button_col = INT(v_width/2)+1
      v_button_row = 1 + v_line_count
   ELSE
      IF ISBLANK(v_msg_save) THEN
         v_width = 28+4
         v_height = 4

         v_row = 9
         v_col = 30

         v_y_button_col = INT(v_width/2)-15
         v_n_button_col = INT(v_width/2)+1
         v_button_row = 0
      ELSE
         v_width = 28+4
         v_height = 5 + v_line_count

         v_row = 11 - INT(v_height/2)
         v_col = 30

         v_y_button_col = INT(v_width/2)-15
         v_n_button_col = INT(v_width/2)+1
         v_button_row = 1 + v_line_count
      ENDIF
   ENDIF

   IF v_line_count > 0 THEN
      v_line_count = v_line_count - 1
   ENDIF

   v_center_row = INT(v_height/2)-2
   v_center_col = INT(v_width/2)-1


   SHOWDIALOG ""
      PROC "TWO_BTN_DLG"
         KEY "Down", "Left", "Right", "Up"

      @v_row,v_col HEIGHT v_height WIDTH v_width


      PAINTCANVAS FILL v_message ATTRIBUTE SYSCOLOR(1036) 0,v_msg_col,0+v_line_count,v_width-4

      PUSHBUTTON @v_button_row,v_y_button_col WIDTH 12
         "C~o~ntinue"
         OK
         VALUE (TRUE)
         TAG "1"
      TO v_choice

      PUSHBUTTON @v_button_row,v_n_button_col WIDTH 12
         "C~a~ncel"
         CANCEL
         VALUE (FALSE)
         TAG "0"
      TO v_choice

   ENDDIALOG

   IF RETVAL THEN
      RETURN(v_choice)
   ELSE
      RETURN(FALSE)
   ENDIF

ENDPROC
;----------------------------------------------------------------------------
WRITELIB vlib CONTINUECANCEL4
RELEASE PROCS CONTINUECANCEL4

;-----------------------------------------------------------------------------
PROC MEMOERRORHANDLER()

   PRIVATE ERRORPROC,errbag

   ERRORPROC=""
   ERRORINFO TO errbag

   SWITCH


      CASE errbag["CODE"]=43:    ;PRINTER NOT READY
         ERRBEEP()
         MESSAGE " Choose \"Continue\" to retry Printing or ",
                 "\"Cancel\" to abort and exit."
         IF CONTINUECANCEL4("\\The Printer Is Either Off-line,\\"+
                            "Out Of Paper, or Turned Off!") THEN
            MESSAGE "Sending Report To Printer..."
            RETURN 0
         ELSE
            MESSAGE "Returning to operating system..."
            RESET
            RETURN 2
         ENDIF

      CASE errbag["CODE"]=44:    ;LOW MEMORY WARNING
         ERRBEEP()
         MESSAGE " A Low Memory Warning is in effect. If you are running ",
                 "from inside Windows, try closing any other open applications ",
                 "(press [Alt]-[Tab] then close app) and then press the ",CHR(34),
                 "Continue",CHR(34)," button."
         IF CONTINUECANCEL4("\\Low Memory Warning!\\Choose "+CHR(34)+"Continue"+
                            CHR(34)+" To Try Again Or\\"+CHR(34)+"Cancel"+CHR(34)+
                            " To Abort And Exit.") THEN
            MESSAGE "Retrying Operation..."
            RETURN 0
         ENDIF

   ENDSWITCH
   ERRBEEP() ERRBEEP()
   MESSAGE "An error file will be written to record this error - Press ",CHR(34),
           "Ok",CHR(34)," to close all files and return to operating system."

   OK4("System Error","\\A System Error Has Occurred Which Will\\"+
      "Necessitate Returning You To The Operating System.")
   MESSAGE "Writing error file..."
   PRINT FILE "ERROR.TXT" "\n\n",
   "Date          : ",TODAY(),"    Time: ",TIME(),"\n\n",
   "Current User  : ",USERNAME(),"\n\n",
   "Current Mode  : ",SYSMODE(),"\n\n",
   "Current Table : ",IIF(NIMAGES()>0,TABLE(),"N/A"),"\n\n",
   "Number Images : ",NIMAGES(),"\n\n",
   "Error User    : ",errbag["USER"],"\n\n",
   "Error Code    : ",errbag["CODE"],"\n\n",
   "Error Message : ",errbag["MESSAGE"],"\n\n",
   "Script Name   : ",errbag["SCRIPT"],"\n\n",
   "Procedure Name: ",errbag["PROC"],"\n\n",
   "Line Number   : ",errbag["LINE"],"\n\n",
   "Position #    : ",errbag["POSITION"],"\n\n"
   IF NIMAGES()>0 AND IMAGETYPE()="Display" AND NRECORDS(TABLE())>0 THEN
      PRINT FILE "ERROR.TXT"
      "Record #      : ",RECNO(),"\n\n",
      "Field Name    : ",FIELD(),"\n\n",
      "Field Contents: ",[],"\n\n"
   ENDIF
   MESSAGE "Closing data files..."
   IF ISFIELDVIEW() THEN DO_IT! ENDIF
   IF MATCH(SYSMODE(),"..Edit..") THEN
      UNDO DO_IT!
   ENDIF
   CLEARALL RESET MESSAGE "Returning to DOS..."
   IF ISASSIGNED(org_paradox_colors) THEN
      SETCOLORS FROM org_paradox_colors
   ENDIF
   RETURN 2

ENDPROC
;----------------------------------------------------------------------------
WRITELIB vlib MEMOERRORHANDLER
RELEASE PROCS MEMOERRORHANDLER

