; MAINT.SC
;    Performs daily, weekly, monthly, yearly procedures.  Reads a script,
;    "maintvar", which contains the dates these procedures were last run.
;
; Written by Tom Reese, Philadelphia Area Paradox User's Group (PA..DOX)
;            CompuServe User ID [76417,3662]
;
; Legal Statement
;
;    This source code is hereby released into the public domain,
;    and may be used freely as long as credit is given for this code.

proc maint()

if isfile("maintvar.sc")
   then
      play "maintvar"
endif

if not(isassigned(DailyLr))
   then Dailylr = today() - 1
endif
if not(isassigned(WeeklyLr))
   then Weeklylr = today() - 7
endif
if not(isassigned(MonthlyLr))
   then MonthlyLr = today() - 31
endif
if not(isassigned(YearlyLy))
   then YearlyLr = today() - 366
endif

if DailyLr < today()
   then
      message "Performing daily maintenance..."
      DailyLr = today()
endif

if WeeklyLr <= today() - 7
   then
      message "Performing weekly maintenance..."
      WeeklyLr = today()
endif

if ((month(MonthlyLr) <= month(today()) - 1) and (year(MonthlyLr) = (year(today()))))
   or (year(MonthlyLr) < year(today()))
   then
      message "Performing monthly maintenance..."
      ;readlib "Utility" Pack
      ;pack("*")                      ; removes all "deleted" records from
                                     ; all tables in current directory
      ;release procs pack
      MonthlyLr = today()
endif

if year(YearlyLr) < year(today())
   then
      message "Performing yearly maintenance..."
      YearlyLr = today()
endif

; save the dates using Savevars, then rename it to maintvar.sc

if isfile("savevars.sc")
   then
      {Tools} {Rename} {Script} {savevars} {trtest}
endif

savevars DailyLr, WeeklyLr, MonthlyLr, YearlyLr
Menu {Tools} {Rename} {Script} {savevars} {maintvar} {Replace}

if isfile("trtest.sc")
   then
      Menu {Tools} {Rename} {Script} {trtest} {savevars}
endif

release vars all

endproc

maint()
