;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : script MAKEID.SC
;Source File     : MAKEID.SC
;Author          : Randolph Brown
;                  PC Support Center
;                  Minneapolis, MN
;                  (612) 377-2954
;
;Informant Issue : October 1992
;
;Description     : MAKEID.SC creates an alphanumeric ID from Lname and Fname 
;                  when adding new records to Demomstr. The first line is 
;                  included in order to avoid the problems that arise when 
;                  editing existing records.
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740


IF RECORDSTATUS("New") THEN
   IF ISBLANK([Last Name]) OR ISBLANK([First Name]) THEN
      MESSAGE "Sorry you must enter both first and last names."
      SLEEP 2000
      RETURN
   ENDIF

   IF LEN([Last Name]) >= 5 THEN
      lname = SUBSTR([Last Name],1,4)
      ELSE
         filler1 = 5 - LEN([Last Name])
         lname = [Last Name] + FILL(".", filler1)
   ENDIF

   IF LEN([First Name]) >= 4 THEN
      fname = SUBSTR([First Name],1,3)
      ELSE
         filler2 = 4 - LEN([First Name])
         fname = [First Name] + FILL(".", filler2)
   ENDIF

   tiebreaker = 1

         tiebreaker = STRVAL(tiebreaker)
         idvar = lname + fname + tiebreaker
         [ID] = idvar
            LOCKRECORD
            IF NOT retval THEN            ;if conflict w/existing key
                  whynot = ERRORCODE()
                  IF whynot = 53 THEN
                        WHILE TRUE
                           tiebreaker = NUMVAL(tiebreaker) + 1
                           tiebreaker = STRVAL(tiebreaker)
                           idvar = lname + fname + tiebreaker
                           [ID] = idvar
                           LOCKRECORD
                           IF retval THEN
                              RETURN
                           ENDIF
                        ENDWHILE
                  ENDIF
            ENDIF
 ENDIF


;NOTE: If this code is used during editing of existing records, a lot more
;code is necessary to trap for key violations, and/or restoring the original
;values to changed key fields.





