;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedures SetupTables(),
;                             Main(),
;                             SearchStudents(),
;                             MoveToCommentsTable(),
;                             MoveToTable(vTableName),
;                             SelectFormButton(vSelectColor,vRow,vCol,vLength,vHideFieldColor),
;                             ResetFormButton(vResetColor,vRow,vCol,vHotKeyOffset,vHotKeyColor,vLength,vHideFieldColor),
;                             ProgressBar(vMsg, vProgress),
;                             UniqueID(),
;                             MakeBox(vAttrib, vRow1, vCol1, vRow2, vCol2),
;                             ErrorHandler()
;
;Source File     : GUI.SC,
;                  GUISTART.SC
;
;Author          : Adam Marin
;                  Seattle, WA
;
;Informant Issue : May 1992
;
;Description     : This Paradox 3.5 application is a demonstration of a few GUI-like
;                  features, including buttons, cascading forms, progress bars, and
;                  pop up boxes.
;
;                  To Search for student other than Jonathan Smart, type in Student
;                  ID number 730-76-9021 to edit Jane Wright.
;
;                  The demo is by no means perfect or even remotely complete.
;                  Just thought it might spur some additional ideas.
;
;                  Enjoy!
;
;                  Adam Marin
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740
;

MESSAGE " * Compiling Library * "
CANVAS off
CREATELIB "GUI" SIZE 300

;------------------------------- SETUP TABLES ---------------------------------
PROC SetupTables()
     CURSOR off
     STYLE ATTRIBUTE 158
     @3,1 ?? "Activating Multi-User Access Mode"
     COEDIT "Link1"
     MOVETO FIELD "UserName"
     LOCATE USERNAME()                     ;reserves a row for each user
     IF retval = False THEN
        INS
        [UserName] = USERNAME()
        LOCKRECORD UNLOCKRECORD            ;post change before using pickform
     ENDIF
     LOCKRECORD
     IF retval = False THEN
        BEEP
        MESSAGE ERRORUSER() + " User Name is already in use!"
        SLEEP 2000
        QUIT
     ENDIF
     [LastUsedDate] = TODAY()
     [LastUsedTime] = TIME()
     UNLOCKRECORD LOCKRECORD               ;allow date and time to be posted w/o form
     @3,1 ?? "Linking Students with Courses, Assignments, Books, Meals and Comments"
     PICKFORM "1"
     vPrompt1 = FORMAT("W80,AC","UNIVERSITY OF PARTICULARS")
     vPrompt2 = FORMAT("W80,AC","Student Records")
     MOVETO "Students"
ENDPROC
WRITELIB "GUI" SetupTables
RELEASE PROCS  SetupTables

;-------------------------------------- MAIN ----------------------------------
PROC Main()
     SetupTables()
     vStudentID = [StudentID]
     MOVETO "Link1"
     [StudentID!] = vStudentID
     MOVETO "Comments"                  ;reasons table linked to ecnnum,
     RESYNCKEY                          ;make sure ecn_txt is correct
     MOVETO "Students"
     IMAGERIGHTS update                 ;don't allow user to change key
     WHILE true
           vMsg1      = "Press [Ctrl-Highlighted Letter] to activate Buttons"
           vStudentID = [StudentID]
           vFirst     = [First_Name]
           vLast      = [Last_Name]
           vField     = FIELD()
           vRecNo     = RECNO()
           IF SUBSTR(vField,1,6) = "Button" THEN
              SWITCH
               CASE vField = "Button1": SelectFormButton(32,05,65,11,34) ;courses
               CASE vField = "Button2": SelectFormButton(32,07,65,11,34) ;books
               CASE vField = "Button3": SelectFormButton(32,09,65,11,34) ;meals
               CASE vField = "Button4": SelectFormButton(32,11,65,11,34) ;activities
               CASE vField = "Button5": SelectFormButton(32,13,65,11,34) ;search
               CASE vField = "Button6": SelectFormButton(32,15,65,11,34) ;print
               CASE vField = "Button7": SelectFormButton(32,17,65,11,34) ;quit
              ENDSWITCH
              vKeys1 = GETCHAR()  ;hold screen, wait for user
              SWITCH
                CASE vField = "Button1":
                     ResetFormButton(79,05,65,1,78,11,68) ;courses
                     IF vKeys1 = -80 THEN MOVETO FIELD "Button2" LOOP ENDIF ;down key
                CASE vField = "Button2":
                     ResetFormButton(79,07,65,1,78,11,68) ;books
                     IF vKeys1 = -72 THEN MOVETO FIELD "Button1" LOOP ENDIF ;up key
                     IF vKeys1 = -80 THEN MOVETO FIELD "Button3" LOOP ENDIF ;down key
                CASE vField = "Button3": ResetFormButton(79,09,65,1,78,11,68) ;meals
                     IF vKeys1 = -72 THEN MOVETO FIELD "Button2" LOOP ENDIF ;up key
                     IF vKeys1 = -80 THEN MOVETO FIELD "Button4" LOOP ENDIF ;down key
                CASE vField = "Button4": ResetFormButton(79,11,65,1,78,11,68) ;activities
                CASE vField = "Button5": ResetFormButton(79,13,65,1,78,11,68) ;search
                CASE vField = "Button6": ResetFormButton(79,15,65,1,78,11,68) ;print
                CASE vField = "Button7": ResetFormButton(79,17,65,1,78,11,68) ;quit
              ENDSWITCH
           ELSE
              WAIT RECORD PROMPT vPrompt1, vPrompt2
                   UNTIL "Esc","Up","Down","Left","Right","Home","End","PgUp","PgDn",
                         "Enter","Del","Ins","FieldView",1,2,3,13,16,17,19,"Tab","ReverseTab"
              vKeys1 = retval
           ENDIF
           IF vKeys1 = 13 AND SEARCH("Button",vField) > 0 THEN
              SWITCH                                           ;translate button to hotkey
                CASE vField = "Button1" : vKeys1 =  3          ;courses, ctrl-c (3)
                CASE vField = "Button2" : vKeys1 =  2          ;books, ctrl-b (2)
                CASE vField = "Button3" : vKeys1 = 13          ;meals, ctrl-c (3)
                CASE vField = "Button4" : vKeys1 =  1          ;activities, ctrl-a (1)
                CASE vField = "Button5" : vKeys1 = 19          ;search, ctrl-s (19)
                CASE vField = "Button6" : vKeys1 = 16          ;print, ctrl-p (16)
                CASE vField = "Button7" : QUITLOOP             ;quit, ctrl-q (17)
              ENDSWITCH
              MOVETO FIELD "Address"                           ;can't leave user in button
           ENDIF
           SWITCH
             CASE vKeys1 =  1      : MESSAGE "The Activities button is Under Development" SLEEP 2000 LOOP
             CASE vKeys1 =  2      : MoveToTable("Books") LOOP
             CASE vKeys1 =  3      : MoveToTable("Courses") LOOP
             CASE vKeys1 = 13      : MovetoTable("Meals") LOOP
             CASE vKeys1 = 16      :
                  vTotal = 10000                               ;simulate printing via progress bar
                  FOR vCount FROM 0 TO vTotal STEP 50
                      ProgressBar("Printing Information for " + vFirst + " " + vLast,INT(((vCount/vTotal)*100)))
                  ENDFOR
                  LOOP
             CASE vKeys1 = 19      : SearchStudents() LOOP
             CASE vKeys1 = "Esc"   : QUITLOOP
             CASE vKeys1 = "Del"   : BEEP LOOP
             CASE vKeys1 = "Ins"   : BEEP LOOP
             CASE vKeys1 = "FieldView" :
                  FIELDVIEW ;go into field view
                  WAIT FIELD PROMPT " FIELD CURSOR",
                                    " Press [Enter] when Done"
                       UNTIL "Enter"
           ENDSWITCH
           IF vField = "Phone" AND vKeys1 = "Down" THEN
              vMsg1 = " COMMENTS  Memo editing is disabled in this demo program"
              MoveToCommentsTable()
              LOOP
           ENDIF
           KEYPRESS vKeys1
           IF RECNO() <> vRecNo THEN             ;don't allow user to fall off
              MOVETO RECORD vRecNo               ;this record
              IF [StudentID] <> vStudentID THEN  ;if another pcr was created
                 MOVETO FIELD "ECNnum"           ;by another user, that may
                 LOCATE vStudentID               ;change this row's record number.
                 MOVETO FIELD vField
              ENDIF
           ENDIF
     ENDWHILE
     MESSAGE " * Exiting Application * "
     CANVAS off
     DO_IT!
     CLEARALL
     CANVAS on
ENDPROC
WRITELIB "GUI" Main
RELEASE PROCS  Main

;-----------------------------SEARCH STUDENTS ------------------------------
PROC SearchStudents()
     WHILE True
           MakeBox(32,4,38,6,70)
           STYLE ATTRIBUTE 32
           @5,40 ?? "Student Number: "
           STYLE ATTRIBUTE 112
           CURSOR box
           ACCEPT "A11" TO vStudentID
           IF retval = False THEN
              CURSOR off
              QUITLOOP
           ENDIF
           CURSOR off STYLE
           MESSAGE " * Searching for Student ID " + vStudentID + " * "
           MOVETO [Students->StudentID]
           LOCATE vStudentID
           IF retval = False THEN
              MESSAGE "Student Number " + vStudentID + " Not Found!" SLEEP 2000
              LOOP
           ENDIF
           LOCKRECORD
           IF retval = False THEN
              MESSAGE "Student ID " + vStudentID + " is currently being edited by " + ERRORUSER()
              SLEEP 2000
              LOOP
           ENDIF
           vStudentID = [StudentID]
           MOVETO "Link1"
           [StudentID!] = vStudentID
           MOVETO "Comments"                  ;reasons table linked to ecnnum,
           RESYNCKEY                          ;make sure ecn_txt is correct
           MOVETO "Students"
           IMAGERIGHTS update                 ;don't allow user to change key
           QUITLOOP
     ENDWHILE
ENDPROC
WRITELIB "GUI" SearchStudents
RELEASE PROCS  SearchStudents

;----------------------------- MOVE TO COMMENTS TABLE -------------------------
PROC MoveToCommentsTable()
     vStudentID = [StudentID]
     MOVETO "Comments"
     IMAGERIGHTS readonly
     WHILE true
           WAIT TABLE PROMPT vPrompt1, vPrompt2
                UNTIL "F9","Up","Down","Esc"
           vKeys1 = retval
           SWITCH
             CASE vKeys1 = "Esc":
                  MOVETO "Students"
                  QUITLOOP
             CASE vKeys1 = "Up" :
                  IF ATFIRST() = True AND vKeys1 = "Up" THEN
                     MOVETO "Students" ;return to field in students
                     QUITLOOP
                  ENDIF
                  UP
             CASE vKeys1 = "Down" :
                  IF ATLAST() = True AND vKeys1 = "Down" THEN
                     MOVETO "Students"
                     MOVETO FIELD "StudentID" ;create the effect of field looping
                     QUITLOOP
                  ENDIF
                  DOWN
             CASE vKeys1 = "F9":
                  MESSAGE "Memo editing is disabled for this demo"
                  SLEEP 2000
           ENDSWITCH
     ENDWHILE
ENDPROC
WRITELIB "GUI" MoveToCommentsTable
RELEASE PROCS  MoveToCommentsTable

;----------------------------------- MOVE TO TABLE ----------------------------
PROC MoveToTable(vTableName)
     PRIVATE v
     MESSAGE " * Working * "
     IF TABLE() = "Students" THEN
        vStudentID = [StudentID]
        MOVETO "Link1"
        [StudentID!] = vStudentID
        MOVETO vTableName
     ENDIF
     IF TABLE() = "Courses" AND vTableName = "Assign" THEN
        vQuarter     = [Quarter]     ;from the courses table
        vNumber      = [Number]      ;variables used to display current
        vDescription = [Description] ;course selection when displaying
        vClass_Grade = [Class_Grade] ;assignments
        MOVETO "Link1"               ;student id already posted to link1
        [Quarter!]   = vQuarter      ;post remaining key items
        [CourseNum!] = vNumber
        MOVETO "Assign"
     ENDIF
     RESYNCKEY                       ;update displayed records with new key
     HOME
     CANVAS on
     WHILE true
           WAIT TABLE PROMPT vPrompt1, vPrompt2
                UNTIL "Esc","Up","Down","Left","Right","Home","End","PgUp","PgDn",
                      "Enter","Del","Ins","FieldView","Tab","ReverseTab"
           vKeys1 = retval
           SWITCH
             CASE vKeys1 = "Esc"   : QUITLOOP
             CASE vKeys1 = "FieldView" :
                  FIELDVIEW                              ;go into field view
                  WAIT FIELD PROMPT " FIELD CURSOR",
                                    " Press [Enter] when Done"
                       UNTIL "Enter"
                  LOOP
             CASE vKeys1 = "Enter"  :
                  IF TABLE() = "Courses" THEN
                     IF ISBLANK([Quarter]) = True OR ISBLANK([Number]) = True THEN
                        BEEP
                        MESSAGE "Quarter and Class Number must be filled in"
                        SLEEP 2000
                        LOOP
                     ENDIF
                     MoveToTable("Assign")
                     LOOP
                  ENDIF
             CASE vKeys1 = "Del"    :
                  BEEP
                  MESSAGE "Cannot Delete Records in this Demo"
                  SLEEP 2000
                  LOOP
             CASE vKeys1 = "F1" :
           ENDSWITCH
           KEYPRESS vKeys1
           IF ISBLANK([UniqueID]) = True THEN
              [UniqueID] = UniqueID()
           ENDIF
     ENDWHILE
     MESSAGE " * Working * "
     IF TABLE() = "Assign" THEN
        MOVETO "Courses"
     ELSE
        MOVETO "Students"
     ENDIF
ENDPROC
WRITELIB "GUI" MoveToTable
RELEASE PROCS  MoveToTable

;----------------------------- SELECT FORM BUTTONS ----------------------------
;vSelectColor       = button's color when selected
;vRow               = button's horizontal position
;vCol               = button's vertical starting position
;vLength            = button's total length
;vHideFieldColor    = color to hide field on form (assumes position vCol+vLength)

PROC SelectFormButton(vSelectColor,vRow,vCol,vLength,vHideFieldColor)
     CANVAS off
     PAINTCANVAS ATTRIBUTE vSelectColor    vRow, vCol,         vRow,   vCol+vLength       ;color button
     PAINTCANVAS ATTRIBUTE vHideFieldColor vRow, vCol+vLength, vRow,   vCol+vLength       ;hide field
     CANVAS on
ENDPROC
WRITELIB "GUI" SelectFormButton
RELEASE PROCS  SelectFormButton

;----------------------------- RESET FORM BUTTONS ----------------------------
;vResetColor      = button's color when selected
;vRow             = button's horizontal position
;vCol             = button's vertical starting position
;vHotKeyOffset    = number of spaces after starting position of hotkey
;vHotKeyColor     = hot key color
;vLength          = button's total length
;vHideFieldColor  = color to hide field on form (assumes position vCol+vLength)

PROC ResetFormButton(vResetColor,vRow,vCol,vHotKeyOffset,vHotKeyColor,vLength,vHideFieldColor)
     CANVAS off
     PAINTCANVAS ATTRIBUTE vResetColor      vRow, vCol,               vRow,   vCol+vLength       ;color button
     PAINTCANVAS ATTRIBUTE vHotKeyColor     vRow, vCol+vHotKeyOffset, vRow,   vCol+vHotKeyOffset ;color hotkey
     PAINTCANVAS ATTRIBUTE vHideFieldColor  vRow, vCol+vLength,       vRow,   vCol+vLength       ;hide field
     CANVAS on
ENDPROC
WRITELIB "GUI" ResetFormButton
RELEASE PROCS  ResetFormButton

;--------------------------------- PROGRESS BAR -------------------------------
PROC ProgressBar(vMsg, vProgress)
     PRIVATE vMsg, vProgress
     CURSOR off
     IF vProgress = 0 THEN                                         ;setup box
        CANVAS off
        MakeBox(112, 8, 10, 11, 68)                                ;by passing
        STYLE ATTRIBUTE  127                                       ;0 Progress
        @ 9,12 ?? FORMAT("W55,AL",vMsg)
        CANVAS on
     ENDIF
     IF vProgress <= 100 THEN
        STYLE ATTRIBUTE 112
        @ 9,12 ?? FORMAT("W55,AL",vMsg)
        STYLE ATTRIBUTE 52
        @10,12 ?? FORMAT("W50,AL",FILL(CHR(219),INT(vProgress/2))) ;50 chr = 100%
        STYLE ATTRIBUTE  127
        @10,63 ?? FORMAT("W4,AR",STRVAL(vProgress) + "%")
     ENDIF
     STYLE
ENDPROC
WRITELIB "GUI" ProgressBar
RELEASE PROCS  ProgressBar

;----------------------------------- UNIQUE ID -------------------------------
PROC UniqueID()             ;provides a fast, simple unique id
     RETURN RAND() * 100000 ;should only be used with multi-column keys
ENDPROC
WRITELIB "GUI" UniqueID
RELEASE PROCS  UniqueID

;------------------------------ MAKE BOX ------------------------------------
PROC MakeBox(vAttrib, vRow1, vCol1, vRow2, vCol2)
     PRIVATE vAttrib, vRow1, vCol1, vRow2, vCol2
     CANVAS off
     PAINTCANVAS FILL CHR(255) vRow1, vCol1, vRow2, vCol2 ;blank spaces
     @ vRow1,vCol1
     ?? ""
     ?? FILL("",(vCol2 - (vCol1+1)))
     ?? ""
      ?
     WHILE NOT Row() = vRow2
         @ Row(), vCol1
         ?? ""
         @ Row(), vCol2
         ?? ""
          ?
     ENDWHILE
     @ vRow2,vCol1
     ?? ""
     ?? FILL("",(vCol2 - (vCol1+1)))
     ?? ""
     PAINTCANVAS ATTRIBUTE       8 vRow1+1, vCol1+2, vRow2+1, vCol2+2
     PAINTCANVAS ATTRIBUTE vAttrib vRow1, vCol1, vRow2, vCol2
     CANVAS on
ENDPROC
WRITELIB "GUI" MakeBox
RELEASE PROCS MakeBox

;--------------------------------- ERROR HANDLER ------------------------------
PROC ErrorHandler()
     PRIVATE errorproc, vErrorMsg, vCount, vErrorCode
     vErrorMsg  = ERRORMESSAGE()
     vErrorCode = ERRORCODE()
     STYLE ATTRIBUTE 79
     @ 0,0 ?? FORMAT("W80,AC","INTERNAL ERROR: " + vErrorMsg)
     @ 1,0 ?? FORMAT("W80,AC","Recording - One Moment Please")
     STYLE
     PRINT FILE "ERRORLOG.RPT" FILL("-",79) + "\n"
     PRINT FILE "ERRORLOG.RPT" "   DATE: " + STRVAL(TODAY()) + ", " + TIME() + "\n"
     PRINT FILE "ERRORLOG.RPT" "  ERROR: #" + STRVAL(vErrorCode) + ", " + vErrorMsg + "\n"
     PRINT FILE "ERRORLOG.RPT" "PRIVDIR: " + PRIVDIR() + "\n"

     IF ISASSIGNED(vMainChoice) = True THEN
        PRINT FILE "ERRORLOG.RPT" "   MAIN: " + vMainChoice + "\n"
     ELSE
        PRINT FILE "ERRORLOG.RPT" "   MAIN: Variable vMainChoice is not Assigned\n"
     ENDIF

     IF ISASSIGNED(vMenuChoice) = True THEN
        PRINT FILE "ERRORLOG.RPT" "   MENU: " + vMenuChoice + "\n"
     ELSE
        PRINT FILE "ERRORLOG.RPT" "   MENU: Variable vMenuChoice is not Assigned\n"
     ENDIF

     IF ISASSIGNED(vKeys1) = True THEN
        IF TYPE(vKeys1) = "N" THEN
           PRINT FILE "ERRORLOG.RPT" "    KEY: " + STRVAL(vKeys1) + "\n"
        ELSE
           PRINT FILE "ERRORLOG.RPT" "    KEY: " + vKeys1 + "\n"
        ENDIF
     ELSE
        PRINT FILE "ERRORLOG.RPT" "    KEY: Variable vKeys1 is not Assigned\n"
     ENDIF

     IF IMAGETYPE() = "Display" THEN
        PRINT FILE "ERRORLOG.RPT" "  TABLE: " + TABLE() + "\n"
     ELSE
        PRINT FILE "ERRORLOG.RPT" "  TABLE: " + IMAGETYPE() + "\n"
     ENDIF

     PRINT FILE "ERRORLOG.RPT" "    RAM: " + STRVAL(MEMLEFT()) +"\n\n"
     retval = ISFILE("ERRORLOG.RPT") ;close the file

    ;CHECK TO SEE THAT WE ARE NOT CAUGHT IN A REAPEATING SERIES OF ERRORS
     IF ARRAYSIZE(vErrorTime) = 0 THEN          ;create an array of variables
        ARRAY vErrorTime[3]                     ;to hold time if they don't
        FOR vCount FROM 1 TO 3                  ;already exist
            vErrorTime[vCount] = 0
        ENDFOR
     ENDIF

    ;strip out the colons from the time() function and make it a number
     vErrorTime[1] = NUMVAL(SUBSTR(TIME(),1,2)+SUBSTR(TIME(),4,2)+SUBSTR(TIME(),7,2))
     IF vErrorTime[1] - vErrorTime[2] <= 5 THEN
        vErrorTime[3] = vErrorTime[3] + 1       ;count number of errors
     ELSE
        vErrorTime[3] = 0                       ;reset count
     ENDIF

;TEST SCREEN
;    CANVAS off
;    PAINTCANVAS FILL " " 6,0,8,79
;    @6,10 ?? "     v1: " + STRVAL(vErrorTime[1]) + ", v2: " + STRVAL(vErrorTime[2])
;    @7,10 ?? "v1 - v2: " + STRVAL(vErrorTime[1] - vErrorTime[2])
;    @8,10 ?? "     v3: " + STRVAL(vErrorTime[3])
;    CANVAS on

     IF vErrorTime[3] = 15 THEN                 ;15 errors have occured, each w/in 5
        CLEAR                                   ;seconds of the other
        STYLE ATTRIBUTE 79
        @ 0,0 ?? FORMAT("W80,AC","SYSTEM FAILURE")
        @ 1,0 ?? FORMAT("W80,AC","Press any key to Exit")
        STYLE
        retval = GETCHAR()
        PRINT FILE "ERRORLOG.RPT" "SYSTEM FAILURE - EXITING AT " + TIME() + "\n\n"
        retval = ISFILE("ERRORLOG.RPT") ;close the file
        QUIT
     ENDIF

     vErrorTime[2] = vErrorTime[1] ;remember the previous time an error occured
     RETURN 1                      ;return 1 means to skip statement causing error
ENDPROC
WRITELIB "GUI" ErrorHandler
RELEASE PROCS ErrorHandler



CANVAS on                                             ;turned off at the top
