;-----------------------------------------------------------------------------
;NAME : Trim
;NOTES: Trims leading and trailing spaces and replaces embedded multiple
;       spaces with one space. Returns trimmed String.
;-----------------------------------------------------------------------------
?? ""
PROC Trim(Str)
   PRIVATE Str1,
           Str2

   WHILE MATCH(Str," ..",Str) ENDWHILE
   WHILE MATCH(Str,".. ",Str) ENDWHILE
   WHILE
      MATCH(Str,"..  ..",Str1,Str2)
      Str = Str1 + " " + Str2
   ENDWHILE
   RETURN Str
ENDPROC
WRITELIB Lib  Trim
RELEASE PROCS Trim

;-----------------------------------------------------------------------------
;NAME : NonCapsArray
;NOTES: Allocates list of words not to be capitalised to a dynarray.
;       Use a list to suit your data requirements. The following are chosen
;       with UK addresses in mind. e.g. Ashby-de-la-Zouch, Kingston-upon-Hull,
;       Ashton-under-Lyne, Wells-next-the-Sea, Chapel-en-le-Frith etc.
;-----------------------------------------------------------------------------
?? ""
PROC NonCapsArray()
   DynArray NonCaps[]
   NonCaps["AND"]    = "and"
   NonCaps["AT"]     = "at"
   NonCaps["BY"]     = "by"
   NonCaps["CUM"]    = "cum"
   NonCaps["DE"]     = "de"
   NonCaps["EN"]     = "en"
   NonCaps["FOR"]    = "for"
   NonCaps["FROM"]   = "from"
   NonCaps["IN"]     = "in"
   NonCaps["ISBN"]   = "ISBN"
   NonCaps["LE"]     = "le"
   NonCaps["LA"]     = "la"
   NonCaps["NEXT"]   = "next"
   NonCaps["ON"]     = "on"
   NonCaps["OF"]     = "of"
   NonCaps["THE"]    = "the"
   NonCaps["TO"]     = "to"
   NonCaps["UPON"]   = "upon"
   NonCaps["UNDER"]  = "under"
ENDPROC
WRITELIB Lib NonCapsArray
RELEASE PROCS NonCapsArray

;-----------------------------------------------------------------------------
;NAME : StripHyphens
;NOTES: Replaces all hyphens in a string with spaces and returns the result
;-----------------------------------------------------------------------------
?? ""
PROC StripHyphens(Str)
   PRIVATE RetStr,
           Word,
           NextStr

   NextStr = Str + "-*" ;Add hyphenated pseudo-word to simplify MATCH loop
   RetStr = ""

   WHILE MATCH(NextStr,"..-..",Word,NextStr)
      ;This causes a leading space which needs trimming later
      RetStr = RetStr + " " + Word
   ENDWHILE

   RETURN Trim(RetStr)
ENDPROC
WriteLib Lib  StripHyphens
Release Procs StripHyphens

;-----------------------------------------------------------------------------
;NAME : ReplaceHyphens
;NOTES: Replaces hyphens which were stripped out of a hyphenated string.
;       'HyphenStr' is the un-modified string and 'Str' the modified string.
;       It is assumed all words are identical in each string and that only
;       some characters have changed case.
;-----------------------------------------------------------------------------
?? ""
PROC ReplaceHyphens(Str,HyphenStr)
   PRIVATE I

   FOR I FROM 2 TO LEN(HyphenStr)
      IF SUBSTR(HyphenStr,I,1) = "-" THEN
         Str = SUBSTR(Str,1,I-1) + "-" + SUBSTR(Str,I+1,255)
      ENDIF
   ENDFOR

   RETURN Str
ENDPROC
WriteLib Lib  ReplaceHyphens
Release Procs ReplaceHyphens

;-----------------------------------------------------------------------------
;NAME : FixCapitals
;NOTES: Fixes the capitals in a string which has been formatted by Paradox
;       to have initial capitals.
;
;       Each word in the string is compared to a look-up array of words which
;       are NOT to be FixCapitalsd and if a match is found, the original
;       word is replaced with the look-up version.
;
;       Hyphenated strings are handled.
;       'Mc' and 'Mac' names are handled.
;
;       During data input it should be possible for the user to circumvent
;       this routine e.g. Only call FixCapitals if the [Enter] key is hit.
;-----------------------------------------------------------------------------
?? ""
PROC FixCapitals(Str)
   PRIVATE FixedStr,  ;To Hold corrected string
           T,         ;Result of Match
           HyphenStr, ;Holds a copy of a hyphenated string
           FirstWord  ;True if the current Word is the first

   Str = Trim(Str)

   IF ISBLANK(Str) THEN
      RETURN STR
   ENDIF

   IF NOT ISASSIGNED(NonCaps) THEN
      NonCapsArray()
   ENDIF

   IF SEARCH("-",Str) > 0 THEN
      HyphenStr = Str
      LeadingHyphen = (SUBSTR(Str,1,1) = "-")
      Str = StripHyphens(Str)
   ELSE
      HyphenStr = ""
   ENDIF

   FixedStr = ""
   Str = Str + " *"       ;Pseudo-word added to simplify following WHILE loop
   T = TRUE
   FirstWord = TRUE

   WHILE T
      T = MATCH(Str,".. ..",Word,NextStr)

      IF T THEN
         Str = NextStr

         IF ISASSIGNED(NonCaps[Word]) AND NOT FirstWord THEN
            ;This causes a leading space which needs trimming later
            FixedStr = FixedStr + " " + NonCaps[Word]
         ELSE
            IF FirstWord AND SUBSTR(Word,1,1) >= "A" AND SUBSTR(Word,1,1) <= "Z" THEN
               FirstWord = FALSE
            ENDIF

            L = LEN(Word)

            IF SUBSTR(Word,L-1,2) = "'S" AND L > 3 THEN
               Word = SUBSTR(Word,1,L-2) + "'s"
            ENDIF

            IF SUBSTR(Word,1,2) = "Mc" AND L > 3 THEN
               Word = "Mc" + UPPER(SUBSTR(Word,3,1)) + SUBSTR(Word,4,l)
            ENDIF

            IF SUBSTR(Word,1,3) = "Mac" AND L > 5 AND SUBSTR(Word,1,7) <> "Machine" THEN
               Word = "Mac" + UPPER(SUBSTR(Word,4,1)) + SUBSTR(Word,5,l)
            ENDIF

            FixedStr = FixedStr + " " + Word
         ENDIF
      ENDIF
   ENDWHILE

   IF HyphenStr > "" THEN
      IF LeadingHyphen THEN
         FixedStr = "-" + Trim(FixedStr)
         RETURN ReplaceHyphens(FixedStr, HyphenStr)
      ENDIF
       RETURN ReplaceHyphens(Trim(FixedStr), HyphenStr)
   ENDIF

   RETURN Trim(FixedStr)
ENDPROC
WriteLib Lib  FixCapitals
Release Procs FixCapitals

