;ͻ
; Script Name:            Creation Date:02/25/91      Author: Ken Johnson   
;  FAMLYDOC.SC            Last Revision:          Revised By:               
;Ķ
; Description: Prints the structure of all Paradox data bases (*.db) in       
;              the current directory, along with listing of family members.   
;              For Forms and Tables, the description is printed along with    
;              the form/report number.                                        
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
; LIST                                  checkprinter.l                   
; STRUCT                                                                 
; FAMILY                                (from PBE book)                  
;                                                                        
;Ķ
;Notes: checkprinter.l() makes sure printer is on; replace with your own      
;      printer check procedure or printerstatus().                            
;                                                                             
;      This code is an enhancement of the PRTSTRUT.SC script available on     
;      BORDB on CompuServe.  This script may not be the most elegant          
;      piece of code around, but does give me the info I need to document     
;      my tables, reports, and forms.  Feel free to use it as a starting      
;      point and make modifications as you see fit.                           
;                                                                             
;ͼ
;
CLEARALL

printok = checkprinter.l()       ; use printerstatus() or other procedure here
IF printok THEN
    STYLE REVERSE
    @24,0
    ?? FORMAT("W80,ac","Printing Table Documentation")
    {Tools} {Info} {Inventory} {Tables} {}
    edit "list"
    OPEN PRINTER
    cur_rec = 1
    WHILE cur_rec <= NRECORDS("list")
       MOVETO RECORD cur_rec
       IF    [Name] = "Answer"
          OR [Name] = "Struct"
          OR [Name] = "List"
          OR [Name] = "Family"
          OR [Name] = "Keyviol"
          OR [Name] = "Inserted"
          OR [Name] = "Changed"
          OR [Name] = "Crosstab"
          OR [Name] = "Deleted"
          OR [Name] = "Entry"
          THEN
          cur_rec = cur_rec + 1
          LOOP
          ENDIF
       cur_name = [Name]
       Do_it!
       Menu {Tools} {Info} {Structure}
       SELECT cur_name
       PRINT  cur_name + " Table\n\r"
       PRINT  " \n\r"
       PRINT  "Field Name                 Field Type\n\r"
       PRINT  "-------------------------  ----------\n\r"
       field_nbr = 1
       WHILE field_nbr <= NRECORDS("struct")
          MOVETO RECORD field_nbr
          PRINT  [Field Name] + SPACES(27-LEN([Field Name])) + [Field Type] + "\n\r"
          field_nbr = field_nbr + 1
       ENDWHILE
       PRINT  " \n\r"      ; two line feeds for spacing
       PRINT  " \n\r"
       Menu {Tools} {Info} {Family}
       SELECT cur_name
       PRINT  "Family Members \n\r"
       PRINT  "--------------------------------------------------- \n\r"
       field_nbr = 1
       MOVETO RECORD field_nbr
       WHILE field_nbr <= NRECORDS("family")
          WHILE search("Form",[Name]) = 1
             IF [Name] = "Form F" THEN
                Menu {Forms} {Change}
                SELECT cur_name
                SELECT "F"
                frdesc = menuchoice()
                MENU Esc
                PRINT [Name] + " -- " + frdesc
                PRINT "\n\r"
                field_nbr = field_nbr + 1
                MOVETO RECORD field_nbr
             ENDIF
             FOR ndx FROM 1 TO 14 STEP 1
                IF [Name] = "Form F" + strval(ndx) THEN
                   Menu {Forms} {Change}
                   SELECT cur_name
                   SELECT ndx
                   frdesc = menuchoice()
                   MENU Esc
                   PRINT [Name] + " -- " + frdesc
                   PRINT "\n\r"
                   field_nbr = field_nbr + 1
                   MOVETO RECORD field_nbr
                ENDIF
             ENDFOR
             IF ATLAST() THEN QUITLOOP
             ENDIF
          ENDWHILE
          WHILE search("Report",[Name]) = 1
             IF [Name] = "Report R" THEN
                Menu {Report} {Change}
                SELECT cur_name
                SELECT "R"
                frdesc = menuchoice()
                MENU Esc
                PRINT [Name] + " -- " + frdesc
                PRINT "\n\r"
                field_nbr = field_nbr + 1
                MOVETO RECORD field_nbr
             ENDIF
             FOR ndx FROM 1 TO 14 STEP 1
                IF [Name] = "Report R" + strval(ndx) THEN
                   Menu {Report} {Change}
                   SELECT cur_name
                   SELECT ndx
                   frdesc = menuchoice()
                   MENU Esc
                   PRINT [Name] + " -- " + frdesc
                   PRINT "\n\r"
                   field_nbr = field_nbr + 1
                   MOVETO RECORD field_nbr
                ENDIF
             ENDFOR
             IF ATLAST() THEN QUITLOOP
             ENDIF
          ENDWHILE
          IF search("Form",[Name]) = 0 and search("Report",[Name]) = 0 THEN
             IF field_nbr=1 THEN PRINT [Name] + " -- Table name \n\r"
             ELSE PRINT [Name] + "\n\r"
             ENDIF
             field_nbr = field_nbr + 1
          ENDIF
          MOVETO RECORD field_nbr
       ENDWHILE
       UpImage
       UpImage
       cur_rec = cur_rec + 1
       Print chr(012)
    ENDWHILE
    CLOSE PRINTER
    RELEASE VARS ALL
    CLEARALL
ENDIF
