;	Name:				E X A M P L E . S C
;
;	Version:			1.0
;
;	Date:    		Januray 3, 1993
;
;						Copyright 1993 Daniel Ambrose - All rights Reserved
;
;	Written by:		Daniel Ambrose					71062,523
;						Ambrose & Muckerman
;						1386 South Fifth Street
;						St. Charles, MO 63301
;
;						Tel 314 - 946-6222
;						Fax 314 - 946-8717
;
;						CIS 71062,523
;
;	Tab size:		3
;
;
;				 I N T R O D U C I N G     E X A M P L E . SC
;				 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;
;		This script contains examples from the Paradox Programmer's
;		Guide that SHOULD have been included as part of Paradox. I
;		hope I've saved you from wasting your valuable time keying
;		these examples in contrast to learning Paradox ...
;
;		Included are all the examples from Chapter 14, Creating Menus and
;		Chapter 15, Creating Dialog boxes.  These examples were all
;		copied word-for-word with comments, from the PAL Programmers
;		Guide into one neat example program.  In some cases an example
;		was slightly modified to best fit this example. Each example is
;		neatly coded into a procedure named similar to that of the page
;		number it was derived from.  When more than one example exist
;		on a page then the letter "A, B, C..." is added at the end.
;		This example (EXAMPLE.SC) includes a main menu with a PICKARRAY
;		for easy selection.  You can run the script and try every example.
;
;
;						 PLEASE TRY TO ANSWER THIS QUESTION
;						 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;		How would I modify the PICKARRAY example on PG. 249 to include a
;		description ?
;
;		Directing your attention to SHOWARRAY and PICKARRAY.  I'd like
;		get the SHOWARRAY functionality in my own DIALOG box. I have
;		examined and tried both Examples (SHOWARRAY PG 240) (PICKARRAY
;		PG 249) shown in Chapter 15, Creating Dialog Boxes.  SHOWARRAY
;		will display the choice and description and PICKARRAY displays
;		ONLY the choice.  How would I modify the PICKARRAY example on PG.
;		249 to include a description ?
;
;		In other words, I want to display a description on the 25th line
;		just like SHOWARRAY would but I want to do this from my own Dialog
;		box using PICKARRAY.  If you have an answer please Email me.
;
;		Regards,		Daniel Ambrose			71062,513
;
;		PS If you find something wrong or have a suggestion gimme a shout!!


	release vars all
	release procs all

	ALTSPACE {Desktop} {Empty}
	echo normal
	echo off


;----------------------------------------------------------------------------
;
;	SHOWMENU with EXECPROC - Example begins on PG 226
;
PROC Example226A()

	PROC EnterProc()
		MESSAGE "This is EnterProc.  Press any key ..."
		i = GETCHAR()
	ENDPROC

	PROC PrintProc()
		MESSAGE "This is PrintProc.  Press any key ..."
		i = GETCHAR()
	ENDPROC

	DYNARRAY MenuTask[]										; define dynamic array
	MenuTask ["Enter Data"] = "EnterProc"
	MenuTask ["Print Report"] = "PrintProc"
	MenuTask ["Quit"] = "QuitProc"

	WHILE True

		SHOWMENU
			"Enter Data"		:	"Enter data into table.",
			"Print Report"		:	"Send report on table to printer.",
			"Quit"				:  "End this script and return to Paradox."
			UNTIL 17
			KEYTO KeyVar
			DEFAULT "Print Report"
		TO MenuItem

		IF (MenuItem = "Quit") OR
			(MenuItem = "Esc")
			THEN Return
		ENDIF

		EXECPROC(MenuTask[MenuItem])		; execute the procedure defined

	ENDWHILE

ENDPROC
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;
;	SHOWMENU with SWITCH - Example begins on PG 226
;
PROC Example226B()

	PROC EnterProc()
		MESSAGE "This is the EnterProc.  Press any key ..."
		i = GETCHAR()
	ENDPROC

	PROC PrintProc()
		MESSAGE "This is the PrintProc.  Press any key ..."
		i = GETCHAR()
	ENDPROC

	WHILE True

		SHOWMENU
			"Enter Data"		:	"Enter data into table.",
			"Print Report"		:	"Send report on table to printer.",
			"Quit"				:  "End this script and return to Paradox."
			UNTIL 17
			KEYTO KeyVar
			DEFAULT "Print Report"
		TO MenuItem

		SWITCH
			CASE	MenuItem = "Enter Data":		EnterProc()
			CASE	MenuItem = "Print Report":		PrintProc()
			CASE	(MenuItem = "Quit") OR
					(MenuItem = "Esc") :				RETURN
		ENDSWITCH

	ENDWHILE

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWPOPUP Two Level Menu - Example begins on PG 228
;
PROC Example228()
	SHOWPOPUP "Utilities"	CENTERED
		"About"			: "About this application"			:	"AboutTag",
		SEPARATOR,
		"Calculator"	: "Display popup calculator"		:	DISABLE
																			"CalculatorTag",
		"Custom"			: "Customize colors or menus"		:	"MenuTag"
			SUBMENU
			"Colors"		: "Customize screen colors"		:	"ColorTag",
			"Menus"		: "Display custom menus"			:	"MenuTag"
			ENDSUBMENU,
		SEPARATOR,
		"Password"		: "Create or change passwords"	:	"PasswordTag"
			SUBMENU
			"New"			:	"Create a new password"			:	"PasswordTag",
			"Change"		:	"Change an existing password"	:	"ChangeTag"
			ENDSUBMENU
		ENDMENU

		UNTIL 17									; Ctrl-Q to quit
		KEYTO KeyVar
		TO MenuVar

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWPULLDOWN Menu - Example begins on PG 231
;
PROC Example231()
	SHOWPULLDOWN

		""         			: "Program Information."			: "AltSpace"
			SUBMENU
			"Utilities"			: "System Utilities."				: "Utilities"
				SUBMENU
				"Calculator"	: "PopUp Calculator."				: "Calculator",
				"Help Interval": "Set AutoHelp Interval."			: "Help Interval"
				ENDSUBMENU,
			SEPARATOR,
			"About"				: "About this application"			: "AltSpace/About"
			ENDSUBMENU,

		"Table"					: "Work with the invoice table."	: "Table"
			SUBMENU
			"Modify"				: "Modify Invoice Table."			: "Table/Modify",
			"Close"				: "Close Invoice Table."			: "Table/Close"
			ENDSUBMENU,
		"Report"					: "Report on customer table."		: "Report"
			SUBMENU
			"All"					: "Print report of all " +
									  "customers."							: "Report/All",
			"West Coast"		: "Print report of only West " +
									"Coast customers."					: "Report/West"
			ENDSUBMENU,
		"Exit"					: "Exit this application."			: "Exit"
			SUBMENU
			"No"					: "Do not exit this application.": "Exit/No",
			"Yes"					: "Exit this application."			: "Exit/Yes"
			ENDSUBMENU
		ENDMENU UNTIL 17								; Ctrl-Q to quit

		WHILE True
			GETMENUSELECTION KEYTO KeyVar TO MenuItemSelected
			IF RetVal			; If the user selects a menu item
				THEN
				QUITLOOP			; quit the loop and take down the menu
			ENDIF
			IF KeyVar = 17    ; if the user presses Ctrl-Q
				THEN
				QUITLOOP			; quit the loop and take down the menu
			ENDIF
		ENDWHILE

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWPULLDOWN and GETEVENT Menu - Example begins on PG 232
;
PROC Example232()

	ECHO NORMAL
	WINDOW CREATE 	@7,13									; create a canvas window
		HEIGHT 11
		WIDTH 56
		TO SplashScreen
	@2,0 ?? FORMAT("W54,AC", "B O R L A N D")				; and use it as a
	@3,0 ?? FORMAT("W54,AC", "Sample Application")		; splash screen

	SHOWPULLDOWN

		""         			: "Program Information."			: "AltSpace"
			SUBMENU
			"Utilities"			: "System Utilities."				: "Utilities"
				SUBMENU
				"Calculator"	: "PopUp Calculator."				: "Calculator",
				"Help Interval": "Set AutoHelp Interval."			: "Help Interval"
				ENDSUBMENU,
			SEPARATOR,
			"About"				: "About this application"			: "AltSpace/About"
			ENDSUBMENU,

		"Table"					: "Work with the invoice table."	: "Table"
			SUBMENU
			"Modify"				: "Modify Invoice Table."			: "Table/Modify",
			"Close"				: "Close Invoice Table."			: "Table/Close"
			ENDSUBMENU,
		"Report"					: "Report on customer table."		: "Report"
			SUBMENU
			"All"					: "Print report of all " +
									  "customers."							: "Report/All",
			"West Coast"		: "Print report of only West " +
									"Coast customers."					: "Report/West"
			ENDSUBMENU,
		"Exit"					: "Exit this application."			: "Exit"
			SUBMENU
			"No"					: "Do not exit this application.": "Exit/No",
			"Yes"					: "Exit this application."			: "Exit/Yes"
			ENDSUBMENU
		ENDMENU

	WHILE True												; trap for MENUSELECT to
		GETEVENT MESSAGE "MENUSELECT"					; see if the user selects
			TO EventInfo									; a menu item then assign
		MenuItemSelected = EventInfo["MENUTAG"]	; the menu variable
		QUITLOOP												; and take down the menu --
	ENDWHILE											; process other events normally


	WINDOW SELECT SplashScreen
	WINDOW CLOSE

ENDPROC
;----------------------------------------------------------------------------



;----------------------------------------------------------------------------
;
;	SHOWPULLDOWN and WAIT Menu - Example begins on PG 234
;
PROC Example234()

	PROC WaitProc(EventType, EventRecord, CycleNumber)
		If EventRecord["MENUTAG"] = "Exit/Yes"
			THEN
				DO_IT!
				CLEARIMAGE
				ExitCode = 2                      	; end the wait session
			ELSE
				MESSAGE EventRecord["MENUTAG"]		; not installed
				SLEEP 1500
				MESSAGE ""
				ExitCode = 0								; process event. don't break
																; wait session
		ENDIF
		RETURN ExitCode
	ENDPROC


	SHOWPULLDOWN

		""         			: "Program Information."			: "AltSpace"
			SUBMENU
			"Utilities"			: "System Utilities."				: "Utilities"
				SUBMENU
				"Calculator"	: "PopUp Calculator."				: "Calculator",
				"Help Interval": "Set AutoHelp Interval."			: "Help Interval"
				ENDSUBMENU,
			SEPARATOR,
			"About"				: "About this application"			: "AltSpace/About"
			ENDSUBMENU,

		"Table"					: "Work with the invoice table."	: "Table"
			SUBMENU
			"Modify"				: "Modify Invoice Table."			:  DISABLE
																					"Table/Modify",
			"Close"				: "Close Invoice Table."			: "Table/Close"
			ENDSUBMENU,
		"Report"					: "Report on customer table."		: "Report"
			SUBMENU
			"All"					: "Print report of all " +
									  "customers."							: "Report/All",
			"West Coast"		: "Print report of only West " +
									"Coast customers."					: "Report/West"
			ENDSUBMENU,
		"Exit"					: "Exit this application."			: "Exit"
			SUBMENU
			"No"					: "Do not exit this application.": "Exit/No",
			"Yes"					: "Exit this application."			: "Exit/Yes"
			ENDSUBMENU
		ENDMENU

	COEDIT "\\PDOX40\\SAMPLE\\CUSTOMER"

	PROMPT "[F10] Menu"
	WAIT WORKSPACE							; let user intercat with workspace
		PROC "WaitProc"					; call procedure when user selects
		MESSAGE "MENUSELECT"				; an item from the menu
	ENDWAIT

	CLEARPULLDOWN

ENDPROC
;----------------------------------------------------------------------------



;----------------------------------------------------------------------------
;
;	SHOWTABLES dialog box - Example begins on PG 239
;
PROC Example239()
	DosPath = "\\PDOX40\\SAMPLE\\"		; specify the path
	SHOWTABLES DosPath
		"Select a table to view"			; display a prompt on screen
	TO TableVar									; assign table name to a variable

;	IF tablevar <> "Esc"						; if the user does not cancel
;		THEN VIEW DosPath + TableVar		; then view the table
;	ENDIF

ENDPROC
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;
;	SHOWFILES dialog box - Example begins on PG 240
;
PROC Example240A()
	PathName = "\\PDOX40\\SAMPLE\\"
	SHOWFILES NOEXT PathName + "*.SC"
		"select a script to edit"
	TO FileVar

	IF FileVar <> "Esc"
		THEN

		EDITOR OPEN PathName + FileVar + ".SC"
	ENDIF

ENDPROC
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;
;	SHOWARRAY dialog box - Example begins on PG 240
PROC	Example240B()

	ARRAY Choice [3]						; define array for pick list choices
		Choice[1] = "EnterData"
		Choice[2] = "PrintReport"
		Choice[3] = "Quit"

	ARRAY Description [3]				; define array for prompt descriptions
		Description[1] = "Enter data into table"
		Description[2] = "Send report on table to printer"
		Description[3] = "End this script and return to Paradox"

	SHOWARRAY Choice Description		; create the dialog box
		UNTIL 17
		KEYTO keyVar
		DEFAULT	"PrintReport"
	TO SelectionVar

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWARRAY dialog box - Example begins on PG 241
PROC	Example241()

	ARRAY Choice [3]						; define array for pick list choices
		Choice[1] = "EnterData"
		Choice[2] = "PrintReport"
		Choice[3] = "Quit"

	ARRAY Description [3]				; define array for prompt descriptions
		Description[1] = "Enter data into table"
		Description[2] = "Send report on table to printer"
		Description[3] = "End this script and return to Paradox"

	DefaultChoice = 2

	SHOWARRAY Choice Description		; create the dialog box
		UNTIL 17
		KEYTO keyVar
		DEFAULT	Choice[DefaultChoice]
	TO SelectionVar

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	simple SHOWDIALOG dialog box - Example begins on PG 244
;
PROC	Example244()

	SHOWDIALOG "Dialog Box with Push Buttons"
		@7,17 HEIGHT 9 WIDTH 44		; locataion and dimension of box

		PUSHBUTTON @5,8 WIDTH 10	; create a push button
		"~O~k"							; label it ok with O as hotkey
		OK									; specify OK as type of action
		VALUE "Accept"					; value of button as pressed
		TAG "Yes"						; name passed to proc as toggle value
		TO ButtonValue					; variable assigned with VALUE value

		PUSHBUTTON @5,23 WIDTH 10	; create a push button
			"~C~ancel"					; label it cancel with C as hot key
			CANCEL						; specify cancel as type of action
			DEFAULT						; this button is selected by default
			VALUE "Cancel"				; value of button when pressed
			TAG "No"						; name passed to procedure as tagValue
			TO ButtonValue				; variable assigned with VALUE value
	ENDDIALOG
ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWDIALOG dialog box with PICKFILE - Example begins on PG 245
;
PROC	Example245()

FileDir = "\\PDOX40\\SAMPLE\\*.SC"		; define variable to represent
													; directory where files are located
													; and filter to scripts only

SHOWDIALOG "List of scripts"				; begin dialog box definition
	@5,23 HEIGHT 14 WIDTH 31				; locataion and dimension of box

	PICKFILE @1,3 HEIGHT 8 WIDTH 22
		COLUMNS 2								; display files in two colunms
		FileDir									; directory where files exist
		NOEXT										; do not display file-name extensions
		TAG "ChosenFile"						; name passed to procedure as TagValue
		TO FileChoice							; varaible assigned with tag value

	PUSHBUTTON @10,2 WIDTH 10				; define OK push button
		"~O~k"									; label it ok with O as hotkey
		OK											; specify OK as type of action
		VALUE "Accept"							; value of button as pressed
		TAG "Yes"								; name passed to proc as toggle value
		TO ButtonValue							; variable assigned with VALUE value

	PUSHBUTTON @10,17 WIDTH 10				; define a Cancel button
		"~C~ancel"								; label it cancel with C as hot key
		CANCEL									; specify cancel as type of action
		DEFAULT									; this button is selected by default
		VALUE "Cancel"							; value of button when pressed
		TAG "No"									; name passed to procedure as tagValue
		TO ButtonValue							; variable assigned with VALUE value

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;
;	SHOWDIALOG dialog box with PICKLIST - Example begins on PG 247
;
PROC	Example247()

TableDir = "\\PDOX40\\SAMPLE\\"		; define variable to represent directory
												; where tables are located

	SHOWDIALOG "List of Tables"		; begin dialog box definition
		@5,23 HEIGHT 14 WIDTH 31		; locataion and dimension of box

		PICKTABLE @1,3 HEIGHT 8 WIDTH 22
			COLUMNS 2						; display files in two colunms
			TableDir							; directory where files exist
			TAG "ChosenFile"				; name passed to procedure as TagValue
			TO FileChoice					; varaible assigned with tag value

		PUSHBUTTON @10,2 WIDTH 10		; define OK push button
			"~O~k"							; label it ok with O as hotkey
			OK
			DEFAULT
			VALUE "Accept"
			TAG "Yes"
			TO ButtonValue

		PUSHBUTTON @10,17 WIDTH 10		; define a Cancel button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "No"
			TO ButtonValue

	ENDDIALOG
ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWDIALOG with PICKARRAY pick list - Example begins on PG 249
;
PROC	Example249()

	ARRAY RepName[7]						; create fixed array
	RepName[1] = "Whitney"           ; assign values to array
	RepName[2] = "McBride"
	RepName[3] = "Thompson"
	RepName[4] = "Lindsay"
	RepName[5] = "Lyon"
	RepName[6] = "Voss"
	RepName[7] = "Ranucci"

	SHOWDIALOG "Marketing Reps"
		@4,23 HEIGHT 13 WIDTH 30		; locataion and dimension of box

		PICKARRAY @1,7 					; create a PICKARRAY pick list
		HEIGHT 6 WIDTH 13					; dimensions of pick list
		RepName								; named of fixed array
		TAG "ArrayTag"						; name passed to procedure as TagValue
		TO ArrayElement					; variable assigned with tag value

		PUSHBUTTON @9,2 WIDTH 10		; create OK push button
		"~O~k"
		OK
		DEFAULT
		VALUE "Accept"
		TAG "AcceptTag"
		TO ButtonValue

		PUSHBUTTON @9,15 WIDTH 10		; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "CancelTag"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWDIALOG with PICKDYNARRAY pick list - Example begins on PG 251
;
PROC	Example251()

	VIEW "\\PDOX40\\SAMPLE\\CUSTOMER"		; view the customer table
	DYNARRAY	CustInfo[]							; create dynamic array

	SCAN          									; scan table into dynamic array
		CustInfo[ STRVAL([Cust ID]) ] = [Last Name]
														; use cust id as tag
	ENDSCAN											; use Last Name field as value

	CLEARIMAGE									; close customer table


	SHOWDIALOG "List of customers"		; begin dialog box definition
		@5,23 HEIGHT 14 WIDTH 31			; location and dimensions of box

		PICKDYNARRAY @1,3						; define a pickdynarray element
		HEIGHT 8 WIDTH 22						; dimensions of pick list box
		COLUMNS 2								; display picklist in two columns
		CustInfo									; name of dynamic array
		TAG "DynArrayTag"						; name passed to procedure as tagValue
		TO CustChoice							; variable assigned with tag value

		PUSHBUTTON @10,2 WIDTH 10			; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "OKTag"
			TO CustChoice

		PUSHBUTTON @10,17 WIDTH 10			; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "CancelTag"
			TO ButtonValue

	ENDDIALOG

ENDPROC


;----------------------------------------------------------------------------
;
;	SHOWDIALOG with PICKDYNARRAYINDEX pick list - Example begins on PG 252
;
PROC	Example252()

	SYSINFO TO SysDynArray				; create dynamic array with sys info

	SHOWDIALOG "System Info Tags"		; begin dialog definition
		@5,23 HEIGHT 14 WIDTH 31		; location and dimensions of box

		PICKDYNARRAYINDEX @1,3			; define a PICKDYNARRAYINDEX element
		HEIGHT 8 WIDTH 22					; dimensions of pick list box
		COLUMNS 1							; display of pick list in one column
		SysDynArray							; name of dynamic array
		TAG "DynArrayTag"					; name passed to procedure as TagValue
		TO SysChoice						; variable assigned with tag value

		PUSHBUTTON @10,2 WIDTH 10		; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "OKTag"
			TO CustChoice

		PUSHBUTTON @10,17 WIDTH 10			; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "CancelTag"
			TO ButtonValue

	ENDDIALOG

ENDPROC


;----------------------------------------------------------------------------
;
;	SHOWDIALOG with radio buttons - Example begins on PG 255
;
PROC Example255()

	SHOWDIALOG "Alert Sounds"			; define dialog box
		@6,22 HEIGHT 12 WIDTH 35		; location and dimension of box

		RADIOBUTTONS @1,4 HEIGHT 5 WIDTH 25 ; define radio buttons
			"Double high beeps",			; labels next to radio buttons
			"Double low beeps",
			"Over the rainbow",
			"Beethoven's 5th",
			"Taps"
			TAG "AlertTag"					; name passed to procedure as TagValue
			TO AlertSelection				; variable assigned with tag name

		PUSHBUTTON @8,4 WIDTH 10		; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "Yes"
			TO AlertSelection

		PUSHBUTTON @8,19 WIDTH 10		; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "No"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWDIALOG with check boxes - Example begins on PG 256
;
PROC Example256()

	TableDir = "\\PDOX40\\SAMPLE\\"		; directory where table resides

	ARRAY TabNames[6]							; create fixed array TabNames
	TabNames[1] = "Customer"
	TabNames[2] = "Orders"
	TabNames[3] = "BackOrd"
	TabNames[4] = "Employee"
	TabNames[5] = "Products"
	TabNames[6] = "Sales"

	ARRAY CheckBox[ ARRAYSIZE(TabNames) ]
	CheckBox[1] = True						; 1st check box is selected by default

	SHOWDIALOG "Tables to View"			; define dialog box
		@6,23 HEIGHT 12 WIDTH 30			; location and dimension of box

		CHECKBOXES @1,6 HEIGHT 6 WIDTH 16
			TAG "Check"							; name passed to procedure as TagValue
			TabNames[1] TO CheckBox[1],	; each check box is assigned the
			TabNames[2] TO CheckBox[2],	; value True if it is selected
			TabNames[3] TO CheckBox[3],
			TabNames[4] TO CheckBox[4],
			TabNames[5] TO CheckBox[5],
			TabNames[6] TO CheckBox[6]

		PUSHBUTTON @8,2 WIDTH 10			; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "Yes"
			TO ButtonValue

		PUSHBUTTON @8,16 WIDTH 10			; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "No"
			TO ButtonValue

	ENDDIALOG

;	If RetVal									; if dialog box was accepted
;		THEN FOR i FROM 1 TO 6				; view each table that was checked
;			If CheckBox[i] = True         ; was checked
;				THEN VIEW TableDir + TabNames[i]
;			ENDIF
;		ENDFOR
;	ENDIF

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWDIALOG with Type-in boxes - Example begins on PG 258
;
PROC Example258()

	TheName = "Type here"					; initialize the ACCEPT variable

	SHOWDIALOG "Name" @6,15 HEIGHT 10 WIDTH 50
		@ 2,8 ?? "Enter your name:"		; display a prompt on the dialog box

		ACCEPT @2,25							; specify location of type-in box
		WIDTH 15 "A10"							; specify width of type-in box
		TAG "UserName"                	; tag specified to dialog proc
		TO TheName								; ACCEPT variable initialized above

		PUSHBUTTON @5,9 WIDTH 10			; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Say Yes"
			TAG "Yes"
			TO ButtonValue

		PUSHBUTTON @5,29 WIDTH 10			; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Say No"
			TAG "No"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWDIALOG with Slider and Type-in box - Example begins on PG 260
;
PROC Example260()

	ControlVar = 20						; optional initial value for
												; SLIDER and ACCEPT variable

	SHOWDIALOG "Dialog Box with Slider"
		@7,17 HEIGHT 9 WIDTH 44			; location and dimensions of dialog box

												; create a slider
		SLIDER @1,10 HORIZONTAL LENGTH 22
			MIN 0                      ; restrict input between 0 and 40
			MAX 40
			ARROWSTEP 2						; slider changes 1 for each arrow click
			PAGESTEP 2						; slider changes 5 for each page click
			TAG "SliderTag"				; name passed to procedure as tag value
			TO ControlVar					; variable assigned with tag value

		ACCEPT @3,26 WIDTH 5				; create an ACCEPT field
			"N"
			MIN 0
			MAX 40
			TAG "AcceptTag"
			TO ControlVar					; same variable used for SLIDER and ACCEPT

		PUSHBUTTON @5,8 WIDTH 10		; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "Yes"
			TO ButtonValue

		PUSHBUTTON @5,23 WIDTH 10	; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "No"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------



;----------------------------------------------------------------------------
;
;	SHOWDIALOG with Label - Example begins on PG 261
;
PROC Example261()

	ControlVar = 20						; optional initial value for
												; SLIDER and ACCEPT variable

	SHOWDIALOG "Dialog Box with Slider"
		@7,17 HEIGHT 9 WIDTH 44			; location and dimensions of dialog box

												; create a slider
		SLIDER @1,10 HORIZONTAL LENGTH 22
			MIN 0                      ; restrict input between 0 and 40
			MAX 40
			ARROWSTEP 1						; slider changes 1 for each arrow click
			PAGESTEP 5						; slider changes 5 for each page click
			TAG "SliderTag"				; name passed to procedure as tag value
			TO ControlVar					; variable assigned with tag value

		LABEL @3,10							; create a LABEL called
			"~V~alue Entered"				; Value Entered with V as a hot key
			FOR "AcceptTag"				; TAG of control element that LABEL
												; is associated with

		ACCEPT @3,26 WIDTH 5				; create an ACCEPT field
			"N"
			MIN 0
			MAX 40
			TAG "AcceptTag"
			TO ControlVar					; same variable used for SLIDER and ACCEPT

		PUSHBUTTON @5,8 WIDTH 10		; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "Yes"
			TO ButtonValue

		PUSHBUTTON @5,23 WIDTH 10	; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "No"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWDIALOG with CANVAS elements - Example begins on PG 263
;
PROC Example263()

	SHOWDIALOG "Canvas Elements"			; show dialog box with title
		@2,6 HEIGHT 13 WIDTH 65				; location and dimension of dialog box

		FRAME SINGLE FROM 1, 1 TO 9, 61	; place a frame in the dialog box

		PAINTCANVAS BORDER ATTRIBUTE (15 + 16) 1, 1, 9, 61
													; BORDER affects a 1-column rectangle
													; attribute 15 + 16 is white on blue
													; location is on top of the frame so
													; the frame colors are white on blue

		PAINTCANVAS BORDER FILL CHR(177) 2, 2, 8, 60
													; BORDER affects a 1-column rectangle
													; fill specifies a character fill
													; location is within the frame

		STYLE ATTRIBUTE 15 + 16				; text colors will be white on blue
		@ 3,3 ?? FORMAT("W57,AC", "Alphabet Soup Orders")
		@ 4,3 ?? FORMAT("W57,AC", "Customer order was placed before January 1, 1992")

		PUSHBUTTON @6,26 WIDTH 10			; create a push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Yes"
			TAG "Accept"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	Dialog proc. arguments and trigger sequence - Example begins on PG 266
;
PROC Example266()

	ECHO NORMAL									; show user the window

													; create a window
	WINDOW CREATE @2,3 WIDTH 40 HEIGHT 8 TO DisplayWindow
	DYNARRAY DWinAttrib[]					; create dynamic array
													; specify title element
	DWinAttrib["TITLE"] = "Variables and their values"
													; change attributes
	WINDOW SETATTRIBUTES DisplayWindow FROM DWinAttrib

	SETMARGIN 2									; set left margin offset
	? "TriggerType"							; write variable names in new window
	? "TagValue"
	? "EventValue"
	? "ElementValue"
	SETMARGIN 17								; subsequent text will not overwrite
													; variable names

													; define the dialog procedure
	PROC ShowVars(TriggerType, TagValue, EventValue, ElementValue)
		@0,17 CLEAR EOS						; clear any residual values
		? "= ", TriggerType					; write variable values
		? "= ", TagValue
		? "= ", EventValue
		? "= ", ElementValue
		SLEEP 500 								; pause to view canvas window
		RETURN True								; process the event
	ENDPROC

	SHOWDIALOG "List Of Tables"			; begin definition
		PROC "ShowVars"						; procedure to execute
		TRIGGER "ALL"              		; trap for all triggers
		@7,46 HEIGHT 14 WIDTH 31			; location and dimension of dialog

		PICKTABLE @1,3 HEIGHT 8 WIDTH 22	; define a pick list
			COLUMNS 2
			"\\PDOX40\\SAMPLE\\"
			TAG "ChosenTable"
			TO TableChoice

		PUSHBUTTON @10,2 WIDTH 10			; define a push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "Yes"
			TO ButtonValue

		PUSHBUTTON @10,17 WIDTH 10			; define a push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "No"
			TO ButtonValue

	ENDDIALOG

	WINDOW SELECT DisplayWindow
	WINDOW CLOSE


ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	Dialog box displaying current system time - Example begins on PG 268
;
PROC Example268()

	PROC RepaintProc(TriggerType, TagValue, EventValue, ElementValue)
		REPAINTDIALOG							; repaaint the dialog canvas
		RETURN True
	ENDPROC

	SHOWDIALOG "Current Time"				; begin definition
		PROC "RepaintProc" IDLE				; execute procedure on idle
		@ 4,26 HEIGHT 11 WIDTH 24			; location and dimension of box

		@ 3, 6 ?? FORMAT( "W10,AC",TIME() )			; display the current time
		PAINTCANVAS BORDER FILL CHR(219) 1,5,5,16 ; place a border around time
		PAINTCANVAS ATTRIBUTE 15+16 2, 6, 4, 15 	; box interior white on blue

		PUSHBUTTON @7,6 WIDTH 10			; place an OK button
			"~O~k"
			OK
			DEFAULT
			VALUE "Yes"
			TAG "OKTag"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	Dialog box Using the RESYNCCONTROL command - Example begins on PG 269
;
PROC Example269()

	PROC SliderProc(TriggerType, TagValue, EventValue, ElementValue)
		IF TriggerType = "UPDATE"			; make sure trigger type is update
		THEN
			IF TagValue = "SliderTag" OR TagValue = "AcceptTag"
													; if SLIDER or ACCEPT has focus
			THEN
				ControlVar = EventValue		; then assign ACCEPT and SLIDER vars
				RESYNCCONTROL "SliderTag"	; to value of new selection and
				RESYNCCONTROL "AcceptTag"	; update SLIDER and ACCEPT controls
				RETURN True						; Process the UPDATE trigger
			ENDIF
		ENDIF
		RETURN True
	ENDPROC

	ControlVar = 20

	SHOWDIALOG "Dialog Box with Slider"
		PROC "SliderProc" TRIGGER "UPDATE" 	; trap for update triggers
		@ 7,17 HEIGHT 9 WIDTH 44				; location and dimension of box

		SLIDER @1,10 HORIZONTAL LENGTH 22	; create a slider
			MIN 0
			MAX 40
			ARROWSTEP 1
			PAGESTEP 5
			TAG "SliderTag"
			TO ControlVar

		LABEL @3,10									; create a label
			"~V~alue Entered"
			FOR "AcceptTag"

		ACCEPT @3,26 WIDTH 5						; create an ACCEPT type-in box
			"N"
			MIN 0
			MAX 40
			TAG "AcceptTag"
			TO ControlVar

		PUSHBUTTON @5,8 WIDTH 10		; create an ok push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "Yes"
			TO ButtonValue

		PUSHBUTTON @5,23 WIDTH 10		; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "No"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	Dialog Box Using the RESYNCDIALOG command - Example begins on PG 273
;
PROC Example273()

	PROC DialogProc(TriggerType, TagValue, EventValue, ElementValue)
											; proc is only called on an update trigger

	IF TagValue = "PickTag" OR		; if pickfile list is updated or
		TagValue = "AcceptTag"		; if accept field is updated
		THEN
			FileName = EventValue	; then assign ACCEPT and PICKFILE vars
			RESYNCDIALOG				; to value of new selection and
											; update PICKFILE and ACCEPT controls
											; since there variables have changed
		ENDIF
		RETURN True						; process the updated event
	ENDPROC

	SHOWDIALOG "List of Files"
		PROC "DialogProc"
		TRIGGER "UPDATE"
		@4,22 HEIGHT 16 WIDTH 39

		@ 10,3 ?? "Selected File:"

		PICKFILE @1,2 HEIGHT 8 WIDTH 32
			COLUMNS 2
			"\\PDOX40\\SAMPLE\\*.*"
			TAG "PickTag"
			TO FileName

		ACCEPT @10,19 WIDTH 15
			"A12"
			TAG "AcceptTag"
			TO FileName

		PUSHBUTTON @12,5 WIDTH 10
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "OKTag"
			TO ButtonValue

		PUSHBUTTON @12,21 WIDTH 10		; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "CancelTag"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	Dialog box Using the SELECTCONTROL command - Example begins on PG 274
;
PROC Example274()

	PROC DialogProc(TriggerType, TagValue, EventValue, ElementValue)
														; proc is only called when
														; dialog is accepted
		IF ISBLANK(IDNumber)						; if user left type-in box empty
			THEN MESSAGE "Enter credit card number"
				SLEEP 1500
				MESSAGE ""
				SELECTCONTROL "AcceptTag"		; place cursor on type-in box
				RETURN False
			ELSE RETURN True
		ENDIF
	ENDPROC

	PayMethod = 1									; select 1st radio button as default
	SHOWDIALOG "Method of payment"
		PROC "DialogProc" TRIGGER "ACCEPT"	; trap for accent trigger
		@6,22 HEIGHT 14 WIDTH 35

		RADIOBUTTONS @1,4 HEIGHT 4 WIDTH 25	; create a bank of radio buttons
			"Visa",
			"MasterCard",
			"American Express",
			"Diners Club"
			TAG "PayType"
			TO PayMethod

		LABEL @6,6									; create a label
			"~E~nter credit card#"
			FOR "AcceptTag"

		ACCEPT @7,6 WIDTH 21						; create an ACCEPT type-in box
			"A10"
			TAG "AcceptTag"
			TO IDNumber

		PUSHBUTTON @10,4 WIDTH 10				; create an ok push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "OKTag"
			TO ButtonValue

		PUSHBUTTON @10,19 WIDTH 10				; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "CancelTag"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	Dialog box using the REFRESHCONTROL command - Example begins on PG 276
;
PROC Example276()

	PROC DialogProc(TriggerType, TagValue, EventValue, ElementValue)
														; proc is only called ON
														; update trigger

		IF TagValue = "DirTag"					; if the ACCEPT type-in box changes
			THEN DirString = EventValue   	; reassign variable after it changes
				REFRESHCONTROL "PickFileTag"	; refresh pick lists using the new
														; directory specifiction
		ENDIF											; such as either push button
		RETURN True									; process update event
	ENDPROC

	DirString = "\\PDOX40\\SAMPLE\\"			; initial value for ACCEPT
														; type-in box

	SHOWDIALOG "Pick List in any Directory"
		PROC "DialogProc" 						; procedure name to execute
		TRIGGER "UPDATE"        				; call procedure for UPDATE trigger
		@3,16 HEIGHT 14 WIDTH 45
		@1,8 ?? "Scripts                Tables"

		PICKFILE @1,4 HEIGHT 6 WIDTH 35		; create a pick list
			COLUMNS 2
			DirString
			TAG "PickFileTag"
			TO FileName

		LABEL @8,4									; create a label forthe pick list
			"~D~irectory: "
			FOR "DirTag"

		ACCEPT @8,18 WIDTH 21					; create a pick list of tables
			"A20"
			TAG "DirTag"
			TO DirString

		PUSHBUTTON @10,9 WIDTH 10				; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "OKTag"
			TO ButtonValue

		PUSHBUTTON @10,26 WIDTH 10				; create a CANCEL push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "CancelTag"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	Using the REFRESHDIALOG command - Example begins on PG 278
;
PROC Example278()

	PROC DialogProc(TriggerType, TagValue, EventValue, ElementValue)
												; proc is only called on update trigger

		IF TagValue = "DirTag"			; if the ACCEPT type-in box changes
			THEN
			DirString = EventValue		; reassign variable after it changes
			REFRESHDIALOG					; refresh both pick lists using
		ENDIF									; the new directory specification
		RETURN True							; process the event whenever an
												; update trigger is generated
	ENDPROC

	DirString = "\\PDOX40\\SAMPLE\\"	; initial value for ACCEPT type-in box

	SHOWDIALOG "Two Pick Lists in One Directory"
		PROC "DialogProc" 				; procedure name to execute
		TRIGGER "UPDATE"					; call procedure for UPDATE trigger
		@3,15 HEIGHT 15 WIDTH 48
		@1,8 ?? "Scripts                Tables"

		PICKFILE @2,2						; create a pick list
			HEIGHT 6 WIDTH 19
			DirString + "*.SC"			; display scripts in the pick list
			TAG "PickFileTag"
			TO FileName

		PICKTABLE @2,24
			HEIGHT 6 WIDTH 19				; create a pick list of tables
			DirString + "*.SC"
			TAG "PickTableTag"
			TO TableName

		LABEL @9,3							; create a label for the pick list
			"~D~irectory: "
			FOR "DirTag"

		ACCEPT @9,18 WIDTH 24			; create an ACCEPT type-in box
			"A18"
			TAG "DirTag"
			TO DirString

		PUSHBUTTON @11,9 WIDTH 10		; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "OKTag"
			TO ButtonValue

		PUSHBUTTON @11,26 WIDTH 10		; create a CANCEL push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "CancelTag"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	Using the ACCEPTDIALOG command - Example begins on PG 279
;
PROC Example279()

	PROC SelectProc(TriggerType, TagValue, EventValue, ElementValue)
		ACCEPTDIALOG
;		VIEW TableDir + TableName
	ENDPROC

	TableDir = "\\PDOX40\\SAMPLE\\"

	SHOWDIALOG "List of Tables"		; begin dialog box definition
		PROC "SelectProc" 				; name of procedure to execute
		TRIGGER "SELECT", "ACCEPT"		; call procedure for SELECT and ACCEPT
		@4,24 HEIGHT 15 WIDTH 29		; locations and dimensions of dialog box

		PICKTABLE @1,6 					; create a pick table
			HEIGHT 8 WIDTH 14
			TableDir
			TAG "TableTag"
			TO TableName

		PUSHBUTTON @11,2 WIDTH 10		; create an ok push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "OKTag"
			TO ButtonValue

		PUSHBUTTON @11,14 WIDTH 10		; create a Cancel push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "CancelTag"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	Using the CANCELDIALOG command - Example begins on PG 280
;
PROC Example280()

	PROC DialogProc(TriggerType, TagValue, EventValue, ElementValue)
		IF TriggerType = "EVENT"		; if proc called for Ctrl-Q
			THEN CANCELDIALOG				; then cancel dialog
			ELSE ACCEPTDIALOG				; otherwise accept dialog
		ENDIF
	ENDPROC

	TableDir = "\\PDOX40\\SAMPLE\\"

	SHOWDIALOG "List of Tables"		; begin definition
		PROC "DialogProc" 				; name of procedure to execute
		KEY 17								; trap for Ctrl-Q to cancel
		@4,24 HEIGHT 15 WIDTH 29		; location and dimension of box

		PICKTABLE @1,6 					; create a pick table
			HEIGHT 8 WIDTH 14
			TableDir
			TAG "TableTag"
			TO TableName

		PUSHBUTTON @11,2 WIDTH 10		; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "OKTag"
			TO ButtonValue

		PUSHBUTTON @11,14 WIDTH 10		; create a CANCEL push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "CancelTag"
			TO ButtonValue

	ENDDIALOG

	IF RetVal										; RetVal is True if Dialog accepted
		THEN VIEW TableDir + TableName		; if RetVal = True view the table
		ELSE
			MESSAGE "Canceling dialog..."		; otherwise display message
			SLEEP 1000
	ENDIF

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	Using the NEWDIALOGSPEC command - Example begins on PG 281
;
PROC Example281()

	PROC DialogProc(TriggerType, TagValue, EventValue, ElementValue)
		IF TagValue = "LowerTag"
		THEN SWITCH
			CASE TriggerType = "ARRIVE" :						; ARRIVE trigger changes
				NEWDIALOGSPEC TRIGGER "DEPART" KEY "ALL"  ; the event list
			CASE TriggerType = "DEPART" :						; DEPART restores
				NEWDIALOGSPEC TRIGGER "ARRIVE"				; original event list
			CASE TriggerType = "EVENT" :						; keypress processed
				IF EventValue["KEYCODE"] <= 90 AND			; if keycode between 90
					EventValue["KEYCODE"] >= 65 				; and 65 (upper case)
				THEN													; make it lower case
					EventValue["KEYCODE"] =
						ASC( LOWER( CHR( EventValue["KEYCODE"] ) ) )
					RELEASE VARS EventValue["SCANCODE"]		; release scancode so
																		; it does not conflict
				ENDIF													; with keycode
			ENDSWITCH
		ENDIF
		RETURN True													; execute the event
	ENDPROC

	SHOWDIALOG "Two type-in boxes"
		PROC "DialogProc" TRIGGER "ARRIVE"
		@4,22 HEIGHT 14 WIDTH 35

		@1,5 ?? "This box ignores cases:"
		@5,5 ?? "This box makes text"
		@6,5 ?? "appear as lower case:"

		ACCEPT @2,5 WIDTH 23							; create an ACCEPT type-in box
			"A21"
			TAG "FirstTag"
			TO FirstValue

		ACCEPT @7,5 WIDTH 23							; create an ACCEPT type-in box
			"A21"
			TAG "LowerTag"
			TO LowerValue

		PUSHBUTTON @10,4 WIDTH 10					; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "OKTag"
			TO ButtonValue

		PUSHBUTTON @10,19 WIDTH 10					; create a CANCEL push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "CancelTag"
			TO ButtonValue

	ENDDIALOG

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	Using the CONTROLVALUE function - Example begins on PG 283
;
PROC Example283()

	PROC DialogProc(TriggerType, TagValue, EventValue, ElementValue)
		IF TagValue = "AcceptTag" AND					; if current control is
			NOT ISBLANK( CONTROLVALUE(TagValue) )	; the type-in box, and
																; and it's not blank
			THEN												; find first record with
																; the type-in box value
				LOCATE PATTERN CONTROLVALUE(TagValue) + ".."
				IF RetVal
					THEN
						WINDOW CREATE FLOATING @4,25 HEIGHT 5 WIDTH 42 TO HelpWin
						@1,1 ?? [Help]						; display text in a window
						MESSAGE "Press any key when done"
						GETEVENT KEY "ALL" TO RetVal	; eat the next key event
						WINDOW CLOSE
						MESSAGE ""
					ELSE
						MESSAGE "No help available."	; locate failed, inform user
						SLEEP 1500
						MESSAGE ""
				ENDIF
				RETURN False					; don't let Paradox process the F1 key
			ELSE
				MESSAGE "No help for blank fields"
				SLEEP 1500
				MESSAGE ""
				RETURN True						; let Paradox process the F1 key
		ENDIF
	ENDPROC

	VIEW "Orgchart"							; table with [Dept] and [Help] fields
	MOVETO FIELD "Dept"

	SHOWDIALOG "Data-sensitive help"
		PROC "DialogProc"						; procedure name to execute
		KEY "F1"									; call procedure when F1 key pressed
		@6,8 HEIGHT 11 WIDTH 40

		@1,0 ?? FORMAT("W38,AC", "Enter all or part of Dept name")
		@2,0 ?? FORMAT("W38,AC", "Press [F1] for help")

		ACCEPT @4,9 WIDTH 20					; create an ACCEPT type-in box
			"A12"
			TAG "AcceptTag"
			TO SearchString

		PUSHBUTTON @7,5 WIDTH 10			; create an OK push button
			"~O~k"
			OK
			DEFAULT
			VALUE "Accept"
			TAG "OKTag"
			TO ButtonValue

		PUSHBUTTON @7,22 WIDTH 10			; create a CANCEL push button
			"~C~ancel"
			CANCEL
			VALUE "Cancel"
			TAG "CancelTag"
			TO ButtonValue

	ENDDIALOG

	WINDOW CLOSE

ENDPROC
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;
;	SHOWMENU - Example begins on PG 225
;
PROC Example225A()
	SHOWMENU
		"EnterData"			:	"Enter data into table.",
		"PrintReport"		:	"Send report on table to printer.",
		"Quit"				:  "End this script and return to Paradox."
		DEFAULT "PrintReport"
	TO MenuSelection
ENDPROC
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;
;	SHOWMENU with UNTIL pop-up - Example begins on PG 225
;
PROC Example225B()

	SHOWMENU
		"Enter Data"		:	"Enter data into table.",
		"Print Report"		:	"Send report on table to printer.",
		"Quit"				:  "End this script and return to Paradox."
		UNTIL 17
		KEYTO KeyVar
		DEFAULT "Print Report"
	TO MenuSelection

ENDPROC
;----------------------------------------------------------------------------




PROC ChooseExample()

	i = 1
	ARRAY ExName[35]
	ARRAY ExDesc[35]

	PROC Set(ProcName, Desc, Loc)
		ExName[i] = ProcName
		ExDesc[i] = "PG " + Loc + " - " + Desc
		i = i + 1
	ENDPROC

;----------------------------------------------------------------------------
;	Chapter 14, Creating Menus
;
	Set("Example225A",	"SHOWMENU",									"225")
	Set("Example225B",	"SHOWMENU with UNTIL",					"225")
	Set("Example226A",	"SHOWMENU with EXECPROC",				"226")
	Set("Example226B",	"SHOWMENU with SWITCH",					"226")
	Set("Example228",		"SHOWPOPUP Two Level Menu",			"228")
	Set("Example231",		"SHOWPULLDOWN Menu",						"231")
	Set("Example232",		"SHOWPULLDOWN and GETEVENT Menu",	"232")
	Set("Example232",		"SHOWPULLDOWN and WAIT Menu",			"234")
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;	Chapter 15, Creating dialog boxes
;
	Set("Example239",		"SHOWTABLES Dialog box",				"239")
	Set("Example240A",	"SHOWFILES Dialog box",					"240")
	Set("Example240B",	"SHOWARRAY Dialog box",					"240")
	Set("Example241", 	"SHOWARRAY Dialog box",					"241")
	Set("Example244", 	"SHOWDIALOG Dialog box",				"244")

	Set("Example245", 	"SHOWDIALOG with PICKFILE",			"245")
	Set("Example247", 	"SHOWDIALOG with PICKLIST",			"247")
	Set("Example249", 	"SHOWDIALOG with PICKARRAY",			"249")
	Set("Example251", 	"SHOWDIALOG with PICKDYNARRAY",		"251")
	Set("Example252", 	"SHOWDIALOG with PICKDYNARRAYINDEX","252")

	Set("Example255", 	"SHOWDIALOG with RADIOBUTTONS",		"255")
	Set("Example256", 	"SHOWDIALOG with CHECKBOXES",			"256")
	Set("Example258", 	"SHOWDIALOG with ACCEPT",				"258")
	Set("Example260", 	"SHOWDIALOG with Slider and ACCEPT","260")
	Set("Example261", 	"SHOWDIALOG with LABEL",				"261")

	Set("Example263", 	"SHOWDIALOG with CANVAS",				"263")
	Set("Example266", 	"SHOWDIALOG with TRIGGER",				"266")
	Set("Example268", 	"SHOWDIALOG with REPAINTDIALOG",		"268")
	Set("Example269", 	"SHOWDIALOG with RESYNCCONTROL",		"269")
	Set("Example273", 	"SHOWDIALOG with RESYNCDIALOG",		"273")

	Set("Example274", 	"SHOWDIALOG with SELECTCONTROL",		"274")
	Set("Example276",		"SHOWDIALOG with REFRESHCONTROL",	"276")
	Set("Example278",		"SHOWDIALOG with REFRESHDIALOG",		"278")
	Set("Example279",		"SHOWDIALOG with ACCEPTDIALOG",		"279")
	Set("Example280",		"SHOWDIALOG with CANCELDIALOG",		"280")

	Set("Example281",		"SHOWDIALOG with NEWDIALOGSPEC",		"281")
	Set("Example283",		"SHOWDIALOG with CONTROLVALUE",		"283")
;----------------------------------------------------------------------------

	ExChoice = 1

	PROC Choose()

		ButtonValue = "Cancel"

		SHOWDIALOG "Paradox Examples"			; begin dialog definition
			@5,10 HEIGHT 14 WIDTH 55			; location and dimensions of box

			PICKARRAY @1,3							; define a pickdynarray element
				HEIGHT 8 WIDTH 45					; dimensions of pick list box
				COLUMNS 1							; display picklist in one column
				ExDesc								; name of dynamic array
				TAG "DynArrayTag"					; name passed to procedure as tagValue
				TO ExChoice							; variable assigned with tag value



			PUSHBUTTON @10,11 WIDTH 10			; create an OK push button
				"~O~k"
				OK
				DEFAULT
				VALUE "Accept"
				TAG "OKTag"
				TO ButtonValue

			PUSHBUTTON @10,30 WIDTH 10			; create a CANCEL push button
				"~C~ancel"
				CANCEL
				VALUE "Cancel"
				TAG "CancelTag"
				TO ButtonValue
		ENDDIALOG
		RETURN ButtonValue
	ENDPROC

	WHILE Choose() <> "Cancel"
		MESSAGE strval(ExChoice) + " " + ButtonValue
		EXECPROC ExName[ExChoice]
	ENDWHILE

ENDPROC

	ChooseExample()					; process all menu selections ...

