;  Last Update: 12/06/88  10:25am
;  Script to Convert Paradox 3.0 file to WordPerfect 4.2 or 5.0 Merge File Format
;  Tom McNally
;

Proc storefieldnames()         ; This procedure stores fieldnames from
private startime, endtime      ; the selected table and transfers them
MOVETO tablename               ; to the temp table: CONWP50
Array x[fields]                ; also returns estimated conversion time
num = 1
startime = numval(substr(Time(),4,2))
For i from 1 to fields
   right
   x[num] = field()
   MOVETO "conwp50"
   IF fields - num > 0 THEN
       typein strval(x[num]) +""    ; Add ^R character for each Field
   ELSE                                ; in Record
       typein strval(x[num]) +""    ; Add ^E character following each
   ENDIF                               ; Record
   DOWN
   num=num+1
   MOVETO tablename                    ; Selected Table variable
Endfor
endtime = numval(substr(Time(),4,2))
If endtime - startime <= 0 THEN
   endtime = endtime + 60
Endif
elapsed = ((endtime-startime)/60 * recs)/60

num = num + 1
Endproc


Proc Scanfile()                ; This proc scans selected table and
MOVETO tablename               ; transfers records to temp table for
Scan                           ; later exporting
   Copytoarray a
   Array z[fields]
   numa = 1
   numz = 1
   FOR i from 1 to fields-1
       z[numz] = strval(a[x[numa]]) + ""
       MOVETO "conwp50"
       Typein z[numz]
       down
       MOVETO tablename
       numa = numa + 1
       numz = numz + 1
   ENDFOR
   z[numz] = strval(a[x[numa]]) + ""
   MOVETO "conwp50"
   Typein z[numz]
   down
   MOVETO tablename
   MESSAGE "Processing Record #: " + strval(Recno())
ENDSCAN
DO_IT!
Endproc

@0,0 CLEAR EOS
CLEARALL
TEXT

   This Script will Convert a Paradox 3 Table into a WordPerfect 5.0
   Merge Format (Each Field in the Record Separated by a ^R; Each Record
   Separated by a ^E with Line Feeds added).  You should run a Query First
   to designate which field(s) and which records from your database you
   wish to convert.  Also, you will probably wish to use Paradox's sorting
   power to sort your table listing before converting the file.

   The script will accept any Paradox Table, and any combination of field
   types.  The maximum size for a translated field is 78 characters.  This
   can be easily modified by changing the field size specifier for the temp
   file.  Fields that are numeric are translated according to how you have
   the field formatted.  Calculated fields I think translate to 6 decimal
   digits.  Should you wish to customize this script, you can add a formatting
   procedure to ensure you receive correct results according to the field type
   in the table.

   Use WP's Text In/Text Out function to edit the file. The first record will
   display the field names of the table, followed by each successive record
   in the table.  Conversion is slow but sure.  If you have expanded memory
   conversion will probably go faster.  Also, you can probably optimize the
   program better than I have.

Endtext
CURSOR OFF
WHILE CHARWAITING()
   x = GETCHAR()
ENDWHILE
Sleep 2000
MESSAGE "Press any key to continue..."
x = GETCHAR()
CURSOR Normal
Clear
@0,0 CLEAR EOS
a = directory()
? "Enter directory where Paradox 3 Table is to be found"
? ""
?? "Directory (from): "
Style Reverse
Accept "A40" Picture "*[?[*@]]" Default a TO mydir
If mydir = "" THEN
   @0,0 Clear EOS
   Return
Endif
IF Direxists(mydir)=1 THEN
   Oldirect = Directory()
   Setdir(mydir)
ELSE
   BEEP
   Message "Directory " + mydir + "Does not Exist"
   Sleep 2000
   Return
ENDIF
@0,0 CLEAR EOS
Showtables mydir
   "Choose table you wish to convert to WordPerfect Merge Format"
   TO tablename
? ""
? ""
Style
?? "Enter file name for converted Paradox3 file"
?  "Use full pathname (c:\\subdir\\myfile.txt) use double \\'s"
?
?? "File Name: "
Style Reverse
Accept "A40" Picture "*[?[*@]]" Default tablename + ".txt" TO newfile
If newfile = "" THEN
   @0,0 Clear EOS
   Return
Endif
Style
IF Istable("conwp50") Then
   Delete "conwp50"
Endif
Create "conwp50" "Name":"A78"      ; Create Temporary table, max field size
                                   ; is 78 characters--to change include a
                                   ; larger number
recs = nrecords(tablename)
fields = nfields(tablename)
IF recs < 1 THEN
   Beep
   Message tablename + "Contains No Records"
   Sleep 1000
   CURSOR OFF
   WHILE CHARWAITING()
       x = GETCHAR()
   ENDWHILE
   Sleep 2000
   MESSAGE "Press any key to continue..."
   x = GETCHAR()
   CURSOR Normal
   Clear
   @0,0 CLEAR EOS
   Return
Endif
Style Reverse
@12,24 ?? "Conversion In Process, Please Wait..."
Style
View tablename
Edit "conwp50"
Storefieldnames()                     ; Transfer Field Names to Convert Table
@14,10 ?? "Estimated Time for Converting " + strval(recs) + " Records = " + strval(format("W6.2", elapsed)) + " Minutes"
@16,25 ?? "Do you wish to Continue? "
Style Reverse
Accept "A3" Picture "Yes,No" Default "Yes" to myresp
@16,0 Clear EOS
Style
If myresp = "No" Then                 ; Check to see if still convert
   Canceledit
   Delete "conwp50"
   Message "Exiting Conversion Program"
Else
   Scanfile()                         ; Transfer the rest of the table
   confile = "{"+ newfile +"}"
   exportfile = "{Tools} {ExportImport} {Export} {Ascii} {Text} {conwp50} " + confile
   Message "Converting Files to WP Merge Format"
   Execute exportfile                 ; Execute export routine
   Delete "conwp50"                   ; Delete the Temp table
   Message "Conversion Complete"
Endif
Sleep 1000
Setdir(Oldirect)                      ; Return to original directory

;  Release variables and return control to calling program or Paradox Menu

Release Vars x, y, z, num, tablename, newfile, confile, exportfile, recs,
fields, numa, numz, oldirect, mydir, elapsed, myresp
Release Procs storefieldnames, scanfile
Clearall
@0,0 Clear EOS
Return
