;
; COMPOSE()
;
; I maintain a subscription database in Paradox with many European
; address and hence need to enter a lot of accented characters.
; Rather than try to remember all of the ASCII codes, I've written a
; very simple "compose" key procedure and assigned it to Ctrl-W with
; SETKEY. It is similar to the compose key in WordPerfect (Ctrl-V),
; although it is considerably more limited in scope. Naturally, the
; exact character mappings depend on the code page you have loaded.
;
; You'll notice that you can type the basic characters and their
; accents in any order. Because it uses ACCEPT, you have to press
; RETURN to get the composite character but this also allows you to
; modify the cursor line as you type.
;
; No fancy programming here: just one big SWITCH statement.
;
; Dedicated to all international PAL users!
;
;
;
; Colin Brace
; Amsterdam, The Netherlands
; CIS: 70023,1164
;
;.........................................................

proc compose()
  if sysmode() <> "CoEdit"          ; only works in coedit mode
    then
      beep
    return
  endif
synccursor                        ; synchronize cursor position
style attribute 031               ; change background at cursor
accept "A2" to g
style
  switch
    case g = "'e"   : ""
    case g = "e'"   : ""

    case g = "e`"   : ""
    case g = "`e"   : ""

    case g = "c,"   : ""
    case g = ",c"   : ""

    case g = "\"u"   : ""
    case g = "u\""   : ""

	case g = "a^"   :  ""
	case g = "^a"   :  ""

    case g = "\"a"   :  ""
    case g = "a\""  :  ""

	case g = "`a"   :  ""
	case g = "a`"   :  ""

	case g = "a@"   :  ""
	case g = "@a"   :  ""

    case g = "c,"   :  ""
    case g = ",c"   :  ""

    case g = "e^"   :  ""
    case g = "^e"   :  ""

    case g = "e\""  :  ""
    case g = "\"e"   :  ""

    case g = "e`"   :  ""
    case g = "`e"   :  ""

    case g = "i\""  :  ""
    case g = "\"i"   :  ""

    case g = "i^"   :  ""
    case g = "^i"   :  ""

    case g = "A\""  :  ""
    case g = "\"A"   :  ""

    case g = "A@"   :  ""
    case g = "@A"   :  ""

    case g = "E'"   :  ""
    case g = "'E"   :  ""

	case g = "ae"   :  ""

	case g = "AE"   :  ""

	case g = "^o"   :  ""
	case g = "o^"   :  ""

    case g = "\"o"   :  ""
    case g = "o\""  :  ""

	case g = "`o"   :  ""
	case g = "o`"   :  ""

	case g = "o^"   :  ""
	case g = "^o"   :  ""

	case g = "u`"   :  ""
	case g = "`u"   :  ""

    case g = "ij"   :  ""

    case g = "\"O"  :  ""
    case g = "O\""  :  ""

    case g = "\"U"  :  ""
    case g = "U\""  :  ""

	case g = "cc"   :  ""
	case g = "ll"   :  ""
	case g = "yy"   :  ""
	case g = "ff"   :  ""

    case g = "a'"   :  ""
    case g = "'a"   :  ""

    case g = "'i"   :  ""
    case g = "i'"   :  ""

    case g = "o'"   :  ""
    case g = "'o"   :  ""

    case g = "'u"   :  ""
    case g = "u'"   :  ""

    case g = "~n"   :  ""
    case g = "n~"   :  ""

    case g = "~N"   :  ""
    case g = "N~"   :  ""

	case g = "a_"   :  ""
	case g = "_a"   :  ""

	case g = "o_"   :  ""
	case g = "_o"   :  ""

	case g = "??"   :  ""

	case g = "12"   :  ""
	case g = "14"   :  ""

    case g = "C,"   :  ""
    case g = ",C"   :  ""

    case g = "/o"   :  ""
    case g = "o/"   :  ""

    case g = "oo"   :  ""

    case g = "ss" : ""

  endswitch
endproc

;--- Just for test purposes:

setkey 23 compose()               ; place it under Ctrl-W


