; CLAWUTIL.SC - Developer utilities to accompany the CLAW Library

; Copyright (c) 1988-92, Craig L. Jones.  All rights reserved.

; This script provides four distinct functions for the development
; of PAW applications:
;
; - A way to convert multi-action objects to PAL code so that you can
;   add more flow control than a simple quit-if-action-fails.
; - A quick patch for the PAW library to replace the silly implementation
;   of PPP_PrinterReady_L()
; - A way to quickly add a new object type of "RETURN" to the Workshop's
;   Master Object table.  This allows the creation of applications that
;   are able to return control to their startup scripts (see the
;   CLAW_RunMenu proc)
; - A way to automatically create help objects for all menu items that
;   do not currently have a help object defined.  (Registered version only.)

Version_A = "1.0 D"
AutoLib = SDIR()+"CLAW"


;--------------------------------------------------------------------
   While True
     Clear ;the screen
     PaintCanvas Attribute 30 0,0,2,79
     Style Attribute 30
     @ 1,0 ?? "\"The CLAW\" for Paradox/DOS 4.0 - (c) 1993, Craig L. Jones.  All rights reserved."
     @ 21,30 ?? " Press Esc to exit. "
     Style
     ClearAll
     ShowPopup " CLAW Utilities - version "+Version_A+" " Centered
       "Change Directory":"Switch to another directory to work in.":"CD",
       "Multi-Action -> PAL":"Convert a multi-action object to PAL code.":"MultiPAL",
       "Help System ~G~enerator":"Create a help object for every menu selection currently without one.":"HelpGen",
       "Define ~R~eturn Object":"Create a new \"Return\" object.":"RetObj",
       "Rewrite ~P~rinterReady":"Overwrite the default Workshop PrinterReady routine.":"PReady",
       Separator,
       "Help ":"Get help using the CLAW Utilities":"Help",
       "About CLAW":"Display information about this version of The CLAW":"About"
       EndMenu
     To Function_A
     If RetVal=False Then
       SetCanvas Default
       Clear
       Return
     EndIf
     Clear

     Switch
     Case Function_A = "CD":
       CLAW_SetDir()
     Case Function_A = "MultiPAL":
       CLAW_MultiPAL_U()
    Case Function_A = "HelpGen":
      CLAW_AutoHelp_U()
     Case Function_A = "PReady":
       CLAW_PrinterReadyUpdt_U()
     Case Function_A = "RetObj":
       CLAW_ReturnObjAdd_U()
     Case Function_A = "About":
       CLAW_About_U()
     Case Function_A = "Help":
       Clear
       Style Attribute 30
       @0,0 ?? Format("W80,AC","The Claw Utilities")
       Style
       @1,0
       Text
These utilities are for preparing & manipulating your Workshop applications.
Some of them only need to be used once.  Others may be useful many times over.  The utilities are as follows:

Change Directory    - Changes the current directory.  You will need to do this
                      if you want to work on an app in another directory.

Multi-Action -> PAL - Gives you a list of all of the multi-action objects that
                      are to be found in CFG\OBJECTS.DB in the current subdir.
                      If you fill in a proc name next to any or all of the
                      M/A objects found, then this utility will create the
                      equivalent PAL code for that object.

Help Gen            - Builds the basis for a complete help system for your
                      application including: (a) generating a primary help
                      object for every menu item, (b) optionally generating
                      a secondary help object to go with each primary help
                      object, (c) optionally generates 7 general help objects
                      such as a help index, help with the Paradox keystrokes,

                      (more)
       EndText
       Style Attribute 30
       @ 24,27 ?? " Press any key to continue. "
       Style
       GetEvent Key "ALL" Mouse "DOWN" To Event_Y
       If Event_Y["TYPE"]="MOUSE" Then ; catch the release too
         GetEvent Mouse "UP" To Event_Y
       EndIf
       Clear
       Style Attribute 30
       @0,0 ?? Format("W80,AC","The Claw Utilities")
       Style
       @1,0
       Text
Help Gen (cont.)    - and help with using the mouse.  All help objects are
                      automatically cross-referenced.  (Note: this option
                      is not available in the shareware version.)

Return Object       - Creates a new "Return" object and places it in the
                      master object table.  The default is to only affect the
                      copy of the master object table in the current subdir, but
                      you can explicitly reference the copy in the directory
                      where Paradox 4.0 is installed.

PrinterReady        - Overwrites the default Workshop PrinterReady routine so
                      that your users will not be bothered by that pesky
                      question about whether or not the printer is ready.  (If
                      the printer isn't ready, it will still be trapped.)

See the CLAW.DOC documentation for further details.
       EndText
       Style Attribute 30
       @ 24,27 ?? " Press any key to continue. "
       Style
       GetEvent Key "ALL" Mouse "DOWN" To Event_Y
       If Event_Y["TYPE"]="MOUSE" Then ; catch the release too
         GetEvent Mouse "UP" To Event_Y
       EndIf
       Clear

     EndSwitch
   EndWhile
   SetCanvas Default
   Clear
