; 
; Program Name - IPRS
;  Script Name - Utility2.sc
; Library Name - Global.lib
;
; This script contains processes that are used by the Built-in Calculator:
;
;        CalculatorShell    - Main shell for the Built-in Calculator
;
;        Calculator.Constructor
;        Calculator.Destructor
;        Calculator.Dialog
;        Calculator!MakeExplain
;        Calculator!ViewExplain
;        Calculator!ViewTape
;        Calculator!PrintTape
;        Calculator!KeyPadModeLine
;        Calculator!TapeModeLine
;        Calculator!DialogProc
; 

; libname = "Libs\\global"
libname = "Calc"

; 
; CalculatorShell
;
; - Main shell for the Built-in Calculator
;
;        Author - Steven Green
; Creation Date - 11/03/93
; Last Modified - 09/26/94
;   Modified by - Steven Green
;  Changes Made - un-comment line 395 of this script
;
; This process calls the Built-in Calculator and, optionally, places the value
; returned by that process into the current field
;
; EXTERNAL VARIABLES MODIFIED
;        pass.calculat.var - flag variable in DialogProc
; 

PROC CalculatorShell()
     PRIVATE Calculator.Value,
             wasvar

Calculator.Constructor()

IF Calculator.Dialog() THEN

   IF ((SYSMODE() = "Edit") OR (SYSMODE() = "CoEdit")) AND
      (IMAGETYPE() = "Display") THEN

      SWITCH

            ; Value is going back to a Dialog ACCEPT that uses a number

            CASE ISASSIGNED(pass.calculat.var) :

                 pass.calculat.var = Calculator.Value

            ; Current field is a Number, Money, or Short Integer field

            CASE (SEARCH(FIELDTYPE(),"$NS") > 0) :

                 ; Save the original value from the field.

                 wasval = []
                 CTRLBACKSPACE

                 ; Put the new value in the field.

                 IF FIELDTYPE() = "S" THEN
                    [] = INT(ROUND(Calculator.Value,0))
                 ELSE
                    [] = Calculator.Value
                 ENDIF

                 ; Revert to the original value
                 ; if the new one is unacceptable.

                 IF NOT ISVALID() OR ((FIELDTYPE() = "S") AND
                    (ABS(Calculator.Value) > 32767)) THEN
                    Dia_OK(TRUE,"Error","Invalid Value for this Field","")
                    [] = wasval
                 ENDIF

            ; Current field is an Alphanumeric field

            CASE (SUBSTR(FIELDTYPE(),1,1) = "A") :

                 ; Save the original value from the field.

                 wasval = []

                 ; Put the new value in the field.

                 [] = wasval + STRVAL(Calculator.Value)

                 ; Revert to the original value
                 ; if the new one is unacceptable.

                 IF NOT ISVALID() THEN
                    Dia_OK(TRUE,"Error","Invalid Value for this Field","")
                    [] = wasval
                 ENDIF

            ; Current field is a "live" Memo field

            CASE ISFIELDVIEW() AND (SUBSTR(FIELDTYPE(),1,1) = "M") :

                 EDITOR INSERT Calculator.Value

            ; Obviously, we are ignoring Date fields

      ENDSWITCH

   ELSE

      ; Value is going back to a Dialog ACCEPT that uses a number

      IF ISASSIGNED(pass.calculat.var) THEN
         pass.calculat.var = Calculator.Value
      ENDIF

   ENDIF

ENDIF

Calculator.Destructor()

ENDPROC

WRITELIB libname CalculatorShell
RELEASE PROCS    CalculatorShell

;==============================================================================
; (c) Copyright Elect Software International Inc., 1992, Toronto. Anyone can
; use this code for anything as long as it is not resold as a software
; development resource, as long as the copyright notice isn't removed, as
; long as changes are clearly marked as to authorship, and as long as users
; indemnify Elect from any liability.
; Comments welcome. Henrik Bechmann, CIS:72701,3717; Tel:416-534-8176.
; Mar-92, Apr-92, Jun-92, Jul-92
;==============================================================================

;==============================================================================
;                        ESI-PD40B CALCULATOR INTERFACE
;==============================================================================
; Calculator.Constructor() ; This configures the calculator in memory. Since
;                          ; the key variables are all created here, the
;                          ; calculator is re-entrant using
;                          ; Calculator.Dialog(). In other words, the user
;                          ; is able to hit [Esc] to temporarily leave
;                          ; the calculator (say to look something up) and then
;                          ; be able to re-enter it to find it in the same
;                          ; state as it was when [Esc] was hit.
;                          ; The constructor should be called at the beginning
;                          ; of a session, to save time in calling the
;                          ; calculator during the session.
; Calculator.Dialog()      ; This calls the calculator. Returns blanknum() if
;                          ; the user exited by hitting [Esc], otherwise
;                          ; returns a number (N).
; Calculator.Destructor()  ; Destroys the calculator's global variables (ie.
;                          ; destroys the calculator) at the end of a session.

; Calculator.Value
; Calculator.IsActive

;==============================================================================
;                       CALCULATOR IMPLEMENTATION
;==============================================================================
;----------------------------------------------------------------------------
; Calculator.Constructor() Sets up variables and arrays for the calculator
; in memory. These variables are technically global, which makes the
; calculator re-entrant.
;----------------------------------------------------------------------------

Proc Calculator.Constructor()
   Private
      i,j,
      Element
   ;-------------------------------------------------------------------------
   ; Provide message to user...
   ;-------------------------------------------------------------------------
   Message "Initializing calculator..."
   ;-------------------------------------------------------------------------
   ; Initialize constants, and control variables...
   ; First, universal null...
   ;-------------------------------------------------------------------------
   Calculator_NULL         = 255
   ;-------------------------------------------------------------------------
   ; Keystroke types...
   ;-------------------------------------------------------------------------
   Calculator_OPCHAR       = 1
   Calculator_FUNCCHAR     = 2
   Calculator_NUMCHAR      = 3
   Calculator_EDITCHAR     = 4
   ;-------------------------------------------------------------------------
   ; Token types... (Only FLOATING and OPERATOR are currently used)
   ;-------------------------------------------------------------------------
;   Calculator_TIME         = 1
;   Calculator_SECONDS      = 2
;   Calculator_MINUTES      = 3
;   Calculator_HOURS        = 4
;   Calculator_DAYS         = 5
;   Calculator_WEEKS        = 6
;   Calculator_MONTHS       = 7
;   Calculator_YEARS        = 8
;   Calculator_DATE         = 9
   Calculator_FLOATING     = 10
;   Calculator_INTEGER      = 11
;   Calculator_MONEY        = 12
;   Calculator_STRING       = 13
   Calculator_OPERATOR     = 14
   ;-------------------------------------------------------------------------
   ; Input cell states...
   ;-------------------------------------------------------------------------
   Calculator_WAITING = 0
   Calculator_CALC = 1
   ;-------------------------------------------------------------------------
   ; Token type names... (not currently used.)
   ;-------------------------------------------------------------------------
;   Dynarray Calculator_TokenTypeName[]
;   Calculator_TokenTypeName[Calculator_TIME]     = "Time"
;   Calculator_TokenTypeName[Calculator_SECONDS]  = "Seconds"
;   Calculator_TokenTypeName[Calculator_MINUTES]  = "Minutes"
;   Calculator_TokenTypeName[Calculator_HOURS]    = "Hours"
;   Calculator_TokenTypeName[Calculator_DAYS]     = "Days"
;   Calculator_TokenTypeName[Calculator_WEEKS]    = "Weeks"
;   Calculator_TokenTypeName[Calculator_MONTHS]   = "Months"
;   Calculator_TokenTypeName[Calculator_YEARS]    = "Years"
;   Calculator_TokenTypeName[Calculator_DATE]     = "Date"
;   Calculator_TokenTypeName[Calculator_FLOATING] = "Floating"
;   Calculator_TokenTypeName[Calculator_INTEGER]  = "Integer"
;   Calculator_TokenTypeName[Calculator_MONEY]    = "Money"
;   Calculator_TokenTypeName[Calculator_STRING]   = "String"
;   Calculator_TokenTypeName[Calculator_OPERATOR] = "Operator"
   ;-------------------------------------------------------------------------
   ; Keycode data...
   ;-------------------------------------------------------------------------
   Calculator_Keycode = BlankNum()
   Calculator_KeycodeAttribute = Calculator_NULL
   ;-------------------------------------------------------------------------
   ; Calculator input cell data...
   ; Set the Accept statement defualt variables here as well...
   ;-------------------------------------------------------------------------
   Calculator_CellDataType      = "N"
   Calculator_DecimalFlag       = False
   Calculator!KeyPadModeLine() ; sets Calculator_KeyPadModeLine
   Calculator_CellStatus        = Calculator_WAITING
   Calculator.Value             = 0
   Calculator_Value             = 0 ; to transfer escaped value to .Value
   Calculator_CellAttribute     = Calculator_FLOATING ; data type
   Calculator_CellLastValue     = Calculator.Value
   Calculator_CellLastAttribute = Calculator_CellAttribute
   ;-------------------------------------------------------------------------
   ; Expression status...
   ;-------------------------------------------------------------------------
   Calculator_CurrentOperator = Calculator_NULL
   Calculator_LastOperator = Calculator_NULL
   ;-------------------------------------------------------------------------
   ; Internal token data...
   ;-------------------------------------------------------------------------
   Dynarray Calculator_StackValue[]
   Dynarray Calculator_StackAttribute[] ; data type/operator
   Calculator_StackPtr = 0
   ;-------------------------------------------------------------------------
   ; Classification of characters streaming in...
   ;-------------------------------------------------------------------------
   Dynarray Calculator_KeyCodeType[] ; 32 total
   Calculator_KeycodeType[Asc("Del")]           = Calculator_EDITCHAR
   Calculator_KeycodeType[Asc("Backspace")]     = Calculator_EDITCHAR
   Calculator_KeycodeType[Asc("CtrlBackspace")] = Calculator_EDITCHAR
   Calculator_KeycodeType[Asc("Right")]         = Calculator_EDITCHAR
   Calculator_KeycodeType[Asc("Left")]          = Calculator_EDITCHAR
   Calculator_KeycodeType[Asc("Home")]          = Calculator_EDITCHAR
   Calculator_KeycodeType[Asc("End")]           = Calculator_EDITCHAR
   Calculator_KeycodeType[Asc("0")]             = Calculator_NUMCHAR
   Calculator_KeycodeType[Asc("1")]             = Calculator_NUMCHAR
   Calculator_KeycodeType[Asc("2")]             = Calculator_NUMCHAR
   Calculator_KeycodeType[Asc("3")]             = Calculator_NUMCHAR
   Calculator_KeycodeType[Asc("4")]             = Calculator_NUMCHAR
   Calculator_KeycodeType[Asc("5")]             = Calculator_NUMCHAR
   Calculator_KeycodeType[Asc("6")]             = Calculator_NUMCHAR
   Calculator_KeycodeType[Asc("7")]             = Calculator_NUMCHAR
   Calculator_KeycodeType[Asc("8")]             = Calculator_NUMCHAR
   Calculator_KeycodeType[Asc("9")]             = Calculator_NUMCHAR
   Calculator_KeycodeType[Asc(".")]             = Calculator_NUMCHAR
   Calculator_KeycodeType[Asc("%")]             = Calculator_FUNCCHAR
   Calculator_KeycodeType[Asc(">")]             = Calculator_FUNCCHAR
   Calculator_KeycodeType[Asc("<")]             = Calculator_FUNCCHAR

   ; Alt-Q square root
   Calculator_KeycodeType[-16]                  = Calculator_FUNCCHAR

   ; Alt-N round
   Calculator_KeycodeType[-49]                  = Calculator_FUNCCHAR

   Calculator_KeycodeType[Asc("!")]             = Calculator_FUNCCHAR
   Calculator_KeycodeType[Asc("^")]             = Calculator_OPCHAR
   Calculator_KeycodeType[Asc("*")]             = Calculator_OPCHAR
   Calculator_KeycodeType[Asc("/")]             = Calculator_OPCHAR
   Calculator_KeycodeType[Asc("+")]             = Calculator_OPCHAR
   Calculator_KeycodeType[Asc("-")]             = Calculator_OPCHAR
   Calculator_KeycodeType[Asc("=")]             = Calculator_OPCHAR
   Calculator_KeycodeType[Asc("Enter")]         = Calculator_OPCHAR
   Calculator_KeycodeType[Asc("Do_It!")]        = Calculator_OPCHAR
   Calculator_KeycodeType[Asc("Esc")]           = Calculator_OPCHAR
   ;-------------------------------------------------------------------------
   ; Set up a key event list for all keycode types. This will be used when
   ; Calculator_CellStatus = Calculator_WAITING
   ;-------------------------------------------------------------------------
   Array Calculator_CharEventKey[33]
   i = 0
   ForEach Element In Calculator_KeyCodeType
      i = i + 1
      Calculator_CharEventKey[i] = Numval(Element)
   Endforeach
;   j = i
;   For i From j + 1 to 31
;      Calculator_CharEventKey[i] = Calculator_NULL
;   EndFor
   ;-------------------------------------------------------------------------
   ; Set up a key event list for operator keycode types. This will be used
   ; when Calculator_CellStatus = Calculator_CALC
   ;-------------------------------------------------------------------------
   Array Calculator_OpEventKey[15]
   Calculator_OpEventKey[1] = Asc("^")
   Calculator_OpEventKey[2] = Asc("%")
   Calculator_OpEventKey[2] = Asc("<")
   Calculator_OpEventKey[2] = Asc(">")
   Calculator_OpEventKey[3] = Asc("!")
   Calculator_OpEventKey[4] = Asc("*")
   Calculator_OpEventKey[5] = Asc("/")
   Calculator_OpEventKey[6] = Asc("+")
   Calculator_OpEventKey[7] = Asc("-")
   Calculator_OpEventKey[8] = Asc("=")
   Calculator_OpEventKey[9] = Asc("Enter")
   Calculator_OpEventKey[10] = -16 ; Alt-Q, square root
   Calculator_OpEventKey[11] = -49 ; Alt-N, round
   Calculator_OpEventKey[12] = Asc("<")
   Calculator_OpEventKey[13] = Asc(">")
   Calculator_OpEventKey[14] = Asc("Do_It!")
   Calculator_OpEventKey[15] = Asc("Esc")
   ;-------------------------------------------------------------------------
   ; Set up a list of procedures to call in response to the operator
   ; keystrokes...
   ;-------------------------------------------------------------------------
   Dynarray Calculator_ResponseProc[] ; 20 total
   Calculator_ResponseProc[Asc("^")]     = "Calculator!Exponent"
   Calculator_ResponseProc[Asc("%")]     = "Calculator!Percent"
   Calculator_ResponseProc[Asc("!")]     = "Calculator!Factorial"
   Calculator_ResponseProc[Asc("*")]     = "Calculator!Multiply"
   Calculator_ResponseProc[Asc("/")]     = "Calculator!Divide"
   Calculator_ResponseProc[Asc("+")]     = "Calculator!Add"
   Calculator_ResponseProc[Asc("-")]     = "Calculator!Subtract"
   Calculator_ResponseProc[Asc("=")]     = "Calculator!Equals"
   Calculator_ResponseProc[Asc("Enter")] = "Calculator!Equals"
   Calculator_ResponseProc[Asc("R")]     = "Calculator!PlusMinus"
   Calculator_ResponseProc[Asc("S")]     = "Calculator!Subtotal"
   Calculator_ResponseProc[Asc("C")]     = "Calculator!Clear"
   Calculator_ResponseProc[Asc("")]     = "Calculator!Sqrt"
   Calculator_ResponseProc[-16]          = "Calculator!Sqrt" ; Alt-Q
   Calculator_ResponseProc[-49]          = "Calculator!Round" ; Alt-N
   Calculator_ResponseProc[Asc("N")]     = "Calculator!Round" ; Alt-N
   Calculator_ResponseProc[Asc(">")]     = "Calculator!SaveMem"
   Calculator_ResponseProc[Asc("<")]     = "Calculator!GetMem"
   Calculator_ResponseProc[Asc("Do_It!")] = "Calculator!OK"
   Calculator_ResponseProc[Asc("Esc")]    = "Calculator!Escape"
   ;-------------------------------------------------------------------------
   ; Define an engine for the DialogProc. This controller directs the thread
   ; of control with an execproc statement to the procedure matching the
   ; event.
   ;-------------------------------------------------------------------------
   Dynarray Calculator_EventEngine[]
   Calculator_EventEngine["Open"]   = "Calculator!Open"
   Calculator_EventEngine["Event"]  = "Calculator!Event"
   ;-------------------------------------------------------------------------
   ; Paper tape facsimile at top of calculator
   ;-------------------------------------------------------------------------
   Array Calculator_Tape[5]
   For i From 1 to 5
      Calculator_Tape[i] = ""
   Endfor

   ; I'm converting from a file to a DynArray -                          ; SG
   ; this keeps track of # of lines

   Calculator_TapeCtr = 1

   ; This is the DynArray to hold the entries

   DYNARRAY Calculator_TapeList[]

   Calculator_TapeFile = PRIVDIR() + "CalcTape.Txt"                      ; SG
   Calculator_TapeIsOn = True                                            ; SG
   Calculator!TapeModeLine()  ; calculates Calculator_TapeModeLine
   ;-------------------------------------------------------------------------
   ; Explanation file...
   ;-------------------------------------------------------------------------
   ; I removed the text file here                                        ; SG
   ; Calculator_ExplainFile = "PopCalc.Txt"
   ;-------------------------------------------------------------------------
   ; Dialog window information...
   ;-------------------------------------------------------------------------
   Calculator_WindowHandle = Blanknum()
   Calculator_WindowBag = Blanknum()
   Calculator_WindowRow = Blanknum()
   Calculator_WindowCol = Blanknum()
   ;-------------------------------------------------------------------------
   ; Memory value...
   ;-------------------------------------------------------------------------
   Calculator_MemoryValue = BlankNum()
   Calculator_MemoryAttribute = Calculator_NULL
   ;-------------------------------------------------------------------------
   ; Clear message to user...
   ;-------------------------------------------------------------------------
   Calculator.IsActive = True
   Message ""
EndProc ; Calculator.Constructor

WRITELIB libname Calculator.Constructor
RELEASE PROCS    Calculator.Constructor

;----------------------------------------------------------------------------
; To release global variables set up in the constructor...
;----------------------------------------------------------------------------

Proc Calculator.Destructor()
   Release Vars
      Calculator_NULL,
      Calculator_OPCHAR,
      Calculator_FUNCCHAR,
      Calculator_NUMCHAR,
      Calculator_EDITCHAR,
      Calculator_TIME,
      Calculator_SECONDS,
      Calculator_MINUTES,
      Calculator_HOURS,
      Calculator_DAYS,
      Calculator_WEEKS,
      Calculator_MONTHS,
      Calculator_YEARS,
      Calculator_DATE,
      Calculator_FLOATING,
      Calculator_INTEGER,
      Calculator_MONEY,
      Calculator_STRING,
      Calculator_OPERATOR,
      Calculator_WAITING,
      Calculator_CALC,
      Calculator_TokenTypeName,
      Calculator_Keycode,
      Calculator_KeycodeAttribute,
      Calculator_CellDataType,
      Calculator_DecimalFlag,
      Calculator_KeyPadModeLine,
      Calculator_CellStatus,
      Calculator.Value,
      Calculator_Value,
      Calculator_CellAttribute,
      Calculator_CellLastValue,
      Calculator_CellLastAttribute,
      Calculator_CurrentOperator,
      Calculator_LastOperator,
      Calculator_StackValue,
      Calculator_StackAttribute,
      Calculator_StackPtr,
      Calculator_KeyCodeType,
      Calculator_CharEventKey,
      Calculator_OpEventKey,
      Calculator_ResponseProc,
      Calculator_EventEngine,
      Calculator_Tape,
      Calculator_TapeCtr,         ; SG
      Calculator_TapeList,        ; SG
      Calculator_TapeIsOn,        ; SG
      Calculator_TapeFile,
      Calculator_TapeModeLine,
      Calculator_ExplainFile,     ; SG
      Calculator_WindowHandle,
      Calculator_WindowBag,
      Calculator_WindowRow,
      Calculator_WindowCol,
      Calculator_MemoryValue,
      Calculator_MemoryAttribute,
      Calculator.IsActive
EndProc ; Calculator.Destructor

WRITELIB libname Calculator.Destructor
RELEASE PROCS    Calculator.Destructor

;----------------------------------------------------------------------------
; Returns blanknum() or a number, depending on user's acceptance of the
; result.
;----------------------------------------------------------------------------

Proc Calculator.Dialog()
   Private
      CalcKey

   ShowDialog "ESI-PD40B Calculator"
   Proc "Calculator!DialogProc"
   Trigger "Open"
   @2,8 Height 20 Width 30                       ; SG
   @0,0 ?? Calculator_Tape[1]
   @1,0 ?? Calculator_Tape[2]
   @2,0 ?? Calculator_Tape[3]
   @3,0 ?? Calculator_Tape[4]
   @4,0 ?? Calculator_Tape[5]
   @5,0 ?? Calculator_TapeModeLine
   @7,0 ?? Calculator_KeyPadModeLine
   Accept
      @6,0 Width 28
      Calculator_CellDataType
      Required
      Tag "Cell"
      To Calculator.Value
   PushButton
      @8,0 Width 5 "7"
      Value Calculator!NumKey("7")
      Tag "7"
      To CalcKey
   PushButton
      @8,5 Width 5 "8"
      Value Calculator!NumKey("8")
      Tag "8"
      To CalcKey
   PushButton
      @8,10 Width 5 "9"
      Value Calculator!NumKey("9")
      Tag "9"
      To CalcKey
   PushButton
      @8,15 Width 7 "~R~ev"
      Value Calculator!PlusMinus()
      Tag "Rev"
      To CalcKey
   PushButton
      @8,22 Width 5 "/"
      Value Calculator!Divide()
      Tag "/"
      To CalcKey
   PushButton
      @10,0 Width 5 "4"
      Value Calculator!NumKey("4")
      Tag "4"
      To CalcKey
   PushButton
      @10,5 Width 5 "5"
      Value Calculator!NumKey("5")
      Tag "5"
      To CalcKey
   PushButton
      @10,10 Width 5 "6"
      Value Calculator!NumKey("6")
      Tag "6"
      To CalcKey
   PushButton
      @10,15 Width 7 "C~l~r"
      Value Calculator!Clear()
      Tag "Clr"
      To CalcKey
   PushButton
      @10,22 Width 5 "*"
      Value Calculator!Multiply()
      Tag "*"
      To CalcKey
   PushButton
      @12,0 Width 5 "1"
      Value Calculator!NumKey("1")
      Tag "1"
      To CalcKey
   PushButton
      @12,5 Width 5 "2"
      Value Calculator!NumKey("2")
      Tag "2"
      To CalcKey
   PushButton
      @12,10 Width 5 "3"
      Value Calculator!NumKey("3")
      Tag "3"
      To CalcKey
   PushButton
      @12,15 Width 7 "~S~ub"
      Value Calculator!Subtotal()
      Tag "Sub"
      To CalcKey
   PushButton
      @12,22 Width 5 "-"
      Value Calculator!Subtract()
      Tag "-"
      To CalcKey
   PushButton
      @14,0 Width 10 "0"
      Value Calculator!NumKey("0")
      Tag "0"
      To CalcKey
   PushButton
      @14,10 Width 5 "."
      Value Calculator!Decimal()
      Tag "."
      To CalcKey
   PushButton
      @14,15 Width 7 "="
      Value Calculator!Equals()
      Tag "="
      To CalcKey
   PushButton
      @14,22 Width 5 "+"
      Value Calculator!Add()
      Tag "+"
      To CalcKey
   PushButton
      @16,0 Width 6 "~O~K"
      OK
      Value Calculator!OK()
      Tag "OK"
      To CalcKey
   PushButton
      @16,6 Width 7 "~E~sc"
      Cancel
      Value Calculator!Escape()
      Tag "Esc"
      To CalcKey
   PushButton
      @16,13 Width 6 "O~p~"
      Value Calculator!Op()
      Tag "Op"
      To CalcKey
   PushButton
      @16,19 Width 8 "~M~enu"
      Value Calculator!Menu()
      Tag "Menu"
      To CalcKey
   EndDialog
   If Not Retval Then
      Calculator.Value = Calculator_Value
   Endif
   Return retval
EndProc ; Calculator.Dialog

WRITELIB libname Calculator.Dialog
RELEASE PROCS    Calculator.Dialog

;----------------------------------------------------------------------------
; I have completely replaced Calculator!ViewExplain() with a Dialog Box
;----------------------------------------------------------------------------

PROC Calculator!ViewExplain()
     PRIVATE tapelist,
             buttonvalue

IF NOT ISASSIGNED(Calculator_ExplainFile) THEN
   Calculator!MakeExplain()
ENDIF

  SHOWDIALOG "ESI-PD40B Calculator Help"
     PROC "StockDialogWait"
     KEY 27
     @2,1 HEIGHT 20 WIDTH 78

     PICKARRAY @1,1 HEIGHT 14 WIDTH 74
        Calculator_ExplainFile
        TAG ""
        TO tapelist

     PUSHBUTTON @16,33 WIDTH 10
        "~O~K"
        OK
        DEFAULT
        VALUE ""
        TAG ""
        TO buttonvalue

  ENDDIALOG

ENDPROC

WRITELIB libname Calculator!ViewExplain
RELEASE PROCS    Calculator!ViewExplain

;----------------------------------------------------------------------------
; This creates the Help Text
;----------------------------------------------------------------------------

PROC Calculator!MakeExplain()

ARRAY Calculator_ExplainFile[78]

Calculator_ExplainFile[1] =
" The ESI-PD40B calculator is a basic business calculator that supports"
Calculator_ExplainFile[2] = " the following operations:"
Calculator_ExplainFile[3] =
"                           ------------ Available from -------------"
Calculator_ExplainFile[4] =
" Operation     Type        Keyboard       PushButton  OpMenu"
Calculator_ExplainFile[5] =
" ---------     ----------  -----------------------------------------"
Calculator_ExplainFile[6] =
" Add           Postfix     [+]            \"+\"         {Add}"
Calculator_ExplainFile[7] =
" Subtract      Postfix     [-]            \"-\"         {Subtract}"
Calculator_ExplainFile[8] =
" Multiply      Infix       [*]            \"*\"         {Multiply}"
Calculator_ExplainFile[9] =
" Divide        Infix       [/]            \"/\"         {Divide}"
Calculator_ExplainFile[10] =
" Exponent      Infix       [^]                        {Exponent}"
Calculator_ExplainFile[11] =
" Percent       Function    [%]                        {Percent}"
Calculator_ExplainFile[12] =
" Factorial     Function    [!]                        {Factorial}"
Calculator_ExplainFile[13] =
" Reverse sign  Function    [Alt-R]        \"Rev\"       {Reverse sign}"
Calculator_ExplainFile[14] =
" Square root   Function    [Alt-Q]                    {Square root}"
Calculator_ExplainFile[15] =
" Round,2       Function    [Alt-N]                    {Round,2}"
Calculator_ExplainFile[16] =
" SaveMem       Function    [>]                        {SaveMem}"
Calculator_ExplainFile[17] =
" GetMem        Function    [<]                        {GetMem}"
Calculator_ExplainFile[18] =
" Subtotal      Postfix     [Alt-S]        \"Sub\"       {Subtotal}"
Calculator_ExplainFile[19] =
" Total         Terminator  [=] or [Enter] \"=\"         {Total}"
Calculator_ExplainFile[20] =
" Clear         Terminator  [Alt-L]        \"Clr\"       {Clear}"
Calculator_ExplainFile[21] = ""
Calculator_ExplainFile[22] =
" In addition it has a numeric keypad that contains the numerals 0 - 9"
Calculator_ExplainFile[23] = " and the decimal point."
Calculator_ExplainFile[24] = ""
Calculator_ExplainFile[25] =
" Postfix operations operate on a number or numbers that have preceded"
Calculator_ExplainFile[26] = " the operator."
Calculator_ExplainFile[27] = ""
Calculator_ExplainFile[28] =
" Infix operations apply to the numbers immediately preceding and"
Calculator_ExplainFile[29] =
" following the operator. Infix operations are nested, ie. they are re-"
Calculator_ExplainFile[30] =
" solved before their postfix cousins are resolved."
Calculator_ExplainFile[31] = ""
Calculator_ExplainFile[32] =
" Functions apply only to the number currently in the input cell."
Calculator_ExplainFile[33] = ""
Calculator_ExplainFile[34] =
" As a simple example, to add 3 - 6 = -3, enter 3 + 6 - [Enter]."
Calculator_ExplainFile[35] = ""
Calculator_ExplainFile[36] =
" For a more complex example, to calculate a bill with tax for five"
Calculator_ExplainFile[37] =
" items: 1 coke at $1.00, three burgers at $2.00 each, and one out of a"
Calculator_ExplainFile[38] =
" case of three apple crisps, when the case is worth $6.00, with tax"
Calculator_ExplainFile[39] =
" altogether of 7%: enter the following keystrokes:"
Calculator_ExplainFile[40] = ""
Calculator_ExplainFile[41] = "      1 + 2 * 3 + 6 / 3 [Alt-S] * 7 % [Enter]"
Calculator_ExplainFile[42] = ""
Calculator_ExplainFile[43] =
" When [Enter], [=], or [Alt-S] are entered without a preceding + or -"
Calculator_ExplainFile[44] = " operator, the + operator is assumed."
Calculator_ExplainFile[45] = ""
Calculator_ExplainFile[46] =
" So, the above keystroke sequence is equivalent to:"
Calculator_ExplainFile[47] = ""
Calculator_ExplainFile[48] =
" (1 + (2 * 3 = 6) + (6 / 3 = 2) = 9 + (9.00 * (7/100 = .07) = .63)"
Calculator_ExplainFile[49] = "  = 9.63"
Calculator_ExplainFile[50] = ""
Calculator_ExplainFile[51] = " The Paper tape would show:"
Calculator_ExplainFile[52] = ""
Calculator_ExplainFile[53] = "      1.00 +"
Calculator_ExplainFile[54] = "      2.00 *"
Calculator_ExplainFile[55] = "      3.00 ="
Calculator_ExplainFile[56] = "      6.00 +"
Calculator_ExplainFile[57] = "      6.00 /"
Calculator_ExplainFile[58] = "      3.00 ="
Calculator_ExplainFile[59] = "      2.00 +"
Calculator_ExplainFile[60] = "      9.00 Subtotal"
Calculator_ExplainFile[61] = "      9.00 *"
Calculator_ExplainFile[62] = "      7.00 % ="
Calculator_ExplainFile[63] = "       .07 :"
Calculator_ExplainFile[64] = "       .07 ="
Calculator_ExplainFile[65] = "       .63 +"
Calculator_ExplainFile[66] = "      9.63 Total"
Calculator_ExplainFile[67] = ""
Calculator_ExplainFile[68] =
" The calculator will use the previously calculated figure of the input"
Calculator_ExplainFile[69] =
" cell if an operator is hit without entering a new number in the input"
Calculator_ExplainFile[70] =
" cell. The input cell shows the running total of the calculation. This"
Calculator_ExplainFile[71] =
" running total is automatically replaced by a number that you input in"
Calculator_ExplainFile[72] = " the input cell."
Calculator_ExplainFile[73] = ""
Calculator_ExplainFile[74] =
" Thus 3 + + + [Enter] will give 9.00, while showing 3,6,9 after each"
Calculator_ExplainFile[75] = " plus, and 9 after the [Enter]."
Calculator_ExplainFile[76] = ""
Calculator_ExplainFile[77] =
" The paper tape is available for viewing and editing from the Menu, and"
Calculator_ExplainFile[78] =
" this help text is available for viewing from the Menu."

ENDPROC

WRITELIB libname Calculator!MakeExplain
RELEASE PROCS    Calculator!MakeExplain

;----------------------------------------------------------------------------
; I have completely replaced Calculator!ViewTape() with a Dialog Box
;----------------------------------------------------------------------------

PROC Calculator!ViewTape()
     PRIVATE tapelist,
             buttonvalue

SHOWDIALOG "Paper Tape Details"
   PROC "StockDialogWait"
   KEY 27
   @2,42 HEIGHT 20 WIDTH 30

   PICKDYNARRAY @1,1 HEIGHT 14 WIDTH 26
      Calculator_TapeList
      TAG ""
      TO tapelist

   PUSHBUTTON @16,9 WIDTH 10
      "~O~K"
      OK
      DEFAULT
      VALUE ""
      TAG ""
      TO buttonvalue

ENDDIALOG

ENDPROC

WRITELIB libname Calculator!ViewTape
RELEASE PROCS    Calculator!ViewTape

;----------------------------------------------------------------------------
; I added the Print process
;----------------------------------------------------------------------------

PROC Calculator!PrintTape()
   Private
      i,x

   MESSAGE "Sending data to printer.."
   SLEEP 1000

   IF ISFILE(Calculator_TapeFile) THEN
      RUN NOREFRESH "del " + Calculator_TapeFile
   ENDIF

   ; Transfer the current tape lines to a DOS file

   FOR i FROM 1 TO DYNARRAYSIZE(Calculator_TapeList)
       PRINT FILE Calculator_TapeFile Calculator_TapeList[i] + "\n"
   ENDFOR

   ; Fill out the last page

   x = MOD(i,60)

   FOR i FROM 1 TO x
       PRINT FILE Calculator_TapeFile "     \n"
   ENDFOR

   RUN NOREFRESH "copy " + Calculator_TapeFile + " lpt1 > nul"
   RUN NOREFRESH "del " + Calculator_TapeFile

   MESSAGE ""

ENDPROC

WRITELIB libname Calculator!PrintTape
RELEASE PROCS    Calculator!PrintTape

;----------------------------------------------------------------------------

Proc Calculator!KeyPadModeLine()
   If Not Calculator_DecimalFlag Then
      Calculator_KeyPadModeLine = Fill("",28)
   Else
      Calculator_KeyPadModeLine = "Decimal flag" + fill("",15)
   Endif
EndProc ; Calculator!KeyPadModeLine

WRITELIB libname Calculator!KeyPadModeLine
RELEASE PROCS    Calculator!KeyPadModeLine

;----------------------------------------------------------------------------

Proc Calculator!TapeModeLine()
   If Not Calculator_TapeIsOn Then
      Calculator_TapeModeLine = "Tape is off" + fill("",15)           ; SG
   Else
      Calculator_TapeModeLine = "Tape is on" + fill("",16)            ; SG
   Endif
EndProc ; Calculator!TapeModeLine

WRITELIB libname Calculator!TapeModeLine
RELEASE PROCS    Calculator!TapeModeLine

;----------------------------------------------------------------------------

Proc Calculator!DialogProc(EventType,TagValue,EventBag,ElementValue)
   Private
      OK
   ExecProc Calculator_EventEngine[EventType]
   OK = Retval
   Return OK
EndProc ; Calculator!DialogProc

WRITELIB libname Calculator!DialogProc
RELEASE PROCS    Calculator!DialogProc

RELEASE VARS libname

