; This utility does *not* work in 4.0 Compatible Mode, or any 3.x version!
;
; this is the PopUp Calendar/Calculator I use.. the default hotkey I use is
; [Ctrl]-[C], but you can use any key combo you prefer.. what key you use is
; external to this process.. (it doesn't matter)..
;
; In order for this critter to work from any WAIT/UNTIL or WAIT/ENDWAIT, just
; trap for the hotkey or keycode, and call Calpops().. same thing for all your
; Dialog procs..
;
; For SHOWPULLDOWN, add the hotkey to your KEYTO list, and call Calpops()..
;
; For interactive, use a SETKEY for your hotkey and something like this:
;
;     SETKEY 3 autolib = "Calc" Calpops()
;
; The one errorproc line that is needed is explained in the Calpops() header.
;
; If the underlying table is in CoEdit mode, interactively or in your app, 
; and the current field is appropriate for the value being passed back to it
; (i.e. you can't pass a date from the calendar back to a number field), this
; process will automatically pass the selected date or number back to the 
; current field if you select the OK button.. nothing will be passed back if
; you [Esc] or hit the CANCEL button.. an OK with no field to go to, or in
; View Mode, will be ignored..
; 
; To pass the value back to an ACCEPT in a dialog box, assign a private var
; in the dialog proc called "pass.calculat.var" or "pass.calendar.var", as
; appropriate, like this:
;
; CASE Event.bag["KeyCode"] = 3 :
;      pass.calculat.var = BLANKNUM()
;      Calpops()
;      IF pass.calculat.var <> BLANKNUM() AND
;         NUMVAL(pass.calculat.var) <> "Error") THEN
;         ; slam it into your ACCEPT
;      ENDIF
;
; Yes, some of the code in these scripts is *very* complex and/or off-the-wall,
; but this is one incredible piece of work that Henrik created.. all I did was
; dress it up in a few places to make it more inter-operative with external
; PAL apps..
;
; To run this as a demo, the section immediately following and the one at the
; end of this script will take care of it for you..
;
; If you incorporate this into an app, you need to set "libname" to the
; appropriate library in Utility2, Utility3, and Utility4, and stick these
; three procs in a script someplace..
;
; --------------------
; this is for the demo

CREATELIB "Calc" SIZE 200
libname = "Calc"
autolib = "Calc"
SETKEY 3 autolib = "Calc" Calpops()

; end of demo code
; --------------------
;
; Steve Green
; Diamond Software Group
; VOICE  : (301) 843-8981
; CIS    : 71333,2362
; PRODIGY: TBMG62A
;

; 
; Calpops()
;
; - Calendar/Calculator selection menu
;
;        Author - Steven Green
; Creation Date - 11/03/93
; Last Modified - 11/17/93
;   Modified by - Steven Green
;  Changes Made - added "procname" for ErrorFix() for IMAGERIGHTS problems
;
; This process dispays a ShowPopUp Menu when [Ctrl][C] is pressed, which allows
; the user to activate the built-in Calculator or Calendar
;
; EXTERNAL VARIABLES MODIFIED
;        procname - ErrorProc "process" identifier
;
; NOTES - the global variable "procname" is set to "Calpops" within this
;         process so that the default attempts to write the value returned
;         by the Calculator or Calendar don't blow up when IMAGERIGHTS stops
;         a write to a field in CoEdit - the ErrorProc line is
;
;         CASE (procname = "Calpops") AND (ERRORCODE() = 25) :
;              RETURN 1
;
;         This just allows the "[] = Calculator.Value" lines to be bypassed
;
;       - "procname" MUST BE RESET to "" at the end of any routine using it!
; 

PROC Calpops()
     PRIVATE pop.choice

SHOWPOPUP "Select a Tool or [Esc]" CENTERED
   "Calculator" : " Use the Calculator" : "Calculator",
   "Ca~l~endar" : " Use the Calendar"   : "Calendar"
ENDMENU
TO pop.choice

IF pop.choice <> "Esc" THEN
   procname = "Calpops"
   EXECPROC pop.choice + "Shell"
   procname = ""
ENDIF

ENDPROC

WRITELIB libname Calpops
RELEASE PROCS    Calpops


; 
; Dia_OK(beep_val,title,msg1,msg2)
;
; - Simple "OK" message
;
;        Author - Charles Vinal
; Creation Date - 05/  /93
; Last Modified - 02/19/95
;   Modified by - Steven Green
;  Changes Made - changed default box size
;
; This process displays a custom message in a dialog box - the only button is
; "OK", so there is no action required by the user other than accepting the OK
;
; PARAMETERS
;        beep_val  - TRUE/FALSE for the HighBeep() sound
;        title     - title line for the display
;        msg1      - first line of text in the display
;        msg2      - second line of text in the display
; 

PROC Dia_OK(beep_val,title,msg1,msg2)
     PRIVATE button_val,
             sc, fstr,
             hght, wdth,
             len1, len2

button_val = "OK"

IF beep_val THEN
    HighBeep()
ENDIF

len1 = LEN(msg1)
len2 = LEN(msg2)

wdth = MAX(len1,len2)

IF (wdth > 60) THEN
   wdth = 60
ENDIF

IF (wdth < 12) THEN
   wdth = 12
ENDIF

wdth = wdth + 8                     ; was 24
sc   = INT((80 - wdth) / 2)
fstr = "W" + STRVAL(wdth - 2) + ",AC"

SHOWDIALOG title @ 8,sc
  HEIGHT IIF(msg2 = "",6,7) WIDTH wdth

  @ 1,0 ?? FORMAT(fstr,msg1)
  @ 2,0 ?? IIF(msg2 = "","",FORMAT(fstr,msg2))

  PUSHBUTTON @ IIF(msg2 = "",3,4), INT(wdth / 2) - (6 + MOD(LEN(title),2))
      WIDTH 10
      "~O~K"                                        ; changed 5 to 6 (2/95)
      OK DEFAULT
      VALUE "OK"
      TAG "pushbutton"
      TO button_val

ENDDIALOG

ENDPROC

WRITELIB libname Dia_OK
RELEASE PROCS    Dia_OK

; 
; HighBeep()
;
; - Special noise to replace the standard BEEP
;
;        Author - Charles Vinal
; Creation Date - 01/  /93
; Last Modified -
;   Modified by -
;  Changes Made -
;
; This process makes a sound that is more pleasant than BEEP
; 

PROC HighBeep()

SOUND 700 70
SOUND 900 45

ENDPROC

WRITELIB libname HighBeep
RELEASE PROCS    HighBeep

; 
; StockDialogWait(triggertype,tagvalue,eventvalue,elementvalue)
;
; - Default Dialog Box Wait Proc
;
;        Author - Steven Green
; Creation Date - 11/05/93
; Last Modified -
;   Modified by -
;  Changes Made -
;
; This process serves as a "standard" Wait Proc for Dialog Boxes that other-
; wise have nothing to trap for - this Wait Proc just catches the [Esc] key
; if there is no "Cancel" button, or calls the Calpops() process when the
; user presses [Ctrl][C]
; 

PROC StockDialogWait(triggertype,tagvalue,eventvalue,elementvalue)

SWITCH
      CASE (triggertype = "EVENT") AND (eventvalue["TYPE"] = "KEY") AND
           (eventvalue["KeyCode"] = 27) :
           CANCELDIALOG

      CASE (triggertype = "EVENT") AND (eventvalue["TYPE"] = "KEY") AND
           (eventvalue["KeyCode"] = 3) :
           Calpops()

           RETURN (True)

ENDSWITCH

ENDPROC

WRITELIB libname StockDialogWait
RELEASE PROCS    StockDialogWait

; --------------------
; this is for the demo

PLAY "Utility2"
PLAY "Utility3"
PLAY "Utility4"

Calpops()

; end of demo code
; --------------------
