; The Amt2Str script converts dollar amounts (numeric) to word strings
; for check printing.
;
; Amt2Str adapted by Glenn Pence on 10/6/93 - updated 4/26/94.
;
; Original script featured in the Dec 1993 issue of 
; Cobb's _PARADOX DEVELOPER'S JOURNAL_.
;
; Modified to use "X dollars and Y cents" OR "X and Y/100 dollars" ouput.
; Allows leading or trailing fill characters (*****).
;
PROC AMTSTR(amount)                     ; amount is the numeric value 
PRIVATE c_amt, dnums, w_amt, i         
c_amt=FORMAT("W13.2,EZ",amount)         ; c_amt is the currency amount
; create an array of word numbers
ARRAY numbers[90]
 numbers[1]="ONE"
 numbers[2]="TWO"
 numbers[3]="THREE"
 numbers[4]="FOUR"
 numbers[5]="FIVE"
 numbers[6]="SIX"
 numbers[7]="SEVEN"
 numbers[8]="EIGHT"
 numbers[9]="NINE"
 numbers[10]="TEN"
 numbers[11]="ELEVEN"
 numbers[12]="TWELVE"
 numbers[13]="THIRTEEN"
 numbers[14]="FOURTEEN"
 numbers[15]="FIFTEEN"
 numbers[16]="SIXTEEN"
 numbers[17]="SEVENTEEN"
 numbers[18]="EIGHTEEN"
 numbers[19]="NINETEEN"
 numbers[20]="TWENTY"
 numbers[30]="THIRTY"
 numbers[40]="FORTY"
 numbers[50]="FIFTY"
 numbers[60]="SIXTY"
 numbers[70]="SEVENTY"
 numbers[80]="EIGHTY"
 numbers[90]="NINETY"
; reset w_amt, find the length of the parameter "amount", set i counter to 1.
 w_amt=""
 length = LEN(amount)
 i=1
; test to see if the amount is too large
 IF amount>999999999.99
  THEN 
   QUIT "Amount too large... program terminated. "
 ENDIF
; test to see if the amount is too small
 IF amount<0
  THEN 
   QUIT "Amount too small... program terminated. "
 ENDIF
; While loop passes 3 times to find the millions, thousand, hundreds, etc.
; dnums is the digits number variable (group of 000)
 WHILE i <= 3
  SWITCH
   CASE i = 1:
    dnums = SUBSTR(c_amt,2,3)
   CASE i = 2:
    dnums = SUBSTR(c_amt,5,3)
   CASE i = 3:
    dnums = SUBSTR(c_amt,8,3)
  ENDSWITCH
; Check the hundreds position ...
  IF SUBSTR(dnums,1,1) > "0" 
   THEN
    w_amt = w_amt + numbers[NUMVAL(SUBSTR(dnums,1,1))] + " HUNDRED "
  ENDIF
; Check tens and ones positions ... 
  dtens = NUMVAL(SUBSTR(dnums,2,2))
  IF dtens > 0 
   THEN
    IF dtens > 20 
     THEN
      w_amt = w_amt + numbers[NUMVAL(SUBSTR(dnums,2,1)+"0")]
      IF SUBSTR(dnums,3,1) > "0" 
       THEN
        w_amt = w_amt + "-" + numbers[NUMVAL(SUBSTR(dnums,3,1))] + " "
       ELSE
        w_amt = w_amt + " "
      ENDIF
     ELSE
      w_amt = w_amt + numbers[dtens] + " "
    ENDIF
  ENDIF
; Add "million" or "thousand" to string if needed...
  SWITCH
   CASE amount >= 1000000.00 AND i = 1:
    w_amt = w_amt + "MILLION "
   CASE (amount >= 1000.00 AND dnums<>"000") AND i = 2:
    w_amt = w_amt + "THOUSAND "
  ENDSWITCH
; increment counter variable i for while loop  
  i = i + 1
 ENDWHILE
;--------------------------------------------------------------------------
; this portion is used for X DOLLARS AND Y CENTS format. 
;
 IF w_amt = "" 
  THEN 
   w_amt = "ZERO " 
 ENDIF
 w_amt = w_amt + "DOLLAR" + IIF((amount>.994 AND amount<1.995), " ", "S ")
 IF SUBSTR(c_amt,Len(c_amt)-1,2) = "00" OR SUBSTR(c_amt,Len(c_amt)-1,2) = ""
  THEN 
   w_amt = w_amt + "AND NO CENTS***"
  ELSE
   IF SUBSTR(c_amt,LEN(c_amt)-1,2) = "01" 
    THEN  
     w_amt = w_amt + "AND " + SUBSTR(c_amt,LEN(c_amt)-1,2) + " CENT***"
    ELSE 
     w_amt = w_amt + "AND " + SUBSTR(c_amt,LEN(c_amt)-1,2) + " CENTS***" 
   ENDIF
 ENDIF
 IF (w_amt = "ZERO DOLLARS AND NO CENTS***")  OR (w_amt = "ZERO DOLLARS AND 00/100***")
  THEN 
   w_amt = "***** VOID *** VOID *** VOID *** NON-NEGOTIABLE *** VOID *** VOID *** VOID *****" 
 ENDIF
;
; -------------------------------------------------------------------------  
;
; this portion used for the X AND Y/100 DOLLARS format.
;
; if amount is less than 1 dollar substitute ONLY and adjust DOLLARS to DOLLAR.
; w_amt = IIF(amount < 1, "ONLY ",w_amt + "AND ") + 
;         SUBSTR(c_amt,LEN(c_amt)-1,2) + "/100 " +
;         "DOLLAR" + IIF(amount=1,"***","S***")
; 
; add leading or trailing fill characters to avoid alternations.
 w_amt = FILL("*",MAX(80-LEN(w_amt),0)) + w_amt   ; uses leading  *'s to fill
; w_amt = w_amt + FILL("*",MAX(80-LEN(w_amt),0))   ; uses trailing *'s to fill
 RETURN w_amt
ENDPROC
; write procedure to a library
WRITELIB "GPTOOLS" AMTSTR
RELEASE PROCS AMTSTR


;
;
;  NOTES & COMMENTS:
;==========================================================================
;
; Remember to change the library (WRITELIB) command to your appropriate
; library name.
;
; You can modify Amt2Str in several ways: 
;
; You can change the print format by "commenting out" the other format
; which is not to be used and you can change the fill character format from
; leading to trailing. You may also change the string which prints out in the
; event of a zero number, although it isn't really necessary as MOST banks
; would notice the ZERO DOLLARS AND NO CENTS amount.
;
; This program tries to catch all the possible rounding situations in order 
; to properly display singular versus plural situations.
;
; Below is a short script named CASH.SC which lets you test the AMT2STR.SC.
; It has been "commented-out" using semi-colons. To use this script you 
; should cut and paste the following code to a new script called CASH.SC.
; Remember to remove each leading semicolon below the title line and remember
; to "play" AMT2STR.SC before you run CASH.SC.
;
; Enjoy!!
;
;-----------------------------------------------------
;; CASH.SC is used to test the Amt2Str.sc
;; Written by Glenn Pence 10/7/93
;;
;READLIB "C:\\DATA\\PDOX\\GPTOOLS" AMTSTR
;WHILE (true)
;INPUTVAL = ""
;CLEAR
;@2,0 ?? "Please enter a dollar amount: "
;accept "N" to inputval
;AMOUNT = AMTSTR(inputval)
;@4,0 ?? "PAY :   "
;@5,0 ?? AMOUNT
;MESSAGE " Press Q to quit... Any other key to continue "
;KEYSTROKE = GETCHAR()
;IF (KEYSTROKE = ASC("Q")) OR (KEYSTROKE = ASC("q")) THEN quitloop ENDIF
;LOOP
;ENDWHILE   
;
