////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
//		Zip Studio 1.2 COPYRIGHT 1993, 1994 Denis CHEVRON ( Patch 1.0, 12 july 1994 )
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//		Zip functions declarations header file for C/C++
//		To Zip, Put ZDLL12A.DLL and ZDLL12B.DLL in the current dir and 
//		link with ZDLL12A.DLL (ZDLL12A.LIB) and define _GOZIP.
//		To UnZip, Put UZDLL12.DLL in the current dir, link with UZDLL12.DLL
//		(UZDLL12.LIB) and define _GOUNZIP.                               
//
//
//		Patch 1.0, See PATCH1.WRI for more informations
//		(doesn' t include specific VB functions)
//		
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define _GOZIP			// to remove?
#define _GOUNZIP		// to remove?

#ifndef _zip_h
#define _zip_h

#ifdef __cplusplus
extern "C"
	{
#endif


#ifdef _GOZIP
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//		Zip functions
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/* Errors constants */
#define ZERROR_OK		0	// No error
#define ZERROR_WARNING		1	// Just a warning (not an error)
#define ZERROR_DESTFILE		2	// Destfile ( *.ZIP ) error
#define ZERROR_INTERNAL 	3	// Internal error
#define ZERROR_FORMAT		4	// Not a Zip file
#define ZERROR_NOMEM		5	// Not enough memory 
#define ZERROR_NOFILE		6	// Nothing to do ( can be just a warning )
#define ZERROR_NODLL		7	// Can' t find required DLLs
#define ZERROR_COMMENT		8	// Comment missing or NULL


/* Overwrite mode */
#define OVERWRITE_ALWAYS	0	// Always overwrite ( always zip files ) (default)
#define OVERWRITE_NEVER		1 	// Never overwrite
#define OVERWRITE_PROMPT	2	// Ask the user
#define OVERWRITE_UPDATE	3	// Overwrite if external file is newer


/* Language mode ( for the replace dialog box )*/
#define LANGUAGE_FRENCH		0	// French mode
#define LANGUAGE_ENGLISH	1	// US Mode ( default )


/* More easy to use with AddFileToZip */
#define STOREPATH_NO		0	// Don' t store paths
#define STOREPATH_YES		1	// Store paths
#define RECURSE_NO		0	// Don' t recurse sub dirs
#define RECURSE_YES		1	// Recurse sub dirs


/* Notification messages */
#define ZN_ZIPPING		WM_USER + 46	// Zipping a file, WP = compressed size in K, LP = current file name
#define ZN_FILEZIPPED		WM_USER + 45	// File is zipped, WP = compress rate, LP = file name
#define ZN_WRITING		WM_USER + 48	// Replace the Zip file, LP = zip file name
#define ZN_DELETING		WM_USER + 47	// Delete a file , LP = current file name
#define ZN_REPARING		WM_USER + 49	// Repare a Zip file, WP = (int)state
						//	step =  1 : Read / Write ,  LP = current file name
						//	step = 3 : Checking zip file, LP = zip file name
#define ZN_COMPUTE		WM_USER +52	// Before zip read, WP = zip files ( over 500, computing can be very long )


/* Main functions */
extern void WINAPI ZipInit( LPCSTR szYourName, LPCSTR szPassword );     // Init the Zip DLL
extern int  WINAPI AddFileToZip( LPCSTR szZipFile, LPCSTR szMask, 
				 int OverwriteMode, BOOL bStorePath,
				 BOOL bRecurse, HWND hParentWnd );	// Zip a file
extern int  WINAPI ZipDeleteFiles( LPCSTR szZipFile, LPCSTR szFiles, 
				   HWND hParentWnd );			// Delete files in a Zip
extern int  WINAPI ZipRepare( LPCSTR szZipFile, HWND hParentWnd );	// Recreate the Zip file
extern int  WINAPI ZipSetComment( LPCSTR szZipFile, LPCSTR szComment, 
				  HWND hParentWnd );			// Set the Zip Comment
				  

/* Helpers */
extern BOOL WINAPI ZipSetLanguage( UINT cZipLanguage );			// Set the Language
extern int  WINAPI ZipGetReplaceFlag( void );				// Return the current overwrite mode


#endif // _GOZIP


#ifdef _GOUNZIP	
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//		UnZip functions
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/* Initialisation function */
extern void WINAPI UnzipInit( LPCSTR szYourName, LPCSTR szPassword );	// required, if you are not a registered user szYourName = "TEST"


/* Interface constants */
#ifndef LANGUAGE_FRENCH
	#define LANGUAGE_FRENCH		0	// french language will be used in the replace dialog box
#endif
#ifndef LANGUAGE_ENGLISH
	#define LANGUAGE_ENGLISH	1	// English language will be used in the replace dialog box ( default )
#endif


/* Interface setting functions */
extern BOOL WINAPI UnzipSetMsgBoxTitle( LPCSTR szNewTitle );	// Set the replace dialog box title ( default = "Replace...");
extern void WINAPI UnzipSetLanguage( UINT iLanguage );		// Set the language for the replace dialog box
extern BOOL WINAPI UnzipSetReceivingWindow( HWND hWnd );	// Set the window for notification messages
extern void WINAPI UnzipSetBackgroundMode( BOOL bBackGroundMode );	// if TRUE, activate the multitask mode ( default )


/* Zip method constants */
#define		ZMETHOD_STORED		0
#define		ZMETHOD_SHRUNK		1
#define		ZMETHOD_REDUCE1		2
#define		ZMETHOD_REDUCE2		3
#define		ZMETHOD_REDUCE3		4
#define		ZMETHOD_REDUCE4		5
#define		ZMETHOD_IMPLODE		6
#define		ZMETHOD_TOKEN		7
#define		ZMETHOD_DEFLATE		8
#define		ZMETHOD_UNKNOWN		9
#define		ZMETHOD_ERROR		10


/* Information functions ( Zip ) */
extern int WINAPI CountFileInZip( LPCSTR szFileName );					// Return number of files in this Zip File
extern LPSTR WINAPI GetFileNameFromZIP( LPCSTR szFileName, UINT iFileNumber );		// Return the name of the iFileNumber file in this Zip File
extern long WINAPI GetZFileOriginalSize( LPCSTR szZIPFileName, LPCSTR szFileName );	// Return the not compressed size of szFileName in octets.
extern long WINAPI GetZFileCompressedSize( LPCSTR szZIPFileName, LPCSTR szFileName );	// Return the compressed size of szFileName in octets.
extern LPSTR WINAPI GetZFileDate( LPCSTR szZIPFileName, LPCSTR szFileName );		// Return the date of a file in a Zip
extern LPSTR WINAPI GetZFileTime( LPCSTR szZIPFileName, LPCSTR szFileName );		// Return the time of a file in a Zip
extern UINT WINAPI GetZCompressMethod( LPCSTR szZipFileName, LPCSTR szFileName );	// Return the Zip method for a file ( ZMETHOD_* )
extern BOOL WINAPI IsThisFileAZipFile( LPCSTR szFileName );		// return TRUE if this file seems to be a zip file
extern BOOL WINAPI IsFileUnzipable( LPCSTR szFileName );		// return TRUE if this file name can be reproduce under DOS
extern UINT WINAPI GetZipCommentLength( LPCSTR szFileName );		// return the size of the zip file comment in octets
extern BOOL WINAPI GetZipComment( LPCSTR szFileName, LPSTR szBuffer );	// Put the zip comment in buffer


/* Information functions ( General ) */
extern BOOL WINAPI bDoesFileExist( LPCSTR szFileName );				// True if this file exists
extern LPSTR WINAPI GetShortFileName( LPCSTR szFileName );			// Return filename without any path
extern LPSTR WINAPI GetPathFromFileName( LPCSTR szFileName );			// Return the path without the file name
extern BOOL WINAPI IsFileNameInFilter( LPCSTR szFileName, LPCSTR szMask );	// Return TRUE if filename is in specified filter


/* Extraction function result constants */
#define ZEXTRACT_OK			0
#define ZEXTRACT_INTERNALERROR		1
#define ZEXTRACT_FILENOTFOUND		2
#define ZEXTRACT_CORRUPTED		3
#define ZEXTRACT_EMPTY			4
#define ZEXTRACT_ERRORINZIPFILE		5
#define ZEXTRACT_NOMEM			6
#define ZEXTRACT_DISKFULL		8
#define ZEXTRACT_WARNING		10


/* Helper constants */
#define OVERWRITE_FALSE			0
#define OVERWRITE_TRUE			1
#define OVERWRITE_QUERY			2
#define CREATEDIR_FALSE			0
#define CREATEDIR_TRUE			1


/* Extraction functions */                                        
extern UINT WINAPI ExtractZipFiles( LPCSTR szFileName, LPCSTR szMask, LPCSTR szDestDir, UINT bOverwrite, BOOL bCreateDir );
extern int WINAPI GetQueryFlag( void );		// Return the overwrite mode the user asked for


/* Notification messages for UNZIP and VIEW*/
#define ZN_OPENFILE		WM_USER + 38		// Open a file, WP = TRUE if Ok, LP = filename
#define ZN_EXPANDING		WM_USER + 39		// Unzipping a file, WP = file current rate, LP = filename
#define ZN_CLOSEFILE		WM_USER + 40		// Close a file, WP = TRUE if Ok, LP = filename


/* View function */
extern BOOL WINAPI ViewFileFromZip( LPCSTR szZipFile, LPCSTR szMask, BOOL bTextOnly );	// view one or several files in a Zip


#endif // _GOUNZIP

#ifdef __cplusplus
	}
#endif

/* ---------------------------------------- End of file ------------------------------------------*/
#endif
			
