(***************************************************************************************************************************)
(*                                                                                                                         *)
(*		Zip Studio 1.2 COPYRIGHT 1993, 1994 Denis CHEVRON                                                                    *)
(*    Source File: ZIP.PAS                                                                                                 *)
(*    Description: Pascal Source file to encapsulate the ZDLL12A.DLL file to provide the functionality to                  *)
(*                 Borland Pascal developers.  This version was written for BP v7.0 but contains nothing that              *)
(*                 would prohibit its adaption to earlier versions.                                                        *)
(*    Date:        Wed Jul 13 17:06:53 1994                                                                                *)
(*    Author:      Brad Stowers, CIS: 72733,3374                                                                           *)
(*                               Internet: brad.stowers@delta.com                                                          *)
(*                                                                                                                         *)
(***************************************************************************************************************************)
(*                                                                                                                         *)
(*		To Zip, Put ZDLL12A.DLL and ZDLL12B.DLL in your applications directory and add this unit to your USES clause.        *)
(*    By using this unit, you are NOT required to use LoadLibrary and FreeLibrary.  Simply call these parameters as you    *)
(*    would any other unit.                                                                                                *)
(***************************************************************************************************************************)

unit UnZip;

interface

uses WinTypes;

(***************************************************************************************************************************)
(* The UNZIP.INC file contains constants that will be useful when calling these functions.  By including it here, you      *)
(* don't have to include it in your own program.  Do have a look at it so that you will know what is available.            *)
(***************************************************************************************************************************)

{$I UNZIP.INC }

(* Initialization function *)
  procedure UnzipInit(YourName, Password: pChar);             { required.  If you aren't a registered user, set         }
                                                              { YourName to 'TEST' and Password to ''                   }

(* Interface setting functions *)
  function  UnzipSetMsgBoxTitle(NewTitle: pChar): boolean;	   { Set the replace dialog box title ( default = "Replace...") }
  procedure UnzipSetLanguage(Language: word);                  { Set the language for the replace dialog box }
  function  UnzipSetReceivingWindow(Wnd: hWnd): boolean;       { Set the window for notification messages }
  procedure UnzipSetBackgroundMode(BackGroundMode: boolean);   { if TRUE, activate the multitask mode ( default ) }

(* Information functions ( Zip ) *)
  function  CountFileInZip(FileName: pChar): integer;          { Return number of files in this Zip File }
  function  GetFileNameFromZip(FileName: pChar;
                               FileNumber: integer): pChar;    { Return the name of the iFileNumber file in this Zip File }
  function  GetZFileOriginalSize(ZIPFilename,
                                 FileName: pChar): LongInt;    { Return the not compressed size of szFileName in octets. }
  function  GetZFileCompressedSize(ZIPFileName,
                                   FileName: pChar): LongInt;  { Return the compressed size of szFileName in octets. }
  function  GetZFileDate(ZIPFileName, FileName: pChar): pChar; { Return the date of a file in a Zip }
  function  GetZFileTime(ZIPFileName, FileName: pChar): pChar; { Return the time of a file in a Zip }
  function  GetZCompressedMethod(ZIPFileName,
                                 FileName: pChar): Word;       { Return the Zip method for a file ( ZMETHOD_* ) }
  function  IsThisFileAZipFile(FileName: pChar): boolean;      { Return TRUE if this file seems to be a zip file }
  function  IsFileUnzipable(FileName: pChar): boolean;         { Return TRUE if this file name can be reproduce under DOS }
  function  GetZipCommentLength(FileName: pChar): word;        { Return the size of the zip file comment in octets }
  function  GetZipComment(FileName, Buffer: pChar): boolean;   { Put the zip comment in buffer }

(* Information functions ( General ) *)
  function DoesFileExist(FileName: pChar): boolean;            { True if this file exists }
  function GetShortFileName(FileName: pChar): pChar;           { Return filename without any path }
  function GetPathFromFileName(FileName: pChar): pChar;        { Return the path without the file name }
  function IsFileNameInFilter(FileName, Mask: pChar): boolean; { Return TRUE if filename is in specified filter }

(* Extraction functions *)
  function ExtractZipFiles(FileName, Mask,DestDir: pChar;
                           Overwrite: word;
                           CreateDir: word): word;             { Go get them }
  function GetQueryFlag: integer;                              { Return the overwrite mode the user asked for }

(* View function *)
  function ViewFileFromZip(ZipFile, Mask: pChar;
                           TextOnly: boolean): boolean;        { View one or several files in a Zip }

implementation

  procedure UnzipInit;                                         external 'UZDLL12';
  function  UnzipSetMsgBoxTitle;                               external 'UZDLL12';
  procedure UnzipSetLanguage;                                  external 'UZDLL12';
  function  UnzipSetReceivingWindow;                           external 'UZDLL12';
  procedure UnzipSetBackgroundMode;                            external 'UZDLL12';
  function  CountFileInZip;                                    external 'UZDLL12';
  function  GetFileNameFromZip;                                external 'UZDLL12';
  function  GetZFileOriginalSize;                              external 'UZDLL12';
  function  GetZFileCompressedSize;                            external 'UZDLL12';
  function  GetZFileDate;                                      external 'UZDLL12';
  function  GetZFileTime;                                      external 'UZDLL12';
  function  GetZCompressedMethod;                              external 'UZDLL12';
  function  IsThisFileAZipFile;                                external 'UZDLL12';
  function  IsFileUnzipable;                                   external 'UZDLL12';
  function  GetZipCommentLength;                               external 'UZDLL12';
  function  GetZipComment;                                     external 'UZDLL12';
  function  DoesFileExist;                                     external 'UZDLL12';
  function  GetShortFileName;                                  external 'UZDLL12';
  function  GetPathFromFileName;                               external 'UZDLL12';
  function  IsFileNameInFilter;                                external 'UZDLL12';
  function  ExtractZipFiles;                                   external 'UZDLL12';
  function  GetQueryFlag;                                      external 'UZDLL12';
  function  ViewFileFromZip;                                   external 'UZDLL12';

end.