USES CRT, DOS;
(*
 Ŀ
  High Level Extended Memory Calls for Turbo Pascal, Should work with      
  versions 4.0 and above, but tested with Borland's Turbo Pascal 5.5.      
                                                                           
  This program which may be converted to a unit gives all of the functions 
  which should concern the application programmer in moving data to and    
  from XMS memory.  It also renders "C like" functions to write address    
  data in hex to screen or file.                                           
                                                                           
  Victor E. Cummings                                                       
  AstroSoft Data Systems, Inc.                                             
  P.O. Box 12295                                                           
  Baltimore, Maryland 21281                                                
  (301) 675-3607                                                           
                                                                           
  Compile Using TPC XMS                                                    
                                                                           
 *)
{$F+} (* Go ahead and take this out if you like to reboot! *)
TYPE
MoveStruct = RECORD
    Len           : LONGINT;  { dd  ?   ; 32-bit number of bytes to transfer   }
    SourceHandle  : WORD;     { dw  ?   ; Handle of source block               }
    SourceOffset  : POINTER;  { dd  ?   ; 32-bit offset into source            }
    DestHandle    : WORD;     { dw  ?   ; Handle of destination block          }
    DestOffset    : POINTER;  { dd  ?   ; 32-bit offset into destination block }
END;
    WordString = STRING [ 4 ];
    VerString  = STRING [ 5 ];
    Str127     = STRING [ 127 ];
VAR
XHANDLE       : WORD;
REQUEST       : WORD;
STATUS        : WORD;
REGS          : REGISTERS;
MoveRec       : MoveStruct;
HelloStr      : STRING;
CH            : CHAR;
ScanLine      : Str127;
Z             : LONGINT;
NumStr        : STRING;
SavedExitProc : POINTER;
(*Ŀ
   This function adjusts the length byte of a Turbo Pascal string 
   to remove trailing spaces.                                     
  *)
FUNCTION CutSp ( Passed_String : STRING ) : STRING;
VAR
   i,
   j       : INTEGER;
BEGIN
     j := LENGTH ( Passed_String );

     WHILE ( Passed_String [ j ] = ' ') AND (j > 0) DO
        j := j - 1;

     Passed_String [ 0 ] := CHR ( j );

     CutSp := Passed_String;
END;
(*Ŀ
   This function converts a byte or word length variable to       
   a hexadecimal string.                                          
  *)
FUNCTION HexWord ( i : INTEGER ) : WordString;
CONST
hc : array[0..15] of Char = '0123456789ABCDEF';
VAR
l, h : BYTE;
BEGIN
  l := LO ( i ); h := HI ( i );
  HexWord := hc [ h SHR 4 ] + hc [ h AND $F ] +
  hc [ l SHR 4 ] + hc [ l AND $F ];
  END;
(*
Ŀ
   XMSInstalled : BOOLEAN                                                   
                                                                            
   GAZINTAS:>NONE                                                          
   GAZOWTAS:  RETURNS True if XMS is installed.                             
*)
FUNCTION XMSInstalled: BOOLEAN;
VAR
REGS : REGISTERS;
BEGIN
  WITH REGS DO
    BEGIN
      AH := $43;
      AL := $00;
      INTR ($2f, REGS);
      IF (AL = $80) THEN XMSInstalled := TRUE
        ELSE XMSInstalled := FALSE;
    END;
END;
{$L XMM.OBJ} (* Assembler module assembled using Borland TASM 2.5 *)
             (* TASM XMM *)
(*
Ŀ
   XMMVer   WORD; EXTERNAL                                                  
                                                                            
   GAZINTA :>NONE                                                          
                                                                            
   GAZOWTA :  Returns Version in DECIMAL Converted to BCD int XMSVersion    
*)
FUNCTION XMMVER : INTEGER; EXTERNAL;
(*
Ŀ
   XMMRev : WORD; EXTERNAL                                                  
                                                                            
   GAZINTAS:>NONE                                                          
                                                                            
   GAZOWTAS:  Returns External Revision Number in Decimal.                  
   converted to BCD by XMSRevision.                                         
*)
FUNCTION XMMRev     : INTEGER; EXTERNAL;
(*
Ŀ
   XMMFree : WORD; EXTERNAL                                                 
                                                                            
   GAZINTAS:>NONE                                                          
                                                                            
   GAZOWTAS:  Returns amount of currently free XMS memory in KB.            
*)
FUNCTION XMMFREE    : WORD; EXTERNAL;
(*
Ŀ
   XMMTotal: WORD; EXTERNAL                                                 
                                                                            
   GAZINTAS:>NONE                                                          
                                                                            
   GAZOWTAS:  Returns total amount of XMS memory in KB.                     
*)
FUNCTION XMMTOTAL   : WORD; EXTERNAL;
(*
Ŀ
   XMMMalloc(Requested: WORD): WORD; EXTERNAL                               
                                                                            
   GAZINTAS:>Requested amount in KB                                        
                                                                            
   GAZOWTAS:  Returns status of 0001h if successful.                        
               0080h if the function is not implemented                     
               0081h if a VDISK device is detected                          
               00A0h if all available extended memory is allocated          
               00A1h if all available extended memory handles are in use    
*)
FUNCTION XMMALLOC(Requested: WORD) : WORD; EXTERNAL;
(*
Ŀ
   XMMDispose(Handle : WORD): WORD; EXTERNAL                                
                                                                            
   GAZINTAS:>Handle to get rid of                                          
                                                                            
   GAZOWTAS:  Returns status of 0001h if successful.                        
               0080h if the function is not implemented                     
               0081h if a VDISK device is detected                          
               00A2h if the handle is invalid                               
               00ABh if the handle is locked                                
*)
FUNCTION XMMDISPOSE(XHANDLE: WORD) : WORD; EXTERNAL;

FUNCTION XMMMove   : WORD; EXTERNAL;
(*
Ŀ
   XMMLock(Handle : WORD): WORD; EXTERNAL                                   
                                                                            
   GAZINTAS:>Handle to lock                                                
                                                                            
   GAZOWTAS:  Returns status of 0001h if successful.                        
               0080h if the function is not implemented                     
               0081h if a VDISK device is detected                          
               00A2h if the handle is invalid                               
               00ACh if the block's lock count overflows                    
               00ADh if the lock fails                                      
*)
FUNCTION XMMLOCK(XHANDLE: WORD)    : WORD; EXTERNAL;
(*
Ŀ
   XMMUnLock(Handle : WORD): WORD; EXTERNAL                                 
                                                                            
   GAZINTAS:>Handle to unlock                                              
                                                                            
   GAZOWTAS:  Returns status of 1 if successful.                            
               0080h if the function is not implemented                     
               0081h if a VDISK device is detected                          
               00A2h if the handle is invalid                               
               00AAh if the block is not locked                             
*)
FUNCTION XMMUNLOCK(XHANDLE : WORD)  : WORD; EXTERNAL;
(*
Ŀ
   XMMGetBlockSize(Handle : WORD): WORD; EXTERNAL                           
                                                                            
   GAZINTAS:>Handle query                                                  
                                                                            
   GAZOWTAS:  Returns amount of memory in KB held by Handle                 
               0080h if the function is not implemented                     
               0081h if a VDISK device is detected                          
               00A2h if the handle is invalid                               
*)
FUNCTION XMMGetBlockSize(XHANDLE : WORD)  : WORD; EXTERNAL;
(*
Ŀ
   XMMGetHandles(Handle : WORD): WORD; EXTERNAL                             
                                                                            
   GAZINTAS:>Handle query                                                  
                                                                            
   GAZOWTAS:  Returns number of free handles in the system                  
               0080h if the function is not implemented                     
               0081h if a VDISK device is detected                          
               00A2h if the handle is invalid                               
*)
FUNCTION XMMGetHandles(XHANDLE : WORD)  : WORD; EXTERNAL;
(*
Ŀ
   XMMRealoc(Handle : WORD; NewSize: WORD): WORD; EXTERNAL                  
                                                                            
   GAZINTAS:>Handle, New Size to make previously allocated block           
                                                                            
   GAZOWTAS:  Returns 0001h if successful                                   
   GAZOWTAS:  Returns 0000h if unsuccessful                                 
*)
FUNCTION XMMREALOC(XHANDLE : WORD; NewSize : WORD)  : WORD; EXTERNAL;
FUNCTION XMMVersion : VerString;
VAR
XMMHIGH    : STRING[2];
XMMLOW     : STRING[2];
TempString : STRING;
  BEGIN
    TempString := HexWord(XMMVer);
    TempString := Cutsp(TempString);
    XMMHIGH    := COPY(TempString,1,2);
    XMMLOW     := COPY(TempString,3,2);
    TempString := XMMHIGH + '.' + XMMLOW;
    IF (COPY(TempString,1,1) = '0') THEN
    TempString := COPY(TempString,2,4);
    XMMVersion := CutSp(TempString);
  END;
FUNCTION XMMRevision: VerString;
VAR
XMMHIGH    : STRING[2];
XMMLOW     : STRING[2];
TempString : STRING;
  BEGIN
    TempString  := HexWord(XMMRev);
    TempString  := Cutsp(TempString);
    XMMHIGH     := COPY(TempString,1,2);
    XMMLOW      := COPY(TempString,3,2);
    TempString  := XMMHIGH + '.' + XMMLOW;
    IF (COPY(TempString,1,1) = '0') THEN
    TempString  := COPY(TempString,2,4);
    XMMRevision := CutSp(TempString);
  END;
{$F+} PROCEDURE CustomExit; {$F-}
BEGIN
    WRITELN('Disposing of XMM Handle: ', XHANDLE );
    STATUS := XMMDISPOSE (XHANDLE);
    WRITELN('Status: ', HexWord(STATUS));
END;
BEGIN
  IF XMSInstalled AND (XMMFree >= 1024) THEN
    BEGIN
      SavedExitProc := EXITPROC;
      EXITPROC   := @CustomExit;
      TEXTBACKGROUND(BLUE);
      TEXTCOLOR(WHITE);
      CLRSCR;
      HelloStr := 'Hello world - I came from XMS memory! ';
      WRITELN('XMS Version Number             :   ', XMMVersion);
      WRITELN('XMS Internal Revision Number   :   ', XMMRevision);
      WRITELN('XMS Free Memory  in Kilo Bytes :   ', XMMFREE);
      WRITELN('XMS Total Memory in Kilo Bytes :   ', XMMTOTAL);
      WRITELN('Allocating 256 KB EMB ...');
      WRITELN('Locking EMB Handle');
      XHANDLE := XMMALLOC(256);
      STATUS := XMMLOCK(XHANDLE);
      WRITELN ('Status of Lock:  ', HexWord(STATUS));
      WRITELN ('Handle Returned:  ', XHANDLE);
      WRITELN('XMS Free Memory in Kilo Bytes after allocation :   ', XMMFREE);
      WRITELN; WRITELN; WRITELN;
      WRITELN ('Press a key to test move functions.');
      CH := READKEY;
      CLRSCR;
      WRITELN('Moving String to allocated block');
      WITH MoveRec DO
      BEGIN
        Len          := LENGTH(HelloStr);
        SourceHandle := 0;
        SourceOffset := PTR(SEG(HelloStr),OFS(HelloStr) + 1);
        DestHandle   := XHANDLE;
        DestOffset   := PTR(0,0);
      END;
      WRITELN('String in base memory is now:  ', HelloStr);
      STATUS := XMMMove;
      WRITELN ('Status of Move:  ', HexWord(STATUS) );
      WRITELN ('Clearing String in base memory');
      {Create storage of correct size for string!}
      HelloStr := '                                      ';
      WRITELN('String in base memory is now:  ', HelloStr);
      WITH MoveRec DO
      BEGIN
        Len          := LENGTH(HelloStr);
        SourceHandle := XHANDLE;
        SourceOffset := PTR(0,0);
        DestHandle   := 0;
        DestOffset   := PTR(SEG(HelloStr),OFS(HelloStr) + 1);
      END;
      STATUS := XMMMove;
      WRITELN ('Status of Move:  ', HexWord(STATUS));
      WRITELN('Printing String: ');
      WRITELN('String in base memory is now:  ', HelloStr);
      WRITELN('UnLocking EMB Handle');
      STATUS := XMMUNLOCK(XHANDLE);
      WRITELN ('Status of Unlock:  ', HexWord(STATUS));
      WRITELN('Adjusting block size closer to data size');
      STATUS := XMMREALOC(XHANDLE, 3);
      WRITELN ('Status of reallocation:  ', HexWord(STATUS));
      WRITELN('Current Block Size:  ', XMMGetBlockSize(XHANDLE), ' KB');
      WRITELN('Number of Free Handles:  ', XMMGetHandles(XHANDLE));
      WRITELN('XMS Free Memory  in Kilo Bytes :   ', XMMFREE);
      WRITELN('Disposing of ', XMMGetBlockSize(XHANDLE), ' KB EMB ...');
      STATUS := XMMDISPOSE (XHANDLE);
      WRITELN ('Status:  ', HexWord(STATUS));
      WRITELN ('Handle Disposed:  ', XHANDLE);
      WRITELN('XMS Free Memory in Kilo Bytes :   ', XMMFREE);
      WRITELN;
      WRITELN;
      WRITELN;
      WRITELN('  Press a key to store 1 MB array of 127 character strings in XMS');
      CH := READKEY;
      WRITELN('Testing Array of Strings.');
 {!}  XHANDLE := XMMALLOC(1024); {Change to smaller number if less than 1 MB}
      {You must allocate the proper length object for the move}
      FillChar (ScanLine, 127, ' ');
 {!}   FOR Z := 1 TO 8191 DO
      BEGIN
        MoveRec.SourceHandle := 0;
        {Bypass Turbo Pascal's length byte by offset of one from string address}
        MoveRec.SourceOffset := PTR(SEG(ScanLine), OFS(ScanLine) + 1);
        MoveRec.DestHandle   := XHandle;
        MoveRec.DestOffset   := PTR((Z DIV 512),(Z MOD 512)*127-127);
        STR(Z, NumStr);
        ScanLine := 'String #: ' + NumStr + ' from XMS.';
        MoveRec.Len := 126;
        STATUS := XMMMove;
        WRITELN ('Status of Move: ',Hexword(STATUS), ' Moving String: ', Z, ' to XMS. <Ctrl><Break> to stop.');
     END;
     CLRSCR;
     WRITELN;
     WRITELN;
     WRITELN;
     WRITELN('  Now there is a 1 MB array of strings in XMS.  Press a key to');
     WRITELN('  read them from XMS to the screen.  <Ctrl><Break> at any time to stop.');
     CH := READKEY;
  {!}  FOR Z := 1 TO 8191 DO
      BEGIN
        MoveRec.DestHandle   := 0;
        MoveRec.DestOffset   := PTR(SEG(ScanLine),OFS(ScanLine) + 1);
        MoveRec.SourceHandle := XHandle;
        MoveRec.SourceOffset := PTR((Z DIV 512),(Z MOD 512)*127-127);
        MoveRec.Len := 126;
        STATUS := XMMMove;
        WRITELN(ScanLine,' Status: ',Hexword(STATUS), ' Offset: ', Z * 127 - 127, ' bytes from XMS Handle.' );
     END;
    END
    ELSE
    BEGIN
      WRITELN ('Buy some extended memory: requires 1 MB Free, or load HIMEM.SYS');
      WRITELN ('If you have less than 1 MB recompile source after changing the');
      WRITELN ('three lines marked with ! to smaller numbers.');
    END;
END.
