{$R-,S-,I+,D+,T-,F-,V+,B-,N-,L+ }
{$M 2048,0,0 }

PROGRAM WordWrap(INPUT,OUTPUT); {Version 1.01, 21 Nov 87}

   {This code is designed for the Turbo Pascal 4.0 compiler.  Version 1.00 was
     released to the public domain on 17 Nov 87.}
   {This program demonstrates word-wrapping so that text is professionally
     displayed on a console screen.  The source code and compiled program were
     developed by Rob Rosenberger, P.O. Box #643, O'Fallon, IL  62269-0643,
     CompuServe ID 74017,1344.  The source code and compiled program have been
     released to the public domain.  PROGRAMMERS: Please tell me about any
     improvements you feel can be made to this code!  I give credit to the
     first contributor of each idea I use.  Send an EasyPlex message with your
     improvements.  (Please tell me if you don't want your name included.)}
   {Version 1.01, released 21 Nov 87, adds the ability to split a word at a
     hyphen as well as to simply drop a complete word to the next line.}


USES
   CRT;

CONST
   FKeyCode          = #0;
   Space             = ' ';
   Hyphen            = '-';
   BackSpace         = ^H;
   CarriageReturn    = ^M;
   MaxWordLineLength = 80;

VAR
   WordLine  : STRING[MaxWordLineLength];
   Index1    : BYTE;
   Index2    : BYTE;
   InputChar : CHAR;

BEGIN {WordWrap}
{Initialize the program.}
WordLine  := '';
Index1    := 0;
Index2    := 0;
InputChar := Space;

{Open INPUT and OUTPUT.}
ASSIGNCRT(INPUT);
ASSIGNCRT(OUTPUT);
RESET(INPUT);
REWRITE(OUTPUT);

{Tell the user what this is all about.}
WRITELN(OUTPUT);
WRITELN(OUTPUT,'WORDWRAP Demonstration Program v1.01, 21 Nov 87');
WRITELN(OUTPUT,'This program demonstrates word-wrapping for programs which');
WRITELN(OUTPUT,'accept input that could traverse the 80-column screen width');
WRITELN(OUTPUT,'of most computers.  Type normally and press ENTER only when');
WRITELN(OUTPUT,'you''re finished.  Words that don''t fit on the current line');
WRITELN(OUTPUT,'will "wrap" onto the next.  Words that have hyphens in them');
WRITELN(OUTPUT,'will be split at the hyphen.  Begin typing now.');
WRITELN(OUTPUT);
WRITELN(OUTPUT);

{Read in the first char from the user.}
InputChar := READKEY;

{Do the job.}
WHILE (InputChar <> CarriageReturn)
 DO BEGIN
    CASE InputChar OF
      BackSpace: {write destructive backspace & remove char from WordLine}
        BEGIN
        WRITE(OUTPUT,BackSpace,Space,BackSpace);
        DELETE(WordLine,(LENGTH(WordLine) - 1),1)
        END;
      FKeyCode: {user pressed a function key, so dismiss it}
        BEGIN
        InputChar := READKEY; {function keys send two-char scan code!}
        InputChar := Space
        END
      ELSE {InputChar contains a valid char, so deal with it}
        BEGIN
        WRITE(OUTPUT,InputChar);
        WordLine := (WordLine + InputChar);
        IF (LENGTH(WordLine) >= (MaxWordLineLength - 1))
         THEN {we have to do a word-wrap}
            BEGIN
            Index1 := (MaxWordLineLength - 1);
            WHILE ((WordLine[Index1] <> Space)
             AND (WordLine[Index1] <> Hyphen)
             AND (Index1 <> 0))
             DO Index1 := (Index1 - 1);
            IF (Index1 = 0) {whoah, no space was found to split line!}
             THEN Index1 := (MaxWordLineLength - 1); {forces split}
            DELETE(WordLine,1,Index1);
            FOR Index2 := 1 TO LENGTH(WordLine)
             DO WRITE(OUTPUT,BackSpace,Space,BackSpace);
            WRITELN(OUTPUT);
            WRITE(OUTPUT,WordLine)
            END
        END
     END; {CASE InputChar}
    {Get next key from user.}
    InputChar := READKEY
    END; {WHILE (InputChar <> CarriageReturn)}

{Wrap up the program.}
WRITELN(OUTPUT);
WRITELN(OUTPUT);
CLOSE(INPUT);
CLOSE(OUTPUT)

{And that's all he wrote!}
END.