{ ******************************************************************************** }
{ ** Unit VerComp                                                               ** }
{ ** Gives info about compile-time options                                      ** }
{ ** Output sent to CRT under DOS and DPMI                                      ** }
{ **  or to either AUX: (AUX symbol defined) or a Message Box, under Windows    ** }
{ **                                                                            ** }
{ ** Successfully written and tested using BP7. should work with other version  ** }
{ ** with very little modifications (see at the end of file the bunch of $ifopt ** }
{ **                                                                            ** }
{ ** please note that the informations  given here are valid *only* after a     ** }
{ ** complete Build !                                                           ** }
{ **                                                                            ** }
{ ** Written in September 1994 by Cyrille Chplov, 100420,1574 - FREEWARE      ** }
{ ******************************************************************************** }
unit VerComp;
interface

{$ifdef WINDOWS}
{$define MSGBOX}
Uses WinTypes,WinProcs,Strings;
{$else}
{$ifdef WIN32} { I don't know whether the symbol 'WIN32' will replace or not the symbol 'WINDOWS' }
{$define MSGBOX}
Uses WinTypes,WinProcs,Strings;
{$else}
uses Strings;
{$endif}

{$endif}


Const
     SymbolsDefined : string = '';
var
     CompilerVersion : Word; { forme $700 }
Const

{$ifdef DOS}
     TargetName = 'DOS';
{$else}
   {$ifdef DPMI}
        TargetName = 'DPMI';
   {$else}
      {$ifdef WIN32}
          TargetName = 'Win32';
      {$else}
         {$ifdef WINDOWS}
            TargetName = 'Win16';
         {$else}
            TargetName = 'Unknown';
         {$endif}
      {$endif}
   {$endif}
{$endif}

{$ifdef CPU86}
{$ifopt G+}
     TargetProcessor = 'Intel 80286';
{$else G+}
     TargetProcessor = 'Intel 8086/8088';
{$endif G+}
{$else CPU86}
     TargetProcessor = 'Unknown';
{$endif CPU86}

var
     OptionsDefined : packed Record
               a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z : boolean;
          end;

Procedure DisplayCompilerInfo;
{ if symbol QUIET is defined, nothing will appear}
{ if symbol AUX is defined in Windows mode, data will be sent to AUX: in DOS format instead of
  popping up a Message Box}

{ --------------------------------------------------------------------------------------------------- }
implementation
{$ifdef AUX}
uses AuxCRT;
{$endif}

{$ifdef AUX} {$define CONSOLE} {$endif}
{$ifndef MSGBOX} {$define CONSOLE} {$endif}

{$ifdef QUIET}
Procedure DisplayCompilerInfo;  { nearly no strings will go into the .EXE }
begin end;
{$else QUIET}

{$ifdef CONSOLE}
Procedure Cat(p : PChar);
begin
     Write (p);
end;

{$else CONSOLE}
var
   msg : PChar;
   pt : Pchar;

Procedure Cat(p : Pchar);
begin
     pt := StrEnd(StrCat(pt,p));
end;

{$endif CONSOLE}

Procedure CatN(i : integer);
var
   s : string[10];
begin
     str(i,s); s := s+#0;
     Cat(@s[1]);
end;

Procedure Catln(p : PChar);
begin
     cat(p);
     cat(#13#10);
end;



Procedure DisplayCompilerInfo;
begin
{$ifndef CONSOLE}
     GetMem(msg,40000); { 40K cannot hurt a Windows computer :-) }
     msg^ := #0;
     pt := msg;
{$else CONSOLE}
     CatLN ('********* Project-wide Compiler Info ************');
{$endif CONSOLE}

     Cat ('Compiler version : '); CatN(Hi(CompilerVersion)); Cat('.'); CatN(Lo(CompilerVersion));
     Cat ('      Target : '); Cat(TargetName); Cat('    Processor : '); Catln(TargetProcessor);
     CatLN ('Compiler Options : ');
     With OptionsDefined do
     begin
          if a then CatLN ('   A+   Word align data');
          if b then CatLN ('   B+   Complete boolean evaluation');
          if c then CatLN ('   C+   ???');
          if d then CatLN ('   D+   Debug info into .TPW files ');

          {$ifdef DOS}
          if e then CatLN ('   E+   DOS x87 emulator on');
          {$else}
          if e then CatLN ('   E+   ???');
          {$endif}

          if f then CatLN ('   F+   Far Calls');
          if g then CatLN ('   G+   286 instruction set');
          if h then CatLN ('   H+   ???');
          if i then CatLN ('   I+   I/O Checking ');
          if j then CatLN ('   J+   ???');
          {$ifdef WINDOWS}
          if k then CatLN ('   K+   Win16 Smart Callbacks');
          {$else}
          if k then CatLN ('   K+   ???');
          {$endif}
          if l then CatLN ('   L+   Local symbol information');
          if m then CatLN ('   M+   ???');
          if n then CatLN ('   N+   x87 instruction set');
          {$ifdef DOS}
          if o then CatLN ('   O+   DOS Overlays allowed');
          {$else}
          if o then CatLN ('   O+   ??? ');
          {$endif}
          if p then CatLN ('   P+   Open Parameters');
          if q then CatLN ('   Q+   Integer Overflow checking ');
          if r then CatLN ('   R+   Range checking');
          if s then CatLN ('   S+   Stack checking');
          if t then CatLN ('   T+   Typed @ operator');
          if u then CatLN ('   U+   ???');
          if v then CatLN ('   V+   Strict Var-Strings');
          {$ifdef WINDOWS}
          if w then CatLN ('   W+   Windows 3.0 real-mode stack frame'); { ??? should be obsolete with BP7
          {$else WINDOWS}                                               { but still supported even though }
          if w then CatLN ('   W+   ???');                               { BP7/TPW generates PM-only Win16 apps }
          {$endif}
          if z then CatLN ('   Z+   ???');
     end;
     CatLN('');
     Cat ('User Symbols defined : ');
     SymbolsDefined[Length(SymbolsDefined)+1] := #0;
     CatLN(@SymbolsDefined[1]);

     CatLN('');

{$ifndef CONSOLE}
     MessageBox(0,msg,'Project-Wide options',mb_ok);
     FreeMem(msg,40000);
{$endif}
end;

{$endif QUIET}


begin
     Fillchar(OptionsDefined,sizeof(OptionsDefined),#0);

  { cancel the options that don't fit into your compiler by putting (* *)  }
     {$ifopt A+} OptionsDefined.a := True; {$endif}
     {$ifopt B+} OptionsDefined.b := True; {$endif}
(*     {$ifopt C+} OptionsDefined.c := True; {$endif} *)
     {$ifopt D+} OptionsDefined.d := True; {$endif}
     {$ifopt F+} OptionsDefined.f := True; {$endif}
     {$ifopt G+} OptionsDefined.g := True; {$endif}
(*     {$ifopt H+} OptionsDefined.h := True; {$endif}  *)
     {$ifopt I+} OptionsDefined.i := True; {$endif}
(*     {$ifopt J+} OptionsDefined.j := True; { $endif} *)
     {$ifopt L+} OptionsDefined.l := True; {$endif}
(*     {$ifopt M+} OptionsDefined.m := True; {$endif} *)
     {$ifopt N+} OptionsDefined.n := True; {$endif}
     {$ifopt O+} OptionsDefined.o := True; {$endif}
     {$ifopt P+} OptionsDefined.p := True; {$endif}
     {$ifopt Q+} OptionsDefined.q := True; {$endif}
     {$ifopt R+} OptionsDefined.r := True; {$endif}
     {$ifopt S+} OptionsDefined.s := True; {$endif}
     {$ifopt T+} OptionsDefined.t := True; {$endif}
(*     {$ifopt U+} OptionsDefined.u := True; {$endif}   *)
     {$ifopt V+} OptionsDefined.v := True; {$endif}
     {$ifopt X+} OptionsDefined.x := True; {$endif}
     {$ifopt Y+} OptionsDefined.y := True; {$endif}
(*     {$ifopt Z+} OptionsDefined.z := True; {$endif} *)

     { Platform specific options }
{$ifdef WINDOWS}
     {$ifopt K+} OptionsDefined.k := True; {$endif}
     {$ifopt W+} OptionsDefined.w := True; {$endif}
{$endif}

{$ifdef DPMI}
     {$ifopt K+} OptionsDefined.k := True; {$endif}
     {$ifopt W+} OptionsDefined.w := True; {$endif}
{$endif}

{$ifdef DOS}
     {$ifopt O+} OptionsDefined.o := True; {$endif}
     {$ifopt E+} OptionsDefined.e := True; {$endif}
{$endif}

     SymbolsDefined := '';
     {$ifdef DEBUG} SymbolsDefined := SymbolsDefined + 'DEBUG '; {$endif}
     {$ifdef RETAIL} SymbolsDefined := SymbolsDefined + 'RETAIL '; {$endif}
     {$ifdef AUX} SymbolsDefined := SymbolsDefined + 'AUX '; {$endif}

     { add your most commonly used symbols here }

     {$ifdef VER10} CompilerVersion := $100; {$endif}
     {$ifdef VER15} CompilerVersion := $105; {$endif}
     {$ifdef VER20} CompilerVersion := $200; {$endif}
     {$ifdef VER30} CompilerVersion := $300; {$endif}
     {$ifdef VER40} CompilerVersion := $400; {$endif}
     {$ifdef VER50} CompilerVersion := $500; {$endif}
     {$ifdef VER55} CompilerVersion := $505; {$endif}
     {$ifdef VER60} CompilerVersion := $600; {$endif}
     {$ifdef VER70} CompilerVersion := $700; {$endif}

     {$ifdef VER80} CompilerVersion := $800; {$endif}    { will it work one day ? }


end.

