
{$I-,V-,S-,R-,F-,B-}

     {*******************************************************************}
     {*                          TWOBRDOS.PAS                           *}
     {*                    Version 1.00 January 1993                    *}
     {*              Copyright (c) 1993 TurboPower Software             *}
     {*                                                                 *}
     {*                         By Lee Inman,                           *}
     {*                      TurboPower Software                        *}
     {*******************************************************************}

{$I BTDEFINE.INC}
{$I OPDEFINE.INC}

{$IFNDEF UseOPCRT}
  *ERROR* This program requires UseOPCRT to be defined in BTDEFINE.INC.
{$ENDIF}

unit BrDosOrd;
  {-implementes a browse window for the order database}

interface

uses
  {.......................... Turbo Pascal units}
  Dos,                       {standard DOS unit}
  {.......................... Object Professional units}
  OpConst, {!!.40}           {error codes, etc.}
  OpRoot,                    {low-level objects, error codes, etc.}
  OpInline,                  {useful inline macros}
  OpString,                  {string handling}
  OpCrt,                     {basic screen handling}
  {$IFDEF UseMouse}
  OpMouse,
  {$ENDIF}
  OpCmd,                     {command processing}
  OpFrame,                   {window frames}
  OpWindow,                  {windows}
  OpField,                   {data entry fields}
  OpSelect,                  {abstract selector}
  OpEntry,                   {data entry screens}
  OpMemo,                    {memo editor}
  {.......................... Optional NetWare support}
  {$IFDEF Novell}
  NetSema,                   {BONUS NetWare Semaphore unit}
  OopSema,                   {OOP Semaphore unit}
  {$ENDIF}
  {.......................... B-Tree Filer units}
  Filer,                     {database management}
  Rebuild,
  FBrowse,                   {object-oriented database browser}
  {.......................... Order Browser units}
  BrDosUtl,                  {Common utility functions}
  BrDosDat;                  {Global types, constants and variables}


  procedure InitOrders;
  {-Initialize entry screen, open database and create browser}
  procedure ProcessOrders;
  {-Enter the browser process loop}
  procedure CloseOrders;
  {-Close the file block}
  procedure GenerateRandomOrders;
  {-Create randomly generated records}


implementation

var
  Order          : OrderDef;         {Currently selected record}

  {data entry stuff}
const
  {field IDs}
  idCustNum      = 0;
  idProductCode  = 1;
  idProductName  = 2;

  {coordinates for entry screen window}
  EntryXL        = 29;
  EntryYL        = 15;
  EntryXH        = 78;
  EntryYH        = 17;

  ORecLen        : Word = SizeOf(OrderDef);

var
  ES             : EntryScreen;  {for entry screens}
  ScrapOrder     : OrderDef;     {used for editing}
  {$IFDEF Novell}
  Sync           : FilerSemaphore;
  {$ENDIF}

{$IFDEF Novell}
  {$F+}
  function SemaphoreRefresh(FBP : FBrowserPtr) : Boolean;
  var
    Ticks : LongInt absolute $40:$6C;
    T : LongInt;
  begin
    {assume false}
    SemaphoreRefresh := False;

    with FBP^ do
      {do nothing if this is a single-user fileblock}
      if LongFlagIsSet(fbOptions, fbIsNet) then begin
        {save tick count}
        T := Ticks;

        {loop while key not pressed}
        while not cwCmdPtr^.cpKeyPressed do
          {is it time to check again?}
          if (Ticks-T) >= RefreshPeriod then
            {check to see if page stack has been invalidated}
            if Sync.IsDirty(GetKeyNumber) then begin
              {we need to refresh the display}
              SemaphoreRefresh := True;
              Exit;
            end
            else
              {save the current tick count}
              T := Ticks;
      end;
  end;
  {$F-}
{$ENDIF}

{$IFDEF UseAdjustableWindows}
const
  Step = 1;

  procedure MoveBrowseWindow;
    {-Move the browse window interactively}
  var
    Finished : Boolean;
  begin
    if FBO.IsZoomed then
      Exit;
    WriteFooter('',' Use cursor keys to move, <Enter> to accept');
    Finished := False;
    with FBO do
      repeat
        case ReadKeyWord of
          $4700 : MoveWindow(-Step, -Step); {Home}
          $4800 : MoveWindow(0, -Step);     {Up arrow}
          $4900 : MoveWindow(Step, -Step);  {PgUp}
          $4B00 : MoveWindow(-Step, 0);     {Left Arrow}
          $4D00 : MoveWindow(Step, 0);      {Right Arrow}
          $4F00 : MoveWindow(-Step, Step);  {End}
          $5000 : MoveWindow(0, Step);      {Down arrow}
          $5100 : MoveWindow(Step, Step);   {PgDn}
          $1C0D : Finished := True;         {Enter}
        end;

        if ClassifyError(GetLastError) = etFatal then
          Abort;
      until Finished;

    WriteFooter('','');
  end;

  procedure ResizeBrowseWindow;
    {-Resize the browse window interactively}
  var
    Finished : Boolean;
  begin
    if FBO.IsZoomed then
      Exit;
    WriteFooter('',' Use cursor keys to resize, <Enter> to accept');
    Finished := False;
    with FBO do
      repeat
        case ReadKeyWord of
          $4700 : ResizeWindow(-Step, -Step); {Home}
          $4800 : ResizeWindow(0, -Step);     {Up}
          $4900 : ResizeWindow(Step, -Step);  {PgUp}
          $4B00 : ResizeWindow(-Step, 0);     {Left}
          $4D00 : ResizeWindow(Step, 0);      {Right}
          $4F00 : ResizeWindow(-Step, Step);  {End}
          $5000 : ResizeWindow(0, Step);      {Down}
          $5100 : ResizeWindow(Step, Step);   {PgDn}
          $1C0D : Finished := True;           {Enter}
        end;

        if ClassifyError(GetLastError) = etFatal then
          Abort;
      until Finished;

    WriteFooter('','');
  end;

  procedure ToggleZoom;
    {-Toggle zoom status of the browse window}
  begin
    with FBO do begin
      if IsZoomed then
        Unzoom
      else
        Zoom;

      if ClassifyError(GetLastError) = etFatal then
        Abort;
    end;
  end;
{$ENDIF}

  procedure ClearOrder(var Order : OrderDef);
    {-Set up for a new record}
  begin
    FillChar(Order, ORecLen, 0);
  end;

  function CompOrder(var P1, P2 : OrderDef) : Boolean;
    {-Compare two records}
  begin
    CompOrder := False;
    if P1.Dele <> P2.Dele then
      Exit;
    if P1.CustNum <> P2.CustNum then
      Exit;
    if P1.ProductCode <> P2.ProductCode then
      Exit;
    if P1.ProductName <> P2.ProductName then
      Exit;

    CompOrder := True;
  end;

  procedure FixHeader(Header : String; RecNum : LongInt);
    {-Fix the entry screen's header}
  var
    Redraw : Boolean;
  begin
    {fix the header}
    if RecNum <> 0 then
      Header := Header+' Record # '+Long2Str(RecNum);
    with ES, wFrame do
      ChangeHeaderString(0, ' '+Header+' ', Redraw);
  end;

  procedure EraseWindows;
    {-Erase the two windows}
  begin
    if ES.IsCurrent then
      ES.Erase;
  end;

  procedure DisplayOrder(var Order : OrderDef; Header : String;
                          RecNum : LongInt);
    {-Show data about Order}
  begin
    {copy into our scrap record}
    ScrapOrder := Order;

    {change the entry screen's header}
    FixHeader(Header, RecNum);

    {display entry screen}
    ES.Draw;
  end;

  function GetOrder(var Order : OrderDef; Required : Boolean;
                     Header : String; RecNum : LongInt) : Boolean;
    {-Edit a Order record}
  var
    Done : Boolean;
  begin
    {copy into our scrap record}
    ScrapOrder := Order;

    {Fill-in current customer number}
    ScrapOrder.CustNum := OrderLinkKey;

    {set required status }
    ES.ChangeRequired(idProductCode, Required);

    {change the entry screen's header}
    FixHeader(Header, RecNum);

    {start editing on product item field}
    ES.SetNextField(idProductCode);

    Done := False;
    repeat
      {start editing}
      ES.Process;

      {see if we need to edit another record}
      case ES.GetLastCommand of
        ccDone :             {^Enter, ^KD, or ^KQ}
          begin
            Done := True;
            GetOrder := True;
          end;
        ccError,             {fatal error}
        ccQuit :             {Esc}
          begin
            Done := True;
            GetOrder := False;
          end;
      end;
    until Done;

    {erase the two windows}
    EraseWindows;

    {return modified record, even if <Esc> was pressed--caller will ignore
     changes if appropriate}
    Order := ScrapOrder;

    {clear the prompt line}
    WriteFooter('','');
  end;

  function CreateOrderFile : Boolean;
    {-Create the database fileblock}
  var
    IID : IsamIndDescr;
  begin
    IID[1].KeyL := OKey1Len;
    IID[1].AllowDupK := True;
    BTCreateFileBlock(OrderFile, ORecLen, 1, IID);
    CreateOrderFile := IsamOK;
  end;

  function OrderLine(var Order : OrderDef; Row: Byte) : String;
    {-Return a string representing Order}
  begin
    with Order do
      OrderLine :=
        Extend(CustNum, 5)+' '+
        Extend(ProductCode, 10)+' '+
        Extend(ProductName, 25);
  end;

{$F+} {the next three routines are called indirectly}
  function BuildKey(var P; KeyNr : Integer) : IsamKeyStr;
    {-Return the key string for either of the two indexes}
  begin
    with OrderDef(P) do
      BuildKey := Extend(CustNum,5);
  end;

  procedure BuildRow(Row : Byte; var DatS; DatLen : Word; Ref : LongInt;
                     Key : IsamKeyStr; var S : string; FBP : FBrowserPtr);
    {-Return one row of an item to the browser}
  var
    P : OrderDef absolute DatS;
    SLen : Byte absolute S;
  begin
    if Ref <> -1 then
      S := OrderLine(P,Row)
    else begin
      {Record is locked, indicate it on screen}
      S := '';
      while SLen < OMaxCols do
        S := S+'**   ';
      SLen := OMaxCols;
    end;
  end;

  procedure UpdateScreen(FBP : FBrowserPtr);
    {-Called by FBROWSE on each screen update}
  const
    Header =
    'Cust# Product#   Product Name';
  begin
    with fbColors, FBP^ do
      {Write the header line now}
      fFastWrite(
        Extend(Copy(Header, GetCurrentCol, Width), Width), 1, 1,
        ColorMono(HighlightColor, HighlightMono));
  end;
{$F-}

  function AddStructure(var P : OrderDef; var Rec : LongInt) : Boolean;
    {-Add a new record}
  begin
    AddStructure := False;
    repeat
      BTAddRec(PfO, Rec, P);
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      IsamErrorNum(IsamError)
    else begin
      FBO.fbOptionsOn(fbForceUpdate);
      AddStructure := True;
    end;
  end;

  function ModStructure(var P : OrderDef; Rec : LongInt) : Boolean;
    {-Write record over previous version}
  begin
    ModStructure := False;
    repeat
      BTPutRec( {was BTAddVariableRec} {!!.22}
        PfO, Rec, P, False);
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      IsamErrorNum(IsamError)
    else begin
      FBO.fbOptionsOn(fbForceUpdate);
      ModStructure := True;
    end;
  end;

  function DelStructure(var Rec : LongInt) : Boolean;
    {-Delete record}
  begin
    DelStructure := False;
    repeat
      BTDeleteRec(PfO, Rec);
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      IsamErrorNum(IsamError)
    else begin
      FBO.fbOptionsOn(fbForceUpdate);
      DelStructure := True;
    end;
  end;

  function AddKey(K : IsamKeyStr; Rec : LongInt; KeyNr : Integer) : Boolean;
    {-Add new key}
  begin
    AddKey := False;
    repeat
      BTAddKey(PfO, KeyNr, Rec, K);
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      IsamErrorNum(IsamError)
    else
      AddKey := True;
  end;

  function EraseKey(K : IsamKeyStr; Rec : LongInt; KeyNr : Integer) : Boolean;
    {-Remove a key}
  begin
    EraseKey := False;
    repeat
      BTDeleteKey(PfO, KeyNr, Rec, K);
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      IsamErrorNum(IsamError)
    else
      EraseKey := True;
  end;

  function ModKey(AltK, NeuK : IsamKeyStr; Rec : LongInt; KeyNr : Integer) : Boolean;
    {-Replace a key}
  begin
    ModKey := False;
    if EraseKey(AltK, Rec, KeyNr) then
      if AddKey(NeuK, Rec, KeyNr) then
        ModKey := True;
  end;

  procedure Reposition(UserKey : IsamKeyStr);
    {-Set sequential file pointer to another key}
  var
    Rec : LongInt;
  begin
    repeat
      BTFindKey(PfO, 1, Rec, UserKey);
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      OActRec := 0;
  end;

  function LockAll : Boolean;
    {-Lock all open files, returning true if successful}
  var
    OK : Boolean;
  begin
    LockAll := False;
    repeat
      BTLockAllOpenFileBlocks;
      if not IsamOK then begin
        if not YesNo('The file is presently in use. Try again?', 'Y') then
          Exit;
        OK := False;
      end
      else
        OK := True;
    until OK;
    LockAll := True;
  end;

  procedure NewStructure;
    {-Prompt for and add new record}
  var
    OrderTemp : OrderDef;
    Key1      : IsamKeyStr;
    Rec       : LongInt;
    OK        : Boolean;
  begin
    WriteHeader(FBO,1,' New Entry ', True);
    ClearOrder(OrderTemp);

    {Get the new record}
    if not GetOrder(OrderTemp, True, 'Add Record', 0) then
      Exit;

    {make the index keys}
    Key1 := BuildKey(OrderTemp, 1);

    {Lock the database in order to safely add the record}
    if not LockAll then
      Exit;

    {Add the record and its keys}
    OK := AddStructure(OrderTemp, Rec);
    if OK then
      OK := AddKey(Key1, Rec, 1);

    {$IFDEF Novell}
    if BTNetSupported = Novell then
      Sync.IndicateDirty(1);
    {$ENDIF}

    {Save global pointers to the current record}
    if OK then begin
      OActRec := Rec;
      OActKey := Key1;
      FBO.SetCurrentRecord(OActKey, OActRec);
    end;

    BTUnLockAllOpenFileBlocks;
  end;

  procedure NewRandomOrder(OrderTemp: OrderDef);
  var
    Key1      : IsamKeyStr;
    Rec       : LongInt;
    OK        : Boolean;
  begin
    {make the index keys}
    Key1 := BuildKey(OrderTemp, 1);

    {Lock the database in order to safely add the record}
    if not LockAll then
      Exit;

    {Add the record and its keys}
    OK := AddStructure(OrderTemp, Rec);
    if OK then
      OK := AddKey(Key1, Rec, 1);

    {$IFDEF Novell}
    if BTNetSupported = Novell then
      Sync.IndicateDirty(1);
    {$ENDIF}

    {Save global pointers to the current record}
    if OK then begin
      OActRec := Rec;
      OActKey := Key1;
    end;

    BTUnLockAllOpenFileBlocks;
  end;

  procedure Modify;
    {-Modify an existing record}
  var
    OrderTemp : OrderDef;
    OrderTemp1 : OrderDef;
    OK : Boolean;
    Rec : LongInt;
    Escaped : Boolean;
    NoChanges : Boolean;
  begin
    WriteHeader(FBO,1,' Modify ', True);
    OrderTemp := Order;

    Escaped := not GetOrder(OrderTemp, True, 'Modifying', OActRec);
    NoChanges := CompOrder(Order, OrderTemp);
    if Escaped and not NoChanges then
      NoChanges := YesNo('Ignore changes to record?', 'N');
    if NoChanges then begin
      DispMessageTemp('Files not changed.', 250);
      Exit;
    end;

    {Lock the database in order to safely modify the record}
    if not LockAll then
      Exit;

    Rec := OActRec;
    {Read actual disk data}
    BTGetRec(PfO, Rec, OrderTemp1, False);
    if not IsamOK then begin
      BTUnLockAllOpenFileBlocks;
      DispMessageTemp('Record could not be read from disk.', 1000);
      Exit;
    end;

    if OrderTemp1.Dele <> LongInt(0) then begin
      BTUnLockAllOpenFileBlocks;
      DispMessageTemp('The record has been erased in the meantime.', 1000);
      Exit;
    end;

    if not CompOrder(OrderTemp1, Order) then begin
      BTUnLockAllOpenFileBlocks;
      DispMessageTemp('The record has been changed in the meantime.', 1000);
      Order := OrderTemp1;
      Exit;
    end;

    OK := ModStructure(OrderTemp, OActRec);
    if OK then
      if BuildKey(OrderTemp, 1) <> BuildKey(Order, 1) then begin
        OK := ModKey(BuildKey(Order, 1), BuildKey(OrderTemp, 1), OActRec, 1);
        if OK then
          Reposition(BuildKey(OrderTemp, 1));
      end;

    BTUnLockAllOpenFileBlocks;
    if OK then begin
      Order := OrderTemp;
      FBO.SetCurrentRecord(BuildKey(Order, 1), OActRec);
      {$IFDEF Novell}
      if BTNetSupported = Novell then begin
        Sync.IndicateDirty(1);
      end;
      {$ENDIF}
    end;
  end;

  procedure Delete;
    {-Prompt for and delete a record}
  var
    Key1    : IsamKeyStr;
    OK, Del : Boolean;
  begin
    WriteHeader(FBO,1,' Deleting ', True);
    DisplayOrder(Order, 'Deleting', OActRec);
    Del := YesNo('Should the record really be deleted?', 'N');
    EraseWindows;
    if not Del then
      Exit;

    Key1 := BuildKey(Order, 1);

    {Lock the database}
    if not LockAll then
      Exit;

    OK := EraseKey(Key1, OActRec, 1);
    if OK then
      OK := DelStructure(OActRec);
    if not OK then
      IsamErrorNum(IsamError);

    {$IFDEF Novell}
    if OK and (BTNetSupported = Novell) then
      Sync.IndicateDirty(1);
    {$ENDIF}

    BTUnLockAllOpenFileBlocks;
  end;

  function MatchString(var SG, ST : String) : Boolean;
    {-Return true if SG and ST match}
  begin
    if Length(SG) = 0 then
      {Nothing to match against}
      MatchString := True
    else
      {Match if ST starts with SG}
      MatchString := (Pos(StUpCase(SG), StUpCase(ST)) = 1);
  end;

  function MatchOrder(var PG, PT : OrderDef) : Boolean;
    {-Compare two Order records}
  begin
    MatchOrder := False;
    if PT.Dele <> 0 then
      Exit;
    if not MatchString(PG.CustNum, PT.CustNum) then
      Exit;
    if not MatchString(PG.ProductCode, PT.ProductCode) then
      Exit;
    if not MatchString(PG.ProductName, PT.ProductName) then
      Exit;
    MatchOrder := True;
  end;

  function GetNextRec(var Fptr       : IsamFileBlockPtr;
                      var Data       : OrderDef;
                      KeyNr          : Integer;
                      var Rec        : LongInt;
                      var UserKey    : IsamKeyStr) : Boolean;
    {-Get next record in index order}
  begin
    GetNextRec := False;

    {Get next sequential key}
    repeat
      BTNextKey(Fptr, KeyNr, Rec, UserKey);
      if LockAbort then
        Exit;
    until not Locked;

    if not IsamOK and (IsamError = 10250) then
      {At end of list, try once more to wrap to beginning}
      repeat
        BTNextKey(Fptr, KeyNr, Rec, UserKey);
        if LockAbort then
          Exit;
      until not Locked
    else
      GetNextRec := True;
    if not IsamOK then
      Exit;

    {Get associated data}
    repeat
      BTGetRec(Fptr, Rec, Data, False);
      if LockAbort then
        Exit;
    until not Locked;
  end;

  procedure Status;
    {-Show the number of records}
  const
    ModeSt : array[OpenMode] of string[6] = ('Normal', 'Save');
  var
    F, U, K : LongInt;
  begin
    WriteHeader(FBO,1,' Status ', True);
    repeat
      U := BTUsedRecs(PfO);
      if LockAbort then
        Exit;
    until not Locked;

    repeat
      F := BTFreeRecs(PfO);
      if LockAbort then
        Exit;
    until not Locked;
    repeat
      K := BTUsedKeys(PfO, 1);
      if LockAbort then
        Exit;
    until not Locked;
    DispMessage(
      'Records:'+Long2Str(K)+
      ', Sections:'+Long2Str(U)+
      ', Deleted:'+Long2Str(F)+
      ', Mode:'+ModeSt[Mode]+
      ', Station:'+Long2Str(BTGetInternalDialogID(PfO)),  {!!.40}
      True, False);
  end;

  function Long2StrDigits(L : LongInt; NumDigits : Byte) : String;
  {-Convert a longint to a string, right justified to NumDigits}
  var
    S : String;
  begin
    Str(L:NumDigits,S);
    Long2StrDigits := S;
  end;

  {$F+}
  procedure UserStatusRoutine(KeyNr : Integer;
                              NumRecsRead,
                              NumRecsWritten : LongInt;
                              var Data;
                              Len : Word);
  {-Display information while rebuilding database}
  var
    StatStr : String[80];
  begin
    StatStr := 'Working on key --> '+Long2StrDigits(KeyNr,1)+
               '   records read --> '+Long2StrDigits(NumRecsRead,6)+
               '   written --> '+Long2StrDigits(NumRecsWritten,6);
    WriteFooter('',StatStr);
  end;
  {$F-}

  function Reconstruct : Boolean;
    {-Reconstruct the database from the datafile}
  var
    IID : IsamIndDescr;
  begin
    IID[1].KeyL := OKey1Len;
    IID[1].AllowDupK := True;
    IsamRexUserProcPtr := @UserStatusRoutine;  {set user status procedure}
    RebuildFileBlock(OrderFile, ORecLen, 1, IID, @BuildKey);
    Reconstruct := IsamOK;
  end;

  function OpenedOrderFiles : Boolean;
    {-Try to open existing database files}
  var
    OK, OK1 : Boolean;
  begin
    OpenedOrderFiles := False;
    repeat
      BTOpenFileBlock(PfO, OrderFile, False, False, (Mode = SaveMode),
        BTNetSupported <> NoNet);                                 {!!.22}
      OK := IsamOK;
      if not IsamOK then begin
        if IsamError = 10010 then begin
          if YesNo('Index file defective. Rebuild it?', 'Y') then
            OK1 := Reconstruct
          else
            Exit;
        end
        else if IsamError = 9903 then begin
          if YesNo('Order data file does not exist. Create new one?', 'Y') then begin
            if not CreateOrderFile then
              Exit;
          end
          else
            Exit;
        end
        else begin
          if YesNo('Data error '+Long2Str(IsamError)+'. Attempt rebuild?', 'Y') then
            OK1 := Reconstruct
          else
            Exit;
        end;
      end;
    until OK;
    OpenedOrderFiles := True;
  end;

  procedure RebuildData;
    {-Purge deleted records and rebuild indices}
  begin
    WriteHeader(FBO,1,' Rebuild ', True);
    WriteFooter('','Please wait... ');
    BTCloseFileBlock(PfO);
    if not IsamOK then begin
      IsamErrorNum(IsamError);
      Halt;
    end;
    if not Reconstruct then begin
      DispMessage('Unable to rebuild data files!', True, True);
    end;

    if not OpenedOrderFiles then begin
      IsamErrorNum(IsamError);
      Halt;
    end;
    OActRec := 0;
    OActKey := '';

    {reset file block pointer in Browser, in case it changed} {!!.07}
    FBO.SetFileBlockPtr(PfO);                                 {!!.07}
  end;

{$F+}
  procedure ErrorHandler(UnitCode : Byte; var ErrCode : Word; Msg : String);
    {-Display messages for errors reported by OPENTRY/OPMEMO/FBROWSE}
  var
    P : Pointer;
  begin
    {try to save underlying text}
    if not SaveWindow(1, ScreenHeight, ScreenWidth, ScreenHeight, True, P) then begin
      RingBell;
      Exit;
    end;

    if Msg = '' then
      Msg := 'Unknown error: '+Long2Str(ErrCode);

    {display the error message}
    if ErrCode = epFatal+ecIsamError then
      IsamErrorNum(IsamError)
    else
      DispMessage(Msg, True, True);

    {restore underlying text}
    RestoreWindow(1, ScreenHeight, ScreenWidth, ScreenHeight, True, P);
  end;

  procedure PreEdit(ESP : EntryScreenPtr);
    {-Display a help prompt for the current field}
  var
    S : String[40];
  begin
    case ESP^.GetCurrentID of
      idCustNum     : S := 'Customer number';
      idProductCode : S := 'Enter product code';
      idProductName : S := 'Enter product name';
    end;
    WriteFooter('',' <^Enter> Done  <Esc> Abort  '+S);
  end;
{$F-}

  procedure InitEntryScreen;
    {-Set up for data entry screens}
  const
    Options     = wClear+wBordered;
    M25         = 'AAAAAAAAAAAAAAAAAAAAAAAAA';
  begin
    {clear the scrap record used for editing}
    ClearOrder(ScrapOrder);

    {.F-}
    {initialize the entry screen}
    if not ES.InitCustom(EntryXL,          {left column of window}
                         EntryYL,          {top row of window}
                         EntryXH,          {right column of window}
                         EntryYH,          {bottom row of window}
                         FbColors,         {color set}
                         Options)          {window options}
    then
      Abort;

    {add dummy header}
    ES.wFrame.AddHeader(' dummy ', heTC);

    {set field delimiters}
    ES.SetDelimiters('[', ']');

    {set entry screen options}
    ES.SetWrapMode(WrapAtEdges);

    {set field editing options}
    ES.esFieldOptionsOn(efBeepOnError+efClearFirstChar);

    {add each of the edit fields in order: left to right, top to bottom}
    {               Prompt               ---Field--- Help              }
    { Prompt        Row Col Picture      Row Col Len Index     Variable}

    ES.AddStringField(
      'Customer#',  01, 05, '!!!!!',     01, 21, 05, 00, ScrapOrder.CustNum);

    ES.AddStringField(
      'Code',       02, 05, '!!!!!!!!!!',02, 21, 10, 01, ScrapOrder.ProductCode);

    ES.AddStringField(
      'Item name',  03, 05, M25,         03, 21, 25, 02, ScrapOrder.ProductName);

    {.F+}

    {install event handlers}
    ES.SetPreEditProc(PreEdit);
    ES.SetErrorProc(ErrorHandler);

    {check for error}
    if ES.GetLastError <> 0 then
      Abort;
  end;

  procedure GenerateRandomOrders;
  var
    I                   : Integer;
    function RanStr(N : Word) : String;
    var
      I                   : Word;
      Tmp                 : String;
    begin
      Tmp := '';
      for I := 0 to Random(N) do
        Tmp := Tmp + Chr(Random(26) + Ord('A'));
      RanStr := Tmp;
    end;
  begin
    Randomize;
    for I := 0 to Random(5) do begin
      FillChar(Order, SizeOf(OrderDef), #0);
      with Order do begin
        CustNum := OrderLinkKey;
        ProductCode := RanStr(10);
        ProductName := RanStr(25);
      end;
      NewRandomOrder(Order);
    end;
    FBO.UpdateContents;
  end;

  procedure InitOrderBrowser;
    {-Set up for browsing}
  const
    {$IFDEF UseAdjustableWindows}
    Options = wClear+wBordered+wResizeable+wAltFrame+wAllMouseEvents;
    {$ELSE}
    Options = wClear+wBordered+wAltFrame+wAllMouseEvents;
    {$ENDIF}

  begin
    {initialize the browser}
    if not FBO.InitCustom(03,             {left column of window}
                  ScreenHeight div 2 + 5, {top row of window}
                  ScreenWidth-2,          {right column of window}
                  ScreenHeight-4,         {bottom row of window}
                  FbColors,               {color set}
                  Options,                {window options}
                  PfO,                    {fileblock}
                  1,                      {key number}
                  Order,                  {scrap variable}
                  0{ScreenHeight-5},         {maximum rows}
                  1,                      {rows per item}
                  OMaxCols)               {maximum columns}
    then
      Abort;

    {adjust frame coordinates}
    with FBO do begin
      {$IFDEF UseAdjustableWindows}
      {set the limits to use when moving/zooming/resizing the window}
      SetPosLimits(1, 2, ScreenWidth, ScreenHeight-2);
      {$ENDIF}

      with wFrame do begin
        AdjustFrameCoords(frXL, frYL-1, frXH, frYH);

        {$IFDEF UseAdjustableWindows}
        {set the limits to use when resizing the window}
        SetFrameLimits(30, 2, ScreenWidth, ScreenHeight-2);
        {$ENDIF}

        {$IFDEF UseScrollBars}
        {add scroll bars}
        AddCustomScrollBar(frBB, 0, MaxLongInt, 1, 1, #178, #176, fbColors);
        AddCustomScrollBar(frRR, 0, MaxLongInt, 1, 1, #178, #176, fbColors);
        {$ENDIF}

        {add headers}
        AddCustomHeader(#181, frTL,  1, 0, $1F, $0F);       {1}
        AddCustomHeader(#7,   frTL,  2, 0, $71, $70);       {2}
        AddCustomHeader(#198, frTL,  3, 0, $1F, $0F);       {3}
        AddCustomHeader(#181, frTR, -3, 0, $1F, $0F);       {4}
        AddCustomHeader(#24,  frTR, -2, 0, $71, $70);       {5}
        AddCustomHeader(#198, frTR, -1, 0, $1F, $0F);       {6}
        AddCustomHeader('+',  frBR,  0, 0, $17, $07);       {7}

        {$IFDEF UseHotSpots}
        {add hot spots}
        AddHotRegion(frTL, hsRegion0, 2, 0, 1, 1);          {Close}
        AddHotRegion(frTR, hsRegion1, -2, 0, 1, 1);         {Zoom}
        AddHotBar(frTT,    hsRegion2);                      {Move}
        AddHotRegion(frBR, hsRegion3, 0, 0, 1, 1);          {Resize}
        {$ENDIF}
      end;
      with aFrame do begin
        SetFrameType(SglWindowFrame);
      end;
    end;

    {install user-written event handlers}
    FBO.SetBuildItemProc(BuildRow);
    FBO.SetScreenUpdateProc(UpdateScreen);
    FBO.SetErrorProc(ErrorHandler);

    {$IFDEF Novell}
    if BTNetSupported = Novell then begin
      FBO.SetRefreshFunc(SemaphoreRefresh);
      RefreshPeriod := 18 div 2;
    end
    else
      FBO.SetRefreshFunc(RefreshPeriodically);
    {$ELSE}
    FBO.SetRefreshFunc(RefreshPeriodically);
    {$ENDIF}

    {options}
    FBO.fbOptionsOn(fbFlushKbd+fbProcessZero);

    {check for error}
    if FBO.GetLastError <> 0 then
      Abort;
  end;

  procedure InitOrders;
  begin
    {initialize screen}
    InitEntryScreen;

    {other initialization}
    OActRec := 0;
    OActKey := '';

    if not OpenedOrderFiles then begin
      DispMessageTemp('Files could not be opened. Aborting.', 2000);
      Halt;
    end;

    {$IFDEF Novell}
    if BTNetSupported = Novell then
      if Sync.Init(OrderFile, 1) then
        RefreshPeriod := 9            {check every half of a second}
      else begin
        DispMessageTemp('Error initializing semaphore object. Aborting.', 2000);
        Halt;
      end;
    {$ENDIF}

    {initialize file browser}
    InitOrderBrowser;

    {$IFDEF UseMouse}
    if MouseInstalled then begin
      {use a red diamond for our mouse cursor}
      with fbColors do
        SoftMouseCursor($0000, (ColorMono(MouseColor, MouseMono) shl 8)+$04);
      ShowMouse;

      {enable mouse support}
      EntryCommands.cpOptionsOn(cpEnableMouse);
      MemoCommands.cpOptionsOn(cpEnableMouse);
      FBrowserCommands.cpOptionsOn(cpEnableMouse);
    end;
    {$ENDIF}
  end;

  procedure CloseOrders;
  begin
    {Close up the database}
    BTCloseFileBlock(PfO);
    if not IsamOK then
      DispMessageTemp('Data may be corrupt.', 2000);

    {$IFDEF Novell}
    if BTNetSupported = Novell then
      Sync.Done;
    {$ENDIF}
  end;

  procedure ProcessOrders;
  var
    BP : LongInt;
    MicH : Integer;
    MicV : Integer;
    FP : FramePosType;
    XAbs : Byte;
    YAbs : Byte;
    HC : Byte;
    Clicked : Boolean;

  begin

    repeat
      {Update the screen and browse around the records}
      WriteHeader(FBO,1,' Order Menu ', True);
      WriteFooter(
        ' F2-Add F3-Del                        F8-Customer F9-Info F10-Purge Esc-Quit',
        ' Generate Random Data -- Alt-C for Customers & Orders, Alt-O for Orders only');

      {process commands}
      if FBO.IsActive and not FBO.IsCurrent then
        FBO.Select;

      FBO.Process;
      BrowExit := FBO.GetLastCommand;
      WriteFooter('','');

      {Check for errors}
      case FBO.GetLastError of
        0 :
          if (BrowExit <> ccQuit) and (BrowExit <> ccError) then begin
            {get current key and reference}
            FBO.GetCurrentKeyAndRef(OActKey, OActRec);

            {Order already contains current record on ccSelect}
            if (BrowExit <> ccSelect) and (OActRec <> 0) then
              {get current record}
              FBO.GetCurrentRecord(Order, ORecLen);

            {check for error}
            if not IsamOK then begin
              IsamErrorNum(IsamError);
              BrowExit := ccNone;
            end;
          end;
        epFatal+ecNoKeysFound :
            FBO.ClearErrors;
      else
        DispMessageTemp('Aborting.', 2000);
        BrowExit := ccError;
      end;

      {Handle requests for action}
      case BrowExit of
        ccSelect : if OActRec = 0 then NewStructure else Modify;
        ccUser2  : NewStructure;
        ccUser3  : if OActRec <> 0 then Delete;
        ccUser9  : Status;
        ccUser10 : RebuildData;
        {$IFDEF UseAdjustableWindows}
        ccUser11 : ResizeBrowseWindow;
        ccUser12 : MoveBrowseWindow;
        ccUser13 : ToggleZoom;
        {$ENDIF}
        ccUser15 : GenerateRandomOrders;
        {$IFDEF UseMouse}
        ccMouseSel :
          with FBO do begin
            XAbs := MouseLastX+MouseXLo;
            YAbs := MouseLastY+MouseYLo;
            EvaluatePos(XAbs, YAbs);
            BP := PosResults(FP, HC);
            if FP <> frOutsideFrame then begin
              case HC of
                hsRegion0 : {Close} BrowExit := ccQuit;
                hsRegion1 : {Zoom} ToggleZoom;
                hsRegion2 : {Move}
                  if not IsZoomed then begin
                    WriteFooter('',
                      ' Drag window to new location, then click left mouse button');
                    HideMouse;
                    Dec(XAbs, wFrame.frXL);
                    Dec(YAbs, wFrame.frYL);
                    GetMickeyCount(MicH, MicV);
                    repeat
                      GetMickeyCount(MicH, MicV);
                      MoveWindow(Delta(MicH), Delta(MicV));
                      if ClassifyError(GetLastError) = etFatal then
                        Abort;
                      if MousePressed then
                        Clicked := (MouseKeyWord = MouseLft)
                      else
                        Clicked := False;
                    until Clicked;
                    Inc(XAbs, wFrame.frXL);
                    Inc(YAbs, wFrame.frYL);
                    MouseGoToXY(XAbs, YAbs);
                    WriteFooter('','');
                    ShowMouse;
                  end;

                hsRegion3 : {Resize}
                  if not IsZoomed then begin    {!!.01}
                    WriteFooter('',
                      ' Move mouse to resize window, then click left mouse button');
                    HideMouse;
                    GetMickeyCount(MicH, MicV);
                    repeat
                      GetMickeyCount(MicH, MicV);
                      ResizeWindow(Delta(MicH), Delta(MicV));
                      if ClassifyError(GetLastError) = etFatal then
                        Abort;
                      if MousePressed then
                        Clicked := (MouseKeyWord = MouseLft)
                      else
                        Clicked := False;
                    until Clicked;
                    MouseGoToXY(wFrame.frXH, wFrame.frYH);
                    WriteFooter('','');
                    ShowMouse;
                  end;
              end;
            end else begin
              {Was the click in the customer window}
              XAbs := MouseLastX+MouseXLo;
              YAbs := MouseLastY+MouseYLo;
              VBC.EvaluatePos(XAbs, YAbs);
              BP := VBC.PosResults(FP, HC);
              if FP <> frOutsideFrame then
               BrowExit := ccUser8;  {Allow exit}
            end;
          end;
        {$ENDIF}
        ccQuit   : ;  {Quit}
      end;
    until (BrowExit = ccQuit) or (BrowExit = ccError) or
          (BrowExit = ccUser8) or (BrowExit = ccUser7);

  end;

end.
