
{$I-,V-,S-,R-,F-,B-}

     {*******************************************************************}
     {*                          TWOBRDOS.PAS                           *}
     {*                    Version 1.00 January 1993                    *}
     {*              Copyright (c) 1993 TurboPower Software             *}
     {*                                                                 *}
     {*                         By Lee Inman,                           *}
     {*                      TurboPower Software                        *}
     {*******************************************************************}

{$I BTDEFINE.INC}
{$I OPDEFINE.INC}

{$IFNDEF UseOPCRT}
  *ERROR* This program requires UseOPCRT to be defined in BTDEFINE.INC.
{$ENDIF}

unit BrDosUtl;
  {-utility and common file functions}

interface

uses
  {.......................... Object Professional units}
  OpConst,                   {error codes, etc.}
  OpString,                  {string handling}
  OpCrt,                     {basic screen handling}
  {$IFDEF UseMouse}
  OpMouse,                   {mouse handling}
  {$ENDIF}
  OpCmd,                     {command processing}
  {.......................... B-Tree Filer units}
  Filer,                     {database management}
  FBrowse,                   {object-oriented database browser}
  {.......................... Order Browser units}
  BrDosDat;                  {Global types, constants and variables}


  function Extend(S : String; Len : Byte) : String;
  procedure GetOptionsFromCommandLine;
  procedure WriteHeader(BR: FBrowser; KeyNr: Integer;
                        Prompt : String;  ShowFilter : Boolean);
  procedure WriteFooter(Prompt1,Prompt2 : String);
  procedure DispMessageTemp(Prompt : String; Time : Word);
  procedure IsamErrorNum(F : Integer);
  function YesNo(Prompt : String; Default : Char) : Boolean;
  function LockAbort : Boolean;
  procedure DispMessage(Prompt : String; WaitKey, SoundBell : Boolean);
  function Menu(Selection, Prompt1,Prompt2 : String) : Char;
  function IsLockError : Boolean;
  procedure Abort;
  function Delta(I : Integer) : Integer;


implementation


  function Extend(S : String; Len : Byte) : String;
    {-Pad or truncate string to specified length}
  var
    SLen : Byte absolute S;
  begin
    if SLen >= Len then begin
      SLen := Len;
      Extend := S;
    end
    else
      Extend := Pad(S, Len);
  end;

  procedure GetOptionsFromCommandLine;
    {-Get the network type (and station number if necessary) from Command line}
  type
    Str128 = String[128];
  var
    Opt : Str128;

    procedure ShowHelp;
      {-Display help message and halt}
    begin
      WriteLn('Usage: TWOBRDOS /opt');
      WriteLn;
      WriteLn('where opt is:');
      WriteLn('  /D     - Single-user DOS, no network');
      WriteLn('  /M     - MS-Net or compatible');
      WriteLn('  /N     - Novell''s Advanced NetWare');
      Halt;
    end;

    procedure InvalidOption(Opt : Str128);
      {-Display invalid option message, show help, and halt}
    begin
      WriteLn('Invalid Option: ',Opt);
      WriteLn;
      ShowHelp;
    end;

  begin
    {$IFDEF NoNet}
    DynamicNetType := NoNet;
    {$ELSE}
    if ParamCount = 0 then
      ShowHelp
    else begin
      Opt := ParamStr(1);
      if Length(Opt) < 2 then
        InvalidOption(Opt);
    end;
    case UpCase(Opt[2]) of
      '?' : ShowHelp;
      'D' : DynamicNetType := NoNet;
      'M' : DynamicNetType := MsNet;
      'N' : DynamicNetType := Novell;
      else InvalidOption(Opt);
    end; {case}
    {$ENDIF}
  end;

  procedure WriteHeader(BR: FBrowser; KeyNr: Integer;
                        Prompt : String;  ShowFilter : Boolean);
    {-Write header and bottom divider}
  const
    FilterOn : array[Boolean] of string[8] = ('        ', 'Filter');
  var
    S : String;
    I, J, L : Integer;
    {$IFDEF UseMouse}
    SaveMouse : Boolean;
    {$ENDIF}
  begin
    {$IFDEF UseMouse}
    HideMousePrim(SaveMouse);
    {$ENDIF}

    {draw header}
    S := Header;
    L := Length(Prompt);
    if L > ScreenWidth then
      L := ScreenWidth;
    J := 40-(L shr 1);
    for I := 1 to L do
      S[J+I] := Prompt[I];
    FastWrite(S, 1, 1, HeadFootAttr);

    {indicate whether filtering is enabled}
    if ShowFilter then
      FastWrite(FilterOn[BR.IsFilteringEnabled], 1, 50, HeadFootAttr);

    {display active key}
    if KeyNr = 1 then
      S := ' Key: Cust#    '
    else
      S := ' Key: Zip code ';
    FastWrite(S, 1, 62, HeadFootAttr);

    {$IFDEF UseMouse}
    ShowMousePrim(SaveMouse);
    {$ENDIF}
  end;

  procedure WriteFooter(Prompt1,Prompt2 : String);
    {-Write a footer}
  {$IFDEF UseMouse}
  var
    SaveMouse : Boolean;
  {$ENDIF}
  begin
    {$IFDEF UseMouse}
    HideMousePrim(SaveMouse);
    {$ENDIF}

    FastWrite(Extend(Prompt1, ScreenWidth), ScreenHeight-1, 1, HeadFootAttr);
    FastWrite(Extend(Prompt2, ScreenWidth), ScreenHeight,   1, HeadFootAttr);
    GotoXYabs(Length(Prompt1)+2, ScreenHeight-1);

    {$IFDEF UseMouse}
    ShowMousePrim(SaveMouse);
    {$ENDIF}
  end;

  procedure DispMessageTemp(Prompt : String; Time : Word);
    {-Display a timed message}
  begin
    WriteFooter(Prompt,'');
    Delay(Time);
    WriteFooter('','');
  end;

  procedure IsamErrorNum(F : Integer);
    {-Display Isam error number and wait for key}
  begin
    DispMessage('IsamError: '+Long2Str(F), True, True);
  end;

  function YesNo(Prompt : String; Default : Char) : Boolean;
    {-Display Yes/No prompt}
  var
    Ch : Char;
  begin
    Ch := Menu('YN'^M, Prompt+' ['+Default+']','');
    if Ch = ^M then
      Ch := Default;
    YesNo := (Ch = 'Y');
  end;

  function LockAbort : Boolean;
    {-If a file lock prevents progress, ask whether to try again}
  begin
    LockAbort := False;
    Locked := IsLockError;
    if not Locked then
      Exit;
    LockAbort := not YesNo('A lock prevents access. Try again?', 'Y');
  end;

  procedure DispMessage(Prompt : String; WaitKey, SoundBell : Boolean);
    {-Display a message on the menu line, optionally waiting for keystroke and
      ringing bell}
  var
    C  : Word;
  begin
    if WaitKey then begin
      if Prompt[Length(Prompt)] <> '.' then
        Prompt := Prompt+'.';
      WriteFooter(' '+Prompt+' Press any key...','');
      if SoundBell then
        RingBell;
      C := ReadKeyWord;
    end
    else
      WriteFooter(' '+Prompt,'');
  end;

  function Menu(Selection, Prompt1,Prompt2 : String) : Char;
    {-Draw a bar menu and get a selection in the CharSet}
  var
    ChWord : Word;
    Ch  : Char absolute ChWord;
    CursorSL, CursorXY : Word;
  begin
    {save the cursor position and shape}
    GetCursorState(CursorXY, CursorSL);
    NormalCursor;

    {display prompt}
    WriteFooter(Prompt1,Prompt2);

    {flush keyboard buffer}
    while KeyPressed do
      Ch := ReadKey;

    {wait for valid key}
    repeat
      ChWord := ReadKeyWord;
      Ch := Upcase(Ch);
    until Pos(Ch, Selection) <> 0;

    {Restore cursor position and shape}
    RestoreCursorState(CursorXY, CursorSL);

    {clear prompt line}
    WriteFooter('','');

    Menu := Ch;
  end;

  function IsLockError : Boolean;
    {-Return true for a locking error}
  begin
    IsLockError := (BTIsamErrorClass = 2);
  end;

  procedure Abort;
    {-Abort the program with an out-of-memory error message}
  begin
    DispMessage(emInsufficientMemory, True, True);
    NormalCursor;
    ClrScr;
    Halt(1);
  end;

  function Delta(I : Integer) : Integer;
  begin
    if I < -4 then
      Delta := -1
    else if I > 4 then
      Delta := 1
    else
      Delta := 0;
  end;


end.



