{$V-,I-}

UNIT TS_Confg; { Copyright (C) 1989 Shenandoah Valley Software }

INTERFACE

USES crt,dos;

PROCEDURE TS_Config ( TS_FileName    : string   ;
                      TS_Seg, TS_Ofs : word     ;
                      TS_Type        : pointer  ;
                      TS_Size        : longint  ;
                  VAR TS_Error       : integer );

IMPLEMENTATION

PROCEDURE TS_Config ( TS_FileName    : string   ;
                      TS_Seg, TS_Ofs : word     ;
                      TS_Type        : pointer  ;
                      TS_Size        : longint  ;
                  VAR TS_Error       : integer );

  VAR TS_Path  : PathStr ;                         TS_Dir   : DirStr  ;
      TS_Name  : NameStr ;                         TS_Ext   : ExtStr  ;
      TS_File  : file    ;                         TS_Head  : word    ;
      TS_Block : longint ;                         TS_Ver   : boolean ;
      TS_Str   : array[1..5000] of char;

  BEGIN

    GetVerify  ( TS_Ver );
    SetVerify  ( true );
    FSplit     ( TS_FileName, TS_Dir, TS_Name, TS_Ext );

    TS_Path  := TS_Name + '.EXE';
    TS_Path  := FSearch ( TS_Path, GetEnv ( 'PATH' ));

    if TS_Path = '' then BEGIN
      TS_Error := 15;
      Exit;
    END else TS_Path := FExpand ( TS_Path );

    Assign     ( TS_File, TS_Path );
    Reset      ( TS_File, 1 );

    TS_Error := IOResult;
    if TS_Error <> 0 then Exit;

    Seek       ( TS_File, 8 );
    BlockRead  ( TS_File, TS_Head, SizeOf ( TS_Head ));

    TS_Block := 16 *( longint ( TS_Seg ) -PrefixSeg +TS_Head ) +TS_Ofs -256;
        
    Seek       ( TS_File, TS_Block );
    Move       ( TS_Type^, TS_Str, TS_Size );
    BlockWrite ( TS_File, TS_Str, TS_Size );
    Close      ( TS_File );
    SetVerify  ( TS_Ver );

  END;

BEGIN
END.
