;
; MOVSCR.ASM - Save and restore text-mode video pages
;              Screen "snow" supression is optionally provided
;              This routine runs on true-compatibles only and
;              works with MDA/CGA/EGA/VGA/MCGA adapters.
;
;  Usage:      _movscr(word_count, pointer_to, pointer_from)
;
;              (omit the leading underscore in your call if your
;               compiler adds one by default, ala Turbo C).
;
;              where word_count is the number of words to be moved
;              (2000 for a complete 80x25 screen), and pointer_to /
;              pointer_from are pointers to the two memory locations
;              (the screen and the save area).  The address of the screen
;              is either b000:0000 (mono) or b800:0000 (color); you will
;              have to construct a pointer and set it to the appropriate
;              value to be used in this call.
;
;              Currently implemented using PASCAL calling sequences;
;              see the comments in the code itself for more information
;              on required global variables.
;
; Copyright (C) 1988, 1989 FreeLance Programming  All rights reserved.
;
; Non-commercial use of this code is permitted, provided that proper
; credit is given.  Use of this code in commercial programs is forbidden.
;
;  /* - - - - - - - - - - - Header Info - - - - - - - - - - - - - - -*/
;
;  NOTE:  The segment names used may not be compatible with your
;         particular compiler.  See the documentation provided with
;         your compiler on interfacing to ASM routines for more information.

;/* - - - - - - - - - - - - - EXTERNS - - - - - - - - - - - - - - -*/

DATA    SEGMENT WORD PUBLIC

        ASSUME DS:DATA

extrn ScrPort:word
                                   ; "var _scr_port : integer"
                                   ; = $03BA (mono) or $03DA (color)

extrn StopSnow:word
                                   ; "var _stop_snow : integer"
                                   ; = 0 for no snow removal,
                                   ; non-zero for snow removal
DATA    ENDS


;/* - - - - - - - - - - - - - CODE - - - - - - - - - - - - - - - -*/

CODE SEGMENT BYTE PUBLIC

     ASSUME  CS:CODE

PUBLIC MovScr

MovScr proc far                   ; may need to change to "proc near",
    push bp                        ; depending on your compiler!
    mov  bp,sp                     ; address parameter list
    push ax                        ; \
    push bx                        ;  \
    push cx                        ;   \
    push dx                        ;    -- save all affected registers
    push si                        ;    -- (you may not need to save all of
    push di                        ;   /    these, depending on your compiler)
    push ds                        ;  /
    push es                        ; /


    cld                            ; make all mov's go forward
    mov  cx,Word Ptr [bp+14]       ; # of *WORDS* to move
                                   ; DON'T change DS yet!
    mov  dx,ScrPort                ; Video Port
    mov  bx,StopSnow               ; Snow supression flag
                                   ; Ok to change DS now
    lds  si,DWord Ptr [bp+6]       ; Address of 'from' area
    les  di,DWord Ptr [bp+10]      ; Address of 'to' area

    cmp  bx,0                      ; do snow removal?
    jne  mov_flicker

mov_no_flicker:
    rep  movsw                     ; no, straight move
    jmp  short mov_it_exit         ; and get out

;
;  The following snow removal logic works as follows:
;    1) wait for NOT a screen retrace period
;    2) wait for START of a retrace period
;    3) move a character
;    4) repeat until done
;
;  This assures that our move is always done at the start of the retrace cycle.
;  Otherwise, the retrace might end before our move is completed, which would
;  cause snow.  Note also the use of MOVS; convential MOV logic at this point
;  is too slow, and *will* cause snow.  As is, this routine NEVER snows, which
;  cannot even be said for my new VGA setup, which flickers about once a month
;  (I don't use snow suppression with it).
;

mov_flicker:
    in   al,dx                     ; Get the screen status register
    test al,1                      ; Is is a retrace period?
    jnz  mov_flicker               ; yes, wait until it is done
    cli                            ; no, prevent interruptions
                                   ; (they might throw off our timings)
mov_wait:                          ;
    in   al,dx                     ; Get the status register again
    test al,1                      ; Is it a retrace period?
    jz  mov_wait                   ; No, wait for one to start
    movsw                          ; Yes, move a character (and attribute)
    sti                            ; Enable interruptions
    loop mov_flicker               ; And repeat until done

mov_it_exit:
    pop  es                        ; Restore all affected registers
    pop  ds                        ; (again, you may not need to preserve and
    pop  di                        ;  restore all the registers, depending on
    pop  si                        ;  your compiler.  Turbo C, for example,
    pop  dx                        ;  requires only DS/SI/DI/BP to be saved.)
    pop  cx                        ;
    pop  bx
    pop  ax
    pop  bp
    ret  10                        ; clean-up stack (PASCAL) and return
MovScr endp                       ; (FAR return by definition)

CODE ENDS
     END
                                                                                                           
