
const subproc_tag: string[90]
   = #0'@(#)CURRENT_FILE LAST_UPDATE Subprocess library 1.0'#0;
#log Subprocess library 1.0


(* subproc.inc - run subprocesses from turbo pascal

  This file contains  a function for  Turbo Pascal  that allows you to
  run other programs from within a Turbo program.  The function
  SubProcess,  actually calls up a different program using MS-DOS call
  4BH, EXEC.

 ----------------------------------------------------------------------*)


(* Pass SubProcess a string of the form:
  'D:\FULL\PATH\NAME\OF\FILE.TYP parameter1 parameter2 ...'            *)


(* For example,
    'C:\SYSTEM\CHKDSK.COM'
    'A:\WS.COM DOCUMENT.1'
    'C:\DOS\LINK.EXE TEST;'
    'C:\COMMAND.COM /C COPY *.* B:\BACKUP >FILESCOP.IED'               *)


(* VERY IMPORTANT NOTE:  you MUST use  the Options menu of Turbo Pascal
  to  restrict  the amount  of  free   dynamic  memory   used by  your
  program.  Only  the  memory  that is   not  used  by  the   heap  is
  available for use by other programs.                                 *)

type
   str66 =             string [66];
   str255 =            string [255];

var
   flagreg:            integer;
   exitstat:           integer;
   pathname:           str66;
   commandtail:        str255;
   parm_blk:           record
         envseg:             integer;
         comlin:             ^integer;
         fcb1pr:             ^integer;
         fcb2pr:             ^integer;
   end;


function subprocess (commandline:        str255): integer;
var
   regs:               regpack;
   fcb1:               array [0..36] of byte;
   fcb2:               array [0..36] of byte;
   
begin
   flush(output);
   
   if pos (' ', commandline)= 0 then
   begin
      pathname := commandline + #0;
      commandtail :=^m;
   end                        { if }
   
   else
   begin
      pathname := copy (commandline, 1, pos (' ', commandline)- 1)+ #0;
      commandtail := copy (commandline, pos (' ', commandline), 255)+^m;
   end;                       { else }
   

   commandtail[0]:= pred (commandtail [0]);
   
   with regs do
   begin
      fillchar(fcb1, sizeof (fcb1), 0);
      ax := $2901;
      ds := seg (commandtail [1]);
      si := ofs (commandtail [1]);
      es := seg (fcb1);
      di := ofs (fcb1);
      msdos(regs);               { Create FCB 1 }
      
      fillchar(fcb2, sizeof (fcb2), 0);
      ax := $2901;
      es := seg (fcb2);
      di := ofs (fcb2);
      msdos(regs);               { Create FCB 2 }
      
      es := cseg;
      bx := sseg - cseg + memw [cseg : memw [cseg : $0101]+ $112];
      ax := $4A00;
      msdos(regs);               { Deallocate unused memory }

   end;                       {with}


   with parm_blk do
   begin
      envseg := memw [cseg : $002C];
      comlin := addr (commandtail);
      fcb1pr := addr (fcb1);
      fcb2pr := addr (fcb2);
   end;                       { with }


   inline($9C /               {pushf}
    $2E / $89 / $2E / $80 / $00 /
                              {MOV cs:80H,BP}
    $2E / $89 / $26 / $82 / $00 /
                              {MOV cs:82H,SP}
    $2E / $8C / $1E / $84 / $00 /
                              {MOV cs:84H,DS}
    $2E / $8C / $16 / $86 / $00 /
                              {MOV cs:86H,SS}
    $1E / $07 /               {mov ES,DS}
    $BA / pathname /          {mov dx,offset(filespec[0])}
    $42 /                     {inc dx (to point to filespec[1])}
    $BB / parm_blk /          {mov bx,offset(parm_block)}
    $B8 / $00 / $4B /         {mov ax,4B00H}
    $FB /                     {sti}
    $cd / $21 /               {int 21 - call EXEC}
    $FA /                     {cli: avoid interrupts while restoring stack}
    $2E / $8B / $2E / $80 / $00 /
                              {MOV BP,cs:80H}
    $2E / $8B / $26 / $82 / $00 /
                              {MOV SP,cs:82H}
    $2E / $8E / $1E / $84 / $00 /
                              {MOV DS,cs:84H}
    $2E / $8E / $16 / $86 / $00 /
                              {MOV SS,cs:86H}
    $FB /                     {sti}
    $9C /                     {pushf}
    $58 /                     {pop ax}
    $A3 / flagreg /           {mov [flagreg],ax}
    $B8 / $00 / $4D /         {mov ax,4D00H}
    $cd / $21 /               {int 21 - call WAIT (return exit code)}
    $A3 / exitstat /          {mov [exitstat],ax}
    $2E / $8B / $2E / $80 / $00 /
                              {MOV BP,cs:80H}
    $9D);                     {popf}
   
   writeln;
   
   if (flagreg and 1)<> 0 then
   begin
      subprocess := flagreg;
      writeln(whoami, ':  Could not execute ', pathname);
   end
   else
   begin
      subprocess := exitstat and $FF;
      
      if exitstat <> 0 then
         writeln(whoami, ':  Abnormal program exit, code=', exitstat, '.');
   end;
end;                       { SubProcess }
