
const getfdate_tag: string[90]
   = #0'@(#)CURRENT_FILE LAST_UPDATE Get file date as a string 2.0'#0;
#log Get file date as a string 2.0

(*
 * given a valid filename, returns modification date and time
 * formatted as a string:  yy/mm/dd hh:mm
 *
 *)

function get_file_date (filename:      anystring): anystring;
type
   string2 = string[2];
var
   cf, b1, b2,
   hr, mn, ss,
   m, d, y:       integer;
   dta:           array [1..512] of byte;
   sval:          string2;
   reg:           regpack;
   info:          anystring;

   function strval (i: integer): string2;
   begin
      strval := chr(((i div 10) mod 10) + ord('0')) +
                chr((i mod 10) + ord('0'));
   end;


begin

{set up disk transfer area}
   reg.ax := $1a00;
   reg.ds := seg (dta [1]);
   reg.dx := ofs (dta [1]);
   msdos(reg);

{fill up dta}
   filename := filename + #0;
   reg.ax := $4e00;
   reg.cx := 39;
   reg.ds := seg (filename [1]);
   reg.dx := ofs (filename [1]);
   msdos(reg);
   cf := reg.flags and 1;

   if cf = 1 then
      info := '00/00/00 00:00:00'
   else

   begin
      b1 := ord (dta [25]);
      b2 := ord (dta [26]);
      d := b1 and 31;
      m :=(b1 shr 5)+ 8 *(b2 and 1);
      y :=(b2 shr 1)+ 80;

      b1 := ord (dta [23]);
      b2 := ord (dta [24]);
      mn :=(b1 shr 5)+ 8 *(b2 and 7);
      hr := b2 shr 3;
      ss := (b1 and 31) shl 1;

      info := strval (y)+ '/' + strval (m)+ '/' + strval (d)+ ' ' +
              strval (hr)+ ':' + strval (mn) + ':' + strval(ss);
   end;

   get_file_date := info;
end;

