

(*
 * filesize.inc - utility library to return the size of a file in bytes.
 *                returns 0 if the file does not exist
 *
 * shs 14-feb-86
 *
 *)

function file_size(name: anystring): real;
type
   onek = array [1..512] of byte;
var
   fd: file of onek;

begin
   assign(fd,name);
{$I-}
   reset(fd);
{$I+}
   if ioresult <> 0 then
      file_size := 0
   else
   begin
      file_size :=  int(filesize(fd)) * 512;
      close(fd);
   end;
end;

